/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.scope;

import org.jruby.RubyArray;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.parser.BlockStaticScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;

public class OneVarDynamicScope
extends DynamicScope {
    private IRubyObject variableValue;

    public OneVarDynamicScope(StaticScope staticScope, DynamicScope dynamicScope) {
        super(staticScope, dynamicScope);
    }

    public OneVarDynamicScope(StaticScope staticScope) {
        super(staticScope);
    }

    public void growIfNeeded() {
        if (this.staticScope.getNumberOfVariables() != 1) {
            throw new RuntimeException("OneVarDynamicScope cannot be grown; use ManyVarsDynamicScope");
        }
    }

    public DynamicScope cloneScope() {
        return new OneVarDynamicScope(this.staticScope, this.parent);
    }

    public IRubyObject[] getValues() {
        return new IRubyObject[]{this.variableValue};
    }

    public IRubyObject getValue(int n, int n2) {
        if (n2 > 0) {
            return this.parent.getValue(n, n2 - 1);
        }
        assert (n == 0) : "SingleVarDynamicScope only supports scopes with one variable";
        return this.variableValue;
    }

    public IRubyObject getValueOrNil(int n, int n2, IRubyObject iRubyObject) {
        if (n2 > 0) {
            return this.parent.getValueOrNil(n, n2 - 1, iRubyObject);
        }
        return this.getValueDepthZeroOrNil(n, iRubyObject);
    }

    public IRubyObject getValueDepthZeroOrNil(int n, IRubyObject iRubyObject) {
        assert (n == 0) : "SingleVarDynamicScope only supports scopes with one variable";
        if (this.variableValue == null) {
            this.variableValue = iRubyObject;
            return this.variableValue;
        }
        return this.variableValue;
    }

    public IRubyObject getValueZeroDepthZeroOrNil(IRubyObject iRubyObject) {
        if (this.variableValue == null) {
            this.variableValue = iRubyObject;
            return this.variableValue;
        }
        return this.variableValue;
    }

    public IRubyObject getValueOneDepthZeroOrNil(IRubyObject iRubyObject) {
        throw new RuntimeException("SingleVarDynamicScope only supports scopes with one variable");
    }

    public void setValue(int n, IRubyObject iRubyObject, int n2) {
        if (n2 > 0) {
            assert (this.parent != null) : "If depth > 0, then parent should not ever be null";
            this.parent.setValue(n, iRubyObject, n2 - 1);
        } else {
            assert (n == 0) : "SingleVarDynamicScope only supports one variable";
            this.variableValue = iRubyObject;
        }
    }

    public void setValueDepthZero(IRubyObject iRubyObject, int n) {
        assert (n == 0) : "SingleVarDynamicScope only supports one variable";
        this.variableValue = iRubyObject;
    }

    public void setValueZeroDepthZero(IRubyObject iRubyObject) {
        this.variableValue = iRubyObject;
    }

    public void setValueOneDepthZero(IRubyObject iRubyObject) {
        throw new RuntimeException("SingleVarDynamicScope only supports scopes with one variable");
    }

    public void setArgValues(IRubyObject[] iRubyObjectArray, int n) {
        assert (iRubyObjectArray.length == 1) : "SingleVarDynamicScope only supports one variable";
        this.variableValue = iRubyObjectArray[0];
    }

    public IRubyObject[] getArgValues() {
        if (!this.staticScope.isArgumentScope()) {
            return this.parent.getArgValues();
        }
        int n = this.staticScope.getRequiredArgs() + this.staticScope.getOptionalArgs();
        assert (n <= 1) : "OneVarDynamicScope only supports one variable";
        if (this.staticScope.getRestArg() < 0) {
            if (n == 1) {
                return new IRubyObject[]{this.variableValue};
            }
            return IRubyObject.NULL_ARRAY;
        }
        IRubyObject iRubyObject = this.getValue(this.staticScope.getRestArg(), 0);
        assert (iRubyObject != null);
        RubyArray rubyArray = ASTInterpreter.splatValue(iRubyObject.getRuntime(), iRubyObject);
        IRubyObject[] iRubyObjectArray = new IRubyObject[n + rubyArray.size()];
        System.arraycopy(rubyArray.toJavaArray(), 0, iRubyObjectArray, n, rubyArray.size());
        return iRubyObjectArray;
    }

    public String toString(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string).append("Static Type[" + this.hashCode() + "]: " + (this.staticScope instanceof BlockStaticScope ? "block" : "local") + " [");
        String[] stringArray = this.staticScope.getVariables();
        stringBuffer.append(stringArray[0]).append("=");
        if (this.variableValue == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(this.variableValue);
        }
        stringBuffer.append("]");
        if (this.parent != null) {
            stringBuffer.append("\n");
            this.parent.toString(stringBuffer, string + "  ");
        }
        return stringBuffer.toString();
    }
}

