/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.marshal;

import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jruby.RubySymbol;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;

public class MarshalCache {
    private Map linkCache = new IdentityHashMap();
    private Map symbolCache = new IdentityHashMap();

    public boolean isRegistered(IRubyObject iRubyObject) {
        return this.selectCache(iRubyObject).containsKey(iRubyObject);
    }

    public void register(IRubyObject iRubyObject) {
        Map map = this.selectCache(iRubyObject);
        map.put(iRubyObject, new Integer(map.size()));
    }

    private int registeredIndex(IRubyObject iRubyObject) {
        return (Integer)this.selectCache(iRubyObject).get(iRubyObject);
    }

    private Map selectCache(IRubyObject iRubyObject) {
        return iRubyObject instanceof RubySymbol ? this.symbolCache : this.linkCache;
    }

    public void writeLink(MarshalStream marshalStream, IRubyObject iRubyObject) throws IOException {
        marshalStream.write(MarshalCache.linkType(iRubyObject));
        marshalStream.writeInt(this.registeredIndex(iRubyObject));
    }

    private static char linkType(IRubyObject iRubyObject) {
        return iRubyObject instanceof RubySymbol ? (char)';' : '@';
    }
}

