/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.callback;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jruby.RubyClass;
import org.jruby.runtime.Arity;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.Dispatcher;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;
import org.jruby.runtime.callback.ReflectionCallback;

public class ReflectionCallbackFactory
extends CallbackFactory {
    private final Class type;

    public ReflectionCallbackFactory(Class clazz) {
        this.type = clazz;
    }

    public Callback getMethod(String string) {
        return new ReflectionCallback(this.type, string, NULL_CLASS_ARRAY, false, false, Arity.noArguments(), false);
    }

    public Callback getFastMethod(String string) {
        return new ReflectionCallback(this.type, string, NULL_CLASS_ARRAY, false, false, Arity.noArguments(), true);
    }

    public Callback getFastMethod(String string, String string2) {
        return new ReflectionCallback(this.type, string2, NULL_CLASS_ARRAY, false, false, Arity.noArguments(), true);
    }

    public Callback getMethod(String string, Class clazz) {
        return new ReflectionCallback(this.type, string, new Class[]{clazz}, false, false, Arity.singleArgument(), false);
    }

    public Callback getFastMethod(String string, Class clazz) {
        return new ReflectionCallback(this.type, string, new Class[]{clazz}, false, false, Arity.singleArgument(), true);
    }

    public Callback getFastMethod(String string, String string2, Class clazz) {
        return new ReflectionCallback(this.type, string2, new Class[]{clazz}, false, false, Arity.singleArgument(), true);
    }

    public Callback getMethod(String string, Class clazz, Class clazz2) {
        return new ReflectionCallback(this.type, string, new Class[]{clazz, clazz2}, false, false, Arity.fixed(2), false);
    }

    public Callback getFastMethod(String string, Class clazz, Class clazz2) {
        return new ReflectionCallback(this.type, string, new Class[]{clazz, clazz2}, false, false, Arity.fixed(2), true);
    }

    public Callback getFastMethod(String string, String string2, Class clazz, Class clazz2) {
        return new ReflectionCallback(this.type, string2, new Class[]{clazz, clazz2}, false, false, Arity.fixed(2), true);
    }

    public Callback getMethod(String string, Class clazz, Class clazz2, Class clazz3) {
        return new ReflectionCallback(this.type, string, new Class[]{clazz, clazz2, clazz3}, false, false, Arity.fixed(3), false);
    }

    public Callback getFastMethod(String string, Class clazz, Class clazz2, Class clazz3) {
        return new ReflectionCallback(this.type, string, new Class[]{clazz, clazz2, clazz3}, false, false, Arity.fixed(3), true);
    }

    public Callback getFastMethod(String string, String string2, Class clazz, Class clazz2, Class clazz3) {
        return new ReflectionCallback(this.type, string2, new Class[]{clazz, clazz2, clazz3}, false, false, Arity.fixed(3), true);
    }

    public Callback getSingletonMethod(String string) {
        return new ReflectionCallback(this.type, string, NULL_CLASS_ARRAY, false, true, Arity.noArguments(), false);
    }

    public Callback getFastSingletonMethod(String string) {
        return new ReflectionCallback(this.type, string, NULL_CLASS_ARRAY, false, true, Arity.noArguments(), true);
    }

    public Callback getSingletonMethod(String string, Class clazz) {
        return new ReflectionCallback(this.type, string, new Class[]{clazz}, false, true, Arity.singleArgument(), false);
    }

    public Callback getFastSingletonMethod(String string, Class clazz) {
        return new ReflectionCallback(this.type, string, new Class[]{clazz}, false, true, Arity.singleArgument(), true);
    }

    public Callback getSingletonMethod(String string, Class clazz, Class clazz2) {
        return new ReflectionCallback(this.type, string, new Class[]{clazz, clazz2}, false, true, Arity.fixed(2), false);
    }

    public Callback getFastSingletonMethod(String string, Class clazz, Class clazz2) {
        return new ReflectionCallback(this.type, string, new Class[]{clazz, clazz2}, false, true, Arity.fixed(2), true);
    }

    public Callback getSingletonMethod(String string, Class clazz, Class clazz2, Class clazz3) {
        return new ReflectionCallback(this.type, string, new Class[]{clazz, clazz2, clazz3}, false, true, Arity.fixed(3), false);
    }

    public Callback getFastSingletonMethod(String string, Class clazz, Class clazz2, Class clazz3) {
        return new ReflectionCallback(this.type, string, new Class[]{clazz, clazz2, clazz3}, false, true, Arity.fixed(3), true);
    }

    public Callback getBlockMethod(String string) {
        return new ReflectionCallback(this.type, string, new Class[]{IRubyObject.class, IRubyObject.class}, false, true, Arity.fixed(2), false);
    }

    public CompiledBlockCallback getBlockCallback(String string, final Object object) {
        try {
            final Method method = object.getClass().getMethod(string, ThreadContext.class, IRubyObject.class, IRubyObject[].class);
            return new CompiledBlockCallback(){

                public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
                    try {
                        return (IRubyObject)method.invoke(object, threadContext, iRubyObject, iRubyObjectArray);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new RuntimeException(illegalAccessException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new RuntimeException(illegalArgumentException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Throwable throwable = invocationTargetException.getCause();
                        if (throwable instanceof RuntimeException) {
                            throw (RuntimeException)throwable;
                        }
                        if (throwable instanceof Error) {
                            throw (Error)throwable;
                        }
                        throw new RuntimeException(invocationTargetException);
                    }
                }
            };
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
    }

    public Callback getOptSingletonMethod(String string) {
        return new ReflectionCallback(this.type, string, new Class[]{IRubyObject[].class}, true, true, Arity.optional(), false);
    }

    public Callback getFastOptSingletonMethod(String string) {
        return new ReflectionCallback(this.type, string, new Class[]{IRubyObject[].class}, true, true, Arity.optional(), true);
    }

    public Callback getOptMethod(String string) {
        return new ReflectionCallback(this.type, string, new Class[]{IRubyObject[].class}, true, false, Arity.optional(), false);
    }

    public Callback getFastOptMethod(String string) {
        return new ReflectionCallback(this.type, string, new Class[]{IRubyObject[].class}, true, false, Arity.optional(), true);
    }

    public Callback getFastOptMethod(String string, String string2) {
        return new ReflectionCallback(this.type, string2, new Class[]{IRubyObject[].class}, true, false, Arity.optional(), true);
    }

    public Dispatcher createDispatcher(RubyClass rubyClass) {
        return Dispatcher.DEFAULT_DISPATCHER;
    }
}

