/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyClass;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class Dispatcher {
    public static final Dispatcher DEFAULT_DISPATCHER = new DefaultDispatcher();
    protected byte[] switchTable;

    public abstract IRubyObject callMethod(ThreadContext var1, IRubyObject var2, RubyClass var3, int var4, String var5, IRubyObject[] var6, CallType var7, Block var8);

    public void clearIndex(int n) {
        if (n >= this.switchTable.length) {
            return;
        }
        this.switchTable[n] = 0;
    }

    private static class DefaultDispatcher
    extends Dispatcher {
        public DefaultDispatcher() {
            this.switchTable = new byte[0];
        }

        public IRubyObject callMethod(ThreadContext threadContext, IRubyObject iRubyObject, RubyClass rubyClass, int n, String string, IRubyObject[] iRubyObjectArray, CallType callType, Block block) {
            try {
                return RuntimeHelpers.invokeAs(threadContext, rubyClass, iRubyObject, string, iRubyObjectArray, callType, block);
            }
            catch (StackOverflowError stackOverflowError) {
                throw threadContext.getRuntime().newSystemStackError("stack level too deep");
            }
        }
    }
}

