/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.Dispatcher;
import org.jruby.runtime.callback.Callback;
import org.jruby.runtime.callback.DumpingInvocationCallbackFactory;
import org.jruby.runtime.callback.InvocationCallbackFactory;
import org.jruby.runtime.callback.ReflectionCallbackFactory;
import org.jruby.util.SafePropertyAccessor;

public abstract class CallbackFactory {
    public static final Class[] NULL_CLASS_ARRAY = new Class[0];
    private static boolean reflection = false;
    private static boolean dumping = false;

    public abstract Callback getMethod(String var1);

    public abstract Callback getFastMethod(String var1);

    public abstract Callback getMethod(String var1, Class var2);

    public abstract Callback getFastMethod(String var1, Class var2);

    public abstract Callback getMethod(String var1, Class var2, Class var3);

    public abstract Callback getFastMethod(String var1, Class var2, Class var3);

    public abstract Callback getMethod(String var1, Class var2, Class var3, Class var4);

    public abstract Callback getFastMethod(String var1, Class var2, Class var3, Class var4);

    public abstract Callback getSingletonMethod(String var1);

    public abstract Callback getFastSingletonMethod(String var1);

    public abstract Callback getSingletonMethod(String var1, Class var2);

    public abstract Callback getFastSingletonMethod(String var1, Class var2);

    public abstract Callback getSingletonMethod(String var1, Class var2, Class var3);

    public abstract Callback getFastSingletonMethod(String var1, Class var2, Class var3);

    public abstract Callback getSingletonMethod(String var1, Class var2, Class var3, Class var4);

    public abstract Callback getFastSingletonMethod(String var1, Class var2, Class var3, Class var4);

    public abstract Callback getBlockMethod(String var1);

    public abstract CompiledBlockCallback getBlockCallback(String var1, Object var2);

    public abstract Callback getOptSingletonMethod(String var1);

    public abstract Callback getFastOptSingletonMethod(String var1);

    public abstract Callback getOptMethod(String var1);

    public abstract Callback getFastOptMethod(String var1);

    public abstract Dispatcher createDispatcher(RubyClass var1);

    public static CallbackFactory createFactory(Ruby ruby, Class clazz) {
        return CallbackFactory.createFactory(ruby, clazz, ruby.getJRubyClassLoader());
    }

    public static CallbackFactory createFactory(Ruby ruby, Class clazz, ClassLoader classLoader) {
        if (reflection) {
            return new ReflectionCallbackFactory(clazz);
        }
        if (dumping) {
            return new DumpingInvocationCallbackFactory(ruby, clazz, classLoader);
        }
        return new InvocationCallbackFactory(ruby, clazz, classLoader);
    }

    static {
        if (Ruby.isSecurityRestricted()) {
            reflection = true;
        } else {
            if (SafePropertyAccessor.getProperty("jruby.reflection") != null && SafePropertyAccessor.getBoolean("jruby.reflection")) {
                reflection = true;
            }
            if (SafePropertyAccessor.getProperty("jruby.dump_invocations") != null) {
                dumping = true;
            }
        }
    }
}

