/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class Block {
    public static final int ZERO_ARGS = 0;
    public static final int MULTIPLE_ASSIGNMENT = 1;
    public static final int ARRAY = 2;
    public static final int SINGLE_RESTARG = 3;
    private RubyProc proc = null;
    public Type type = Type.NORMAL;
    private final Binding binding;
    private final BlockBody body;
    public static final Block NULL_BLOCK = new Block(){

        public boolean isGiven() {
            return false;
        }

        public IRubyObject yield(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, RubyModule rubyModule, boolean bl) {
            throw threadContext.getRuntime().newLocalJumpError("noreason", iRubyObject, "yield called out of block");
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
            throw threadContext.getRuntime().newLocalJumpError("noreason", threadContext.getRuntime().newArrayNoCopy(iRubyObjectArray), "yield called out of block");
        }

        public IRubyObject yield(ThreadContext threadContext, IRubyObject iRubyObject) {
            throw threadContext.getRuntime().newLocalJumpError("noreason", iRubyObject, "yield called out of block");
        }

        public Block cloneBlock() {
            return this;
        }

        public BlockBody getBody() {
            return BlockBody.NULL_BODY;
        }
    };

    protected Block() {
        this(null, null);
    }

    public Block(BlockBody blockBody, Binding binding) {
        this.body = blockBody;
        this.binding = binding;
    }

    public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        return this.body.call(threadContext, iRubyObjectArray, this.binding, this.type);
    }

    public IRubyObject yield(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.body.yield(threadContext, iRubyObject, this.binding, this.type);
    }

    public IRubyObject yield(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, RubyModule rubyModule, boolean bl) {
        return this.body.yield(threadContext, iRubyObject, iRubyObject2, rubyModule, bl, this.binding, this.type);
    }

    protected int arrayLength(IRubyObject iRubyObject) {
        return iRubyObject instanceof RubyArray ? ((RubyArray)iRubyObject).getLength() : 0;
    }

    public Block cloneBlock() {
        Block block = this.body.cloneBlock(this.binding);
        block.type = this.type;
        return block;
    }

    public Arity arity() {
        return this.body.arity();
    }

    public RubyProc getProcObject() {
        return this.proc;
    }

    public void setProcObject(RubyProc rubyProc) {
        this.proc = rubyProc;
    }

    public boolean isGiven() {
        return true;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public BlockBody getBody() {
        return this.body;
    }

    public Frame getFrame() {
        return this.binding.getFrame();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        NORMAL,
        PROC,
        LAMBDA,
        THREAD;

    }
}

