/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.javasupport.JavaAccessibleObject;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaField
extends JavaAccessibleObject {
    private Field field;

    public static RubyClass createJavaFieldClass(Ruby ruby, RubyModule rubyModule) {
        RubyClass rubyClass = rubyModule.defineClassUnder("JavaField", ruby.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        CallbackFactory callbackFactory = ruby.callbackFactory(JavaField.class);
        JavaAccessibleObject.registerRubyMethods(ruby, rubyClass);
        rubyClass.defineFastMethod("value_type", callbackFactory.getFastMethod("value_type"));
        rubyClass.defineFastMethod("public?", callbackFactory.getFastMethod("public_p"));
        rubyClass.defineFastMethod("static?", callbackFactory.getFastMethod("static_p"));
        rubyClass.defineFastMethod("value", callbackFactory.getFastMethod("value", IRubyObject.class));
        rubyClass.defineFastMethod("set_value", callbackFactory.getFastMethod("set_value", IRubyObject.class, IRubyObject.class));
        rubyClass.defineFastMethod("set_static_value", callbackFactory.getFastMethod("set_static_value", IRubyObject.class));
        rubyClass.defineFastMethod("final?", callbackFactory.getFastMethod("final_p"));
        rubyClass.defineFastMethod("static_value", callbackFactory.getFastMethod("static_value"));
        rubyClass.defineFastMethod("name", callbackFactory.getFastMethod("name"));
        rubyClass.defineFastMethod("==", callbackFactory.getFastMethod("op_equal", IRubyObject.class));
        rubyClass.defineAlias("===", "==");
        rubyClass.defineFastMethod("enum_constant?", callbackFactory.getFastMethod("enum_constant_p"));
        rubyClass.defineFastMethod("to_generic_string", callbackFactory.getFastMethod("to_generic_string"));
        rubyClass.defineFastMethod("type", callbackFactory.getFastMethod("field_type"));
        return rubyClass;
    }

    public JavaField(Ruby ruby, Field field) {
        super(ruby, ruby.getJavaSupport().getJavaModule().fastGetClass("JavaField"));
        this.field = field;
    }

    public boolean equals(Object object) {
        return object instanceof JavaField && this.field == ((JavaField)object).field;
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    public RubyString value_type() {
        return this.getRuntime().newString(this.field.getType().getName());
    }

    public IRubyObject op_equal(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof JavaField)) {
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().newBoolean(this.field.equals(((JavaField)iRubyObject).field));
    }

    public RubyBoolean public_p() {
        return this.getRuntime().newBoolean(Modifier.isPublic(this.field.getModifiers()));
    }

    public RubyBoolean static_p() {
        return this.getRuntime().newBoolean(Modifier.isStatic(this.field.getModifiers()));
    }

    public RubyBoolean enum_constant_p() {
        return this.getRuntime().newBoolean(this.field.isEnumConstant());
    }

    public RubyString to_generic_string() {
        return this.getRuntime().newString(this.field.toGenericString());
    }

    public IRubyObject field_type() {
        return JavaClass.get(this.getRuntime(), this.field.getType());
    }

    public JavaObject value(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof JavaObject)) {
            throw this.getRuntime().newTypeError("not a java object");
        }
        Object object = ((JavaObject)iRubyObject).getValue();
        try {
            return JavaObject.wrap(this.getRuntime(), this.field.get(object));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw this.getRuntime().newTypeError("illegal access");
        }
    }

    public JavaObject set_value(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (!(iRubyObject instanceof JavaObject)) {
            throw this.getRuntime().newTypeError("not a java object: " + iRubyObject);
        }
        if (!(iRubyObject2 instanceof JavaObject)) {
            throw this.getRuntime().newTypeError("not a java object:" + iRubyObject2);
        }
        Object object = ((JavaObject)iRubyObject).getValue();
        try {
            Object object2 = JavaUtil.convertArgument(iRubyObject2.getRuntime(), ((JavaObject)iRubyObject2).getValue(), this.field.getType());
            this.field.set(object, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw this.getRuntime().newTypeError("illegal access on setting variable: " + illegalAccessException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this.getRuntime().newTypeError("wrong type for " + this.field.getType().getName() + ": " + ((JavaObject)iRubyObject2).getValue().getClass().getName());
        }
        return (JavaObject)iRubyObject2;
    }

    public RubyBoolean final_p() {
        return this.getRuntime().newBoolean(Modifier.isFinal(this.field.getModifiers()));
    }

    public JavaObject static_value() {
        try {
            if (!Ruby.isSecurityRestricted()) {
                this.field.setAccessible(true);
            }
            return JavaObject.wrap(this.getRuntime(), this.field.get(null));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw this.getRuntime().newTypeError("illegal static value access: " + illegalAccessException.getMessage());
        }
    }

    public JavaObject set_static_value(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof JavaObject)) {
            throw this.getRuntime().newTypeError("not a java object:" + iRubyObject);
        }
        try {
            Object object = JavaUtil.convertArgument(this.getRuntime(), ((JavaObject)iRubyObject).getValue(), this.field.getType());
            this.field.set(null, object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw this.getRuntime().newTypeError("illegal access on setting static variable: " + illegalAccessException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this.getRuntime().newTypeError("wrong type for " + this.field.getType().getName() + ": " + ((JavaObject)iRubyObject).getValue().getClass().getName());
        }
        return (JavaObject)iRubyObject;
    }

    public RubyString name() {
        return this.getRuntime().newString(this.field.getName());
    }

    protected AccessibleObject accessibleObject() {
        return this.field;
    }
}

