/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaObject;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class JavaArrayUtilities {
    public static RubyModule createJavaArrayUtilitiesModule(Ruby ruby) {
        RubyModule rubyModule = ruby.defineModule("JavaArrayUtilities");
        CallbackFactory callbackFactory = ruby.callbackFactory(JavaArrayUtilities.class);
        rubyModule.defineFastModuleFunction("bytes_to_ruby_string", callbackFactory.getFastSingletonMethod("bytes_to_ruby_string", IRubyObject.class));
        rubyModule.defineFastModuleFunction("ruby_string_to_bytes", callbackFactory.getFastSingletonMethod("ruby_string_to_bytes", IRubyObject.class));
        return rubyModule;
    }

    public static IRubyObject bytes_to_ruby_string(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = iRubyObject.getRuntime();
        IRubyObject iRubyObject3 = iRubyObject2.getInstanceVariables().fastGetInstanceVariable("@java_object");
        if (!(iRubyObject3 instanceof JavaArray) || !(((JavaArray)iRubyObject3).getValue() instanceof byte[])) {
            throw ruby.newTypeError("wrong argument type " + iRubyObject2.getMetaClass() + " (expected byte[])");
        }
        return ruby.newString(new ByteList((byte[])((JavaArray)iRubyObject3).getValue(), true));
    }

    public static IRubyObject ruby_string_to_bytes(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = iRubyObject.getRuntime();
        if (!(iRubyObject2 instanceof RubyString)) {
            throw ruby.newTypeError(iRubyObject2, ruby.getString());
        }
        return Java.java_to_ruby(iRubyObject, JavaObject.wrap(ruby, ((RubyString)iRubyObject2).getBytes()), Block.NULL_BLOCK);
    }
}

