/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ast.executable.RubiniusCMethod;
import org.jruby.ast.executable.RubiniusMachine;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.JumpTarget;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class RubiniusMethod
extends DynamicMethod
implements JumpTarget {
    private RubiniusCMethod cmethod;
    private StaticScope staticScope;
    private Arity arity;

    public RubiniusMethod(RubyModule rubyModule, RubiniusCMethod rubiniusCMethod, StaticScope staticScope, Visibility visibility) {
        super(rubyModule, visibility, CallConfiguration.FRAME_AND_SCOPE);
        this.staticScope = staticScope;
        this.cmethod = rubiniusCMethod;
        this.arity = Arity.optional();
    }

    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
        IRubyObject iRubyObject2;
        assert (iRubyObjectArray != null);
        Ruby ruby = threadContext.getRuntime();
        this.callConfig.pre(threadContext, iRubyObject, rubyModule, this.getArity(), string, iRubyObjectArray, block, this.staticScope, this);
        try {
            if (ruby.hasEventHooks()) {
                this.traceCall(threadContext, ruby, string);
            }
            iRubyObject2 = RubiniusMachine.INSTANCE.exec(threadContext, iRubyObject, this.cmethod.code, this.cmethod.literals, iRubyObjectArray);
            Object var11_10 = null;
        }
        catch (JumpException.ReturnJump returnJump) {
            block10: {
                try {
                    if (returnJump.getTarget() != this) break block10;
                    IRubyObject iRubyObject3 = (IRubyObject)returnJump.getValue();
                    Object var11_11 = null;
                    if (ruby.hasEventHooks()) {
                        this.traceReturn(threadContext, ruby, string);
                    }
                    this.callConfig.post(threadContext);
                    return iRubyObject3;
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    if (ruby.hasEventHooks()) {
                        this.traceReturn(threadContext, ruby, string);
                    }
                    this.callConfig.post(threadContext);
                    throw throwable;
                }
            }
            throw returnJump;
        }
        if (ruby.hasEventHooks()) {
            this.traceReturn(threadContext, ruby, string);
        }
        this.callConfig.post(threadContext);
        return iRubyObject2;
    }

    private void traceReturn(ThreadContext threadContext, Ruby ruby, String string) {
        if (!ruby.hasEventHooks()) {
            return;
        }
        Frame frame = threadContext.getPreviousFrame();
        ruby.callEventHooks(threadContext, 4, frame.getFile(), frame.getLine(), string, this.getImplementationClass());
    }

    private void traceCall(ThreadContext threadContext, Ruby ruby, String string) {
        if (!ruby.hasEventHooks()) {
            return;
        }
        ruby.callEventHooks(threadContext, 3, threadContext.getFile(), threadContext.getLine(), string, this.getImplementationClass());
    }

    public Arity getArity() {
        return this.arity;
    }

    public DynamicMethod dup() {
        return new RubiniusMethod(this.getImplementationClass(), this.cmethod, this.staticScope, this.getVisibility());
    }
}

