/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.JumpTarget;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;

public class FullFunctionCallbackMethod
extends DynamicMethod
implements JumpTarget {
    private Callback callback;

    public FullFunctionCallbackMethod(RubyModule rubyModule, Callback callback, Visibility visibility) {
        super(rubyModule, visibility, CallConfiguration.FRAME_ONLY);
        this.callback = callback;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
        try {
            IRubyObject iRubyObject2;
            block9: {
                this.callConfig.pre(threadContext, iRubyObject, rubyModule, this.getArity(), string, iRubyObjectArray, block, null, this);
                assert (iRubyObjectArray != null);
                Ruby ruby = threadContext.getRuntime();
                boolean bl = ruby.hasEventHooks();
                if (bl) {
                    ruby.callEventHooks(threadContext, 5, threadContext.getFile(), threadContext.getLine(), string, this.getImplementationClass());
                }
                try {
                    iRubyObject2 = this.callback.execute(iRubyObject, iRubyObjectArray, block);
                    Object var12_11 = null;
                    if (!bl) break block9;
                }
                catch (JumpException.ReturnJump returnJump) {
                    block10: {
                        IRubyObject iRubyObject3;
                        block11: {
                            try {
                                if (returnJump.getTarget() != this) break block10;
                                iRubyObject3 = (IRubyObject)returnJump.getValue();
                                Object var12_12 = null;
                                if (!bl) break block11;
                                ruby.callEventHooks(threadContext, 6, threadContext.getFile(), threadContext.getLine(), string, this.getImplementationClass());
                            }
                            catch (Throwable throwable) {
                                Object var12_13 = null;
                                if (!bl) throw throwable;
                                ruby.callEventHooks(threadContext, 6, threadContext.getFile(), threadContext.getLine(), string, this.getImplementationClass());
                                throw throwable;
                            }
                        }
                        Object var14_15 = null;
                        this.callConfig.post(threadContext);
                        return iRubyObject3;
                    }
                    throw returnJump;
                }
                ruby.callEventHooks(threadContext, 6, threadContext.getFile(), threadContext.getLine(), string, this.getImplementationClass());
            }
            Object var14_14 = null;
            this.callConfig.post(threadContext);
            return iRubyObject2;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            this.callConfig.post(threadContext);
            throw throwable;
        }
    }

    public Callback getCallback() {
        return this.callback;
    }

    public Arity getArity() {
        return this.getCallback().getArity();
    }

    public DynamicMethod dup() {
        return new FullFunctionCallbackMethod(this.getImplementationClass(), this.callback, this.getVisibility());
    }
}

