/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.MetaClass;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class DynamicMethod {
    protected RubyModule implementationClass;
    protected Visibility visibility;
    protected CallConfiguration callConfig;

    protected DynamicMethod(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration) {
        this.visibility = visibility;
        this.implementationClass = rubyModule;
        this.callConfig = callConfiguration;
    }

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject[] var5, Block var6);

    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray) {
        return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string) {
        return this.call(threadContext, iRubyObject, rubyModule, string, IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, Block block) {
        return this.call(threadContext, iRubyObject, rubyModule, string, IRubyObject.NULL_ARRAY, block);
    }

    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2) {
        return this.call(threadContext, iRubyObject, rubyModule, string, new IRubyObject[]{iRubyObject2}, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, Block block) {
        return this.call(threadContext, iRubyObject, rubyModule, string, new IRubyObject[]{iRubyObject2}, block);
    }

    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        return this.call(threadContext, iRubyObject, rubyModule, string, new IRubyObject[]{iRubyObject2, iRubyObject3}, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, Block block) {
        return this.call(threadContext, iRubyObject, rubyModule, string, new IRubyObject[]{iRubyObject2, iRubyObject3}, block);
    }

    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4) {
        return this.call(threadContext, iRubyObject, rubyModule, string, new IRubyObject[]{iRubyObject2, iRubyObject3, iRubyObject4}, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4, Block block) {
        return this.call(threadContext, iRubyObject, rubyModule, string, new IRubyObject[]{iRubyObject2, iRubyObject3, iRubyObject4}, block);
    }

    public abstract DynamicMethod dup();

    public boolean isCallableFrom(IRubyObject iRubyObject, CallType callType) {
        switch (this.visibility) {
            case PUBLIC: {
                return true;
            }
            case PRIVATE: {
                return callType != CallType.NORMAL;
            }
            case PROTECTED: {
                RubyModule rubyModule = this.getImplementationClass();
                if (rubyModule.isSingleton()) {
                    rubyModule = rubyModule.getSuperClass();
                }
                while (rubyModule.isIncluded()) {
                    rubyModule = rubyModule.getMetaClass();
                }
                if (rubyModule instanceof MetaClass) {
                    rubyModule = ((MetaClass)rubyModule).getRealClass();
                }
                return rubyModule.isInstance(iRubyObject);
            }
        }
        return true;
    }

    public RubyModule getImplementationClass() {
        return this.implementationClass;
    }

    public void setImplementationClass(RubyModule rubyModule) {
        this.implementationClass = rubyModule;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public boolean isUndefined() {
        return false;
    }

    public Arity getArity() {
        return Arity.optional();
    }

    public DynamicMethod getRealMethod() {
        return this;
    }

    public CallConfiguration getCallConfig() {
        return this.callConfig;
    }

    public void setCallConfig(CallConfiguration callConfiguration) {
        this.callConfig = callConfiguration;
    }

    public boolean isNative() {
        return false;
    }
}

