/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.executable.Script;
import org.jruby.compiler.JITCompiler;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.evaluator.AssignmentVisitor;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.JumpTarget;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public final class DefaultMethod
extends DynamicMethod
implements JumpTarget {
    private StaticScope staticScope;
    private Node body;
    private ArgsNode argsNode;
    private int callCount = 0;
    private Script jitCompiledScript;
    private int requiredArgsCount;
    private int restArg;
    private boolean hasOptArgs;
    private CallConfiguration jitCallConfig;
    private ISourcePosition position;

    public DefaultMethod(RubyModule rubyModule, StaticScope staticScope, Node node, ArgsNode argsNode, Visibility visibility, ISourcePosition iSourcePosition) {
        super(rubyModule, visibility, CallConfiguration.FRAME_AND_SCOPE);
        this.body = node;
        this.staticScope = staticScope;
        this.argsNode = argsNode;
        this.requiredArgsCount = argsNode.getRequiredArgsCount();
        this.restArg = argsNode.getRestArg();
        this.hasOptArgs = argsNode.getOptArgs() != null;
        this.position = iSourcePosition;
        assert (argsNode != null);
    }

    public int getCallCount() {
        return this.callCount;
    }

    public void setCallCount(int n) {
        this.callCount = n;
    }

    public Script getJITCompilerScript() {
        return this.jitCompiledScript;
    }

    public void setJITCompiledScript(Script script) {
        this.jitCompiledScript = script;
    }

    public CallConfiguration getJITCallConfig() {
        return this.jitCallConfig;
    }

    public void setJITCallConfig(CallConfiguration callConfiguration) {
        this.jitCallConfig = callConfiguration;
    }

    public Node getBodyNode() {
        return this.body;
    }

    public ArgsNode getArgsNode() {
        return this.argsNode;
    }

    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
        assert (iRubyObjectArray != null);
        RubyModule rubyModule2 = this.getImplementationClass();
        Ruby ruby = threadContext.getRuntime();
        if (ruby.getInstanceConfig().getCompileMode().shouldJIT()) {
            JITCompiler.runJIT(this, ruby, threadContext, string);
        }
        if (this.jitCompiledScript != null && !ruby.hasEventHooks()) {
            try {
                IRubyObject iRubyObject2;
                try {
                    this.jitCallConfig.pre(threadContext, iRubyObject, rubyModule2, this.getArity(), string, iRubyObjectArray, block, this.staticScope, this);
                    iRubyObject2 = this.jitCompiledScript.__file__(threadContext, iRubyObject, iRubyObjectArray, block);
                    Object var12_15 = null;
                }
                catch (JumpException.ReturnJump returnJump) {
                    if (returnJump.getTarget() != this) throw returnJump;
                    IRubyObject iRubyObject3 = (IRubyObject)returnJump.getValue();
                    Object var12_16 = null;
                    if (ruby.hasEventHooks()) {
                        this.traceReturn(threadContext, ruby, string);
                    }
                    this.jitCallConfig.post(threadContext);
                    return iRubyObject3;
                }
                catch (JumpException.RedoJump redoJump) {
                    throw ruby.newLocalJumpError("redo", ruby.getNil(), "unexpected redo");
                }
                if (ruby.hasEventHooks()) {
                    this.traceReturn(threadContext, ruby, string);
                }
                this.jitCallConfig.post(threadContext);
                return iRubyObject2;
            }
            catch (Throwable throwable) {
                Object var12_17 = null;
                if (ruby.hasEventHooks()) {
                    this.traceReturn(threadContext, ruby, string);
                }
                this.jitCallConfig.post(threadContext);
                throw throwable;
            }
        }
        try {
            IRubyObject iRubyObject4;
            try {
                this.callConfig.pre(threadContext, iRubyObject, rubyModule2, this.getArity(), string, iRubyObjectArray, block, this.staticScope, this);
                if (this.argsNode.getBlockArgNode() != null) {
                    threadContext.getCurrentScope().setValue(this.argsNode.getBlockArgNode().getCount(), RuntimeHelpers.processBlockArgument(ruby, block), 0);
                }
                this.getArity().checkArity(ruby, iRubyObjectArray);
                this.prepareArguments(threadContext, ruby, iRubyObjectArray);
                if (ruby.hasEventHooks()) {
                    this.traceCall(threadContext, ruby, string);
                }
                iRubyObject4 = ASTInterpreter.eval(ruby, threadContext, this.body, iRubyObject, block);
                Object var14_21 = null;
            }
            catch (JumpException.ReturnJump returnJump) {
                if (returnJump.getTarget() != this) throw returnJump;
                IRubyObject iRubyObject5 = (IRubyObject)returnJump.getValue();
                Object var14_22 = null;
                if (ruby.hasEventHooks()) {
                    this.traceReturn(threadContext, ruby, string);
                }
                this.callConfig.post(threadContext);
                return iRubyObject5;
            }
            catch (JumpException.RedoJump redoJump) {
                throw ruby.newLocalJumpError("redo", ruby.getNil(), "unexpected redo");
            }
            if (ruby.hasEventHooks()) {
                this.traceReturn(threadContext, ruby, string);
            }
            this.callConfig.post(threadContext);
            return iRubyObject4;
        }
        catch (Throwable throwable) {
            Object var14_23 = null;
            if (ruby.hasEventHooks()) {
                this.traceReturn(threadContext, ruby, string);
            }
            this.callConfig.post(threadContext);
            throw throwable;
        }
    }

    private void prepareArguments(ThreadContext threadContext, Ruby ruby, IRubyObject[] iRubyObjectArray) {
        if (this.requiredArgsCount > iRubyObjectArray.length) {
            throw ruby.newArgumentError("Wrong # of arguments(" + iRubyObjectArray.length + " for " + this.requiredArgsCount + ")");
        }
        if (this.requiredArgsCount > 0) {
            threadContext.getCurrentScope().setArgValues(iRubyObjectArray, this.requiredArgsCount);
        }
        if (this.hasOptArgs || this.restArg != -1) {
            this.prepareOptOrRestArgs(threadContext, ruby, iRubyObjectArray);
        }
    }

    private void prepareOptOrRestArgs(ThreadContext threadContext, Ruby ruby, IRubyObject[] iRubyObjectArray) {
        int n;
        Object object;
        int n2 = this.requiredArgsCount;
        int n3 = this.requiredArgsCount;
        if (this.argsNode.getOptArgs() != null && this.restArg == -1 && (n3 += this.argsNode.getOptArgs().size()) < iRubyObjectArray.length) {
            throw ruby.newArgumentError("wrong # of arguments(" + iRubyObjectArray.length + " for " + n3 + ")");
        }
        if (this.hasOptArgs) {
            int n4;
            object = this.argsNode.getOptArgs();
            n = 0;
            for (n4 = this.requiredArgsCount; n4 < iRubyObjectArray.length && n < ((ListNode)object).size(); ++n4, ++n) {
                AssignmentVisitor.assign(ruby, threadContext, threadContext.getFrameSelf(), ((ListNode)object).get(n), iRubyObjectArray[n4], Block.NULL_BLOCK, true);
                ++n2;
            }
            n4 = 0;
            while (n < ((ListNode)object).size()) {
                ASTInterpreter.eval(ruby, threadContext, ((ListNode)object).get(n), threadContext.getFrameSelf(), Block.NULL_BLOCK);
                ++n4;
                ++n;
            }
        }
        if (this.restArg != -1 && this.restArg >= 0) {
            object = ruby.newArray(iRubyObjectArray.length - n2);
            for (n = n2; n < iRubyObjectArray.length; ++n) {
                ((RubyArray)object).append(iRubyObjectArray[n]);
            }
            threadContext.getCurrentScope().setValue(this.restArg, (IRubyObject)object, 0);
        }
    }

    public ISourcePosition getPosition() {
        return this.position;
    }

    private void traceReturn(ThreadContext threadContext, Ruby ruby, String string) {
        Frame frame = threadContext.getPreviousFrame();
        ruby.callEventHooks(threadContext, 4, frame.getFile(), frame.getLine(), string, this.getImplementationClass());
    }

    private void traceCall(ThreadContext threadContext, Ruby ruby, String string) {
        ruby.callEventHooks(threadContext, 3, this.position.getFile(), this.position.getStartLine(), string, this.getImplementationClass());
    }

    public Arity getArity() {
        return this.argsNode.getArity();
    }

    public DynamicMethod dup() {
        return new DefaultMethod(this.getImplementationClass(), this.staticScope, this.body, this.argsNode, this.getVisibility(), this.position);
    }
}

