/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.Ruby;
import org.jruby.RubyThread;
import org.jruby.internal.runtime.RubyNativeThread;
import org.jruby.runtime.ThreadContext;
import org.jruby.util.collections.WeakHashSet;

public class ThreadService {
    private Ruby runtime;
    private ThreadContext mainContext;
    private ThreadLocal<SoftReference> localContext;
    private ThreadGroup rubyThreadGroup;
    private Set rubyThreadList;
    private Thread mainThread;
    private ReentrantLock criticalLock = new ReentrantLock();

    public ThreadService(Ruby ruby) {
        this.runtime = ruby;
        this.mainContext = ThreadContext.newContext(ruby);
        this.localContext = new ThreadLocal();
        this.rubyThreadGroup = new ThreadGroup("Ruby Threads#" + ruby.hashCode());
        this.rubyThreadList = Collections.synchronizedSet(new WeakHashSet());
        this.mainThread = Thread.currentThread();
        this.localContext.set(new SoftReference<ThreadContext>(this.mainContext));
        this.rubyThreadList.add(this.mainThread);
    }

    public void disposeCurrentThread() {
        this.localContext.set(null);
    }

    public ThreadContext getCurrentContext() {
        SoftReference softReference = null;
        ThreadContext threadContext = null;
        while (threadContext == null) {
            softReference = this.localContext.get();
            if (softReference == null) {
                softReference = this.adoptCurrentThread();
                threadContext = (ThreadContext)softReference.get();
            } else {
                threadContext = (ThreadContext)softReference.get();
            }
            if (threadContext != null) continue;
            this.localContext.set(null);
        }
        return threadContext;
    }

    private SoftReference adoptCurrentThread() {
        Thread thread = Thread.currentThread();
        RubyThread.adopt(this.runtime.getThread(), thread);
        return this.localContext.get();
    }

    public RubyThread getMainThread() {
        return this.mainContext.getThread();
    }

    public void setMainThread(RubyThread rubyThread) {
        this.mainContext.setThread(rubyThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized RubyThread[] getActiveRubyThreads() {
        Set set = this.rubyThreadList;
        synchronized (set) {
            ArrayList<RubyThread> arrayList = new ArrayList<RubyThread>(this.rubyThreadList.size());
            for (Thread thread : this.rubyThreadList) {
                if (!thread.isAlive()) continue;
                RubyThread rubyThread = this.getRubyThreadFromThread(thread);
                arrayList.add(rubyThread);
            }
            RubyThread[] rubyThreadArray = new RubyThread[arrayList.size()];
            arrayList.toArray(rubyThreadArray);
            return rubyThreadArray;
        }
    }

    public ThreadGroup getRubyThreadGroup() {
        return this.rubyThreadGroup;
    }

    public synchronized ThreadContext registerNewThread(RubyThread rubyThread) {
        ThreadContext threadContext = ThreadContext.newContext(this.runtime);
        this.localContext.set(new SoftReference<ThreadContext>(threadContext));
        this.getCurrentContext().setThread(rubyThread);
        this.rubyThreadList.add(Thread.currentThread());
        return threadContext;
    }

    public synchronized void unregisterThread(RubyThread rubyThread) {
        this.rubyThreadList.remove(Thread.currentThread());
        this.getCurrentContext().setThread(null);
        this.localContext.set(null);
    }

    private RubyThread getRubyThreadFromThread(Thread thread) {
        RubyThread rubyThread;
        if (thread instanceof RubyNativeThread) {
            RubyNativeThread rubyNativeThread = (RubyNativeThread)thread;
            rubyThread = rubyNativeThread.getRubyThread();
        } else {
            rubyThread = this.mainContext.getThread();
        }
        return rubyThread;
    }

    public void setCritical(boolean bl) {
        if (this.criticalLock.isHeldByCurrentThread()) {
            if (!bl) {
                this.criticalLock.unlock();
            }
        } else if (bl) {
            this.criticalLock.lock();
        }
    }

    public boolean getCritical() {
        return this.criticalLock.isHeldByCurrentThread();
    }

    public void waitForCritical() {
        if (this.criticalLock.isLocked()) {
            this.criticalLock.lock();
            this.criticalLock.unlock();
        }
    }
}

