/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import org.jruby.Ruby;
import org.jruby.RubyProc;
import org.jruby.RubyThread;
import org.jruby.RubyThreadGroup;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThreadKill;
import org.jruby.runtime.Block;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyRunnable
implements Runnable {
    private Ruby runtime;
    private Frame currentFrame;
    private RubyProc proc;
    private IRubyObject[] arguments;
    private RubyThread rubyThread;
    private Thread javaThread;

    public RubyRunnable(RubyThread rubyThread, IRubyObject[] iRubyObjectArray, Block block) {
        this.rubyThread = rubyThread;
        this.runtime = rubyThread.getRuntime();
        ThreadContext threadContext = this.runtime.getCurrentContext();
        this.proc = this.runtime.newProc(Block.Type.THREAD, block);
        this.currentFrame = threadContext.getCurrentFrame();
        this.arguments = iRubyObjectArray;
    }

    public RubyThread getRubyThread() {
        return this.rubyThread;
    }

    public Thread getJavaThread() {
        return this.javaThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block10: {
            if (Ruby.RUNTIME_THREADLOCAL) {
                Ruby.setCurrentInstance(this.runtime);
            }
            this.javaThread = Thread.currentThread();
            ThreadContext threadContext = this.runtime.getThreadService().registerNewThread(this.rubyThread);
            threadContext.preRunThread(this.currentFrame);
            try {
                try {
                    IRubyObject iRubyObject = this.proc.call(threadContext, this.arguments);
                    this.rubyThread.cleanTerminate(iRubyObject);
                }
                catch (ThreadKill threadKill) {
                    Object object = this.rubyThread.killLock;
                    synchronized (object) {
                        this.rubyThread.killLock.notifyAll();
                    }
                    Object var6_7 = null;
                    this.runtime.getThreadService().setCritical(false);
                    this.runtime.getThreadService().unregisterThread(this.rubyThread);
                    ((RubyThreadGroup)this.rubyThread.group()).remove(this.rubyThread);
                    break block10;
                }
                catch (JumpException.ReturnJump returnJump) {
                    this.rubyThread.exceptionRaised(this.runtime.newThreadError("return can't jump across threads"));
                    Object var6_8 = null;
                    this.runtime.getThreadService().setCritical(false);
                    this.runtime.getThreadService().unregisterThread(this.rubyThread);
                    ((RubyThreadGroup)this.rubyThread.group()).remove(this.rubyThread);
                    break block10;
                }
                catch (RaiseException raiseException) {
                    this.rubyThread.exceptionRaised(raiseException);
                    Object var6_9 = null;
                    this.runtime.getThreadService().setCritical(false);
                    this.runtime.getThreadService().unregisterThread(this.rubyThread);
                    ((RubyThreadGroup)this.rubyThread.group()).remove(this.rubyThread);
                }
                Object var6_6 = null;
                this.runtime.getThreadService().setCritical(false);
                this.runtime.getThreadService().unregisterThread(this.rubyThread);
                ((RubyThreadGroup)this.rubyThread.group()).remove(this.rubyThread);
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                this.runtime.getThreadService().setCritical(false);
                this.runtime.getThreadService().unregisterThread(this.rubyThread);
                ((RubyThreadGroup)this.rubyThread.group()).remove(this.rubyThread);
                throw throwable;
            }
        }
    }
}

