/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import org.jruby.RubyThread;
import org.jruby.internal.runtime.RubyNativeThread;
import org.jruby.internal.runtime.ThreadLike;
import org.jruby.runtime.Block;
import org.jruby.runtime.builtin.IRubyObject;

public class NativeThread
implements ThreadLike {
    private Thread nativeThread;
    public RubyThread rubyThread;

    public NativeThread(RubyThread rubyThread, IRubyObject[] iRubyObjectArray, Block block) {
        this.rubyThread = rubyThread;
        this.nativeThread = new RubyNativeThread(rubyThread, iRubyObjectArray, block);
    }

    public NativeThread(RubyThread rubyThread, Thread thread) {
        this.rubyThread = rubyThread;
        this.nativeThread = thread;
    }

    public void start() {
        this.nativeThread.start();
    }

    public void interrupt() {
        this.nativeThread.interrupt();
    }

    public boolean isAlive() {
        return this.nativeThread.isAlive();
    }

    public void join() throws InterruptedException {
        this.nativeThread.join();
    }

    public void join(long l) throws InterruptedException {
        this.nativeThread.join(l);
    }

    public int getPriority() {
        return this.nativeThread.getPriority();
    }

    public void setPriority(int n) {
        this.nativeThread.setPriority(n);
    }

    public boolean isCurrent() {
        return Thread.currentThread() == this.nativeThread;
    }

    public boolean isInterrupted() {
        return this.nativeThread.isInterrupted();
    }
}

