/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.Union;
import com.sun.jna.ptr.IntByReference;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.posix.util.Platform;
import org.jruby.ext.socket.RubyBasicSocket;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.ChannelStream;
import org.jruby.util.io.ModeFlags;

public class RubyUNIXSocket
extends RubyBasicSocket {
    protected static LibCSocket INSTANCE = null;
    private static ObjectAllocator UNIXSOCKET_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new RubyUNIXSocket(ruby, rubyClass);
        }
    };
    protected int fd;
    protected String fpath;
    protected static final int F_GETFL = 3;
    protected static final int F_SETFL = 4;
    protected static final int O_NONBLOCK = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tryUnixDomainSocket() {
        if (INSTANCE != null) {
            return true;
        }
        try {
            Class<RubyUNIXSocket> clazz = RubyUNIXSocket.class;
            synchronized (RubyUNIXSocket.class) {
                if (INSTANCE != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return true;
                }
                INSTANCE = (LibCSocket)Native.loadLibrary((String)"c", LibCSocket.class);
                // ** MonitorExit[var0] (shouldn't be in output)
                return true;
            }
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    static void createUNIXSocket(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("UNIXSocket", ruby.fastGetClass("BasicSocket"), UNIXSOCKET_ALLOCATOR);
        ruby.getObject().fastSetConstant("UNIXsocket", rubyClass);
        CallbackFactory callbackFactory = ruby.callbackFactory(RubyUNIXSocket.class);
        rubyClass.defineFastMethod("initialize", callbackFactory.getFastMethod("initialize", IRubyObject.class));
        rubyClass.defineFastMethod("path", callbackFactory.getFastMethod("path"));
        rubyClass.defineFastMethod("addr", callbackFactory.getFastMethod("addr"));
        rubyClass.defineFastMethod("peeraddr", callbackFactory.getFastMethod("peeraddr"));
        rubyClass.defineFastMethod("recvfrom", callbackFactory.getFastOptMethod("recvfrom"));
        rubyClass.defineFastMethod("send_io", callbackFactory.getFastMethod("send_io", IRubyObject.class));
        rubyClass.defineFastMethod("recv_io", callbackFactory.getFastOptMethod("recv_io"));
        rubyClass.getMetaClass().defineFastMethod("socketpair", callbackFactory.getFastOptSingletonMethod("socketpair"));
        rubyClass.getMetaClass().defineFastMethod("pair", callbackFactory.getFastOptSingletonMethod("socketpair"));
        rubyClass.getMetaClass().defineFastMethod("open", callbackFactory.getFastSingletonMethod("open", IRubyObject.class));
    }

    public RubyUNIXSocket(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    protected void rb_sys_fail(String string) {
        RubyUNIXSocket.rb_sys_fail(this.getRuntime(), string);
    }

    protected static void rb_sys_fail(Ruby ruby, String string) {
        int n = Native.getLastError();
        Native.setLastError((int)0);
        IRubyObject iRubyObject = string != null ? ruby.newString(string) : ruby.getNil();
        RubyClass rubyClass = ruby.getErrno(n);
        if (rubyClass == null) {
            rubyClass = ruby.fastGetClass("SystemCallError");
            throw new RaiseException((RubyException)rubyClass.newInstance(ruby.getCurrentContext(), new IRubyObject[]{iRubyObject, ruby.newFixnum(n)}, Block.NULL_BLOCK));
        }
        throw new RaiseException((RubyException)rubyClass.newInstance(ruby.getCurrentContext(), new IRubyObject[]{iRubyObject}, Block.NULL_BLOCK));
    }

    protected void init_unixsock(IRubyObject iRubyObject, boolean bl) throws Exception {
        int n;
        this.fd = -1;
        try {
            this.fd = INSTANCE.socket(1, 1, 0);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        if (this.fd < 0) {
            this.rb_sys_fail("socket(2)");
        }
        LibCSocket.sockaddr_un sockaddr_un2 = new LibCSocket.sockaddr_un();
        sockaddr_un2.setFamily(1);
        ByteList byteList = iRubyObject.convertToString().getByteList();
        this.fpath = byteList.toString();
        if (sockaddr_un2.sun_path.length <= byteList.realSize) {
            throw this.getRuntime().newArgumentError("too long unix socket path (max: " + (sockaddr_un2.sun_path.length - 1) + "bytes)");
        }
        System.arraycopy(byteList.bytes, byteList.begin, sockaddr_un2.sun_path, 0, byteList.realSize);
        if (bl) {
            n = INSTANCE.bind(this.fd, sockaddr_un2, 106);
        } else {
            try {
                n = INSTANCE.connect(this.fd, sockaddr_un2, 106);
            }
            catch (RuntimeException runtimeException) {
                INSTANCE.close(this.fd);
                throw runtimeException;
            }
        }
        if (n < 0) {
            INSTANCE.close(this.fd);
            this.rb_sys_fail(this.fpath);
        }
        if (bl) {
            INSTANCE.listen(this.fd, 5);
        }
        this.init_sock();
        if (bl) {
            this.openFile.setPath(this.fpath);
        }
    }

    public IRubyObject setsockopt(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        int n = RubyNumeric.fix2int(iRubyObject);
        int n2 = RubyNumeric.fix2int(iRubyObject2);
        block0 : switch (n) {
            case 65535: {
                switch (n2) {
                    case 8: {
                        byte[] byArray;
                        if (this.asBoolean(iRubyObject3)) {
                            byte[] byArray2 = new byte[4];
                            byArray2[0] = 32;
                            byArray2[1] = 0;
                            byArray2[2] = 0;
                            byArray = byArray2;
                            byArray2[3] = 0;
                        } else {
                            byte[] byArray3 = new byte[4];
                            byArray3[0] = 0;
                            byArray3[1] = 0;
                            byArray3[2] = 0;
                            byArray = byArray3;
                            byArray3[3] = 0;
                        }
                        int n3 = INSTANCE.setsockopt(this.fd, n, n2, byArray, 4);
                        if (n3 != -1) break block0;
                        this.rb_sys_fail(this.openFile.getPath());
                        break block0;
                    }
                    default: {
                        throw this.getRuntime().newErrnoENOPROTOOPTError();
                    }
                }
            }
            default: {
                throw this.getRuntime().newErrnoENOPROTOOPTError();
            }
        }
        return this.getRuntime().newFixnum(0L);
    }

    protected void init_sock() throws Exception {
        ModeFlags modeFlags = new ModeFlags(2L);
        this.openFile.setMainStream(new ChannelStream(this.getRuntime(), new ChannelDescriptor(new UnixDomainSocketChannel(this.fd), RubyUNIXSocket.getNewFileno(), modeFlags, new FileDescriptor())));
        this.openFile.setPipeStream(this.openFile.getMainStream());
        this.openFile.setMode(modeFlags.getOpenFileFlags());
        this.openFile.getMainStream().setSync(true);
    }

    public IRubyObject initialize(IRubyObject iRubyObject) throws Exception {
        this.init_unixsock(iRubyObject, false);
        return this;
    }

    private String unixpath(LibCSocket.sockaddr_un sockaddr_un2, IntByReference intByReference) throws Exception {
        int n = 0;
        for (int i = 0; i < sockaddr_un2.sun_path.length; ++i) {
            if (sockaddr_un2.sun_path[i] != 0) continue;
            n = i;
            break;
        }
        if (intByReference.getValue() > 0) {
            return new String(sockaddr_un2.sun_path, 0, n, "ISO8859-1");
        }
        return "";
    }

    private IRubyObject unixaddr(LibCSocket.sockaddr_un sockaddr_un2, IntByReference intByReference) throws Exception {
        return this.getRuntime().newArrayNoCopy(new IRubyObject[]{this.getRuntime().newString("AF_UNIX"), this.getRuntime().newString(this.unixpath(sockaddr_un2, intByReference))});
    }

    public IRubyObject path() throws Exception {
        if (this.openFile.getPath() == null) {
            LibCSocket.sockaddr_un sockaddr_un2 = new LibCSocket.sockaddr_un();
            IntByReference intByReference = new IntByReference(106);
            if (INSTANCE.getsockname(this.fd, sockaddr_un2, intByReference) < 0) {
                this.rb_sys_fail(null);
            }
            this.openFile.setPath(this.unixpath(sockaddr_un2, intByReference));
        }
        return this.getRuntime().newString(this.openFile.getPath());
    }

    public IRubyObject addr() throws Exception {
        LibCSocket.sockaddr_un sockaddr_un2 = new LibCSocket.sockaddr_un();
        IntByReference intByReference = new IntByReference(106);
        if (INSTANCE.getsockname(this.fd, sockaddr_un2, intByReference) < 0) {
            this.rb_sys_fail("getsockname(2)");
        }
        return this.unixaddr(sockaddr_un2, intByReference);
    }

    public IRubyObject peeraddr() throws Exception {
        LibCSocket.sockaddr_un sockaddr_un2 = new LibCSocket.sockaddr_un();
        IntByReference intByReference = new IntByReference(106);
        if (INSTANCE.getpeername(this.fd, sockaddr_un2, intByReference) < 0) {
            this.rb_sys_fail("getpeername(2)");
        }
        return this.unixaddr(sockaddr_un2, intByReference);
    }

    public IRubyObject recvfrom(IRubyObject[] iRubyObjectArray) throws Exception {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1024);
        LibCSocket.sockaddr_un sockaddr_un2 = new LibCSocket.sockaddr_un();
        IntByReference intByReference = new IntByReference(106);
        IRubyObject iRubyObject = Arity.checkArgumentCount(this.getRuntime(), iRubyObjectArray, 1, 2) == 2 ? iRubyObjectArray[1] : this.getRuntime().getNil();
        IRubyObject iRubyObject2 = iRubyObjectArray[0];
        int n = iRubyObject.isNil() ? 0 : RubyNumeric.fix2int(iRubyObject);
        int n2 = RubyNumeric.fix2int(iRubyObject2);
        int n3 = INSTANCE.recvfrom(this.fd, byteBuffer, n2, n, sockaddr_un2, intByReference);
        if (n3 < 0) {
            this.rb_sys_fail("recvfrom(2)");
        }
        if (n3 < n2) {
            n2 = n3;
        }
        byte[] byArray = new byte[n2];
        byteBuffer.get(byArray);
        RubyString rubyString = this.getRuntime().newString(new ByteList(byArray, 0, n2, false));
        return this.getRuntime().newArrayNoCopy(new IRubyObject[]{rubyString, this.unixaddr(sockaddr_un2, intByReference)});
    }

    public IRubyObject send_io(IRubyObject iRubyObject) {
        return this.getRuntime().getNil();
    }

    public IRubyObject recv_io(IRubyObject[] iRubyObjectArray) {
        return this.getRuntime().getNil();
    }

    public IRubyObject close() {
        super.close();
        INSTANCE.close(this.fd);
        return this.getRuntime().getNil();
    }

    public static IRubyObject open(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return iRubyObject.callMethod(iRubyObject.getRuntime().getCurrentContext(), "new", new IRubyObject[]{iRubyObject2}, Block.NULL_BLOCK);
    }

    private static int getSocketType(IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyString) {
            String string = iRubyObject.toString();
            if ("SOCK_STREAM".equals(string)) {
                return 1;
            }
            if ("SOCK_DGRAM".equals(string)) {
                return 2;
            }
            if ("SOCK_RAW".equals(string)) {
                return 3;
            }
            return -1;
        }
        return RubyNumeric.fix2int(iRubyObject);
    }

    public static IRubyObject socketpair(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) throws Exception {
        int n = 1;
        Arity.checkArgumentCount(iRubyObject.getRuntime(), iRubyObjectArray, 0, 2);
        int n2 = iRubyObjectArray.length == 0 ? 1 : RubyUNIXSocket.getSocketType(iRubyObjectArray[0]);
        int n3 = iRubyObjectArray.length <= 1 ? 0 : RubyNumeric.fix2int(iRubyObjectArray[1]);
        int[] nArray = new int[2];
        int n4 = -1;
        try {
            n4 = INSTANCE.socketpair(n, n2, n3, nArray);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        if (n4 < 0) {
            RubyUNIXSocket.rb_sys_fail(iRubyObject.getRuntime(), "socketpair(2)");
        }
        RubyUNIXSocket rubyUNIXSocket = (RubyUNIXSocket)iRubyObject.getRuntime().fastGetClass("UNIXSocket").callMethod(iRubyObject.getRuntime().getCurrentContext(), "allocate", new IRubyObject[0]);
        rubyUNIXSocket.fd = nArray[0];
        rubyUNIXSocket.init_sock();
        RubyUNIXSocket rubyUNIXSocket2 = (RubyUNIXSocket)iRubyObject.getRuntime().fastGetClass("UNIXSocket").callMethod(iRubyObject.getRuntime().getCurrentContext(), "allocate", new IRubyObject[0]);
        rubyUNIXSocket2.fd = nArray[1];
        rubyUNIXSocket2.init_sock();
        return iRubyObject.getRuntime().newArrayNoCopy(new IRubyObject[]{rubyUNIXSocket, rubyUNIXSocket2});
    }

    public static interface LibCSocket
    extends Library {
        public int socketpair(int var1, int var2, int var3, int[] var4);

        public int socket(int var1, int var2, int var3);

        public int connect(int var1, sockaddr_un var2, int var3);

        public int bind(int var1, sockaddr_un var2, int var3);

        public int listen(int var1, int var2);

        public int accept(int var1, sockaddr_un var2, IntByReference var3);

        public int getsockname(int var1, sockaddr_un var2, IntByReference var3);

        public int getpeername(int var1, sockaddr_un var2, IntByReference var3);

        public int getsockopt(int var1, int var2, int var3, byte[] var4, IntByReference var5);

        public int setsockopt(int var1, int var2, int var3, byte[] var4, int var5);

        public int recv(int var1, Buffer var2, int var3, int var4);

        public int recvfrom(int var1, Buffer var2, int var3, int var4, sockaddr_un var5, IntByReference var6);

        public int send(int var1, Buffer var2, int var3, int var4);

        public int fcntl(int var1, int var2, int var3);

        public int unlink(String var1);

        public int close(int var1);

        public void perror(String var1);

        public static class sockaddr_un
        extends Structure {
            public static final int LENGTH = 106;
            public static final boolean hasLen = Platform.IS_BSD;
            public header sun_header;
            public byte[] sun_path = new byte[104];

            public void setFamily(int n) {
                if (hasLen) {
                    this.sun_header.famlen.sun_family = (byte)n;
                } else {
                    this.sun_header.sun_family = (short)n;
                }
            }

            public int getFamily() {
                if (hasLen) {
                    return this.sun_header.famlen.sun_family;
                }
                return this.sun_header.sun_family;
            }

            public static final class header
            extends Union {
                public famlen famlen;
                public short sun_family;

                public header() {
                    this.setType(hasLen ? famlen.class : Short.TYPE);
                }

                public static final class famlen
                extends Structure {
                    public byte sun_len;
                    public byte sun_family;
                }
            }
        }
    }

    private static class UnixDomainSocketChannel
    implements ReadableByteChannel,
    WritableByteChannel {
        private final int fd;
        private boolean open = true;

        public UnixDomainSocketChannel(int n) {
            this.fd = n;
        }

        public void close() throws IOException {
            this.open = false;
        }

        public boolean isOpen() {
            return this.open;
        }

        public int read(ByteBuffer byteBuffer) throws IOException {
            int n = byteBuffer.remaining();
            int n2 = INSTANCE.recv(this.fd, byteBuffer, n, 0);
            if (n2 != -1) {
                byteBuffer.position(byteBuffer.position() + n2);
            }
            return n2;
        }

        public int write(ByteBuffer byteBuffer) throws IOException {
            int n = byteBuffer.remaining();
            int n2 = INSTANCE.send(this.fd, byteBuffer, n, 0);
            if (n2 != -1) {
                byteBuffer.position(byteBuffer.position() + n2);
            }
            return n2;
        }
    }
}

