/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.socket.RubyBasicSocket;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyIPSocket
extends RubyBasicSocket {
    private static ObjectAllocator IPSOCKET_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new RubyIPSocket(ruby, rubyClass);
        }
    };

    static void createIPSocket(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("IPSocket", ruby.fastGetClass("BasicSocket"), IPSOCKET_ALLOCATOR);
        CallbackFactory callbackFactory = ruby.callbackFactory(RubyIPSocket.class);
        rubyClass.defineFastMethod("addr", callbackFactory.getFastMethod("addr"));
        rubyClass.defineFastMethod("peeraddr", callbackFactory.getFastMethod("peeraddr"));
        rubyClass.getMetaClass().defineFastMethod("getaddress", callbackFactory.getFastSingletonMethod("getaddress", IRubyObject.class));
        ruby.getObject().fastSetConstant("IPsocket", rubyClass);
    }

    public RubyIPSocket(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    protected static RuntimeException sockerr(IRubyObject iRubyObject, String string) {
        return new RaiseException(iRubyObject.getRuntime(), iRubyObject.getRuntime().fastGetClass("SocketError"), string, true);
    }

    private IRubyObject addrFor(InetSocketAddress inetSocketAddress) {
        IRubyObject[] iRubyObjectArray = new IRubyObject[4];
        Ruby ruby = this.getRuntime();
        iRubyObjectArray[0] = ruby.newString("AF_INET");
        iRubyObjectArray[1] = ruby.newFixnum(inetSocketAddress.getPort());
        iRubyObjectArray[2] = ruby.isDoNotReverseLookupEnabled() ? ruby.newString(inetSocketAddress.getAddress().getHostAddress()) : ruby.newString(inetSocketAddress.getHostName());
        iRubyObjectArray[3] = ruby.newString(inetSocketAddress.getAddress().getHostAddress());
        return ruby.newArrayNoCopy(iRubyObjectArray);
    }

    public IRubyObject addr() {
        return this.addrFor(this.getLocalSocket());
    }

    public IRubyObject peeraddr() {
        return this.addrFor(this.getRemoteSocket());
    }

    public static IRubyObject getaddress(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        try {
            return iRubyObject.getRuntime().newString(InetAddress.getByName(iRubyObject2.convertToString().toString()).getHostAddress());
        }
        catch (UnknownHostException unknownHostException) {
            throw RubyIPSocket.sockerr(iRubyObject, "getaddress: name or service not known");
        }
    }
}

