/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Chmod {
    private static final boolean CHMOD_API_AVAILABLE;
    private static final Method setWritable;
    private static final Method setReadable;
    private static final Method setExecutable;

    public static int chmod(File file, String string) {
        if (CHMOD_API_AVAILABLE) {
            char c = '0';
            if (string.length() >= 1) {
                c = string.charAt(string.length() - 1);
            }
            char c2 = '0';
            if (string.length() >= 3) {
                c2 = string.charAt(string.length() - 3);
            }
            if (!Chmod.setPermissions(file, c, false)) {
                return -1;
            }
            if (!Chmod.setPermissions(file, c2, true)) {
                return -1;
            }
        } else {
            try {
                Process process = Runtime.getRuntime().exec("/bin/chmod " + string + " " + file.getAbsolutePath());
                process.waitFor();
                return process.exitValue();
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return -1;
    }

    private static boolean setPermissions(File file, char c, boolean bl) {
        int n = Character.digit(c, 8);
        try {
            if ((n & 1) != 0) {
                setExecutable.invoke((Object)file, Boolean.TRUE, bl);
            } else {
                setExecutable.invoke((Object)file, Boolean.FALSE, bl);
            }
            if ((n & 2) != 0) {
                setWritable.invoke((Object)file, Boolean.TRUE, bl);
            } else {
                setWritable.invoke((Object)file, Boolean.FALSE, bl);
            }
            if ((n & 4) != 0) {
                setReadable.invoke((Object)file, Boolean.TRUE, bl);
            } else {
                setReadable.invoke((Object)file, Boolean.FALSE, bl);
            }
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return false;
    }

    static {
        boolean bl = false;
        Method method = null;
        Method method2 = null;
        Method method3 = null;
        try {
            method = File.class.getMethod("setWritable", Boolean.TYPE, Boolean.TYPE);
            method2 = File.class.getMethod("setReadable", Boolean.TYPE, Boolean.TYPE);
            method3 = File.class.getMethod("setExecutable", Boolean.TYPE, Boolean.TYPE);
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        setWritable = method;
        setReadable = method2;
        setExecutable = method3;
        CHMOD_API_AVAILABLE = bl;
    }
}

