/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import org.jruby.ext.posix.FileStat;
import org.jruby.ext.posix.JavaFileStat;
import org.jruby.ext.posix.JavaPasswd;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.POSIXHandler;
import org.jruby.ext.posix.Passwd;
import org.jruby.ext.posix.util.Chmod;
import org.jruby.ext.posix.util.ExecIt;
import org.jruby.ext.posix.util.FieldAccess;

public class JavaLibCHelper {
    public static final int STDIN = 0;
    public static final int STDOUT = 1;
    public static final int STDERR = 2;
    POSIXHandler handler;
    Field field;

    public JavaLibCHelper(POSIXHandler pOSIXHandler) {
        this.handler = pOSIXHandler;
        this.field = FieldAccess.getProtectedField(FileDescriptor.class, "fd");
    }

    public int chmod(String string, int n) {
        return Chmod.chmod(new File(string), Integer.toOctalString(n));
    }

    public int chown(String string, int n, int n2) {
        ExecIt execIt = new ExecIt(this.handler);
        int n3 = -1;
        int n4 = -1;
        try {
            if (n != -1) {
                n3 = execIt.runAndWait("chown", "" + n, string);
            }
            if (n2 != -1) {
                n4 = execIt.runAndWait("chgrp ", "" + n, string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n3 != -1 && n4 != -1 ? 0 : 1;
    }

    public int getfd(FileDescriptor fileDescriptor) {
        if (fileDescriptor == null || this.field == null) {
            return -1;
        }
        try {
            return this.field.getInt(fileDescriptor);
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return -1;
    }

    public String getlogin() {
        return System.getProperty("user.name");
    }

    public int getpid() {
        return this.handler.getPID();
    }

    public Passwd getpwent() {
        return new JavaPasswd(this.handler);
    }

    public int setpwent() {
        return 0;
    }

    public int endpwent() {
        return 0;
    }

    public int isatty(int n) {
        return n == 1 || n == 0 || n == 2 ? 1 : 0;
    }

    public int link(String string, String string2) {
        try {
            return new ExecIt(this.handler).runAndWait("ln", string, string2);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int lstat(String string, FileStat fileStat) {
        File file = new File(string);
        if (!file.exists()) {
            this.handler.error(POSIX.ERRORS.ENOENT, string);
        }
        JavaFileStat javaFileStat = (JavaFileStat)fileStat;
        javaFileStat.setup(string);
        return 0;
    }

    public int mkdir(String string, int n) {
        File file = new File(string);
        if (!file.mkdir()) {
            return -1;
        }
        this.chmod(string, n);
        return 0;
    }

    public int stat(String string, FileStat fileStat) {
        JavaFileStat javaFileStat = (JavaFileStat)fileStat;
        try {
            File file = new File(string);
            if (!file.exists()) {
                this.handler.error(POSIX.ERRORS.ENOENT, string);
            }
            javaFileStat.setup(file.getCanonicalPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0;
    }

    public int symlink(String string, String string2) {
        try {
            return new ExecIt(this.handler).runAndWait("ln", "-s", string, string2);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int readlink(String string, ByteBuffer byteBuffer, int n) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            new ExecIt(this.handler).runAndWait(byteArrayOutputStream, "readlink", string);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (byArray.length > n || byArray.length == 0) {
                return -1;
            }
            byteBuffer.put(byArray, 0, byArray.length - 1);
            return byteBuffer.position();
        }
        catch (InterruptedException interruptedException) {
            return -1;
        }
    }
}

