/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.evaluator;

import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBinding;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyMatchData;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.RubyRange;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ast.AliasNode;
import org.jruby.ast.ArgsCatNode;
import org.jruby.ast.ArgsPushNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.BeginNode;
import org.jruby.ast.BignumNode;
import org.jruby.ast.BinaryOperatorNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.BreakNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.CaseNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DRegexpNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.DSymbolNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.DXStrNode;
import org.jruby.ast.DefinedNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.DotNode;
import org.jruby.ast.EnsureNode;
import org.jruby.ast.EvStrNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.FlipNode;
import org.jruby.ast.FloatNode;
import org.jruby.ast.ForNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.HashNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.Match2Node;
import org.jruby.ast.Match3Node;
import org.jruby.ast.MatchNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.NextNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.NotNode;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.OpAsgnNode;
import org.jruby.ast.OpAsgnOrNode;
import org.jruby.ast.OpElementAsgnNode;
import org.jruby.ast.OrNode;
import org.jruby.ast.PostExeNode;
import org.jruby.ast.PreExeNode;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.RescueBodyNode;
import org.jruby.ast.ReturnNode;
import org.jruby.ast.RootNode;
import org.jruby.ast.SClassNode;
import org.jruby.ast.SValueNode;
import org.jruby.ast.SplatNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.SuperNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.ToAryNode;
import org.jruby.ast.UndefNode;
import org.jruby.ast.VAliasNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.WhenNode;
import org.jruby.ast.XStrNode;
import org.jruby.ast.YieldNode;
import org.jruby.ast.ZSuperNode;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.evaluator.AssignmentVisitor;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.DefaultMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.WrapperMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.InterpretedBlock;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.SharedScopeBlock;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.TypeConverter;

public class ASTInterpreter {
    public static IRubyObject eval(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        assert (iRubyObject != null) : "self during eval must never be null";
        try {
            return ASTInterpreter.evalInternal(ruby, threadContext, node, iRubyObject, block);
        }
        catch (StackOverflowError stackOverflowError) {
            throw ruby.newSystemStackError("stack level too deep");
        }
    }

    public static IRubyObject evalWithBinding(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, String string, int n) {
        assert (!iRubyObject2.isNil());
        Ruby ruby = iRubyObject.getRuntime();
        String string2 = threadContext.getFile();
        int n2 = threadContext.getLine();
        if (!(iRubyObject2 instanceof RubyBinding)) {
            if (iRubyObject2 instanceof RubyProc) {
                iRubyObject2 = ((RubyProc)iRubyObject2).binding();
            } else {
                throw ruby.newTypeError("wrong argument type " + iRubyObject2.getMetaClass() + " (expected Proc/Binding)");
            }
        }
        Binding binding = ((RubyBinding)iRubyObject2).getBinding();
        DynamicScope dynamicScope = binding.getDynamicScope().getEvalScope();
        if (string == null) {
            string = binding.getFrame().getFile();
        }
        if (n == -1) {
            n = binding.getFrame().getLine();
        }
        dynamicScope.getStaticScope().determineModule();
        try {
            threadContext.preEvalWithBinding(binding);
            IRubyObject iRubyObject3 = binding.getSelf();
            RubyString rubyString = iRubyObject.convertToString();
            Node node = ruby.parseEval(rubyString.getByteList(), string, dynamicScope, n);
            IRubyObject iRubyObject4 = ASTInterpreter.eval(ruby, threadContext, node, iRubyObject3, binding.getFrame().getBlock());
            return iRubyObject4;
        }
        catch (JumpException.BreakJump breakJump) {
            throw ruby.newLocalJumpError("break", (IRubyObject)breakJump.getValue(), "unexpected break");
        }
        catch (JumpException.RedoJump redoJump) {
            throw ruby.newLocalJumpError("redo", (IRubyObject)redoJump.getValue(), "unexpected redo");
        }
        finally {
            threadContext.postEvalWithBinding(binding);
            threadContext.setFile(string2);
            threadContext.setLine(n2);
        }
    }

    public static IRubyObject evalSimple(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, String string, int n) {
        assert (string != null);
        Ruby ruby = iRubyObject2.getRuntime();
        String string2 = threadContext.getFile();
        int n2 = threadContext.getLine();
        RubyString rubyString = iRubyObject2.convertToString();
        DynamicScope dynamicScope = threadContext.getCurrentScope().getEvalScope();
        dynamicScope.getStaticScope().determineModule();
        try {
            Node node = ruby.parseEval(rubyString.getByteList(), string, dynamicScope, n);
            IRubyObject iRubyObject3 = ASTInterpreter.eval(ruby, threadContext, node, iRubyObject, Block.NULL_BLOCK);
            return iRubyObject3;
        }
        catch (JumpException.BreakJump breakJump) {
            throw ruby.newLocalJumpError("break", (IRubyObject)breakJump.getValue(), "unexpected break");
        }
        finally {
            threadContext.setFile(string2);
            threadContext.setLine(n2);
        }
    }

    private static IRubyObject evalInternal(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        block94: while (true) {
            if (node == null) {
                return ASTInterpreter.nilNode(ruby, threadContext);
            }
            switch (node.nodeId) {
                case ALIASNODE: {
                    return ASTInterpreter.aliasNode(ruby, threadContext, node);
                }
                case ANDNODE: {
                    Object object = (BinaryOperatorNode)((Object)node);
                    IRubyObject iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, object.getFirstNode(), iRubyObject, block);
                    if (!iRubyObject2.isTrue()) {
                        return iRubyObject2;
                    }
                    node = object.getSecondNode();
                    continue block94;
                }
                case ARGSCATNODE: {
                    return ASTInterpreter.argsCatNode(ruby, threadContext, node, iRubyObject, block);
                }
                case ARGSPUSHNODE: {
                    return ASTInterpreter.argsPushNode(ruby, threadContext, node, iRubyObject, block);
                }
                case ARRAYNODE: {
                    return ASTInterpreter.arrayNode(ruby, threadContext, node, iRubyObject, block);
                }
                case ATTRASSIGNNODE: {
                    return ASTInterpreter.attrAssignNode(ruby, threadContext, node, iRubyObject, block);
                }
                case BACKREFNODE: {
                    return ASTInterpreter.backRefNode(threadContext, node);
                }
                case BEGINNODE: {
                    node = ((BeginNode)node).getBodyNode();
                    continue block94;
                }
                case BIGNUMNODE: {
                    return ASTInterpreter.bignumNode(ruby, node);
                }
                case BLOCKNODE: {
                    return ASTInterpreter.blockNode(ruby, threadContext, node, iRubyObject, block);
                }
                case BLOCKPASSNODE: {
                    assert (false) : "Call nodes and friends deal with this";
                }
                case BREAKNODE: {
                    return ASTInterpreter.breakNode(ruby, threadContext, node, iRubyObject, block);
                }
                case CALLNODE: {
                    return ASTInterpreter.callNode(ruby, threadContext, node, iRubyObject, block);
                }
                case CASENODE: {
                    return ASTInterpreter.caseNode(ruby, threadContext, node, iRubyObject, block);
                }
                case CLASSNODE: {
                    return ASTInterpreter.classNode(ruby, threadContext, node, iRubyObject, block);
                }
                case CLASSVARASGNNODE: {
                    return ASTInterpreter.classVarAsgnNode(ruby, threadContext, node, iRubyObject, block);
                }
                case CLASSVARDECLNODE: {
                    return ASTInterpreter.classVarDeclNode(ruby, threadContext, node, iRubyObject, block);
                }
                case CLASSVARNODE: {
                    return ASTInterpreter.classVarNode(ruby, threadContext, node, iRubyObject);
                }
                case COLON2NODE: {
                    return ASTInterpreter.colon2Node(ruby, threadContext, node, iRubyObject, block);
                }
                case COLON3NODE: {
                    return ASTInterpreter.colon3Node(ruby, node);
                }
                case CONSTDECLNODE: {
                    return ASTInterpreter.constDeclNode(ruby, threadContext, node, iRubyObject, block);
                }
                case CONSTNODE: {
                    return ASTInterpreter.constNode(threadContext, node);
                }
                case DASGNNODE: {
                    return ASTInterpreter.dAsgnNode(ruby, threadContext, node, iRubyObject, block);
                }
                case DEFINEDNODE: {
                    return ASTInterpreter.definedNode(ruby, threadContext, node, iRubyObject, block);
                }
                case DEFNNODE: {
                    return ASTInterpreter.defnNode(ruby, threadContext, node);
                }
                case DEFSNODE: {
                    return ASTInterpreter.defsNode(ruby, threadContext, node, iRubyObject, block);
                }
                case DOTNODE: {
                    return ASTInterpreter.dotNode(ruby, threadContext, node, iRubyObject, block);
                }
                case DREGEXPNODE: {
                    return ASTInterpreter.dregexpNode(ruby, threadContext, node, iRubyObject, block);
                }
                case DSTRNODE: {
                    return ASTInterpreter.dStrNode(ruby, threadContext, node, iRubyObject, block);
                }
                case DSYMBOLNODE: {
                    return ASTInterpreter.dSymbolNode(ruby, threadContext, node, iRubyObject, block);
                }
                case DVARNODE: {
                    return ASTInterpreter.dVarNode(ruby, threadContext, node);
                }
                case DXSTRNODE: {
                    return ASTInterpreter.dXStrNode(ruby, threadContext, node, iRubyObject, block);
                }
                case ENSURENODE: {
                    return ASTInterpreter.ensureNode(ruby, threadContext, node, iRubyObject, block);
                }
                case EVSTRNODE: {
                    return ASTInterpreter.evStrNode(ruby, threadContext, node, iRubyObject, block);
                }
                case FALSENODE: {
                    return ASTInterpreter.falseNode(ruby, threadContext);
                }
                case FCALLNODE: {
                    return ASTInterpreter.fCallNode(ruby, threadContext, node, iRubyObject, block);
                }
                case FIXNUMNODE: {
                    return ASTInterpreter.fixnumNode(ruby, node);
                }
                case FLIPNODE: {
                    return ASTInterpreter.flipNode(ruby, threadContext, node, iRubyObject, block);
                }
                case FLOATNODE: {
                    return ASTInterpreter.floatNode(ruby, node);
                }
                case FORNODE: {
                    return ASTInterpreter.forNode(ruby, threadContext, node, iRubyObject, block);
                }
                case GLOBALASGNNODE: {
                    return ASTInterpreter.globalAsgnNode(ruby, threadContext, node, iRubyObject, block);
                }
                case GLOBALVARNODE: {
                    return ASTInterpreter.globalVarNode(ruby, threadContext, node);
                }
                case HASHNODE: {
                    return ASTInterpreter.hashNode(ruby, threadContext, node, iRubyObject, block);
                }
                case IFNODE: {
                    Object object = (IfNode)node;
                    IRubyObject iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, ((IfNode)object).getCondition(), iRubyObject, block);
                    if (iRubyObject2.isTrue()) {
                        node = ((IfNode)object).getThenBody();
                        continue block94;
                    }
                    node = ((IfNode)object).getElseBody();
                    continue block94;
                }
                case INSTASGNNODE: {
                    return ASTInterpreter.instAsgnNode(ruby, threadContext, node, iRubyObject, block);
                }
                case INSTVARNODE: {
                    return ASTInterpreter.instVarNode(ruby, node, iRubyObject);
                }
                case ITERNODE: {
                    assert (false) : "Call nodes deal with these directly";
                }
                case LOCALASGNNODE: {
                    return ASTInterpreter.localAsgnNode(ruby, threadContext, node, iRubyObject, block);
                }
                case LOCALVARNODE: {
                    return ASTInterpreter.localVarNode(ruby, threadContext, node);
                }
                case MATCH2NODE: {
                    return ASTInterpreter.match2Node(ruby, threadContext, node, iRubyObject, block);
                }
                case MATCH3NODE: {
                    return ASTInterpreter.match3Node(ruby, threadContext, node, iRubyObject, block);
                }
                case MATCHNODE: {
                    return ASTInterpreter.matchNode(ruby, threadContext, node, iRubyObject, block);
                }
                case MODULENODE: {
                    return ASTInterpreter.moduleNode(ruby, threadContext, node, iRubyObject, block);
                }
                case MULTIPLEASGNNODE: {
                    return ASTInterpreter.multipleAsgnNode(ruby, threadContext, node, iRubyObject, block);
                }
                case NEWLINENODE: {
                    Object object = (NewlineNode)node;
                    threadContext.setFile(((Node)object).getPosition().getFile());
                    threadContext.setLine(((Node)object).getPosition().getStartLine());
                    if (ASTInterpreter.isTrace(ruby)) {
                        ASTInterpreter.callTraceFunction(ruby, threadContext, 0);
                    }
                    node = ((NewlineNode)object).getNextNode();
                    continue block94;
                }
                case NEXTNODE: {
                    return ASTInterpreter.nextNode(ruby, threadContext, node, iRubyObject, block);
                }
                case NILNODE: {
                    return ASTInterpreter.nilNode(ruby, threadContext);
                }
                case NOTNODE: {
                    return ASTInterpreter.notNode(ruby, threadContext, node, iRubyObject, block);
                }
                case NTHREFNODE: {
                    return ASTInterpreter.nthRefNode(threadContext, node);
                }
                case OPASGNANDNODE: {
                    Object object = (BinaryOperatorNode)((Object)node);
                    IRubyObject iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, object.getFirstNode(), iRubyObject, block);
                    if (!iRubyObject2.isTrue()) {
                        return ASTInterpreter.pollAndReturn(threadContext, iRubyObject2);
                    }
                    node = object.getSecondNode();
                    continue block94;
                }
                case OPASGNNODE: {
                    return ASTInterpreter.opAsgnNode(ruby, threadContext, node, iRubyObject, block);
                }
                case OPASGNORNODE: {
                    return ASTInterpreter.opAsgnOrNode(ruby, threadContext, node, iRubyObject, block);
                }
                case OPELEMENTASGNNODE: {
                    return ASTInterpreter.opElementAsgnNode(ruby, threadContext, node, iRubyObject, block);
                }
                case ORNODE: {
                    return ASTInterpreter.orNode(ruby, threadContext, node, iRubyObject, block);
                }
                case PREEXENODE: {
                    return ASTInterpreter.preExeNode(ruby, threadContext, node, iRubyObject, block);
                }
                case POSTEXENODE: {
                    return ASTInterpreter.postExeNode(ruby, threadContext, node, iRubyObject, block);
                }
                case REDONODE: {
                    return ASTInterpreter.redoNode(threadContext, node);
                }
                case REGEXPNODE: {
                    return ASTInterpreter.regexpNode(ruby, node);
                }
                case RESCUEBODYNODE: {
                    node = ((RescueBodyNode)node).getBodyNode();
                    continue block94;
                }
                case RESCUENODE: {
                    return ASTInterpreter.rescueNode(ruby, threadContext, node, iRubyObject, block);
                }
                case RETRYNODE: {
                    return ASTInterpreter.retryNode(threadContext);
                }
                case RETURNNODE: {
                    return ASTInterpreter.returnNode(ruby, threadContext, node, iRubyObject, block);
                }
                case ROOTNODE: {
                    return ASTInterpreter.rootNode(ruby, threadContext, node, iRubyObject, block);
                }
                case SCLASSNODE: {
                    return ASTInterpreter.sClassNode(ruby, threadContext, node, iRubyObject, block);
                }
                case SELFNODE: {
                    return ASTInterpreter.pollAndReturn(threadContext, iRubyObject);
                }
                case SPLATNODE: {
                    return ASTInterpreter.splatNode(ruby, threadContext, node, iRubyObject, block);
                }
                case STRNODE: {
                    return ASTInterpreter.strNode(ruby, node);
                }
                case SUPERNODE: {
                    return ASTInterpreter.superNode(ruby, threadContext, node, iRubyObject, block);
                }
                case SVALUENODE: {
                    return ASTInterpreter.sValueNode(ruby, threadContext, node, iRubyObject, block);
                }
                case SYMBOLNODE: {
                    return ASTInterpreter.symbolNode(ruby, node);
                }
                case TOARYNODE: {
                    return ASTInterpreter.toAryNode(ruby, threadContext, node, iRubyObject, block);
                }
                case TRUENODE: {
                    return ASTInterpreter.trueNode(ruby, threadContext);
                }
                case UNDEFNODE: {
                    return ASTInterpreter.undefNode(ruby, threadContext, node);
                }
                case UNTILNODE: {
                    return ASTInterpreter.untilNode(ruby, threadContext, node, iRubyObject, block);
                }
                case VALIASNODE: {
                    return ASTInterpreter.valiasNode(ruby, node);
                }
                case VCALLNODE: {
                    return ASTInterpreter.vcallNode(ruby, threadContext, node, iRubyObject);
                }
                case WHENNODE: {
                    assert (false);
                    return null;
                }
                case WHILENODE: {
                    return ASTInterpreter.whileNode(ruby, threadContext, node, iRubyObject, block);
                }
                case XSTRNODE: {
                    return ASTInterpreter.xStrNode(ruby, threadContext, node, iRubyObject);
                }
                case YIELDNODE: {
                    return ASTInterpreter.yieldNode(ruby, threadContext, node, iRubyObject, block);
                }
                case ZARRAYNODE: {
                    return ASTInterpreter.zArrayNode(ruby);
                }
                case ZSUPERNODE: {
                    return ASTInterpreter.zsuperNode(ruby, threadContext, node, iRubyObject, block);
                }
            }
            break;
        }
        throw new RuntimeException("Invalid node encountered in interpreter: \"" + node.getClass().getName() + "\", please report this at www.jruby.org");
    }

    private static IRubyObject aliasNode(Ruby ruby, ThreadContext threadContext, Node node) {
        AliasNode aliasNode = (AliasNode)node;
        RuntimeHelpers.defineAlias(threadContext, aliasNode.getNewName(), aliasNode.getOldName());
        RubyModule rubyModule = threadContext.getRubyClass();
        if (rubyModule == null) {
            throw ruby.newTypeError("no class to make alias");
        }
        rubyModule.defineAlias(aliasNode.getNewName(), aliasNode.getOldName());
        rubyModule.callMethod(threadContext, "method_added", ruby.fastNewSymbol(aliasNode.getNewName()));
        return ruby.getNil();
    }

    private static IRubyObject argsCatNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        ArgsCatNode argsCatNode = (ArgsCatNode)node;
        IRubyObject iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, argsCatNode.getFirstNode(), iRubyObject, block);
        RubyArray rubyArray = ASTInterpreter.splatValue(ruby, ASTInterpreter.evalInternal(ruby, threadContext, argsCatNode.getSecondNode(), iRubyObject, block));
        RubyArray rubyArray2 = iRubyObject2 instanceof RubyArray ? (RubyArray)iRubyObject2 : ruby.newArray(iRubyObject2);
        return rubyArray2.concat(rubyArray);
    }

    private static IRubyObject argsPushNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        ArgsPushNode argsPushNode = (ArgsPushNode)node;
        RubyArray rubyArray = (RubyArray)ASTInterpreter.evalInternal(ruby, threadContext, argsPushNode.getFirstNode(), iRubyObject, block).dup();
        return rubyArray.append(ASTInterpreter.evalInternal(ruby, threadContext, argsPushNode.getSecondNode(), iRubyObject, block));
    }

    private static IRubyObject arrayNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        ArrayNode arrayNode = (ArrayNode)node;
        IRubyObject[] iRubyObjectArray = new IRubyObject[arrayNode.size()];
        for (int i = 0; i < arrayNode.size(); ++i) {
            Node node2 = arrayNode.get(i);
            iRubyObjectArray[i] = ASTInterpreter.evalInternal(ruby, threadContext, node2, iRubyObject, block);
        }
        if (arrayNode.isLightweight()) {
            return ruby.newArrayNoCopyLight(iRubyObjectArray);
        }
        return ruby.newArrayNoCopy(iRubyObjectArray);
    }

    public static RubyArray arrayValue(Ruby ruby, IRubyObject iRubyObject) {
        IRubyObject iRubyObject2 = iRubyObject.checkArrayType();
        if (iRubyObject2.isNil()) {
            if (iRubyObject.getMetaClass().searchMethod("to_a").getImplementationClass() != ruby.getKernel()) {
                if (!((iRubyObject = iRubyObject.callMethod(ruby.getCurrentContext(), MethodIndex.TO_A, "to_a")) instanceof RubyArray)) {
                    throw ruby.newTypeError("`to_a' did not return Array");
                }
                return (RubyArray)iRubyObject;
            }
            return ruby.newArray(iRubyObject);
        }
        return (RubyArray)iRubyObject2;
    }

    public static IRubyObject aryToAry(Ruby ruby, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyArray) {
            return iRubyObject;
        }
        if (iRubyObject.respondsTo("to_ary")) {
            return TypeConverter.convertToType(iRubyObject, ruby.getArray(), MethodIndex.TO_A, "to_ary", false);
        }
        return ruby.newArray(iRubyObject);
    }

    private static IRubyObject attrAssignNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        String string;
        AttrAssignNode attrAssignNode = (AttrAssignNode)node;
        IRubyObject iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, attrAssignNode.getReceiverNode(), iRubyObject, block);
        IRubyObject[] iRubyObjectArray = ASTInterpreter.setupArgs(ruby, threadContext, attrAssignNode.getArgsNode(), iRubyObject, block);
        assert (iRubyObject2.getMetaClass() != null) : iRubyObject2.getClass().getName();
        CallType callType = iRubyObject2 == iRubyObject ? CallType.VARIABLE : CallType.NORMAL;
        RubyClass rubyClass = iRubyObject2.getMetaClass();
        DynamicMethod dynamicMethod = rubyClass.searchMethod(string = attrAssignNode.getName());
        if (dynamicMethod.isUndefined() || !dynamicMethod.isCallableFrom(iRubyObject, callType)) {
            RuntimeHelpers.callMethodMissing(threadContext, iRubyObject2, dynamicMethod, string, iRubyObjectArray, iRubyObject, callType, Block.NULL_BLOCK);
        } else {
            dynamicMethod.call(threadContext, iRubyObject2, (RubyModule)rubyClass, string, iRubyObjectArray);
        }
        return iRubyObjectArray[iRubyObjectArray.length - 1];
    }

    private static IRubyObject backRefNode(ThreadContext threadContext, Node node) {
        BackRefNode backRefNode = (BackRefNode)node;
        IRubyObject iRubyObject = threadContext.getCurrentFrame().getBackRef();
        switch (backRefNode.getType()) {
            case '&': {
                return RubyRegexp.last_match(iRubyObject);
            }
            case '`': {
                return RubyRegexp.match_pre(iRubyObject);
            }
            case '\'': {
                return RubyRegexp.match_post(iRubyObject);
            }
            case '+': {
                return RubyRegexp.match_last(iRubyObject);
            }
        }
        assert (false) : "backref with invalid type";
        return null;
    }

    private static IRubyObject bignumNode(Ruby ruby, Node node) {
        return RubyBignum.newBignum(ruby, ((BignumNode)node).getValue());
    }

    private static IRubyObject blockNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        BlockNode blockNode = (BlockNode)node;
        IRubyObject iRubyObject2 = ruby.getNil();
        for (int i = 0; i < blockNode.size(); ++i) {
            iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, blockNode.get(i), iRubyObject, block);
        }
        return iRubyObject2;
    }

    private static IRubyObject breakNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        BreakNode breakNode = (BreakNode)node;
        IRubyObject iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, breakNode.getValueNode(), iRubyObject, block);
        throw new JumpException.BreakJump(null, iRubyObject2);
    }

    /*
     * Loose catch block
     */
    private static IRubyObject callNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        CallNode callNode = (CallNode)node;
        IRubyObject iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, callNode.getReceiverNode(), iRubyObject, block);
        IRubyObject[] iRubyObjectArray = ASTInterpreter.setupArgs(ruby, threadContext, callNode.getArgsNode(), iRubyObject, block);
        assert (iRubyObject2.getMetaClass() != null) : iRubyObject2.getClass().getName();
        Block block2 = ASTInterpreter.getBlock(ruby, threadContext, iRubyObject, block, callNode.getIterNode());
        if (!block2.isGiven()) {
            return callNode.callAdapter.call(threadContext, iRubyObject2, iRubyObjectArray);
        }
        while (true) {
            try {
                return callNode.callAdapter.call(threadContext, iRubyObject2, iRubyObjectArray, block2);
            }
            catch (JumpException.RetryJump retryJump) {
                continue;
            }
            break;
        }
        catch (JumpException.BreakJump breakJump) {
            return (IRubyObject)breakJump.getValue();
        }
    }

    private static IRubyObject caseNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        CaseNode caseNode = (CaseNode)node;
        IRubyObject iRubyObject2 = null;
        if (caseNode.getCaseNode() != null) {
            iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, caseNode.getCaseNode(), iRubyObject, block);
        }
        threadContext.pollThreadEvents();
        IRubyObject iRubyObject3 = ruby.getNil();
        Node node2 = caseNode.getFirstWhenNode();
        while (node2 != null) {
            if (!(node2 instanceof WhenNode)) {
                node = node2;
                return ASTInterpreter.evalInternal(ruby, threadContext, node, iRubyObject, block);
            }
            WhenNode whenNode = (WhenNode)node2;
            if (whenNode.getExpressionNodes() instanceof ArrayNode) {
                ArrayNode arrayNode = (ArrayNode)whenNode.getExpressionNodes();
                threadContext.setFile(arrayNode.getPosition().getFile());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    Node node3 = arrayNode.get(i);
                    threadContext.setLine(node3.getPosition().getStartLine());
                    if (ASTInterpreter.isTrace(ruby)) {
                        ASTInterpreter.callTraceFunction(ruby, threadContext, 0);
                    }
                    if (node3 instanceof WhenNode) {
                        IRubyObject iRubyObject4 = ASTInterpreter.evalInternal(ruby, threadContext, ((WhenNode)node3).getExpressionNodes(), iRubyObject, block);
                        RubyArray rubyArray = ASTInterpreter.splatValue(ruby, iRubyObject4);
                        int n = rubyArray.getLength();
                        for (int j = 0; j < n; ++j) {
                            IRubyObject iRubyObject5 = rubyArray.eltInternal(j);
                            if ((iRubyObject2 == null || !iRubyObject5.callMethod(threadContext, MethodIndex.OP_EQQ, "===", iRubyObject2).isTrue()) && (iRubyObject2 != null || !iRubyObject5.isTrue())) continue;
                            node = ((WhenNode)node2).getBodyNode();
                            return ASTInterpreter.evalInternal(ruby, threadContext, node, iRubyObject, block);
                        }
                        continue;
                    }
                    iRubyObject3 = ASTInterpreter.evalInternal(ruby, threadContext, node3, iRubyObject, block);
                    if ((iRubyObject2 == null || !iRubyObject3.callMethod(threadContext, MethodIndex.OP_EQQ, "===", iRubyObject2).isTrue()) && (iRubyObject2 != null || !iRubyObject3.isTrue())) continue;
                    node = whenNode.getBodyNode();
                    return ASTInterpreter.evalInternal(ruby, threadContext, node, iRubyObject, block);
                }
            } else {
                iRubyObject3 = ASTInterpreter.evalInternal(ruby, threadContext, whenNode.getExpressionNodes(), iRubyObject, block);
                if (iRubyObject2 != null && iRubyObject3.callMethod(threadContext, MethodIndex.OP_EQQ, "===", iRubyObject2).isTrue() || iRubyObject2 == null && iRubyObject3.isTrue()) {
                    node = ((WhenNode)node2).getBodyNode();
                    return ASTInterpreter.evalInternal(ruby, threadContext, node, iRubyObject, block);
                }
            }
            threadContext.pollThreadEvents();
            node2 = whenNode.getNextCase();
        }
        return ruby.getNil();
    }

    private static IRubyObject classNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        Object object;
        ClassNode classNode = (ClassNode)node;
        Colon3Node colon3Node = classNode.getCPath();
        RubyModule rubyModule = ASTInterpreter.getEnclosingModule(ruby, threadContext, colon3Node, iRubyObject, block);
        if (rubyModule == null) {
            throw ruby.newTypeError("no outer class/module");
        }
        Node node2 = classNode.getSuperNode();
        RubyClass rubyClass = null;
        if (node2 != null) {
            object = ASTInterpreter.evalInternal(ruby, threadContext, node2, iRubyObject, block);
            RubyClass.checkInheritable((IRubyObject)object);
            rubyClass = (RubyClass)object;
        }
        object = ((INameNode)colon3Node).getName();
        RubyClass rubyClass2 = rubyModule.defineOrGetClassUnder((String)object, rubyClass);
        StaticScope staticScope = classNode.getScope();
        staticScope.setModule(rubyClass2);
        return ASTInterpreter.evalClassDefinitionBody(ruby, threadContext, staticScope, classNode.getBodyNode(), rubyClass2, iRubyObject, block);
    }

    private static IRubyObject classVarAsgnNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        ClassVarAsgnNode classVarAsgnNode = (ClassVarAsgnNode)node;
        IRubyObject iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, classVarAsgnNode.getValueNode(), iRubyObject, block);
        RubyModule rubyModule = ASTInterpreter.getClassVariableBase(threadContext, ruby);
        if (rubyModule == null) {
            rubyModule = iRubyObject.getMetaClass();
        }
        rubyModule.fastSetClassVar(classVarAsgnNode.getName(), iRubyObject2);
        return iRubyObject2;
    }

    private static IRubyObject classVarDeclNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        ClassVarDeclNode classVarDeclNode = (ClassVarDeclNode)node;
        RubyModule rubyModule = ASTInterpreter.getClassVariableBase(threadContext, ruby);
        if (rubyModule == null) {
            throw ruby.newTypeError("no class/module to define class variable");
        }
        IRubyObject iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, classVarDeclNode.getValueNode(), iRubyObject, block);
        rubyModule.fastSetClassVar(classVarDeclNode.getName(), iRubyObject2);
        return iRubyObject2;
    }

    private static IRubyObject classVarNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject) {
        ClassVarNode classVarNode = (ClassVarNode)node;
        RubyModule rubyModule = ASTInterpreter.getClassVariableBase(threadContext, ruby);
        if (rubyModule == null) {
            rubyModule = iRubyObject.getMetaClass();
        }
        return rubyModule.getClassVar(classVarNode.getName());
    }

    private static IRubyObject colon2Node(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        Colon2Node colon2Node = (Colon2Node)node;
        Node node2 = colon2Node.getLeftNode();
        if (node2 == null) {
            return ruby.getObject().fastGetConstantFrom(colon2Node.getName());
        }
        IRubyObject iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, colon2Node.getLeftNode(), iRubyObject, block);
        if (iRubyObject2 instanceof RubyModule) {
            return ((RubyModule)iRubyObject2).fastGetConstantFrom(colon2Node.getName());
        }
        return iRubyObject2.callMethod(threadContext, colon2Node.getName(), IRubyObject.NULL_ARRAY, block);
    }

    private static IRubyObject colon3Node(Ruby ruby, Node node) {
        return ruby.getObject().fastGetConstantFrom(((Colon3Node)node).getName());
    }

    private static IRubyObject constDeclNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        ConstDeclNode constDeclNode = (ConstDeclNode)node;
        Node node2 = constDeclNode.getConstNode();
        IRubyObject iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, constDeclNode.getValueNode(), iRubyObject, block);
        if (node2 == null) {
            return threadContext.setConstantInCurrent(constDeclNode.getName(), iRubyObject2);
        }
        if (node2.nodeId == NodeType.COLON2NODE) {
            IRubyObject iRubyObject3 = ASTInterpreter.evalInternal(ruby, threadContext, ((Colon2Node)constDeclNode.getConstNode()).getLeftNode(), iRubyObject, block);
            return threadContext.setConstantInModule(constDeclNode.getName(), iRubyObject3, iRubyObject2);
        }
        return threadContext.setConstantInObject(constDeclNode.getName(), iRubyObject2);
    }

    private static IRubyObject constNode(ThreadContext threadContext, Node node) {
        return threadContext.getConstant(((ConstNode)node).getName());
    }

    private static IRubyObject dAsgnNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        DAsgnNode dAsgnNode = (DAsgnNode)node;
        IRubyObject iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, dAsgnNode.getValueNode(), iRubyObject, block);
        threadContext.getCurrentScope().setValue(dAsgnNode.getIndex(), iRubyObject2, dAsgnNode.getDepth());
        return iRubyObject2;
    }

    private static IRubyObject definedNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        DefinedNode definedNode = (DefinedNode)node;
        String string = ASTInterpreter.getDefinition(ruby, threadContext, definedNode.getExpressionNode(), iRubyObject, block);
        if (string != null) {
            return ruby.newString(string);
        }
        return ruby.getNil();
    }

    private static IRubyObject defnNode(Ruby ruby, ThreadContext threadContext, Node node) {
        DefnNode defnNode = (DefnNode)node;
        RubyModule rubyModule = threadContext.getRubyClass();
        if (rubyModule == null) {
            throw ruby.newTypeError("No class to add method.");
        }
        String string = defnNode.getName();
        if (rubyModule == ruby.getObject() && string == "initialize") {
            ruby.getWarnings().warn(IRubyWarnings.ID.REDEFINING_DANGEROUS, "redefining Object#initialize may cause infinite loop", "Object#initialize");
        }
        if (string == "__id__" || string == "__send__") {
            ruby.getWarnings().warn(IRubyWarnings.ID.REDEFINING_DANGEROUS, "redefining `" + string + "' may cause serious problem", string);
        }
        Visibility visibility = threadContext.getCurrentVisibility();
        if (string == "initialize" || visibility == Visibility.MODULE_FUNCTION) {
            visibility = Visibility.PRIVATE;
        }
        StaticScope staticScope = defnNode.getScope();
        staticScope.determineModule();
        DefaultMethod defaultMethod = new DefaultMethod(rubyModule, staticScope, defnNode.getBodyNode(), defnNode.getArgsNode(), visibility, defnNode.getPosition());
        rubyModule.addMethod(string, defaultMethod);
        if (threadContext.getCurrentVisibility() == Visibility.MODULE_FUNCTION) {
            rubyModule.getSingletonClass().addMethod(string, new WrapperMethod((RubyModule)rubyModule.getSingletonClass(), defaultMethod, Visibility.PUBLIC));
            rubyModule.callMethod(threadContext, "singleton_method_added", ruby.fastNewSymbol(string));
        }
        if (rubyModule.isSingleton()) {
            ((MetaClass)rubyModule).getAttached().callMethod(threadContext, "singleton_method_added", ruby.fastNewSymbol(defnNode.getName()));
        } else {
            rubyModule.callMethod(threadContext, "method_added", ruby.fastNewSymbol(string));
        }
        return ruby.getNil();
    }

    private static IRubyObject defsNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        DefsNode defsNode = (DefsNode)node;
        IRubyObject iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, defsNode.getReceiverNode(), iRubyObject, block);
        String string = defsNode.getName();
        if (ruby.getSafeLevel() >= 4 && !iRubyObject2.isTaint()) {
            throw ruby.newSecurityError("Insecure; can't define singleton method.");
        }
        if (iRubyObject2 instanceof RubyFixnum || iRubyObject2 instanceof RubySymbol) {
            throw ruby.newTypeError("can't define singleton method \"" + string + "\" for " + iRubyObject2.getMetaClass().getBaseName());
        }
        if (iRubyObject2.isFrozen()) {
            throw ruby.newFrozenError("object");
        }
        RubyClass rubyClass = iRubyObject2.getSingletonClass();
        if (ruby.getSafeLevel() >= 4 && rubyClass.getMethods().get(string) != null) {
            throw ruby.newSecurityError("redefining method prohibited.");
        }
        StaticScope staticScope = defsNode.getScope();
        staticScope.determineModule();
        DefaultMethod defaultMethod = new DefaultMethod(rubyClass, staticScope, defsNode.getBodyNode(), defsNode.getArgsNode(), Visibility.PUBLIC, defsNode.getPosition());
        rubyClass.addMethod(string, defaultMethod);
        iRubyObject2.callMethod(threadContext, "singleton_method_added", ruby.fastNewSymbol(string));
        return ruby.getNil();
    }

    private static IRubyObject dotNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        DotNode dotNode = (DotNode)node;
        return RubyRange.newRange(ruby, threadContext, ASTInterpreter.evalInternal(ruby, threadContext, dotNode.getBeginNode(), iRubyObject, block), ASTInterpreter.evalInternal(ruby, threadContext, dotNode.getEndNode(), iRubyObject, block), dotNode.isExclusive());
    }

    private static IRubyObject dregexpNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        RubyRegexp rubyRegexp;
        DRegexpNode dRegexpNode = (DRegexpNode)node;
        if (dRegexpNode.getOnce() && (rubyRegexp = dRegexpNode.getOnceRegexp()) != null) {
            return rubyRegexp;
        }
        RubyString rubyString = ruby.newString(new ByteList());
        for (int i = 0; i < dRegexpNode.size(); ++i) {
            Node node2 = dRegexpNode.get(i);
            if (node2 instanceof StrNode) {
                rubyString.getByteList().append(((StrNode)node2).getValue());
                continue;
            }
            rubyString.append(ASTInterpreter.evalInternal(ruby, threadContext, node2, iRubyObject, block));
        }
        try {
            rubyRegexp = RubyRegexp.newRegexp(ruby, rubyString.getByteList(), dRegexpNode.getOptions());
        }
        catch (Exception exception) {
            throw ruby.newRegexpError(exception.getMessage());
        }
        if (dRegexpNode.getOnce()) {
            dRegexpNode.setOnceRegexp(rubyRegexp);
        }
        return rubyRegexp;
    }

    private static IRubyObject dStrNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        DStrNode dStrNode = (DStrNode)node;
        RubyString rubyString = ruby.newString(new ByteList());
        for (int i = 0; i < dStrNode.size(); ++i) {
            Node node2 = dStrNode.get(i);
            if (node2 instanceof StrNode) {
                rubyString.getByteList().append(((StrNode)node2).getValue());
                continue;
            }
            rubyString.append(ASTInterpreter.evalInternal(ruby, threadContext, node2, iRubyObject, block));
        }
        return rubyString;
    }

    private static IRubyObject dSymbolNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        DSymbolNode dSymbolNode = (DSymbolNode)node;
        RubyString rubyString = ruby.newString(new ByteList());
        for (int i = 0; i < dSymbolNode.size(); ++i) {
            Node node2 = dSymbolNode.get(i);
            if (node2 instanceof StrNode) {
                rubyString.getByteList().append(((StrNode)node2).getValue());
                continue;
            }
            rubyString.append(ASTInterpreter.evalInternal(ruby, threadContext, node2, iRubyObject, block));
        }
        return ruby.newSymbol(rubyString.toString());
    }

    private static IRubyObject dVarNode(Ruby ruby, ThreadContext threadContext, Node node) {
        DVarNode dVarNode = (DVarNode)node;
        IRubyObject iRubyObject = threadContext.getCurrentScope().getValue(dVarNode.getIndex(), dVarNode.getDepth());
        return iRubyObject == null ? ruby.getNil() : iRubyObject;
    }

    private static IRubyObject dXStrNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        DXStrNode dXStrNode = (DXStrNode)node;
        RubyString rubyString = ruby.newString(new ByteList());
        for (int i = 0; i < dXStrNode.size(); ++i) {
            Node node2 = dXStrNode.get(i);
            if (node2 instanceof StrNode) {
                rubyString.getByteList().append(((StrNode)node2).getValue());
                continue;
            }
            rubyString.append(ASTInterpreter.evalInternal(ruby, threadContext, node2, iRubyObject, block));
        }
        return iRubyObject.callMethod(threadContext, "`", rubyString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject ensureNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        EnsureNode ensureNode = (EnsureNode)node;
        if (ensureNode.getEnsureNode() != null) {
            IRubyObject iRubyObject2 = ruby.getNil();
            try {
                iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, ensureNode.getBodyNode(), iRubyObject, block);
            }
            finally {
                ASTInterpreter.evalInternal(ruby, threadContext, ensureNode.getEnsureNode(), iRubyObject, block);
            }
            return iRubyObject2;
        }
        node = ensureNode.getBodyNode();
        return ASTInterpreter.evalInternal(ruby, threadContext, node, iRubyObject, block);
    }

    private static IRubyObject evStrNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        return ASTInterpreter.evalInternal(ruby, threadContext, ((EvStrNode)node).getBody(), iRubyObject, block).asString();
    }

    private static IRubyObject falseNode(Ruby ruby, ThreadContext threadContext) {
        return ASTInterpreter.pollAndReturn(threadContext, ruby.getFalse());
    }

    private static IRubyObject fCallNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        FCallNode fCallNode = (FCallNode)node;
        IRubyObject[] iRubyObjectArray = ASTInterpreter.setupArgs(ruby, threadContext, fCallNode.getArgsNode(), iRubyObject, block);
        Block block2 = ASTInterpreter.getBlock(ruby, threadContext, iRubyObject, block, fCallNode.getIterNode());
        if (!block2.isGiven()) {
            return fCallNode.callAdapter.call(threadContext, iRubyObject, iRubyObjectArray);
        }
        while (true) {
            try {
                return fCallNode.callAdapter.call(threadContext, iRubyObject, iRubyObjectArray, block2);
            }
            catch (JumpException.RetryJump retryJump) {
                continue;
            }
            break;
        }
    }

    private static IRubyObject fixnumNode(Ruby ruby, Node node) {
        return ((FixnumNode)node).getFixnum(ruby);
    }

    private static IRubyObject flipNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        FlipNode flipNode = (FlipNode)node;
        DynamicScope dynamicScope = threadContext.getCurrentScope();
        DynamicScope dynamicScope2 = dynamicScope.getNthParentScope(flipNode.getDepth());
        if (dynamicScope2 != null) {
            dynamicScope2.growIfNeeded();
        }
        IRubyObject iRubyObject2 = dynamicScope.getValue(flipNode.getIndex(), flipNode.getDepth());
        if (flipNode.isExclusive()) {
            if (iRubyObject2 == null || !iRubyObject2.isTrue()) {
                iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, flipNode.getBeginNode(), iRubyObject, block).isTrue() ? ruby.getTrue() : ruby.getFalse();
                dynamicScope.setValue(flipNode.getIndex(), iRubyObject2, flipNode.getDepth());
                return iRubyObject2;
            }
            if (ASTInterpreter.evalInternal(ruby, threadContext, flipNode.getEndNode(), iRubyObject, block).isTrue()) {
                dynamicScope.setValue(flipNode.getIndex(), ruby.getFalse(), flipNode.getDepth());
            }
            return ruby.getTrue();
        }
        if (iRubyObject2 == null || !iRubyObject2.isTrue()) {
            if (ASTInterpreter.evalInternal(ruby, threadContext, flipNode.getBeginNode(), iRubyObject, block).isTrue()) {
                dynamicScope.setValue(flipNode.getIndex(), ASTInterpreter.evalInternal(ruby, threadContext, flipNode.getEndNode(), iRubyObject, block).isTrue() ? ruby.getFalse() : ruby.getTrue(), flipNode.getDepth());
                return ruby.getTrue();
            }
            return ruby.getFalse();
        }
        if (ASTInterpreter.evalInternal(ruby, threadContext, flipNode.getEndNode(), iRubyObject, block).isTrue()) {
            dynamicScope.setValue(flipNode.getIndex(), ruby.getFalse(), flipNode.getDepth());
        }
        return ruby.getTrue();
    }

    private static IRubyObject floatNode(Ruby ruby, Node node) {
        return RubyFloat.newFloat(ruby, ((FloatNode)node).getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject forNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        ForNode forNode = (ForNode)node;
        Block block2 = SharedScopeBlock.newInterpretedSharedScopeClosure(threadContext, forNode, threadContext.getCurrentScope(), iRubyObject);
        try {
            while (true) {
                try {
                    String string = threadContext.getFile();
                    int n = threadContext.getLine();
                    IRubyObject iRubyObject2 = null;
                    try {
                        iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, forNode.getIterNode(), iRubyObject, block);
                    }
                    finally {
                        threadContext.setFile(string);
                        threadContext.setLine(n);
                    }
                    return forNode.callAdapter.call(threadContext, iRubyObject2, block2);
                }
                catch (JumpException.RetryJump retryJump) {
                    continue;
                }
                break;
            }
        }
        catch (JumpException.BreakJump breakJump) {
            return (IRubyObject)breakJump.getValue();
        }
    }

    private static IRubyObject globalAsgnNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        GlobalAsgnNode globalAsgnNode = (GlobalAsgnNode)node;
        IRubyObject iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, globalAsgnNode.getValueNode(), iRubyObject, block);
        ruby.getGlobalVariables().set(globalAsgnNode.getName(), iRubyObject2);
        return iRubyObject2;
    }

    private static IRubyObject globalVarNode(Ruby ruby, ThreadContext threadContext, Node node) {
        GlobalVarNode globalVarNode = (GlobalVarNode)node;
        return ruby.getGlobalVariables().get(globalVarNode.getName());
    }

    private static IRubyObject hashNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        HashNode hashNode = (HashNode)node;
        RubyHash rubyHash = null;
        if (hashNode.getListNode() != null) {
            rubyHash = RubyHash.newHash(ruby);
            int n = 0;
            while (n < hashNode.getListNode().size()) {
                IRubyObject iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, hashNode.getListNode().get(n++), iRubyObject, block);
                IRubyObject iRubyObject3 = ASTInterpreter.evalInternal(ruby, threadContext, hashNode.getListNode().get(n++), iRubyObject, block);
                rubyHash.fastASet(iRubyObject2, iRubyObject3);
            }
        }
        if (rubyHash == null) {
            return RubyHash.newHash(ruby);
        }
        return rubyHash;
    }

    private static IRubyObject instAsgnNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        InstAsgnNode instAsgnNode = (InstAsgnNode)node;
        IRubyObject iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, instAsgnNode.getValueNode(), iRubyObject, block);
        iRubyObject.getInstanceVariables().fastSetInstanceVariable(instAsgnNode.getName(), iRubyObject2);
        return iRubyObject2;
    }

    private static IRubyObject instVarNode(Ruby ruby, Node node, IRubyObject iRubyObject) {
        InstVarNode instVarNode = (InstVarNode)node;
        IRubyObject iRubyObject2 = iRubyObject.getInstanceVariables().fastGetInstanceVariable(instVarNode.getName());
        if (iRubyObject2 != null) {
            return iRubyObject2;
        }
        ruby.getWarnings().warning(IRubyWarnings.ID.IVAR_NOT_INITIALIZED, instVarNode.getPosition(), "instance variable " + instVarNode.getName() + " not initialized", instVarNode.getName());
        return ruby.getNil();
    }

    private static IRubyObject localAsgnNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        LocalAsgnNode localAsgnNode = (LocalAsgnNode)node;
        IRubyObject iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, localAsgnNode.getValueNode(), iRubyObject, block);
        threadContext.getCurrentScope().setValue(localAsgnNode.getIndex(), iRubyObject2, localAsgnNode.getDepth());
        return iRubyObject2;
    }

    private static IRubyObject localVarNode(Ruby ruby, ThreadContext threadContext, Node node) {
        LocalVarNode localVarNode = (LocalVarNode)node;
        IRubyObject iRubyObject = threadContext.getCurrentScope().getValue(localVarNode.getIndex(), localVarNode.getDepth());
        return iRubyObject == null ? ruby.getNil() : iRubyObject;
    }

    private static IRubyObject match2Node(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        Match2Node match2Node = (Match2Node)node;
        IRubyObject iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, match2Node.getReceiverNode(), iRubyObject, block);
        IRubyObject iRubyObject3 = ASTInterpreter.evalInternal(ruby, threadContext, match2Node.getValueNode(), iRubyObject, block);
        return ((RubyRegexp)iRubyObject2).op_match(threadContext, iRubyObject3);
    }

    private static IRubyObject match3Node(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        Match3Node match3Node = (Match3Node)node;
        IRubyObject iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, match3Node.getReceiverNode(), iRubyObject, block);
        IRubyObject iRubyObject3 = ASTInterpreter.evalInternal(ruby, threadContext, match3Node.getValueNode(), iRubyObject, block);
        if (iRubyObject3 instanceof RubyString) {
            return ((RubyRegexp)iRubyObject2).op_match(threadContext, iRubyObject3);
        }
        return match3Node.callAdapter.call(threadContext, iRubyObject3, iRubyObject2);
    }

    private static IRubyObject matchNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        return ((RubyRegexp)ASTInterpreter.evalInternal(ruby, threadContext, ((MatchNode)node).getRegexpNode(), iRubyObject, block)).op_match2(threadContext);
    }

    private static IRubyObject moduleNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        ModuleNode moduleNode = (ModuleNode)node;
        Colon3Node colon3Node = moduleNode.getCPath();
        RubyModule rubyModule = ASTInterpreter.getEnclosingModule(ruby, threadContext, colon3Node, iRubyObject, block);
        if (rubyModule == null) {
            throw ruby.newTypeError("no outer class/module");
        }
        String string = ((INameNode)colon3Node).getName();
        RubyModule rubyModule2 = rubyModule.defineOrGetModuleUnder(string);
        StaticScope staticScope = moduleNode.getScope();
        staticScope.setModule(rubyModule2);
        return ASTInterpreter.evalClassDefinitionBody(ruby, threadContext, staticScope, moduleNode.getBodyNode(), rubyModule2, iRubyObject, block);
    }

    private static IRubyObject multipleAsgnNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        MultipleAsgnNode multipleAsgnNode = (MultipleAsgnNode)node;
        switch (multipleAsgnNode.getValueNode().nodeId) {
            case ARRAYNODE: {
                ArrayNode arrayNode = (ArrayNode)multipleAsgnNode.getValueNode();
                return ASTInterpreter.multipleAsgnArrayNode(ruby, threadContext, multipleAsgnNode, arrayNode, iRubyObject, block);
            }
            case SPLATNODE: {
                SplatNode splatNode = (SplatNode)multipleAsgnNode.getValueNode();
                RubyArray rubyArray = ASTInterpreter.splatValue(ruby, ASTInterpreter.evalInternal(ruby, threadContext, splatNode.getValue(), iRubyObject, block));
                return AssignmentVisitor.multiAssign(ruby, threadContext, iRubyObject, multipleAsgnNode, rubyArray, false);
            }
        }
        IRubyObject iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, multipleAsgnNode.getValueNode(), iRubyObject, block);
        if (!(iRubyObject2 instanceof RubyArray)) {
            iRubyObject2 = RubyArray.newArray(ruby, iRubyObject2);
        }
        return AssignmentVisitor.multiAssign(ruby, threadContext, iRubyObject, multipleAsgnNode, (RubyArray)iRubyObject2, false);
    }

    private static IRubyObject multipleAsgnArrayNode(Ruby ruby, ThreadContext threadContext, MultipleAsgnNode multipleAsgnNode, ArrayNode arrayNode, IRubyObject iRubyObject, Block block) {
        IRubyObject[] iRubyObjectArray = new IRubyObject[arrayNode.size()];
        for (int i = 0; i < arrayNode.size(); ++i) {
            Node node = arrayNode.get(i);
            iRubyObjectArray[i] = ASTInterpreter.evalInternal(ruby, threadContext, node, iRubyObject, block);
        }
        return AssignmentVisitor.multiAssign(ruby, threadContext, iRubyObject, multipleAsgnNode, RubyArray.newArrayNoCopyLight(ruby, iRubyObjectArray), false);
    }

    private static IRubyObject nextNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        NextNode nextNode = (NextNode)node;
        threadContext.pollThreadEvents();
        IRubyObject iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, nextNode.getValueNode(), iRubyObject, block);
        throw new JumpException.NextJump(iRubyObject2);
    }

    private static IRubyObject nilNode(Ruby ruby, ThreadContext threadContext) {
        return ASTInterpreter.pollAndReturn(threadContext, ruby.getNil());
    }

    private static IRubyObject notNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        NotNode notNode = (NotNode)node;
        IRubyObject iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, notNode.getConditionNode(), iRubyObject, block);
        return iRubyObject2.isTrue() ? ruby.getFalse() : ruby.getTrue();
    }

    private static IRubyObject nthRefNode(ThreadContext threadContext, Node node) {
        return RubyRegexp.nth_match(((NthRefNode)node).getMatchNumber(), threadContext.getCurrentFrame().getBackRef());
    }

    public static IRubyObject pollAndReturn(ThreadContext threadContext, IRubyObject iRubyObject) {
        threadContext.pollThreadEvents();
        return iRubyObject;
    }

    private static IRubyObject opAsgnNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        OpAsgnNode opAsgnNode = (OpAsgnNode)node;
        IRubyObject iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, opAsgnNode.getReceiverNode(), iRubyObject, block);
        IRubyObject iRubyObject3 = opAsgnNode.variableCallAdapter.call(threadContext, iRubyObject2);
        if (opAsgnNode.getOperatorName() == "||") {
            if (iRubyObject3.isTrue()) {
                return ASTInterpreter.pollAndReturn(threadContext, iRubyObject3);
            }
            iRubyObject3 = ASTInterpreter.evalInternal(ruby, threadContext, opAsgnNode.getValueNode(), iRubyObject, block);
        } else if (opAsgnNode.getOperatorName() == "&&") {
            if (!iRubyObject3.isTrue()) {
                return ASTInterpreter.pollAndReturn(threadContext, iRubyObject3);
            }
            iRubyObject3 = ASTInterpreter.evalInternal(ruby, threadContext, opAsgnNode.getValueNode(), iRubyObject, block);
        } else {
            iRubyObject3 = opAsgnNode.operatorCallAdapter.call(threadContext, iRubyObject3, ASTInterpreter.evalInternal(ruby, threadContext, opAsgnNode.getValueNode(), iRubyObject, block));
        }
        opAsgnNode.variableAsgnCallAdapter.call(threadContext, iRubyObject2, iRubyObject3);
        return ASTInterpreter.pollAndReturn(threadContext, iRubyObject3);
    }

    private static IRubyObject opAsgnOrNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        OpAsgnOrNode opAsgnOrNode = (OpAsgnOrNode)node;
        String string = ASTInterpreter.getDefinition(ruby, threadContext, opAsgnOrNode.getFirstNode(), iRubyObject, block);
        IRubyObject iRubyObject2 = ruby.getNil();
        if (string != null) {
            iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, opAsgnOrNode.getFirstNode(), iRubyObject, block);
        }
        if (!iRubyObject2.isTrue()) {
            iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, opAsgnOrNode.getSecondNode(), iRubyObject, block);
        }
        return ASTInterpreter.pollAndReturn(threadContext, iRubyObject2);
    }

    private static IRubyObject opElementAsgnNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        OpElementAsgnNode opElementAsgnNode = (OpElementAsgnNode)node;
        IRubyObject iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, opElementAsgnNode.getReceiverNode(), iRubyObject, block);
        IRubyObject[] iRubyObjectArray = ASTInterpreter.setupArgs(ruby, threadContext, opElementAsgnNode.getArgsNode(), iRubyObject, block);
        IRubyObject iRubyObject3 = opElementAsgnNode.elementAdapter.call(threadContext, iRubyObject2, iRubyObjectArray);
        if (opElementAsgnNode.getOperatorName() == "||") {
            if (iRubyObject3.isTrue()) {
                return iRubyObject3;
            }
            iRubyObject3 = ASTInterpreter.evalInternal(ruby, threadContext, opElementAsgnNode.getValueNode(), iRubyObject, block);
        } else if (opElementAsgnNode.getOperatorName() == "&&") {
            if (!iRubyObject3.isTrue()) {
                return iRubyObject3;
            }
            iRubyObject3 = ASTInterpreter.evalInternal(ruby, threadContext, opElementAsgnNode.getValueNode(), iRubyObject, block);
        } else {
            iRubyObject3 = opElementAsgnNode.callAdapter.call(threadContext, iRubyObject3, ASTInterpreter.evalInternal(ruby, threadContext, opElementAsgnNode.getValueNode(), iRubyObject, block));
        }
        IRubyObject[] iRubyObjectArray2 = new IRubyObject[iRubyObjectArray.length + 1];
        System.arraycopy(iRubyObjectArray, 0, iRubyObjectArray2, 0, iRubyObjectArray.length);
        iRubyObjectArray2[iRubyObjectArray2.length - 1] = iRubyObject3;
        opElementAsgnNode.elementAsgnAdapter.call(threadContext, iRubyObject2, iRubyObjectArray2);
        return iRubyObject3;
    }

    private static IRubyObject orNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        OrNode orNode = (OrNode)node;
        IRubyObject iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, orNode.getFirstNode(), iRubyObject, block);
        if (!iRubyObject2.isTrue()) {
            iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, orNode.getSecondNode(), iRubyObject, block);
        }
        return iRubyObject2;
    }

    private static IRubyObject postExeNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        PostExeNode postExeNode = (PostExeNode)node;
        Block block2 = SharedScopeBlock.newInterpretedSharedScopeClosure(threadContext, postExeNode, threadContext.getCurrentScope(), iRubyObject);
        ruby.pushExitBlock(ruby.newProc(Block.Type.LAMBDA, block2));
        return ruby.getNil();
    }

    private static IRubyObject preExeNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        PreExeNode preExeNode = (PreExeNode)node;
        DynamicScope dynamicScope = DynamicScope.newDynamicScope(preExeNode.getScope());
        threadContext.preScopedBody(dynamicScope);
        Block block2 = InterpretedBlock.newInterpretedClosure(threadContext, preExeNode, iRubyObject);
        block2.yield(threadContext, null);
        threadContext.postScopedBody();
        return ruby.getNil();
    }

    private static IRubyObject redoNode(ThreadContext threadContext, Node node) {
        threadContext.pollThreadEvents();
        throw JumpException.REDO_JUMP;
    }

    private static IRubyObject regexpNode(Ruby ruby, Node node) {
        RegexpNode regexpNode = (RegexpNode)node;
        RubyRegexp rubyRegexp = regexpNode.getPattern();
        if (rubyRegexp == null) {
            rubyRegexp = RubyRegexp.newRegexp(ruby, regexpNode.getValue(), regexpNode.getOptions());
            regexpNode.setPattern(rubyRegexp);
        }
        return rubyRegexp;
    }

    /*
     * Exception decompiling
     */
    private static IRubyObject rescueNode(Ruby var0, ThreadContext var1_1, Node var2_2, IRubyObject var3_3, Block var4_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 10[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static IRubyObject retryNode(ThreadContext threadContext) {
        threadContext.pollThreadEvents();
        throw JumpException.RETRY_JUMP;
    }

    private static IRubyObject returnNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        ReturnNode returnNode = (ReturnNode)node;
        IRubyObject iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, returnNode.getValueNode(), iRubyObject, block);
        throw new JumpException.ReturnJump(threadContext.getFrameJumpTarget(), iRubyObject2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject rootNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        RootNode rootNode = (RootNode)node;
        DynamicScope dynamicScope = rootNode.getScope();
        if (dynamicScope == null) {
            dynamicScope = DynamicScope.newDynamicScope(rootNode.getStaticScope());
        }
        StaticScope staticScope = dynamicScope.getStaticScope();
        threadContext.preScopedBody(dynamicScope);
        if (staticScope.getModule() == null) {
            staticScope.setModule(ruby.getObject());
        }
        try {
            IRubyObject iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, rootNode.getBodyNode(), iRubyObject, block);
            return iRubyObject2;
        }
        finally {
            threadContext.postScopedBody();
        }
    }

    private static IRubyObject sClassNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        SClassNode sClassNode = (SClassNode)node;
        IRubyObject iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, sClassNode.getReceiverNode(), iRubyObject, block);
        if (iRubyObject2 instanceof RubyFixnum || iRubyObject2 instanceof RubySymbol) {
            throw ruby.newTypeError("no virtual class for " + iRubyObject2.getMetaClass().getBaseName());
        }
        if (ruby.getSafeLevel() >= 4 && !iRubyObject2.isTaint()) {
            throw ruby.newSecurityError("Insecure: can't extend object.");
        }
        RubyClass rubyClass = iRubyObject2.getSingletonClass();
        StaticScope staticScope = sClassNode.getScope();
        staticScope.setModule(rubyClass);
        return ASTInterpreter.evalClassDefinitionBody(ruby, threadContext, staticScope, sClassNode.getBodyNode(), rubyClass, iRubyObject, block);
    }

    private static IRubyObject splatNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        return ASTInterpreter.splatValue(ruby, ASTInterpreter.evalInternal(ruby, threadContext, ((SplatNode)node).getValue(), iRubyObject, block));
    }

    private static IRubyObject strNode(Ruby ruby, Node node) {
        return ruby.newStringShared(((StrNode)node).getValue());
    }

    private static IRubyObject superNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        SuperNode superNode = (SuperNode)node;
        RubyModule rubyModule = threadContext.getFrameKlazz();
        if (rubyModule == null) {
            String string = threadContext.getFrameName();
            throw ruby.newNameError("Superclass method '" + string + "' disabled.", string);
        }
        IRubyObject[] iRubyObjectArray = ASTInterpreter.setupArgs(ruby, threadContext, superNode.getArgsNode(), iRubyObject, block);
        Block block2 = ASTInterpreter.getBlock(ruby, threadContext, iRubyObject, block, superNode.getIterNode());
        if (superNode.getIterNode() == null && !block2.isGiven()) {
            block2 = block;
        }
        return iRubyObject.callSuper(threadContext, iRubyObjectArray, block2);
    }

    private static IRubyObject sValueNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        return ASTInterpreter.aValueSplat(ruby, ASTInterpreter.evalInternal(ruby, threadContext, ((SValueNode)node).getValue(), iRubyObject, block));
    }

    private static IRubyObject symbolNode(Ruby ruby, Node node) {
        return ((SymbolNode)node).getSymbol(ruby);
    }

    private static IRubyObject toAryNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        return ASTInterpreter.aryToAry(ruby, ASTInterpreter.evalInternal(ruby, threadContext, ((ToAryNode)node).getValue(), iRubyObject, block));
    }

    private static IRubyObject trueNode(Ruby ruby, ThreadContext threadContext) {
        return ASTInterpreter.pollAndReturn(threadContext, ruby.getTrue());
    }

    private static IRubyObject undefNode(Ruby ruby, ThreadContext threadContext, Node node) {
        UndefNode undefNode = (UndefNode)node;
        RubyModule rubyModule = threadContext.getRubyClass();
        if (rubyModule == null) {
            throw ruby.newTypeError("No class to undef method '" + undefNode.getName() + "'.");
        }
        rubyModule.undef(threadContext, undefNode.getName());
        return ruby.getNil();
    }

    /*
     * Exception decompiling
     */
    private static IRubyObject untilNode(Ruby var0, ThreadContext var1_1, Node var2_2, IRubyObject var3_3, Block var4_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 3[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static IRubyObject valiasNode(Ruby ruby, Node node) {
        VAliasNode vAliasNode = (VAliasNode)node;
        ruby.getGlobalVariables().alias(vAliasNode.getNewName(), vAliasNode.getOldName());
        return ruby.getNil();
    }

    private static IRubyObject vcallNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject) {
        VCallNode vCallNode = (VCallNode)node;
        return vCallNode.callAdapter.call(threadContext, iRubyObject);
    }

    /*
     * Exception decompiling
     */
    private static IRubyObject whileNode(Ruby var0, ThreadContext var1_1, Node var2_2, IRubyObject var3_3, Block var4_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[UNCONDITIONALDOLOOP]], but top level block is 4[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static IRubyObject xStrNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject) {
        return iRubyObject.callMethod(threadContext, "`", ruby.newStringShared(((XStrNode)node).getValue()));
    }

    private static IRubyObject yieldNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        YieldNode yieldNode = (YieldNode)node;
        IRubyObject iRubyObject2 = null;
        if (yieldNode.getArgsNode() != null) {
            iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, yieldNode.getArgsNode(), iRubyObject, block);
        }
        Block block2 = threadContext.getCurrentFrame().getBlock();
        return block2.yield(threadContext, iRubyObject2, null, null, yieldNode.getCheckState());
    }

    private static IRubyObject zArrayNode(Ruby ruby) {
        return ruby.newArray();
    }

    private static IRubyObject zsuperNode(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        Block block2 = ASTInterpreter.getBlock(ruby, threadContext, iRubyObject, block, ((ZSuperNode)node).getIterNode());
        return RuntimeHelpers.callZSuper(ruby, threadContext, block2, iRubyObject);
    }

    public static IRubyObject aValueSplat(Ruby ruby, IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof RubyArray) || ((RubyArray)iRubyObject).length().getLongValue() == 0L) {
            return ruby.getNil();
        }
        RubyArray rubyArray = (RubyArray)iRubyObject;
        return rubyArray.getLength() == 1 ? rubyArray.first(IRubyObject.NULL_ARRAY) : rubyArray;
    }

    private static void callTraceFunction(Ruby ruby, ThreadContext threadContext, int n) {
        String string = threadContext.getFrameName();
        RubyModule rubyModule = threadContext.getFrameKlazz();
        ruby.callEventHooks(threadContext, n, threadContext.getFile(), threadContext.getLine(), string, rubyModule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject evalClassDefinitionBody(Ruby ruby, ThreadContext threadContext, StaticScope staticScope, Node node, RubyModule rubyModule, IRubyObject iRubyObject, Block block) {
        threadContext.preClassEval(staticScope, rubyModule);
        try {
            if (ASTInterpreter.isTrace(ruby)) {
                ASTInterpreter.callTraceFunction(ruby, threadContext, 1);
            }
            IRubyObject iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, node, rubyModule, block);
            return iRubyObject2;
        }
        finally {
            if (ASTInterpreter.isTrace(ruby)) {
                ASTInterpreter.callTraceFunction(ruby, threadContext, 2);
            }
            threadContext.postClassEval();
        }
    }

    private static String getArgumentDefinition(Ruby ruby, ThreadContext threadContext, Node node, String string, IRubyObject iRubyObject, Block block) {
        if (node == null) {
            return string;
        }
        if (node instanceof ArrayNode) {
            for (int i = 0; i < ((ArrayNode)node).size(); ++i) {
                Node node2 = ((ArrayNode)node).get(i);
                if (ASTInterpreter.getDefinitionInner(ruby, threadContext, node2, iRubyObject, block) != null) continue;
                return null;
            }
        } else if (ASTInterpreter.getDefinitionInner(ruby, threadContext, node, iRubyObject, block) == null) {
            return null;
        }
        return string;
    }

    public static Block getBlock(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block, Node node) {
        if (node == null) {
            return Block.NULL_BLOCK;
        }
        if (node instanceof IterNode) {
            IterNode iterNode = (IterNode)node;
            StaticScope staticScope = iterNode.getScope();
            staticScope.determineModule();
            return InterpretedBlock.newInterpretedClosure(threadContext, iterNode.getBlockBody(), iRubyObject);
        }
        if (node instanceof BlockPassNode) {
            BlockPassNode blockPassNode = (BlockPassNode)node;
            IRubyObject iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, blockPassNode.getBodyNode(), iRubyObject, block);
            return RuntimeHelpers.getBlockFromBlockPassBody(iRubyObject2, block);
        }
        assert (false) : "Trying to get block from something which cannot deliver";
        return null;
    }

    public static RubyModule getClassVariableBase(ThreadContext threadContext, Ruby ruby) {
        StaticScope staticScope = threadContext.getCurrentScope().getStaticScope();
        RubyModule rubyModule = staticScope.getModule();
        if (rubyModule.isSingleton()) {
            staticScope = staticScope.getPreviousCRefScope();
            rubyModule = staticScope.getModule();
            if (staticScope.getPreviousCRefScope() == null) {
                ruby.getWarnings().warn(IRubyWarnings.ID.CVAR_FROM_TOPLEVEL_SINGLETON_METHOD, "class variable access from toplevel singleton method", new Object[0]);
            }
        }
        return rubyModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDefinition(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        try {
            threadContext.setWithinDefined(true);
            String string = ASTInterpreter.getDefinitionInner(ruby, threadContext, node, iRubyObject, block);
            return string;
        }
        finally {
            threadContext.setWithinDefined(false);
        }
    }

    private static String getDefinitionInner(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        if (node == null) {
            return "expression";
        }
        switch (node.nodeId) {
            case ATTRASSIGNNODE: {
                AttrAssignNode attrAssignNode = (AttrAssignNode)node;
                if (ASTInterpreter.getDefinitionInner(ruby, threadContext, attrAssignNode.getReceiverNode(), iRubyObject, block) != null) {
                    try {
                        IRubyObject iRubyObject2 = ASTInterpreter.eval(ruby, threadContext, attrAssignNode.getReceiverNode(), iRubyObject, block);
                        RubyClass rubyClass = iRubyObject2.getMetaClass();
                        DynamicMethod dynamicMethod = rubyClass.searchMethod(attrAssignNode.getName());
                        Visibility visibility = dynamicMethod.getVisibility();
                        if (visibility != Visibility.PRIVATE && (visibility != Visibility.PROTECTED || rubyClass.getRealClass().isInstance(iRubyObject)) && rubyClass.isMethodBound(attrAssignNode.getName(), false)) {
                            return ASTInterpreter.getArgumentDefinition(ruby, threadContext, attrAssignNode.getArgsNode(), "assignment", iRubyObject, block);
                        }
                    }
                    catch (JumpException jumpException) {
                        // empty catch block
                    }
                }
                return null;
            }
            case BACKREFNODE: {
                IRubyObject iRubyObject3 = threadContext.getCurrentFrame().getBackRef();
                if (iRubyObject3 instanceof RubyMatchData) {
                    return "$" + ((BackRefNode)node).getType();
                }
                return null;
            }
            case CALLNODE: {
                CallNode callNode = (CallNode)node;
                if (ASTInterpreter.getDefinitionInner(ruby, threadContext, callNode.getReceiverNode(), iRubyObject, block) != null) {
                    try {
                        IRubyObject iRubyObject4 = ASTInterpreter.eval(ruby, threadContext, callNode.getReceiverNode(), iRubyObject, block);
                        RubyClass rubyClass = iRubyObject4.getMetaClass();
                        DynamicMethod dynamicMethod = rubyClass.searchMethod(callNode.getName());
                        Visibility visibility = dynamicMethod.getVisibility();
                        if (visibility != Visibility.PRIVATE && (visibility != Visibility.PROTECTED || rubyClass.getRealClass().isInstance(iRubyObject)) && rubyClass.isMethodBound(callNode.getName(), false)) {
                            return ASTInterpreter.getArgumentDefinition(ruby, threadContext, callNode.getArgsNode(), "method", iRubyObject, block);
                        }
                    }
                    catch (JumpException jumpException) {
                        // empty catch block
                    }
                }
                return null;
            }
            case CLASSVARASGNNODE: 
            case CLASSVARDECLNODE: 
            case CONSTDECLNODE: 
            case DASGNNODE: 
            case GLOBALASGNNODE: 
            case LOCALASGNNODE: 
            case MULTIPLEASGNNODE: 
            case OPASGNNODE: 
            case OPELEMENTASGNNODE: {
                return "assignment";
            }
            case CLASSVARNODE: {
                ClassVarNode classVarNode = (ClassVarNode)node;
                RubyModule rubyModule = threadContext.getCurrentScope().getStaticScope().getModule();
                if (rubyModule == null && iRubyObject.getMetaClass().fastIsClassVarDefined(classVarNode.getName())) {
                    return "class variable";
                }
                if (rubyModule.fastIsClassVarDefined(classVarNode.getName())) {
                    return "class variable";
                }
                IRubyObject iRubyObject5 = null;
                if (rubyModule.isSingleton()) {
                    iRubyObject5 = ((MetaClass)rubyModule).getAttached();
                }
                if (iRubyObject5 instanceof RubyModule && (rubyModule = (RubyModule)iRubyObject5).fastIsClassVarDefined(classVarNode.getName())) {
                    return "class variable";
                }
                return null;
            }
            case COLON2NODE: 
            case COLON3NODE: {
                Colon3Node colon3Node = (Colon3Node)node;
                try {
                    IRubyObject iRubyObject6 = ruby.getObject();
                    if (colon3Node instanceof Colon2Node) {
                        iRubyObject6 = ASTInterpreter.eval(ruby, threadContext, ((Colon2Node)colon3Node).getLeftNode(), iRubyObject, block);
                    }
                    if (iRubyObject6 instanceof RubyModule && ((RubyModule)iRubyObject6).fastGetConstantAt(colon3Node.getName()) != null) {
                        return "constant";
                    }
                    if (iRubyObject6.getMetaClass().isMethodBound(colon3Node.getName(), true)) {
                        return "method";
                    }
                }
                catch (JumpException jumpException) {
                    // empty catch block
                }
                return null;
            }
            case CONSTNODE: {
                if (threadContext.getConstantDefined(((ConstNode)node).getName())) {
                    return "constant";
                }
                return null;
            }
            case DVARNODE: {
                return "local-variable(in-block)";
            }
            case FALSENODE: {
                return "false";
            }
            case FCALLNODE: {
                FCallNode fCallNode = (FCallNode)node;
                if (iRubyObject.getMetaClass().isMethodBound(fCallNode.getName(), false)) {
                    return ASTInterpreter.getArgumentDefinition(ruby, threadContext, fCallNode.getArgsNode(), "method", iRubyObject, block);
                }
                return null;
            }
            case GLOBALVARNODE: {
                if (ruby.getGlobalVariables().isDefined(((GlobalVarNode)node).getName())) {
                    return "global-variable";
                }
                return null;
            }
            case INSTVARNODE: {
                if (iRubyObject.getInstanceVariables().fastHasInstanceVariable(((InstVarNode)node).getName())) {
                    return "instance-variable";
                }
                return null;
            }
            case LOCALVARNODE: {
                return "local-variable";
            }
            case MATCH2NODE: 
            case MATCH3NODE: {
                return "method";
            }
            case NILNODE: {
                return "nil";
            }
            case NTHREFNODE: {
                IRubyObject iRubyObject7 = threadContext.getCurrentFrame().getBackRef();
                if (iRubyObject7 instanceof RubyMatchData) {
                    ((RubyMatchData)iRubyObject7).use();
                    if (!((RubyMatchData)iRubyObject7).group(((NthRefNode)node).getMatchNumber()).isNil()) {
                        return "$" + ((NthRefNode)node).getMatchNumber();
                    }
                }
                return null;
            }
            case SELFNODE: {
                return "self";
            }
            case SUPERNODE: {
                SuperNode superNode = (SuperNode)node;
                String string = threadContext.getFrameName();
                RubyModule rubyModule = threadContext.getFrameKlazz();
                if (string != null && rubyModule != null && rubyModule.getSuperClass().isMethodBound(string, false)) {
                    return ASTInterpreter.getArgumentDefinition(ruby, threadContext, superNode.getArgsNode(), "super", iRubyObject, block);
                }
                return null;
            }
            case TRUENODE: {
                return "true";
            }
            case VCALLNODE: {
                VCallNode vCallNode = (VCallNode)node;
                if (iRubyObject.getMetaClass().isMethodBound(vCallNode.getName(), false)) {
                    return "method";
                }
                return null;
            }
            case YIELDNODE: {
                return block.isGiven() ? "yield" : null;
            }
            case ZSUPERNODE: {
                String string = threadContext.getFrameName();
                RubyModule rubyModule = threadContext.getFrameKlazz();
                if (string != null && rubyModule != null && rubyModule.getSuperClass().isMethodBound(string, false)) {
                    return "super";
                }
                return null;
            }
        }
        try {
            ASTInterpreter.eval(ruby, threadContext, node, iRubyObject, block);
            return "expression";
        }
        catch (JumpException jumpException) {
            return null;
        }
    }

    private static RubyModule getEnclosingModule(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        RubyModule rubyModule = null;
        if (node instanceof Colon2Node) {
            IRubyObject iRubyObject2 = ASTInterpreter.evalInternal(ruby, threadContext, ((Colon2Node)node).getLeftNode(), iRubyObject, block);
            if (iRubyObject2 != null && !iRubyObject2.isNil()) {
                rubyModule = (RubyModule)iRubyObject2;
            }
        } else if (node instanceof Colon3Node) {
            rubyModule = ruby.getObject();
        }
        if (rubyModule == null) {
            rubyModule = threadContext.getCurrentScope().getStaticScope().getModule();
        }
        return rubyModule;
    }

    private static boolean isTrace(Ruby ruby) {
        return ruby.hasEventHooks();
    }

    private static IRubyObject[] setupArgs(Ruby ruby, ThreadContext threadContext, Node node, IRubyObject iRubyObject, Block block) {
        if (node == null) {
            return IRubyObject.NULL_ARRAY;
        }
        if (node instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)node;
            String string = threadContext.getFile();
            int n = threadContext.getLine();
            int n2 = arrayNode.size();
            IRubyObject[] iRubyObjectArray = new IRubyObject[n2];
            for (int i = 0; i < n2; ++i) {
                iRubyObjectArray[i] = ASTInterpreter.evalInternal(ruby, threadContext, arrayNode.get(i), iRubyObject, block);
            }
            threadContext.setFile(string);
            threadContext.setLine(n);
            return iRubyObjectArray;
        }
        return ArgsUtil.convertToJavaArray(ASTInterpreter.evalInternal(ruby, threadContext, node, iRubyObject, block));
    }

    public static RubyArray splatValue(Ruby ruby, IRubyObject iRubyObject) {
        if (iRubyObject.isNil()) {
            return ruby.newArray(iRubyObject);
        }
        return ASTInterpreter.arrayValue(ruby, iRubyObject);
    }

    public static RubyArray splatValue(IRubyObject iRubyObject, Ruby ruby) {
        return ASTInterpreter.splatValue(ruby, iRubyObject);
    }

    public static IRubyObject aValueSplat(IRubyObject iRubyObject, Ruby ruby) {
        return ASTInterpreter.aValueSplat(ruby, iRubyObject);
    }

    public static IRubyObject aryToAry(IRubyObject iRubyObject, Ruby ruby) {
        return ASTInterpreter.aryToAry(ruby, iRubyObject);
    }
}

