/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import java.util.Arrays;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.impl.AbstractVariableCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;

public class HeapBasedVariableCompiler
extends AbstractVariableCompiler {
    protected int scopeIndex;
    protected int varsIndex;

    public HeapBasedVariableCompiler(StandardASMCompiler.AbstractMethodCompiler abstractMethodCompiler, SkinnyMethodAdapter skinnyMethodAdapter, int n, int n2, int n3, int n4, int n5) {
        super(abstractMethodCompiler, skinnyMethodAdapter, n3, n4, n5);
        this.scopeIndex = n;
        this.varsIndex = n2;
    }

    public void beginMethod(CompilerCallback compilerCallback, StaticScope staticScope) {
        if (staticScope.getNumberOfVariables() > 0) {
            this.methodCompiler.loadThreadContext();
            this.methodCompiler.invokeThreadContext("getCurrentScope", CodegenUtils.sig(DynamicScope.class));
            this.method.dup();
            this.method.astore(this.scopeIndex);
            this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class));
            this.method.astore(this.varsIndex);
            this.method.aload(this.varsIndex);
            this.methodCompiler.loadNil();
            this.method.invokestatic(CodegenUtils.p(Arrays.class), "fill", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Object[].class, Object.class)));
        }
        if (compilerCallback != null) {
            compilerCallback.call(this.methodCompiler);
        }
    }

    public void beginClass(CompilerCallback compilerCallback, StaticScope staticScope) {
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.invokeThreadContext("getCurrentScope", CodegenUtils.sig(DynamicScope.class));
        this.method.dup();
        this.method.astore(this.scopeIndex);
        this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class));
        this.method.astore(this.varsIndex);
        compilerCallback.call(this.methodCompiler);
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.invokeThreadContext("getCurrentScope", CodegenUtils.sig(DynamicScope.class));
        this.method.dup();
        this.method.astore(this.scopeIndex);
        this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class));
        this.method.astore(this.varsIndex);
        this.method.aload(this.varsIndex);
        this.methodCompiler.loadNil();
        this.method.invokestatic(CodegenUtils.p(Arrays.class), "fill", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Object[].class, Object.class)));
    }

    public void beginClosure(CompilerCallback compilerCallback, StaticScope staticScope) {
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.invokeThreadContext("getCurrentScope", CodegenUtils.sig(DynamicScope.class));
        this.method.dup();
        this.method.astore(this.scopeIndex);
        this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class));
        this.method.astore(this.varsIndex);
        if (staticScope != null) {
            this.methodCompiler.loadNil();
            for (int i = 0; i < staticScope.getNumberOfVariables(); ++i) {
                this.assignLocalVariable(i);
            }
            this.method.pop();
        }
        if (compilerCallback != null) {
            this.method.aload(this.argsIndex);
            this.method.ldc(new Integer(0));
            this.method.arrayload();
            compilerCallback.call(this.methodCompiler);
            this.method.pop();
        }
    }

    public void assignLocalVariable(int n) {
        this.method.dup();
        switch (n) {
            case 0: {
                this.method.aload(this.scopeIndex);
                this.method.swap();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueZeroDepthZero", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(IRubyObject.class)));
                break;
            }
            case 1: {
                this.method.aload(this.scopeIndex);
                this.method.swap();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueOneDepthZero", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(IRubyObject.class)));
                break;
            }
            default: {
                this.method.aload(this.varsIndex);
                this.method.swap();
                this.method.ldc(new Integer(n));
                this.method.swap();
                this.method.arraystore();
            }
        }
    }

    public void assignLocalVariable(int n, int n2) {
        if (n2 == 0) {
            this.assignLocalVariable(n);
            return;
        }
        this.method.dup();
        this.method.aload(this.scopeIndex);
        while (n2 > 0) {
            this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getNextCapturedScope", CodegenUtils.sig(DynamicScope.class));
            --n2;
        }
        switch (n) {
            case 0: {
                this.method.swap();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueZeroDepthZero", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(IRubyObject.class)));
                break;
            }
            case 1: {
                this.method.swap();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueOneDepthZero", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(IRubyObject.class)));
                break;
            }
            default: {
                this.method.swap();
                this.method.ldc(new Integer(n));
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueDepthZero", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(IRubyObject.class, Integer.TYPE)));
            }
        }
    }

    public void retrieveLocalVariable(int n) {
        switch (n) {
            case 0: {
                this.method.aload(this.scopeIndex);
                this.methodCompiler.loadNil();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueZeroDepthZeroOrNil", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                break;
            }
            case 1: {
                this.method.aload(this.scopeIndex);
                this.methodCompiler.loadNil();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueOneDepthZeroOrNil", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                break;
            }
            default: {
                this.method.aload(this.varsIndex);
                this.method.ldc(new Integer(n));
                this.method.arrayload();
            }
        }
    }

    public void retrieveLocalVariable(int n, int n2) {
        if (n2 == 0) {
            this.retrieveLocalVariable(n);
            return;
        }
        this.method.aload(this.scopeIndex);
        while (n2 > 0) {
            this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getNextCapturedScope", CodegenUtils.sig(DynamicScope.class));
            --n2;
        }
        switch (n) {
            case 0: {
                this.methodCompiler.loadNil();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueZeroDepthZeroOrNil", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                break;
            }
            case 1: {
                this.methodCompiler.loadNil();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueOneDepthZeroOrNil", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                break;
            }
            default: {
                this.method.ldc(new Integer(n));
                this.methodCompiler.loadNil();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueDepthZeroOrNil", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(Integer.TYPE, IRubyObject.class)));
            }
        }
    }
}

