/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.impl.HeapBasedVariableCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.parser.StaticScope;

public class BoxedVariableCompiler
extends HeapBasedVariableCompiler {
    private StaticScope scope;
    private int baseVariableIndex;

    public BoxedVariableCompiler(StandardASMCompiler.AbstractMethodCompiler abstractMethodCompiler, SkinnyMethodAdapter skinnyMethodAdapter, int n, int n2, int n3, int n4, int n5) {
        super(abstractMethodCompiler, skinnyMethodAdapter, n, n2, n3, n4, n5);
        this.baseVariableIndex = n5;
        this.scopeIndex = n;
        this.varsIndex = n2;
    }

    public void beginMethod(CompilerCallback compilerCallback, StaticScope staticScope) {
        this.scope = staticScope;
        if (staticScope != null && staticScope.getNumberOfVariables() > 0) {
            this.methodCompiler.loadNil();
            for (int i = 0; i < staticScope.getNumberOfVariables(); ++i) {
                if (staticScope.isCaptured(i)) continue;
                this.assignLocalVariable(i);
                ++this.tempVariableIndex;
            }
            this.method.pop();
        }
        super.beginMethod(compilerCallback, staticScope);
    }

    public void beginClass(CompilerCallback compilerCallback, StaticScope staticScope) {
        assert (false) : "Do not use boxed var compiler for class bodies";
    }

    public void beginClosure(CompilerCallback compilerCallback, StaticScope staticScope) {
        this.scope = staticScope;
        if (staticScope != null) {
            this.methodCompiler.loadNil();
            for (int i = 0; i < staticScope.getNumberOfVariables(); ++i) {
                if (staticScope.isCaptured(i)) continue;
                this.assignLocalVariable(i);
                ++this.tempVariableIndex;
            }
            this.method.pop();
        }
        super.beginClosure(compilerCallback, staticScope);
    }

    public void assignLocalVariable(int n) {
        if (this.scope.isCaptured(n)) {
            super.assignLocalVariable(n);
        } else {
            this.method.dup();
            this.method.astore(this.baseVariableIndex + n);
        }
    }

    public void retrieveLocalVariable(int n) {
        if (this.scope.isCaptured(n)) {
            super.retrieveLocalVariable(n);
        } else {
            this.method.aload(this.baseVariableIndex + n);
        }
    }
}

