/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.compiler.ArrayCallback;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.VariableCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;
import org.objectweb.asm.Label;

public abstract class AbstractVariableCompiler
implements VariableCompiler {
    protected SkinnyMethodAdapter method;
    protected StandardASMCompiler.AbstractMethodCompiler methodCompiler;
    protected int argsIndex;
    protected int closureIndex;
    protected int tempVariableIndex;
    protected Arity arity;

    public AbstractVariableCompiler(StandardASMCompiler.AbstractMethodCompiler abstractMethodCompiler, SkinnyMethodAdapter skinnyMethodAdapter, int n, int n2, int n3) {
        this.methodCompiler = abstractMethodCompiler;
        this.method = skinnyMethodAdapter;
        this.argsIndex = n;
        this.closureIndex = n2;
        this.tempVariableIndex = n3;
    }

    public SkinnyMethodAdapter getMethodAdapter() {
        return this.method;
    }

    public void setMethodAdapter(SkinnyMethodAdapter skinnyMethodAdapter) {
        this.method = skinnyMethodAdapter;
    }

    public void assignLastLine() {
        this.method.dup();
        this.methodCompiler.loadRuntime();
        this.method.swap();
        this.methodCompiler.loadThreadContext();
        this.method.swap();
        this.method.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "setLastLine", CodegenUtils.sig(Void.TYPE, Ruby.class, ThreadContext.class, IRubyObject.class));
    }

    public void retrieveLastLine() {
        this.methodCompiler.loadRuntime();
        this.methodCompiler.loadThreadContext();
        this.method.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "getLastLine", CodegenUtils.sig(IRubyObject.class, Ruby.class, ThreadContext.class));
    }

    public void assignBackRef() {
        this.method.dup();
        this.methodCompiler.loadRuntime();
        this.method.swap();
        this.methodCompiler.loadThreadContext();
        this.method.swap();
        this.method.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "setBackref", CodegenUtils.sig(Void.TYPE, Ruby.class, ThreadContext.class, IRubyObject.class));
    }

    public void retrieveBackRef() {
        this.methodCompiler.loadRuntime();
        this.methodCompiler.loadThreadContext();
        this.method.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "getBackref", CodegenUtils.sig(IRubyObject.class, Ruby.class, ThreadContext.class));
    }

    public void checkMethodArity(int n, int n2, int n3) {
        Label label = new Label();
        Label label2 = new Label();
        if (n3 != -1) {
            if (n > 0) {
                this.method.aload(this.argsIndex);
                this.method.arraylength();
                this.method.ldc(n);
                this.method.if_icmplt(label);
            }
        } else if (n2 > 0) {
            if (n > 0) {
                this.method.aload(this.argsIndex);
                this.method.arraylength();
                this.method.ldc(n);
                this.method.if_icmplt(label);
            }
            this.method.aload(this.argsIndex);
            this.method.arraylength();
            this.method.ldc(n + n2);
            this.method.if_icmpgt(label);
        } else {
            this.method.aload(this.argsIndex);
            this.method.arraylength();
            this.method.ldc(n);
            this.method.if_icmpne(label);
        }
        this.method.go_to(label2);
        this.method.label(label);
        this.methodCompiler.loadRuntime();
        this.method.aload(this.argsIndex);
        this.method.ldc(n);
        this.method.ldc(n + n2);
        this.method.invokestatic(CodegenUtils.p(Arity.class), "checkArgumentCount", CodegenUtils.sig(Integer.TYPE, Ruby.class, IRubyObject[].class, Integer.TYPE, Integer.TYPE));
        this.method.pop();
        this.method.label(label2);
    }

    public void assignMethodArguments(Object object, int n, Object object2, int n2, ArrayCallback arrayCallback, ArrayCallback arrayCallback2, ArrayCallback arrayCallback3, CompilerCallback compilerCallback, CompilerCallback compilerCallback2) {
        if (n > 0 || n2 > 0 || compilerCallback != null) {
            Label label;
            int n3;
            this.method.aload(this.argsIndex);
            for (n3 = 0; n3 < n; ++n3) {
                this.method.dup();
                this.method.ldc(new Integer(n3));
                this.method.arrayload();
                arrayCallback.nextValue(this.methodCompiler, object, n3);
                this.method.pop();
            }
            for (int i = 0; i < n2; ++i) {
                label = new Label();
                Label label2 = new Label();
                this.method.dup();
                this.method.arraylength();
                this.method.ldc(new Integer(n3));
                this.method.if_icmple(label);
                this.method.dup();
                this.method.ldc(new Integer(n3));
                this.method.arrayload();
                arrayCallback2.nextValue(this.methodCompiler, object2, i);
                this.method.go_to(label2);
                this.method.label(label);
                arrayCallback3.nextValue(this.methodCompiler, object2, i);
                this.method.label(label2);
                this.method.pop();
                ++n3;
            }
            if (compilerCallback != null) {
                Label label3 = new Label();
                label = new Label();
                this.method.dup();
                this.method.arraylength();
                this.method.ldc(new Integer(n3));
                this.method.if_icmple(label3);
                this.method.dup();
                this.methodCompiler.loadRuntime();
                this.method.ldc(n3);
                this.methodCompiler.invokeUtilityMethod("createSubarray", CodegenUtils.sig(RubyArray.class, IRubyObject[].class, Ruby.class, Integer.TYPE));
                this.method.go_to(label);
                this.method.label(label3);
                this.methodCompiler.createEmptyArray();
                this.method.label(label);
                compilerCallback.call(this.methodCompiler);
                this.method.pop();
            }
            this.method.pop();
        }
        if (compilerCallback2 != null) {
            this.methodCompiler.loadRuntime();
            this.method.aload(this.closureIndex);
            this.methodCompiler.invokeUtilityMethod("processBlockArgument", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(Ruby.class, Block.class)));
            compilerCallback2.call(this.methodCompiler);
            this.method.pop();
        }
    }

    public int grabTempLocal() {
        return this.tempVariableIndex++;
    }

    public void setTempLocal(int n) {
        this.method.astore(n);
    }

    public void getTempLocal(int n) {
        this.method.aload(n);
    }

    public void releaseTempLocal() {
        --this.tempVariableIndex;
    }
}

