/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast.visitor.rewriter.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.jruby.ast.visitor.rewriter.FormatHelper;
import org.jruby.ast.visitor.rewriter.utils.BooleanStateStack;
import org.jruby.ast.visitor.rewriter.utils.CallDepth;
import org.jruby.ast.visitor.rewriter.utils.HereDocument;
import org.jruby.ast.visitor.rewriter.utils.Indentor;
import org.jruby.ast.visitor.rewriter.utils.LocalVariables;
import org.jruby.lexer.yacc.ISourcePosition;

public class ReWriterContext {
    private final String source;
    private final CallDepth callDepth = new CallDepth();
    private final LocalVariables localVariables = new LocalVariables();
    private final BooleanStateStack printQuotesInString = new BooleanStateStack(true, true);
    private HereDocument hereDocument;
    private boolean skipNextNewline = true;
    private PrintWriter output;
    private FormatHelper formatHelper;
    private ISourcePosition lastPosition;

    public LocalVariables getLocalVariables() {
        return this.localVariables;
    }

    public ReWriterContext(PrintWriter printWriter, String string, FormatHelper formatHelper) {
        this.output = printWriter;
        this.source = string;
        this.formatHelper = formatHelper;
    }

    public ReWriterContext(StringWriter stringWriter, String string, FormatHelper formatHelper) {
        this(new PrintWriter(stringWriter), string, formatHelper);
    }

    public CallDepth getCallDepth() {
        return this.callDepth;
    }

    public String getSource() {
        return this.source;
    }

    public Indentor getIndentor() {
        return this.formatHelper.getIndentor();
    }

    public ISourcePosition getLastPosition() {
        return this.lastPosition;
    }

    public void setLastPosition(ISourcePosition iSourcePosition) {
        this.lastPosition = iSourcePosition;
    }

    public BooleanStateStack getPrintQuotesInString() {
        return this.printQuotesInString;
    }

    public boolean hasHereDocument() {
        return this.hereDocument != null;
    }

    public HereDocument fetchHereDocument() {
        HereDocument hereDocument = this.hereDocument;
        this.hereDocument = null;
        return hereDocument;
    }

    public void depositHereDocument(String string) {
        this.hereDocument = new HereDocument(string, this);
    }

    public boolean isSkipNextNewline() {
        return this.skipNextNewline;
    }

    public void setSkipNextNewline(boolean bl) {
        this.skipNextNewline = bl;
    }

    public PrintWriter getOutput() {
        return this.output;
    }

    public void setOutput(PrintWriter printWriter) {
        this.output = printWriter;
    }

    public FormatHelper getFormatHelper() {
        return this.formatHelper;
    }
}

