/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubySymbol;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolNode
extends Node
implements ILiteralNode,
INameNode {
    private String name;
    private RubySymbol symbol;

    public SymbolNode(ISourcePosition iSourcePosition, String string) {
        super(iSourcePosition, NodeType.SYMBOLNODE);
        this.name = string;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitSymbolNode(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    public RubySymbol getSymbol(Ruby ruby) {
        RubySymbol rubySymbol = this.symbol;
        if (rubySymbol != null) {
            return rubySymbol;
        }
        this.symbol = ruby.fastNewSymbol(this.name);
        return this.symbol;
    }
}

