/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpElementAsgnNode
extends Node {
    private final Node receiverNode;
    private final Node argsNode;
    private final Node valueNode;
    public final CallSite callAdapter;
    public final CallSite elementAdapter;
    public final CallSite elementAsgnAdapter;

    public OpElementAsgnNode(ISourcePosition iSourcePosition, Node node, String string, Node node2, Node node3) {
        super(iSourcePosition, NodeType.OPELEMENTASGNNODE);
        this.receiverNode = node;
        this.argsNode = node2;
        if (node2 instanceof ArrayNode) {
            ((ArrayNode)node2).setLightweight(true);
        }
        this.valueNode = node3;
        this.callAdapter = new CallSite.InlineCachingCallSite(string, CallType.NORMAL);
        this.elementAdapter = new CallSite.InlineCachingCallSite("[]", CallType.FUNCTIONAL);
        this.elementAsgnAdapter = new CallSite.InlineCachingCallSite("[]=", CallType.FUNCTIONAL);
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitOpElementAsgnNode(this);
    }

    public Node getArgsNode() {
        return this.argsNode;
    }

    public String getOperatorName() {
        return this.callAdapter.methodName;
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    public Node getValueNode() {
        return this.valueNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.argsNode, this.valueNode);
    }
}

