/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import org.jruby.RubyRegexp;
import org.jruby.ast.DStrNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;

public class DRegexpNode
extends ListNode
implements ILiteralNode {
    private final int options;
    private final boolean once;
    private RubyRegexp onceRegexp;

    public DRegexpNode(ISourcePosition iSourcePosition) {
        this(iSourcePosition, 0, false);
    }

    public DRegexpNode(ISourcePosition iSourcePosition, DStrNode dStrNode, int n, boolean bl) {
        this(iSourcePosition, n, bl);
        this.addAll(dStrNode);
    }

    public DRegexpNode(ISourcePosition iSourcePosition, int n, boolean bl) {
        super(iSourcePosition, NodeType.DREGEXPNODE);
        this.options = n;
        this.once = bl;
    }

    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitDRegxNode(this);
    }

    public boolean getOnce() {
        return this.once;
    }

    public int getOptions() {
        return this.options;
    }

    public RubyRegexp getOnceRegexp() {
        return this.onceRegexp;
    }

    public void setOnceRegexp(RubyRegexp rubyRegexp) {
        if (this.once && this.onceRegexp == null) {
            this.onceRegexp = rubyRegexp;
        }
    }
}

