/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.anno;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;

public class JavaMethodDescriptor {
    public final boolean isStatic;
    public final boolean hasContext;
    public final boolean hasBlock;
    public final int actualRequired;
    public final int arity;
    public final int required;
    public final int optional;
    public final boolean rest;
    public final Class[] parameters;
    public final JRubyMethod anno;
    public final Method method;

    public JavaMethodDescriptor(Method method) {
        int n;
        this.method = method;
        this.anno = method.getAnnotation(JRubyMethod.class);
        this.isStatic = Modifier.isStatic(method.getModifiers());
        this.parameters = method.getParameterTypes();
        if (this.parameters.length > 0) {
            this.hasContext = this.parameters[0] == ThreadContext.class;
            this.hasBlock = this.parameters[this.parameters.length - 1] == Block.class;
        } else {
            this.hasContext = false;
            this.hasBlock = false;
        }
        this.optional = this.anno.optional();
        this.rest = this.anno.rest();
        this.required = this.anno.required();
        if (this.optional == 0 && !this.rest) {
            n = this.parameters.length;
            if (n == 0) {
                this.actualRequired = 0;
            } else {
                if (this.isStatic) {
                    --n;
                }
                if (this.hasContext) {
                    --n;
                }
                if (this.hasBlock) {
                    --n;
                }
                this.actualRequired = n;
            }
        } else {
            n = this.parameters.length;
            if (n == 0) {
                this.actualRequired = 0;
            } else {
                if (this.isStatic) {
                    --n;
                }
                if (this.hasContext) {
                    --n;
                }
                if (this.hasBlock) {
                    --n;
                }
                this.actualRequired = --n;
            }
            if (this.actualRequired != 0) {
                throw new RuntimeException("Combining specific args with IRubyObject[] is not yet supported");
            }
        }
        n = Math.max(this.required, this.actualRequired);
        this.arity = this.optional > 0 || this.rest ? -(n + 1) : n;
    }
}

