/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.ArrayList;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class RubyStringIO
extends RubyObject {
    private static ObjectAllocator STRINGIO_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new RubyStringIO(ruby, rubyClass);
        }
    };
    private long pos = 0L;
    private int lineno = 0;
    private boolean eof = false;
    private RubyString internal;
    private boolean closedRead = false;
    private boolean closedWrite = false;
    private boolean append = false;
    public static final ByteList NEWLINE = ByteList.create("\n");

    public static RubyClass createStringIOClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("StringIO", ruby.getObject(), STRINGIO_ALLOCATOR);
        rubyClass.defineAnnotatedMethods(RubyStringIO.class);
        return rubyClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"open"}, optional=2, frame=true, meta=true)
    public static IRubyObject open(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        RubyStringIO rubyStringIO;
        IRubyObject iRubyObject2 = rubyStringIO = (RubyStringIO)((RubyClass)iRubyObject).newInstance(threadContext, iRubyObjectArray, Block.NULL_BLOCK);
        if (block.isGiven()) {
            try {
                iRubyObject2 = block.yield(threadContext, rubyStringIO);
                Object var7_6 = null;
                rubyStringIO.close();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                rubyStringIO.close();
                throw throwable;
            }
            {
            }
        }
        return iRubyObject2;
    }

    protected RubyStringIO(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    @JRubyMethod(name={"initialize"}, optional=2, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] iRubyObjectArray, Block block) {
        if (iRubyObjectArray.length > 0) {
            this.internal = iRubyObjectArray[0].convertToString();
            if (iRubyObjectArray.length > 1) {
                if (iRubyObjectArray[1] instanceof RubyFixnum) {
                    // empty if block
                }
                String string = iRubyObjectArray[1].convertToString().toString();
                this.setupModes(string);
            }
        } else {
            this.internal = this.getRuntime().newString("");
        }
        return this;
    }

    @JRubyMethod(name={"<<"}, required=1)
    public IRubyObject append(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.checkWritable();
        this.checkFrozen();
        RubyString rubyString = (RubyString)iRubyObject.callMethod(threadContext, MethodIndex.TO_S, "to_s");
        this.internal.modify();
        if (this.append) {
            this.internal.getByteList().append(rubyString.getByteList());
        } else {
            int n = this.internal.getByteList().length() - (int)this.pos;
            this.internal.getByteList().replace((int)this.pos, Math.min(rubyString.getByteList().length(), n), rubyString.getByteList());
            this.pos += (long)rubyString.getByteList().length();
        }
        return this;
    }

    @JRubyMethod(name={"binmode"})
    public IRubyObject binmode() {
        return this;
    }

    @JRubyMethod(name={"close"})
    public IRubyObject close() {
        this.closedRead = true;
        this.closedWrite = true;
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"closed?"})
    public IRubyObject closed_p() {
        return this.getRuntime().newBoolean(this.closedRead && this.closedWrite);
    }

    @JRubyMethod(name={"close_read"})
    public IRubyObject close_read() {
        this.closedRead = true;
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"closed_read?"})
    public IRubyObject closed_read_p() {
        return this.getRuntime().newBoolean(this.closedRead);
    }

    @JRubyMethod(name={"close_write"})
    public IRubyObject close_write() {
        this.closedWrite = true;
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"closed_write?"})
    public IRubyObject closed_write_p() {
        return this.getRuntime().newBoolean(this.closedWrite);
    }

    @JRubyMethod(name={"each"}, optional=1, frame=true)
    public IRubyObject each(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        IRubyObject iRubyObject = this.gets(threadContext, iRubyObjectArray);
        while (!iRubyObject.isNil()) {
            block.yield(threadContext, iRubyObject);
            iRubyObject = this.gets(threadContext, iRubyObjectArray);
        }
        return this;
    }

    @JRubyMethod(name={"each_byte"}, frame=true)
    public IRubyObject each_byte(ThreadContext threadContext, Block block) {
        this.checkReadable();
        RubyString.newString(this.getRuntime(), new ByteList(this.internal.getByteList(), (int)this.pos, this.internal.getByteList().length())).each_byte(threadContext, block);
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"each_line"}, optional=1, frame=true)
    public IRubyObject each_line(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        return this.each(threadContext, iRubyObjectArray, block);
    }

    @JRubyMethod(name={"eof"})
    public IRubyObject eof() {
        return this.pos >= (long)this.internal.getByteList().length() || this.eof ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"eof?"})
    public IRubyObject eof_p() {
        return this.pos >= (long)this.internal.getByteList().length() || this.eof ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"fcntl"})
    public IRubyObject fcntl() {
        throw this.getRuntime().newNotImplementedError("fcntl not implemented");
    }

    @JRubyMethod(name={"fileno"})
    public IRubyObject fileno() {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"flush"})
    public IRubyObject flush() {
        return this;
    }

    @JRubyMethod(name={"fsync"})
    public IRubyObject fsync() {
        return RubyFixnum.zero(this.getRuntime());
    }

    @JRubyMethod(name={"getc"})
    public IRubyObject getc() {
        if (this.pos >= (long)this.internal.getByteList().length()) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newFixnum(this.internal.getByteList().get((int)this.pos++) & 0xFF);
    }

    public IRubyObject internalGets(IRubyObject[] iRubyObjectArray) {
        if (this.pos < (long)this.internal.getByteList().realSize && !this.eof) {
            ByteList byteList = ((RubyString)this.getRuntime().getGlobalVariables().get("$/")).getByteList();
            if (iRubyObjectArray.length > 0) {
                if (iRubyObjectArray[0].isNil()) {
                    ByteList byteList2 = this.internal.getByteList().makeShared((int)this.pos, this.internal.getByteList().realSize - (int)this.pos);
                    this.pos += (long)byteList2.realSize;
                    return RubyString.newString(this.getRuntime(), byteList2);
                }
                byteList = iRubyObjectArray[0].convertToString().getByteList();
            }
            ByteList byteList3 = this.internal.getByteList();
            int n = byteList3.indexOf(byteList, (int)this.pos);
            ByteList byteList4 = byteList;
            if (-1 == n) {
                n = this.internal.getByteList().realSize;
                byteList4 = new ByteList(new byte[0], false);
            }
            ByteList byteList5 = this.internal.getByteList().makeShared((int)this.pos, n - (int)this.pos);
            byteList5.unshare();
            byteList5.append(byteList4);
            byteList5.invalidate();
            this.pos = n + byteList4.realSize;
            ++this.lineno;
            return RubyString.newString(this.getRuntime(), byteList5);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"gets"}, optional=1)
    public IRubyObject gets(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        this.checkReadable();
        IRubyObject iRubyObject = this.internalGets(iRubyObjectArray);
        if (!iRubyObject.isNil()) {
            threadContext.getCurrentFrame().setLastLine(iRubyObject);
        }
        return iRubyObject;
    }

    @JRubyMethod(name={"isatty"})
    public IRubyObject isatty() {
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"tty?"})
    public IRubyObject tty_p() {
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"length"})
    public IRubyObject length() {
        return this.getRuntime().newFixnum(this.internal.getByteList().length());
    }

    @JRubyMethod(name={"lineno"})
    public IRubyObject lineno() {
        return this.getRuntime().newFixnum(this.lineno);
    }

    @JRubyMethod(name={"lineno="}, required=1)
    public IRubyObject set_lineno(IRubyObject iRubyObject) {
        this.lineno = RubyNumeric.fix2int(iRubyObject);
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"path"})
    public IRubyObject path() {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"pid"})
    public IRubyObject pid() {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"pos"})
    public IRubyObject pos() {
        return this.getRuntime().newFixnum(this.pos);
    }

    @JRubyMethod(name={"tell"})
    public IRubyObject tell() {
        return this.getRuntime().newFixnum(this.pos);
    }

    @JRubyMethod(name={"pos="}, required=1)
    public IRubyObject set_pos(IRubyObject iRubyObject) {
        this.pos = RubyNumeric.fix2int(iRubyObject);
        if (this.pos < 0L) {
            throw this.getRuntime().newErrnoEINVALError("Invalid argument");
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"print"}, rest=true)
    public IRubyObject print(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject;
        if (iRubyObjectArray.length != 0) {
            int n = iRubyObjectArray.length;
            for (int i = 0; i < n; ++i) {
                this.append(threadContext, iRubyObjectArray[i]);
            }
        }
        if (!(iRubyObject = this.getRuntime().getGlobalVariables().get("$\\")).isNil()) {
            this.append(threadContext, iRubyObject);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"printf"}, required=1, rest=true)
    public IRubyObject printf(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        this.append(threadContext, RubyKernel.sprintf(this, iRubyObjectArray));
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"putc"}, required=1)
    public IRubyObject putc(IRubyObject iRubyObject) {
        this.checkWritable();
        byte by = RubyNumeric.num2chr(iRubyObject);
        this.checkFrozen();
        this.internal.modify();
        if (this.append) {
            this.pos = this.internal.getByteList().length();
            this.internal.getByteList().append(by);
        } else {
            if (this.pos >= (long)this.internal.getByteList().length()) {
                this.internal.getByteList().append(by);
            } else {
                this.internal.getByteList().set((int)this.pos, by);
            }
            ++this.pos;
        }
        return iRubyObject;
    }

    @JRubyMethod(name={"puts"}, rest=true)
    public IRubyObject puts(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        this.checkWritable();
        if (iRubyObjectArray.length == 0) {
            this.callMethod(threadContext, "write", this.getRuntime().newStringShared(NEWLINE));
            return this.getRuntime().getNil();
        }
        for (int i = 0; i < iRubyObjectArray.length; ++i) {
            String string;
            if (iRubyObjectArray[i].isNil()) {
                string = "nil";
            } else if (this.getRuntime().isInspecting(iRubyObjectArray[i])) {
                string = "[...]";
            } else {
                if (iRubyObjectArray[i] instanceof RubyArray) {
                    this.inspectPuts(threadContext, (RubyArray)iRubyObjectArray[i]);
                    continue;
                }
                string = iRubyObjectArray[i].toString();
            }
            this.callMethod(threadContext, "write", this.getRuntime().newString(string));
            if (string.endsWith("\n")) continue;
            this.callMethod(threadContext, "write", this.getRuntime().newStringShared(NEWLINE));
        }
        return this.getRuntime().getNil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject inspectPuts(ThreadContext threadContext, RubyArray rubyArray) {
        try {
            this.getRuntime().registerInspecting(rubyArray);
            IRubyObject iRubyObject = this.puts(threadContext, rubyArray.toJavaArray());
            Object var5_4 = null;
            this.getRuntime().unregisterInspecting(rubyArray);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.getRuntime().unregisterInspecting(rubyArray);
            throw throwable;
        }
    }

    @JRubyMethod(name={"read"}, optional=2)
    public IRubyObject read(IRubyObject[] iRubyObjectArray) {
        this.checkReadable();
        ByteList byteList = null;
        int n = 0;
        int n2 = 0;
        RubyString rubyString = null;
        switch (iRubyObjectArray.length) {
            case 2: {
                rubyString = iRubyObjectArray[1].convertToString();
                rubyString.modify();
                byteList = rubyString.getByteList();
            }
            case 1: {
                if (!iRubyObjectArray[0].isNil()) {
                    n2 = n = RubyNumeric.fix2int(iRubyObjectArray[0]);
                    if (n < 0) {
                        throw this.getRuntime().newArgumentError("negative length " + n + " given");
                    }
                    if (n > 0 && this.pos >= (long)this.internal.getByteList().length()) {
                        this.eof = true;
                        if (byteList != null) {
                            byteList.realSize = 0;
                        }
                        return this.getRuntime().getNil();
                    }
                    if (!this.eof) break;
                    if (byteList != null) {
                        byteList.realSize = 0;
                    }
                    return this.getRuntime().getNil();
                }
            }
            case 0: {
                n2 = -1;
                n = this.internal.getByteList().length();
                if ((long)n <= this.pos) {
                    this.eof = true;
                    if (byteList == null) {
                        byteList = new ByteList();
                    } else {
                        byteList.realSize = 0;
                    }
                    return this.getRuntime().newString(byteList);
                }
                n = (int)((long)n - this.pos);
                break;
            }
            default: {
                this.getRuntime().newArgumentError(iRubyObjectArray.length, 0);
            }
        }
        if (byteList == null) {
            int n3 = this.internal.getByteList().length();
            if (n3 > 0) {
                if ((long)n3 >= this.pos + (long)n) {
                    byteList = new ByteList(this.internal.getByteList(), (int)this.pos, n);
                } else {
                    int n4 = (int)((long)this.internal.getByteList().length() - this.pos);
                    if (n > n4) {
                        n = n4;
                    }
                    byteList = new ByteList(this.internal.getByteList(), (int)this.pos, n);
                }
            }
        } else {
            int n5 = (int)((long)this.internal.getByteList().length() - this.pos);
            if (n > n5) {
                n = n5;
            }
            byteList.realSize = n;
            byteList.replace(0, n, this.internal.getByteList().bytes, (int)this.pos, n);
        }
        if (byteList == null) {
            if (!this.eof) {
                byteList = new ByteList();
            }
            n = 0;
        } else {
            n = byteList.length();
            this.pos += (long)n;
        }
        if (n2 < 0 || n2 > n) {
            this.eof = true;
        }
        return rubyString != null ? rubyString : this.getRuntime().newString(byteList);
    }

    @JRubyMethod(name={"readchar"})
    public IRubyObject readchar() {
        IRubyObject iRubyObject = this.getc();
        if (iRubyObject.isNil()) {
            throw this.getRuntime().newEOFError();
        }
        return iRubyObject;
    }

    @JRubyMethod(name={"readline"}, optional=1)
    public IRubyObject readline(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject = this.gets(threadContext, iRubyObjectArray);
        if (iRubyObject.isNil()) {
            throw this.getRuntime().newEOFError();
        }
        return iRubyObject;
    }

    @JRubyMethod(name={"readlines"}, optional=1)
    public IRubyObject readlines(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        this.checkReadable();
        ArrayList<IRubyObject> arrayList = new ArrayList<IRubyObject>();
        while (this.pos < (long)this.internal.getByteList().length() && !this.eof) {
            arrayList.add(this.gets(threadContext, iRubyObjectArray));
        }
        return this.getRuntime().newArray(arrayList);
    }

    @JRubyMethod(name={"reopen"}, required=1, optional=1)
    public IRubyObject reopen(IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject = iRubyObjectArray[0];
        if (iRubyObject instanceof RubyStringIO) {
            this.pos = ((RubyStringIO)iRubyObject).pos;
            this.lineno = ((RubyStringIO)iRubyObject).lineno;
            this.eof = ((RubyStringIO)iRubyObject).eof;
            this.closedRead = ((RubyStringIO)iRubyObject).closedRead;
            this.closedWrite = ((RubyStringIO)iRubyObject).closedWrite;
            this.internal = ((RubyStringIO)iRubyObject).internal;
        } else {
            this.pos = 0L;
            this.lineno = 0;
            this.eof = false;
            this.closedRead = false;
            this.closedWrite = false;
            this.internal = iRubyObject.convertToString();
        }
        if (iRubyObjectArray.length == 2) {
            this.setupModes(iRubyObjectArray[1].convertToString().toString());
        } else {
            this.setupModes("");
        }
        if (this.internal.isFrozen() && (this.closedRead || this.append)) {
            throw this.getRuntime().newErrnoEACCESError("not opened for writing");
        }
        if (this.closedRead) {
            this.internal.modify();
            this.internal.setValue("");
        }
        return this;
    }

    @JRubyMethod(name={"rewind"})
    public IRubyObject rewind() {
        this.pos = 0L;
        this.lineno = 0;
        return RubyFixnum.zero(this.getRuntime());
    }

    @JRubyMethod(name={"seek"}, required=1, optional=1)
    public IRubyObject seek(IRubyObject[] iRubyObjectArray) {
        long l = RubyNumeric.num2long(iRubyObjectArray[0]);
        int n = 0;
        long l2 = this.pos;
        if (iRubyObjectArray.length > 1 && !iRubyObjectArray[0].isNil()) {
            n = RubyNumeric.fix2int(iRubyObjectArray[1]);
        }
        l2 = n == 1 ? (l2 += l) : (n == 2 ? (long)this.internal.getByteList().length() + l : l);
        if (l2 < 0L) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        this.pos = l2;
        this.eof = false;
        return RubyFixnum.zero(this.getRuntime());
    }

    @JRubyMethod(name={"string="}, required=1)
    public IRubyObject set_string(IRubyObject iRubyObject) {
        return this.reopen(new IRubyObject[]{iRubyObject});
    }

    @JRubyMethod(name={"sync="}, required=1)
    public IRubyObject set_sync(IRubyObject iRubyObject) {
        return iRubyObject;
    }

    @JRubyMethod(name={"size"})
    public IRubyObject size() {
        return this.getRuntime().newFixnum(this.internal.getByteList().length());
    }

    @JRubyMethod(name={"string"})
    public IRubyObject string() {
        return this.internal;
    }

    @JRubyMethod(name={"sync"})
    public IRubyObject sync() {
        return this.getRuntime().getTrue();
    }

    @JRubyMethod(name={"sysread"}, optional=2)
    public IRubyObject sysread(IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject = this.read(iRubyObjectArray);
        if (iRubyObject.isNil() || ((RubyString)iRubyObject).getByteList().length() == 0) {
            throw this.getRuntime().newEOFError();
        }
        return iRubyObject;
    }

    @JRubyMethod(name={"syswrite"}, required=1)
    public IRubyObject syswrite(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.write(threadContext, iRubyObject);
    }

    @JRubyMethod(name={"truncate"}, required=1)
    public IRubyObject truncate(IRubyObject iRubyObject) {
        this.checkWritable();
        int n = RubyFixnum.fix2int(iRubyObject);
        this.internal.modify();
        this.internal.getByteList().length(n);
        return this.getRuntime().newFixnum(n);
    }

    @JRubyMethod(name={"ungetc"}, required=1)
    public IRubyObject ungetc(IRubyObject iRubyObject) {
        this.checkReadable();
        int n = RubyNumeric.num2int(iRubyObject);
        if (this.pos == 0L) {
            return this.getRuntime().getNil();
        }
        this.internal.modify();
        --this.pos;
        this.internal.getByteList().set((int)this.pos, n);
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"write"}, required=1)
    public IRubyObject write(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.checkWritable();
        String string = iRubyObject.toString();
        this.append(threadContext, iRubyObject);
        return this.getRuntime().newFixnum(string.length());
    }

    protected void checkFrozen() {
        if (this.internal.isFrozen()) {
            throw this.getRuntime().newIOError("not modifiable string");
        }
    }

    private void checkReadable() {
        if (this.closedRead) {
            throw this.getRuntime().newIOError("not opened for reading");
        }
    }

    private void checkWritable() {
        if (this.closedWrite) {
            throw this.getRuntime().newIOError("not opened for writing");
        }
    }

    private void setupModes(String string) {
        this.closedWrite = false;
        this.closedRead = false;
        this.append = false;
        if (string.contains("r")) {
            this.closedWrite = true;
        }
        if (string.contains("w")) {
            this.closedRead = true;
        }
        if (string.contains("a")) {
            this.append = true;
        }
    }
}

