/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.RubySymbol;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.posix.POSIX;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;

public class RubyProcess {
    private static String[] signals = new String[]{"EXIT", "HUP", "INT", "QUIT", "ILL", "TRAP", "ABRT", "POLL", "FPE", "KILL", "BUS", "SEGV", "SYS", "PIPE", "ALRM", "TERM", "URG", "STOP", "TSTP", "CONT", "CHLD", "TTIN", "TTOU", "XCPU", "XFSZ", "VTALRM", "PROF", "USR1", "USR2"};

    public static RubyModule createProcessModule(Ruby ruby) {
        RubyModule rubyModule = ruby.defineModule("Process");
        ruby.setProcess(rubyModule);
        RubyClass rubyClass = rubyModule.defineClassUnder("Status", ruby.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        ruby.setProcStatus(rubyClass);
        RubyModule rubyModule2 = rubyModule.defineModuleUnder("UID");
        ruby.setProcUID(rubyModule2);
        RubyModule rubyModule3 = rubyModule.defineModuleUnder("GID");
        ruby.setProcGID(rubyModule3);
        RubyModule rubyModule4 = rubyModule.defineModuleUnder("Sys");
        ruby.setProcSys(rubyModule4);
        CallbackFactory callbackFactory = ruby.callbackFactory(RubyStatus.class);
        rubyModule.defineAnnotatedMethods(RubyProcess.class);
        rubyClass.defineAnnotatedMethods(RubyStatus.class);
        rubyModule2.defineAnnotatedMethods(UserID.class);
        rubyModule3.defineAnnotatedMethods(GroupID.class);
        rubyModule4.defineAnnotatedMethods(Sys.class);
        rubyModule.defineConstant("PRIO_PROCESS", ruby.newFixnum(0L));
        rubyModule.defineConstant("PRIO_PGRP", ruby.newFixnum(1L));
        rubyModule.defineConstant("PRIO_USER", ruby.newFixnum(2L));
        rubyModule.defineConstant("WNOHANG", ruby.newFixnum(1L));
        Callback callback = callbackFactory.getFastMethod("not_implemented");
        rubyClass.defineMethod("&", callbackFactory.getFastMethod("not_implemented1", IRubyObject.class));
        rubyClass.defineMethod("to_int", callback);
        rubyClass.defineMethod("pid", callback);
        rubyClass.defineMethod("stopped?", callback);
        rubyClass.defineMethod("stopsig", callback);
        rubyClass.defineMethod("signaled?", callback);
        rubyClass.defineMethod("termsig", callback);
        rubyClass.defineMethod("exited?", callback);
        rubyClass.defineMethod("coredump?", callback);
        return rubyModule;
    }

    @JRubyMethod(name={"abort"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject abort(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        return RubyKernel.abort(threadContext, iRubyObject, iRubyObjectArray);
    }

    @JRubyMethod(name={"exit!"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject exit_bang(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        return RubyKernel.exit_bang(iRubyObject, iRubyObjectArray);
    }

    @JRubyMethod(name={"groups"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject groups(IRubyObject iRubyObject) {
        throw iRubyObject.getRuntime().newNotImplementedError("Process#groups not yet implemented");
    }

    @JRubyMethod(name={"setrlimit"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject setrlimit(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        throw iRubyObject.getRuntime().newNotImplementedError("Process#setrlimit not yet implemented");
    }

    @JRubyMethod(name={"getpgrp"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject getpgrp(IRubyObject iRubyObject) {
        return iRubyObject.getRuntime().newFixnum(iRubyObject.getRuntime().getPosix().getpgrp());
    }

    @JRubyMethod(name={"groups="}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject groups_set(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        throw iRubyObject.getRuntime().newNotImplementedError("Process#groups not yet implemented");
    }

    @JRubyMethod(name={"waitpid"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject waitpid(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        Ruby ruby = iRubyObject.getRuntime();
        int n = -1;
        int n2 = 0;
        if (iRubyObjectArray.length > 0) {
            n = (int)iRubyObjectArray[0].convertToInteger().getLongValue();
        }
        if (iRubyObjectArray.length > 1) {
            n2 = (int)iRubyObjectArray[1].convertToInteger().getLongValue();
        }
        int[] nArray = new int[1];
        n = ruby.getPosix().waitpid(n, nArray, n2);
        if (n == -1) {
            throw ruby.newErrnoECHILDError();
        }
        ruby.getGlobalVariables().set("$?", RubyStatus.newProcessStatus(ruby, nArray[0]));
        return ruby.newFixnum(n);
    }

    @JRubyMethod(name={"wait"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject wait(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        Ruby ruby = iRubyObject.getRuntime();
        if (iRubyObjectArray.length > 0) {
            return RubyProcess.waitpid(iRubyObject, iRubyObjectArray);
        }
        int[] nArray = new int[1];
        int n = ruby.getPosix().wait(nArray);
        if (n == -1) {
            throw ruby.newErrnoECHILDError();
        }
        ruby.getGlobalVariables().set("$?", RubyStatus.newProcessStatus(ruby, nArray[0]));
        return ruby.newFixnum(n);
    }

    @JRubyMethod(name={"waitall"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject waitall(IRubyObject iRubyObject) {
        Ruby ruby = iRubyObject.getRuntime();
        POSIX pOSIX = ruby.getPosix();
        RubyArray rubyArray = iRubyObject.getRuntime().newArray();
        int[] nArray = new int[1];
        int n = pOSIX.wait(nArray);
        while (n != -1) {
            rubyArray.append(ruby.newArray(ruby.newFixnum(n), RubyStatus.newProcessStatus(ruby, nArray[0])));
            n = pOSIX.wait(nArray);
        }
        return rubyArray;
    }

    @JRubyMethod(name={"setsid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject setsid(IRubyObject iRubyObject) {
        return iRubyObject.getRuntime().newFixnum(iRubyObject.getRuntime().getPosix().setsid());
    }

    @JRubyMethod(name={"setpgrp"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject setpgrp(IRubyObject iRubyObject) {
        return iRubyObject.getRuntime().newFixnum(iRubyObject.getRuntime().getPosix().setpgid(0, 0));
    }

    @JRubyMethod(name={"egid="}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject egid_set(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        iRubyObject.getRuntime().getPosix().setegid((int)iRubyObject2.convertToInteger().getLongValue());
        return RubyFixnum.zero(iRubyObject.getRuntime());
    }

    @JRubyMethod(name={"euid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject euid(IRubyObject iRubyObject) {
        return iRubyObject.getRuntime().newFixnum(iRubyObject.getRuntime().getPosix().geteuid());
    }

    @JRubyMethod(name={"uid="}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject uid_set(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        iRubyObject.getRuntime().getPosix().setuid((int)iRubyObject2.convertToInteger().getLongValue());
        return RubyFixnum.zero(iRubyObject.getRuntime());
    }

    @JRubyMethod(name={"gid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject gid(IRubyObject iRubyObject) {
        return iRubyObject.getRuntime().newFixnum(iRubyObject.getRuntime().getPosix().getgid());
    }

    @JRubyMethod(name={"maxgroups"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject maxgroups(IRubyObject iRubyObject) {
        throw iRubyObject.getRuntime().newNotImplementedError("Process#maxgroups not yet implemented");
    }

    @JRubyMethod(name={"getpriority"}, required=2, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject getpriority(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        int n = (int)iRubyObject2.convertToInteger().getLongValue();
        int n2 = (int)iRubyObject3.convertToInteger().getLongValue();
        int n3 = iRubyObject.getRuntime().getPosix().getpriority(n, n2);
        return iRubyObject.getRuntime().newFixnum(n3);
    }

    @JRubyMethod(name={"uid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject uid(IRubyObject iRubyObject) {
        return iRubyObject.getRuntime().newFixnum(iRubyObject.getRuntime().getPosix().getuid());
    }

    @JRubyMethod(name={"waitpid2"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject waitpid2(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        Ruby ruby = iRubyObject.getRuntime();
        int n = -1;
        int n2 = 0;
        if (iRubyObjectArray.length > 0) {
            n = (int)iRubyObjectArray[0].convertToInteger().getLongValue();
        }
        if (iRubyObjectArray.length > 1) {
            n2 = (int)iRubyObjectArray[1].convertToInteger().getLongValue();
        }
        int[] nArray = new int[1];
        n = ruby.getPosix().waitpid(n, nArray, n2);
        if (n == -1) {
            throw ruby.newErrnoECHILDError();
        }
        return ruby.newArray(ruby.newFixnum(n), RubyStatus.newProcessStatus(ruby, nArray[0]));
    }

    @JRubyMethod(name={"initgroups"}, required=2, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject initgroups(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        throw iRubyObject.getRuntime().newNotImplementedError("Process#initgroups not yet implemented");
    }

    @JRubyMethod(name={"maxgroups="}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject maxgroups_set(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        throw iRubyObject.getRuntime().newNotImplementedError("Process#maxgroups_set not yet implemented");
    }

    @JRubyMethod(name={"ppid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject ppid(IRubyObject iRubyObject) {
        return iRubyObject.getRuntime().newFixnum(iRubyObject.getRuntime().getPosix().getppid());
    }

    @JRubyMethod(name={"gid="}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject gid_set(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return iRubyObject.getRuntime().newFixnum(iRubyObject.getRuntime().getPosix().setgid((int)iRubyObject2.convertToInteger().getLongValue()));
    }

    @JRubyMethod(name={"wait2"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject wait2(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        return RubyProcess.waitpid2(iRubyObject, iRubyObjectArray);
    }

    @JRubyMethod(name={"euid="}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject euid_set(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        iRubyObject.getRuntime().getPosix().seteuid((int)iRubyObject2.convertToInteger().getLongValue());
        return RubyFixnum.zero(iRubyObject.getRuntime());
    }

    @JRubyMethod(name={"setpriority"}, required=3, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject setpriority(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4) {
        int n = (int)iRubyObject2.convertToInteger().getLongValue();
        int n2 = (int)iRubyObject3.convertToInteger().getLongValue();
        int n3 = (int)iRubyObject4.convertToInteger().getLongValue();
        int n4 = iRubyObject.getRuntime().getPosix().setpriority(n, n2, n3);
        return iRubyObject.getRuntime().newFixnum(n4);
    }

    @JRubyMethod(name={"setpgid"}, required=2, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject setpgid(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        int n = (int)iRubyObject2.convertToInteger().getLongValue();
        int n2 = (int)iRubyObject3.convertToInteger().getLongValue();
        return iRubyObject.getRuntime().newFixnum(iRubyObject.getRuntime().getPosix().setpgid(n, n2));
    }

    @JRubyMethod(name={"getpgid"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject getpgid(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return iRubyObject.getRuntime().newFixnum(iRubyObject.getRuntime().getPosix().getpgid((int)iRubyObject2.convertToInteger().getLongValue()));
    }

    @JRubyMethod(name={"getrlimit"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject getrlimit(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        throw iRubyObject.getRuntime().newNotImplementedError("Process#getrlimit not yet implemented");
    }

    @JRubyMethod(name={"egid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject egid(IRubyObject iRubyObject) {
        return iRubyObject.getRuntime().newFixnum(iRubyObject.getRuntime().getPosix().getegid());
    }

    private static int parseSignalString(Ruby ruby, String string) {
        boolean bl;
        int n = 0;
        boolean bl2 = string.startsWith("-");
        if (bl2) {
            ++n;
        }
        if (bl = string.startsWith("SIG", n)) {
            n += 3;
        }
        String string2 = string.substring(n);
        for (int i = 0; i < signals.length; ++i) {
            if (!signals[i].equals(string2)) continue;
            return bl2 ? -i : i;
        }
        throw ruby.newArgumentError("unsupported name `SIG" + string2 + "'");
    }

    @JRubyMethod(name={"kill"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject kill(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        boolean bl;
        if (iRubyObjectArray.length < 2) {
            throw iRubyObject.getRuntime().newArgumentError("wrong number of arguments -- kill(sig, pid...)");
        }
        Ruby ruby = iRubyObject.getRuntime();
        int n = iRubyObjectArray[0] instanceof RubyFixnum ? (int)((RubyFixnum)iRubyObjectArray[0]).getLongValue() : (iRubyObjectArray[0] instanceof RubySymbol ? RubyProcess.parseSignalString(ruby, iRubyObjectArray[0].toString()) : (iRubyObjectArray[0] instanceof RubyString ? RubyProcess.parseSignalString(ruby, iRubyObjectArray[0].toString()) : RubyProcess.parseSignalString(ruby, iRubyObjectArray[0].checkStringType().toString())));
        boolean bl2 = bl = n < 0;
        if (bl) {
            n = -n;
        }
        POSIX pOSIX = ruby.getPosix();
        for (int i = 1; i < iRubyObjectArray.length; ++i) {
            int n2 = RubyNumeric.num2int(iRubyObjectArray[i]);
            if (n2 == 0) {
                n2 = ruby.getPosix().getpid();
            }
            pOSIX.kill(bl ? -n2 : n2, n);
        }
        return ruby.newFixnum(iRubyObjectArray.length - 1);
    }

    @JRubyMethod(name={"detach"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject detach(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        final int n = (int)iRubyObject2.convertToInteger().getLongValue();
        Ruby ruby = iRubyObject.getRuntime();
        BlockCallback blockCallback = new BlockCallback(){

            public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
                int[] nArray = new int[1];
                int n2 = threadContext.getRuntime().getPosix().waitpid(n, nArray, 0);
                return threadContext.getRuntime().newFixnum(n2);
            }
        };
        return RubyThread.newInstance(ruby.getThread(), IRubyObject.NULL_ARRAY, CallBlock.newCallClosure(iRubyObject, (RubyModule)iRubyObject, Arity.NO_ARGUMENTS, blockCallback, threadContext));
    }

    @JRubyMethod(name={"times"}, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject times(IRubyObject iRubyObject, Block block) {
        Ruby ruby = iRubyObject.getRuntime();
        double d = (double)System.currentTimeMillis() / 1000.0;
        double d2 = (double)ruby.getStartTime() / 1000.0;
        RubyFloat rubyFloat = ruby.newFloat(0.0);
        return RubyStruct.newStruct(ruby.getTmsStruct(), new IRubyObject[]{ruby.newFloat(d - d2), rubyFloat, rubyFloat, rubyFloat}, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"pid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject pid(IRubyObject iRubyObject) {
        return iRubyObject.getRuntime().newFixnum(iRubyObject.getRuntime().getPosix().getpid());
    }

    @JRubyMethod(name={"fork"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject fork(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        return RubyKernel.fork(threadContext, iRubyObject, block);
    }

    @JRubyMethod(name={"exit"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject exit(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        return RubyKernel.exit(iRubyObject, iRubyObjectArray);
    }

    public static class Sys {
        @JRubyMethod(name={"getegid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject getegid(IRubyObject iRubyObject) {
            return RubyProcess.egid(iRubyObject);
        }

        @JRubyMethod(name={"geteuid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject geteuid(IRubyObject iRubyObject) {
            return RubyProcess.euid(iRubyObject);
        }

        @JRubyMethod(name={"getgid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject getgid(IRubyObject iRubyObject) {
            return RubyProcess.gid(iRubyObject);
        }

        @JRubyMethod(name={"getuid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject getuid(IRubyObject iRubyObject) {
            return RubyProcess.uid(iRubyObject);
        }

        @JRubyMethod(name={"setegid"}, required=1, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject setegid(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return RubyProcess.egid_set(iRubyObject, iRubyObject2);
        }

        @JRubyMethod(name={"seteuid"}, required=1, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject seteuid(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return RubyProcess.euid_set(iRubyObject, iRubyObject2);
        }

        @JRubyMethod(name={"setgid"}, required=1, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject setgid(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return RubyProcess.gid_set(iRubyObject, iRubyObject2);
        }

        @JRubyMethod(name={"setuid"}, required=1, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject setuid(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return RubyProcess.uid_set(iRubyObject, iRubyObject2);
        }
    }

    public static class GroupID {
        @JRubyMethod(name={"change_privilege"}, required=1, module=true)
        public static IRubyObject change_privilege(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            throw iRubyObject.getRuntime().newNotImplementedError("Process::GID::change_privilege not implemented yet");
        }

        @JRubyMethod(name={"eid"}, module=true)
        public static IRubyObject eid(IRubyObject iRubyObject) {
            return RubyProcess.egid(iRubyObject);
        }

        @JRubyMethod(name={"eid="}, required=1, module=true)
        public static IRubyObject eid(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return RubyProcess.egid_set(iRubyObject, iRubyObject2);
        }

        @JRubyMethod(name={"grant_privilege"}, required=1, module=true)
        public static IRubyObject grant_privilege(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            throw iRubyObject.getRuntime().newNotImplementedError("Process::GID::grant_privilege not implemented yet");
        }

        @JRubyMethod(name={"re_exchange"}, module=true)
        public static IRubyObject re_exchange(ThreadContext threadContext, IRubyObject iRubyObject) {
            return GroupID.switch_rb(threadContext, iRubyObject, Block.NULL_BLOCK);
        }

        @JRubyMethod(name={"re_exchangeable?"}, module=true)
        public static IRubyObject re_exchangeable_p(IRubyObject iRubyObject) {
            throw iRubyObject.getRuntime().newNotImplementedError("Process::GID::re_exchangeable? not implemented yet");
        }

        @JRubyMethod(name={"rid"}, module=true)
        public static IRubyObject rid(IRubyObject iRubyObject) {
            return RubyProcess.gid(iRubyObject);
        }

        @JRubyMethod(name={"sid_available?"}, module=true)
        public static IRubyObject sid_available_p(IRubyObject iRubyObject) {
            throw iRubyObject.getRuntime().newNotImplementedError("Process::GID::sid_available not implemented yet");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(name={"switch"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject switch_rb(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
            Ruby ruby = iRubyObject.getRuntime();
            int n = ruby.getPosix().getgid();
            int n2 = ruby.getPosix().getegid();
            if (block.isGiven()) {
                IRubyObject iRubyObject2;
                try {
                    ruby.getPosix().setegid(n);
                    ruby.getPosix().setgid(n2);
                    iRubyObject2 = block.yield(threadContext, ruby.getNil());
                    Object var8_7 = null;
                    ruby.getPosix().setegid(n2);
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    ruby.getPosix().setegid(n2);
                    ruby.getPosix().setgid(n);
                    throw throwable;
                }
                ruby.getPosix().setgid(n);
                return iRubyObject2;
            }
            ruby.getPosix().setegid(n);
            ruby.getPosix().setgid(n2);
            return RubyFixnum.zero(ruby);
        }
    }

    public static class UserID {
        @JRubyMethod(name={"change_privilege"}, required=1, module=true)
        public static IRubyObject change_privilege(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            throw iRubyObject.getRuntime().newNotImplementedError("Process::UID::change_privilege not implemented yet");
        }

        @JRubyMethod(name={"eid"}, module=true)
        public static IRubyObject eid(IRubyObject iRubyObject) {
            return RubyProcess.euid(iRubyObject);
        }

        @JRubyMethod(name={"eid="}, required=1, module=true)
        public static IRubyObject eid(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return RubyProcess.euid_set(iRubyObject, iRubyObject2);
        }

        @JRubyMethod(name={"grant_privilege"}, required=1, module=true)
        public static IRubyObject grant_privilege(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            throw iRubyObject.getRuntime().newNotImplementedError("Process::UID::grant_privilege not implemented yet");
        }

        @JRubyMethod(name={"re_exchange"}, module=true)
        public static IRubyObject re_exchange(ThreadContext threadContext, IRubyObject iRubyObject) {
            return UserID.switch_rb(threadContext, iRubyObject, Block.NULL_BLOCK);
        }

        @JRubyMethod(name={"re_exchangeable?"}, module=true)
        public static IRubyObject re_exchangeable_p(IRubyObject iRubyObject) {
            throw iRubyObject.getRuntime().newNotImplementedError("Process::UID::re_exchangeable? not implemented yet");
        }

        @JRubyMethod(name={"rid"}, module=true)
        public static IRubyObject rid(IRubyObject iRubyObject) {
            return RubyProcess.uid(iRubyObject);
        }

        @JRubyMethod(name={"sid_available?"}, module=true)
        public static IRubyObject sid_available_p(IRubyObject iRubyObject) {
            throw iRubyObject.getRuntime().newNotImplementedError("Process::UID::sid_available not implemented yet");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(name={"switch"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject switch_rb(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
            Ruby ruby = iRubyObject.getRuntime();
            int n = ruby.getPosix().getuid();
            int n2 = ruby.getPosix().geteuid();
            if (block.isGiven()) {
                IRubyObject iRubyObject2;
                try {
                    ruby.getPosix().seteuid(n);
                    ruby.getPosix().setuid(n2);
                    iRubyObject2 = block.yield(threadContext, ruby.getNil());
                    Object var8_7 = null;
                    ruby.getPosix().seteuid(n2);
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    ruby.getPosix().seteuid(n2);
                    ruby.getPosix().setuid(n);
                    throw throwable;
                }
                ruby.getPosix().setuid(n);
                return iRubyObject2;
            }
            ruby.getPosix().seteuid(n);
            ruby.getPosix().setuid(n2);
            return RubyFixnum.zero(ruby);
        }
    }

    public static class RubyStatus
    extends RubyObject {
        private long status = 0L;
        private static final long EXIT_SUCCESS = 0L;

        public RubyStatus(Ruby ruby, RubyClass rubyClass, long l) {
            super(ruby, rubyClass);
            this.status = l;
        }

        public static RubyStatus newProcessStatus(Ruby ruby, long l) {
            return new RubyStatus(ruby, ruby.getProcStatus(), l);
        }

        public IRubyObject not_implemented() {
            String string = "Process::Status#" + this.getRuntime().getCurrentContext().getFrameName() + " not implemented";
            throw this.getRuntime().newNotImplementedError(string);
        }

        public IRubyObject not_implemented1(IRubyObject iRubyObject) {
            String string = "Process::Status#" + this.getRuntime().getCurrentContext().getFrameName() + " not implemented";
            throw this.getRuntime().newNotImplementedError(string);
        }

        @JRubyMethod(name={"exitstatus"})
        public IRubyObject exitstatus() {
            return this.getRuntime().newFixnum(this.status);
        }

        @JRubyMethod(name={">>"}, required=1)
        public IRubyObject op_rshift(IRubyObject iRubyObject) {
            long l = iRubyObject.convertToInteger().getLongValue();
            return this.getRuntime().newFixnum(this.status >> (int)l);
        }

        @JRubyMethod(name={"=="}, required=1)
        public IRubyObject op_equal(ThreadContext threadContext, IRubyObject iRubyObject) {
            return iRubyObject.callMethod(threadContext, MethodIndex.EQUALEQUAL, "==", this.to_i());
        }

        @JRubyMethod(name={"to_i"})
        public IRubyObject to_i() {
            return this.getRuntime().newFixnum(this.shiftedValue());
        }

        @JRubyMethod(name={"to_s"})
        public IRubyObject to_s() {
            return this.getRuntime().newString(String.valueOf(this.shiftedValue()));
        }

        @JRubyMethod(name={"inspect"})
        public IRubyObject inspect() {
            return this.getRuntime().newString("#<Process::Status: pid=????,exited(" + String.valueOf(this.status) + ")>");
        }

        @JRubyMethod(name={"success?"})
        public IRubyObject success_p() {
            return this.getRuntime().newBoolean(this.status == 0L);
        }

        private long shiftedValue() {
            return this.status << 8;
        }
    }
}

