/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.CompatVersion;
import org.jruby.IncludedModuleWrapper;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyKernel;
import org.jruby.RubyMethod;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyUnboundMethod;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.compiler.ASTInspector;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.AliasMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.FullFunctionCallbackMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.internal.runtime.methods.MethodMethod;
import org.jruby.internal.runtime.methods.ProcMethod;
import org.jruby.internal.runtime.methods.SimpleCallbackMethod;
import org.jruby.internal.runtime.methods.UndefinedMethod;
import org.jruby.internal.runtime.methods.WrapperMethod;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CacheMap;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.Dispatcher;
import org.jruby.runtime.MethodFactory;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.callback.Callback;
import org.jruby.runtime.component.VariableEntry;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ClassProvider;
import org.jruby.util.IdUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyModule
extends RubyObject {
    static ObjectAllocator MODULE_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new RubyModule(ruby, rubyClass);
        }
    };
    protected RubyClass superClass;
    public int index;
    public Dispatcher dispatcher = Dispatcher.DEFAULT_DISPATCHER;
    public KindOf kindOf = KindOf.DEFAULT_KIND_OF;
    public final int id;
    public RubyModule parent;
    protected String classId;
    protected final ReentrantLock variableWriteLock = new ReentrantLock();
    protected volatile transient ConstantTableEntry[] constantTable = new ConstantTableEntry[8];
    protected transient int constantTableSize;
    protected transient int constantTableThreshold = 6;
    private final Map<String, DynamicMethod> methods = new ConcurrentHashMap<String, DynamicMethod>(12, 0.75f, 1);
    private transient List<ClassProvider> classProviders;
    private static MethodFactory.MethodDefiningCallback methodDefiningCallback = new MethodFactory.MethodDefiningCallback(){

        public void define(RubyModule rubyModule, Method method, DynamicMethod dynamicMethod) {
            block17: {
                String string;
                JRubyMethod jRubyMethod;
                block18: {
                    String string2;
                    jRubyMethod = method.getAnnotation(JRubyMethod.class);
                    if (jRubyMethod.frame()) {
                        for (String string3 : jRubyMethod.name()) {
                            ASTInspector.FRAME_AWARE_METHODS.add(string3);
                        }
                    }
                    if (jRubyMethod.compat() != CompatVersion.BOTH && rubyModule.getRuntime().getInstanceConfig().getCompatVersion() != jRubyMethod.compat()) break block17;
                    RubyClass rubyClass = rubyModule.metaClass;
                    if (!jRubyMethod.meta()) break block18;
                    if (jRubyMethod.name().length == 0) {
                        string2 = method.getName();
                        rubyClass.addMethod(string2, dynamicMethod);
                    } else {
                        string2 = jRubyMethod.name()[0];
                        String[] stringArray = jRubyMethod.name();
                        int n = stringArray.length;
                        for (int i = 0; i < n; ++i) {
                            String string4 = stringArray[i];
                            rubyClass.addMethod(string4, dynamicMethod);
                        }
                    }
                    if (jRubyMethod.alias().length <= 0) break block17;
                    for (String string4 : jRubyMethod.alias()) {
                        rubyClass.defineAlias(string4, string2);
                    }
                    break block17;
                }
                if (jRubyMethod.name().length == 0) {
                    string = method.getName();
                    rubyModule.addMethod(method.getName(), dynamicMethod);
                } else {
                    string = jRubyMethod.name()[0];
                    String[] stringArray = jRubyMethod.name();
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String string5 = stringArray[i];
                        rubyModule.addMethod(string5, dynamicMethod);
                    }
                }
                if (jRubyMethod.alias().length > 0) {
                    for (String string5 : jRubyMethod.alias()) {
                        rubyModule.defineAlias(string5, string);
                    }
                }
                if (jRubyMethod.module()) {
                    DynamicMethod dynamicMethod2 = dynamicMethod.dup();
                    dynamicMethod2.setVisibility(Visibility.PUBLIC);
                    RubyClass rubyClass = rubyModule.getSingletonClass();
                    if (jRubyMethod.name().length == 0) {
                        string = method.getName();
                        rubyClass.addMethod(method.getName(), dynamicMethod2);
                    } else {
                        string = jRubyMethod.name()[0];
                        String[] stringArray = jRubyMethod.name();
                        int n = stringArray.length;
                        for (int i = 0; i < n; ++i) {
                            String string6 = stringArray[i];
                            rubyClass.addMethod(string6, dynamicMethod2);
                        }
                    }
                    if (jRubyMethod.alias().length > 0) {
                        for (String string6 : jRubyMethod.alias()) {
                            rubyClass.defineAlias(string6, string);
                        }
                    }
                }
            }
        }
    };
    protected static final String ERR_INSECURE_SET_CLASS_VAR = "Insecure: can't modify class variable";
    protected static final String ERR_FROZEN_CVAR_TYPE = "class/module ";
    protected static final String ERR_INSECURE_SET_CONSTANT = "Insecure: can't modify constant";
    protected static final String ERR_FROZEN_CONST_TYPE = "class/module ";
    protected static final int CONSTANT_TABLE_DEFAULT_CAPACITY = 8;
    protected static final int CONSTANT_TABLE_MAXIMUM_CAPACITY = 0x40000000;
    protected static final float CONSTANT_TABLE_LOAD_FACTOR = 0.75f;

    public static RubyClass createModuleClass(Ruby ruby, RubyClass rubyClass) {
        rubyClass.index = 12;
        rubyClass.kindOf = new KindOf(){

            public boolean isKindOf(IRubyObject iRubyObject, RubyModule rubyModule) {
                return iRubyObject instanceof RubyModule;
            }
        };
        CallbackFactory callbackFactory = ruby.callbackFactory(RubyModule.class);
        rubyClass.defineAnnotatedMethods(RubyModule.class);
        rubyClass.dispatcher = callbackFactory.createDispatcher(rubyClass);
        callbackFactory = ruby.callbackFactory(RubyKernel.class);
        rubyClass.defineFastMethod("autoload", callbackFactory.getFastSingletonMethod("autoload", RubyKernel.IRUBY_OBJECT, RubyKernel.IRUBY_OBJECT));
        rubyClass.defineFastMethod("autoload?", callbackFactory.getFastSingletonMethod("autoload_p", RubyKernel.IRUBY_OBJECT));
        return rubyClass;
    }

    @Override
    public int getNativeTypeIndex() {
        return 12;
    }

    @Override
    public boolean isModule() {
        return true;
    }

    @Override
    public boolean isClass() {
        return false;
    }

    public boolean isSingleton() {
        return false;
    }

    public boolean isInstance(IRubyObject iRubyObject) {
        return this.kindOf.isKindOf(iRubyObject, this);
    }

    protected RubyModule(Ruby ruby, RubyClass rubyClass, boolean bl) {
        super(ruby, rubyClass, bl);
        this.id = ruby.allocModuleId();
        this.setFlag(2048, !this.isClass());
    }

    protected RubyModule(Ruby ruby, RubyClass rubyClass) {
        this(ruby, rubyClass, ruby.isObjectSpaceEnabled());
    }

    protected RubyModule(Ruby ruby) {
        this(ruby, ruby.getModule());
    }

    public boolean needsImplementer() {
        return this.getFlag(2048);
    }

    public static RubyModule newModule(Ruby ruby) {
        return new RubyModule(ruby);
    }

    public static RubyModule newModule(Ruby ruby, String string, RubyModule rubyModule, boolean bl) {
        RubyModule rubyModule2 = RubyModule.newModule(ruby);
        rubyModule2.setBaseName(string);
        if (bl) {
            rubyModule2.setParent(rubyModule);
        }
        rubyModule.setConstant(string, rubyModule2);
        return rubyModule2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addClassProvider(ClassProvider classProvider) {
        if (this.classProviders == null) {
            List<ClassProvider> list = Collections.synchronizedList(new ArrayList());
            list.add(classProvider);
            this.classProviders = list;
        } else {
            List<ClassProvider> list = this.classProviders;
            synchronized (list) {
                if (!this.classProviders.contains(classProvider)) {
                    this.classProviders.add(classProvider);
                }
            }
        }
    }

    public void removeClassProvider(ClassProvider classProvider) {
        if (this.classProviders != null) {
            this.classProviders.remove(classProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubyClass searchProvidersForClass(String string, RubyClass rubyClass) {
        if (this.classProviders != null) {
            List<ClassProvider> list = this.classProviders;
            synchronized (list) {
                for (ClassProvider classProvider : this.classProviders) {
                    RubyClass rubyClass2 = classProvider.defineClassUnder(this, string, rubyClass);
                    if (rubyClass2 == null) continue;
                    return rubyClass2;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubyModule searchProvidersForModule(String string) {
        if (this.classProviders != null) {
            List<ClassProvider> list = this.classProviders;
            synchronized (list) {
                for (ClassProvider classProvider : this.classProviders) {
                    RubyModule rubyModule = classProvider.defineModuleUnder(this, string);
                    if (rubyModule == null) continue;
                    return rubyModule;
                }
            }
        }
        return null;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public RubyClass getSuperClass() {
        return this.superClass;
    }

    protected void setSuperClass(RubyClass rubyClass) {
        this.superClass = rubyClass;
    }

    public RubyModule getParent() {
        return this.parent;
    }

    public void setParent(RubyModule rubyModule) {
        this.parent = rubyModule;
    }

    public Map<String, DynamicMethod> getMethods() {
        return this.methods;
    }

    private void putMethod(String string, DynamicMethod dynamicMethod) {
        this.dispatcher.clearIndex(MethodIndex.getIndex(string));
        this.getMethods().put(string, dynamicMethod);
    }

    public boolean isIncluded() {
        return false;
    }

    public RubyModule getNonIncludedClass() {
        return this;
    }

    public String getBaseName() {
        return this.classId;
    }

    public void setBaseName(String string) {
        this.classId = string;
    }

    public String getName() {
        if (this.getBaseName() == null) {
            if (this.isClass()) {
                return "#<Class:01x" + Integer.toHexString(System.identityHashCode(this)) + ">";
            }
            return "#<Module:01x" + Integer.toHexString(System.identityHashCode(this)) + ">";
        }
        StringBuffer stringBuffer = new StringBuffer(this.getBaseName());
        RubyClass rubyClass = this.getRuntime().getObject();
        for (RubyModule rubyModule = this.getParent(); rubyModule != null && rubyModule != rubyClass; rubyModule = rubyModule.getParent()) {
            String string = rubyModule.getBaseName();
            if (string == null) {
                string = rubyModule.getName();
            }
            stringBuffer.insert(0, "::").insert(0, string);
        }
        return stringBuffer.toString();
    }

    public IncludedModuleWrapper newIncludeClass(RubyClass rubyClass) {
        IncludedModuleWrapper includedModuleWrapper = new IncludedModuleWrapper(this.getRuntime(), rubyClass, this);
        if (this.getSuperClass() != null) {
            includedModuleWrapper.includeModule(this.getSuperClass());
        }
        return includedModuleWrapper;
    }

    public RubyClass getClass(String string) {
        IRubyObject iRubyObject = this.getConstantAt(string);
        if (iRubyObject instanceof RubyClass) {
            return (RubyClass)iRubyObject;
        }
        return null;
    }

    public RubyClass fastGetClass(String string) {
        IRubyObject iRubyObject = this.fastGetConstantAt(string);
        if (iRubyObject instanceof RubyClass) {
            return (RubyClass)iRubyObject;
        }
        return null;
    }

    public synchronized void includeModule(IRubyObject iRubyObject) {
        assert (iRubyObject != null);
        this.testFrozen("module");
        if (!this.isTaint()) {
            this.getRuntime().secure(4);
        }
        if (!(iRubyObject instanceof RubyModule)) {
            throw this.getRuntime().newTypeError("Wrong argument type " + iRubyObject.getMetaClass().getName() + " (expected Module).");
        }
        RubyModule rubyModule = (RubyModule)iRubyObject;
        if (this.isSame(rubyModule)) {
            return;
        }
        this.infectBy(rubyModule);
        this.doIncludeModule(rubyModule);
    }

    public void defineMethod(String string, Callback callback) {
        Visibility visibility = string.equals("initialize") ? Visibility.PRIVATE : Visibility.PUBLIC;
        this.addMethod(string, new FullFunctionCallbackMethod(this, callback, visibility));
    }

    public void defineAnnotatedMethod(Class clazz, String string) {
        boolean bl = false;
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals(string) || !this.defineAnnotatedMethod(method, MethodFactory.createFactory(this.getRuntime().getJRubyClassLoader()))) continue;
            bl = true;
        }
        if (!bl) {
            throw new RuntimeException("No JRubyMethod present for method " + string + "on class " + clazz.getName());
        }
    }

    public void defineAnnotatedMethods(Class clazz) {
        if (RubyInstanceConfig.INDEXED_METHODS) {
            this.defineAnnotatedMethodsIndexed(clazz);
        } else {
            this.defineAnnotatedMethodsIndividually(clazz);
        }
    }

    public void defineAnnotatedMethodsIndividually(Class clazz) {
        Method[] methodArray = clazz.getDeclaredMethods();
        MethodFactory methodFactory = MethodFactory.createFactory(this.getRuntime().getJRubyClassLoader());
        for (Method method : methodArray) {
            this.defineAnnotatedMethod(method, methodFactory);
        }
    }

    private void defineAnnotatedMethodsIndexed(Class clazz) {
        MethodFactory methodFactory = MethodFactory.createFactory(this.getRuntime().getJRubyClassLoader());
        methodFactory.defineIndexedAnnotatedMethods(this, clazz, methodDefiningCallback);
    }

    public boolean defineAnnotatedMethod(Method method, MethodFactory methodFactory) {
        JRubyMethod jRubyMethod = method.getAnnotation(JRubyMethod.class);
        if (jRubyMethod == null) {
            return false;
        }
        if (jRubyMethod.compat() == CompatVersion.BOTH || this.getRuntime().getInstanceConfig().getCompatVersion() == jRubyMethod.compat()) {
            DynamicMethod dynamicMethod = methodFactory.getAnnotatedMethod(this, method);
            methodDefiningCallback.define(this, method, dynamicMethod);
            return true;
        }
        return false;
    }

    public void defineFastMethod(String string, Callback callback) {
        Visibility visibility = string.equals("initialize") ? Visibility.PRIVATE : Visibility.PUBLIC;
        this.addMethod(string, new SimpleCallbackMethod(this, callback, visibility));
    }

    public void defineFastMethod(String string, Callback callback, Visibility visibility) {
        this.addMethod(string, new SimpleCallbackMethod(this, callback, visibility));
    }

    public void definePrivateMethod(String string, Callback callback) {
        this.addMethod(string, new FullFunctionCallbackMethod(this, callback, Visibility.PRIVATE));
    }

    public void defineFastPrivateMethod(String string, Callback callback) {
        this.addMethod(string, new SimpleCallbackMethod(this, callback, Visibility.PRIVATE));
    }

    public void defineFastProtectedMethod(String string, Callback callback) {
        this.addMethod(string, new SimpleCallbackMethod(this, callback, Visibility.PROTECTED));
    }

    public void undefineMethod(String string) {
        this.addMethod(string, UndefinedMethod.getInstance());
    }

    public void undef(ThreadContext threadContext, String string) {
        DynamicMethod dynamicMethod;
        Ruby ruby = this.getRuntime();
        if (this == ruby.getObject()) {
            ruby.secure(4);
        }
        if (ruby.getSafeLevel() >= 4 && !this.isTaint()) {
            throw new SecurityException("Insecure: can't undef");
        }
        this.testFrozen("module");
        if (string.equals("__id__") || string.equals("__send__")) {
            this.getRuntime().getWarnings().warn(IRubyWarnings.ID.UNDEFINING_BAD, "undefining `" + string + "' may cause serious problem", new Object[0]);
        }
        if ((dynamicMethod = this.searchMethod(string)).isUndefined()) {
            String string2 = " class";
            RubyModule rubyModule = this;
            if (rubyModule.isSingleton()) {
                IRubyObject iRubyObject = ((MetaClass)rubyModule).getAttached();
                if (iRubyObject != null && iRubyObject instanceof RubyModule) {
                    rubyModule = (RubyModule)iRubyObject;
                    string2 = "";
                }
            } else if (rubyModule.isModule()) {
                string2 = " module";
            }
            throw this.getRuntime().newNameError("Undefined method " + string + " for" + string2 + " '" + rubyModule.getName() + "'", string);
        }
        this.addMethod(string, UndefinedMethod.getInstance());
        if (this.isSingleton()) {
            IRubyObject iRubyObject = ((MetaClass)this).getAttached();
            iRubyObject.callMethod(threadContext, "singleton_method_undefined", this.getRuntime().newSymbol(string));
        } else {
            this.callMethod(threadContext, "method_undefined", this.getRuntime().newSymbol(string));
        }
    }

    @JRubyMethod(name={"include?"}, required=1)
    public IRubyObject include_p(IRubyObject iRubyObject) {
        if (!iRubyObject.isModule()) {
            throw this.getRuntime().newTypeError(iRubyObject, this.getRuntime().getModule());
        }
        for (RubyModule rubyModule = this; rubyModule != null; rubyModule = rubyModule.getSuperClass()) {
            if (!(rubyModule instanceof IncludedModuleWrapper) || ((IncludedModuleWrapper)rubyModule).getNonIncludedClass() != iRubyObject) continue;
            return this.getRuntime().newBoolean(true);
        }
        return this.getRuntime().newBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMethod(String string, DynamicMethod dynamicMethod) {
        if (this == this.getRuntime().getObject()) {
            this.getRuntime().secure(4);
        }
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw this.getRuntime().newSecurityError("Insecure: can't define method");
        }
        this.testFrozen("class/module");
        Map<String, DynamicMethod> map = this.getMethods();
        synchronized (map) {
            DynamicMethod dynamicMethod2 = this.getMethods().put(string, dynamicMethod);
            if (dynamicMethod2 != null) {
                this.getRuntime().getCacheMap().remove(dynamicMethod2);
            }
            this.dispatcher.clearIndex(MethodIndex.getIndex(string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMethod(ThreadContext threadContext, String string) {
        if (this == this.getRuntime().getObject()) {
            this.getRuntime().secure(4);
        }
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw this.getRuntime().newSecurityError("Insecure: can't remove method");
        }
        this.testFrozen("class/module");
        Object object = this.getMethods();
        synchronized (object) {
            DynamicMethod dynamicMethod = this.getMethods().remove(string);
            if (dynamicMethod == null) {
                throw this.getRuntime().newNameError("method '" + string + "' not defined in " + this.getName(), string);
            }
            this.getRuntime().getCacheMap().remove(dynamicMethod);
        }
        if (this.isSingleton()) {
            object = ((MetaClass)this).getAttached();
            object.callMethod(threadContext, "singleton_method_removed", this.getRuntime().newSymbol(string));
        } else {
            this.callMethod(threadContext, "method_removed", this.getRuntime().newSymbol(string));
        }
    }

    public DynamicMethod searchMethod(String string) {
        for (RubyModule rubyModule = this; rubyModule != null; rubyModule = rubyModule.getSuperClass()) {
            DynamicMethod dynamicMethod = rubyModule.getMethods().get(string);
            if (dynamicMethod == null) continue;
            return dynamicMethod;
        }
        return UndefinedMethod.getInstance();
    }

    public DynamicMethod retrieveMethod(String string) {
        return this.getMethods().get(string);
    }

    public RubyModule findImplementer(RubyModule rubyModule) {
        for (RubyModule rubyModule2 = this; rubyModule2 != null; rubyModule2 = rubyModule2.getSuperClass()) {
            if (!rubyModule2.isSame(rubyModule)) continue;
            return rubyModule2;
        }
        return null;
    }

    public void addModuleFunction(String string, DynamicMethod dynamicMethod) {
        this.addMethod(string, dynamicMethod);
        this.getSingletonClass().addMethod(string, dynamicMethod);
    }

    public void defineModuleFunction(String string, Callback callback) {
        this.definePrivateMethod(string, callback);
        this.getSingletonClass().defineMethod(string, callback);
    }

    public void definePublicModuleFunction(String string, Callback callback) {
        this.defineMethod(string, callback);
        this.getSingletonClass().defineMethod(string, callback);
    }

    public void defineFastModuleFunction(String string, Callback callback) {
        this.defineFastPrivateMethod(string, callback);
        this.getSingletonClass().defineFastMethod(string, callback);
    }

    public void defineFastPublicModuleFunction(String string, Callback callback) {
        this.defineFastMethod(string, callback);
        this.getSingletonClass().defineFastMethod(string, callback);
    }

    public synchronized void defineAlias(String string, String string2) {
        this.testFrozen("module");
        if (string2.equals(string)) {
            return;
        }
        Ruby ruby = this.getRuntime();
        if (this == ruby.getObject()) {
            ruby.secure(4);
        }
        DynamicMethod dynamicMethod = this.searchMethod(string2);
        DynamicMethod dynamicMethod2 = this.searchMethod(string);
        if (dynamicMethod.isUndefined()) {
            if (this.isModule()) {
                dynamicMethod = ruby.getObject().searchMethod(string2);
            }
            if (dynamicMethod.isUndefined()) {
                throw ruby.newNameError("undefined method `" + string2 + "' for " + (this.isModule() ? "module" : "class") + " `" + this.getName() + "'", string2);
            }
        }
        CacheMap cacheMap = ruby.getCacheMap();
        cacheMap.remove(dynamicMethod);
        cacheMap.remove(dynamicMethod2);
        if (dynamicMethod2 != dynamicMethod2.getRealMethod()) {
            cacheMap.remove(dynamicMethod2.getRealMethod());
        }
        this.putMethod(string, new AliasMethod(this, dynamicMethod, string2));
    }

    public synchronized void defineAliases(List<String> list, String string) {
        DynamicMethod dynamicMethod;
        this.testFrozen("module");
        Ruby ruby = this.getRuntime();
        if (this == ruby.getObject()) {
            ruby.secure(4);
        }
        if ((dynamicMethod = this.searchMethod(string)).isUndefined()) {
            if (this.isModule()) {
                dynamicMethod = ruby.getObject().searchMethod(string);
            }
            if (dynamicMethod.isUndefined()) {
                throw ruby.newNameError("undefined method `" + string + "' for " + (this.isModule() ? "module" : "class") + " `" + this.getName() + "'", string);
            }
        }
        CacheMap cacheMap = ruby.getCacheMap();
        cacheMap.remove(dynamicMethod);
        for (String string2 : list) {
            if (string.equals(string2)) continue;
            DynamicMethod dynamicMethod2 = this.searchMethod(string2);
            cacheMap.remove(dynamicMethod2);
            if (dynamicMethod2 != dynamicMethod2.getRealMethod()) {
                cacheMap.remove(dynamicMethod2.getRealMethod());
            }
            this.putMethod(string2, new AliasMethod(this, dynamicMethod, string));
        }
    }

    public RubyClass defineOrGetClassUnder(String string, RubyClass rubyClass) {
        RubyClass rubyClass2;
        Ruby ruby = this.getRuntime();
        IRubyObject iRubyObject = this.getConstantAt(string);
        if (iRubyObject != null) {
            if (!(iRubyObject instanceof RubyClass)) {
                throw ruby.newTypeError(string + " is not a class");
            }
            rubyClass2 = (RubyClass)iRubyObject;
            if (rubyClass != null) {
                RubyClass rubyClass3;
                for (rubyClass3 = rubyClass2.getSuperClass(); rubyClass3 != null && rubyClass3.isIncluded(); rubyClass3 = rubyClass3.getSuperClass()) {
                }
                if (rubyClass3 != null) {
                    rubyClass3 = rubyClass3.getRealClass();
                }
                if (rubyClass3 != rubyClass) {
                    throw ruby.newTypeError("superclass mismatch for class " + string);
                }
            }
            if (ruby.getSafeLevel() >= 4) {
                throw ruby.newTypeError("extending class prohibited");
            }
        } else if (this.classProviders == null || (rubyClass2 = this.searchProvidersForClass(string, rubyClass)) == null) {
            if (rubyClass == null) {
                rubyClass = ruby.getObject();
            }
            rubyClass2 = RubyClass.newClass(ruby, rubyClass, string, rubyClass.getAllocator(), this, true);
        }
        return rubyClass2;
    }

    public RubyModule defineOrGetModuleUnder(String string) {
        RubyModule rubyModule;
        Ruby ruby = this.getRuntime();
        IRubyObject iRubyObject = this.getConstantAt(string);
        if (iRubyObject != null) {
            if (!iRubyObject.isModule()) {
                throw ruby.newTypeError(string + " is not a module");
            }
            if (ruby.getSafeLevel() >= 4) {
                throw ruby.newSecurityError("extending module prohibited");
            }
            rubyModule = (RubyModule)iRubyObject;
        } else if (this.classProviders == null || (rubyModule = this.searchProvidersForModule(string)) == null) {
            rubyModule = RubyModule.newModule(ruby, string, this, true);
        }
        return rubyModule;
    }

    public RubyClass defineClassUnder(String string, RubyClass rubyClass, ObjectAllocator objectAllocator) {
        return this.getRuntime().defineClassUnder(string, rubyClass, objectAllocator, this);
    }

    public RubyModule defineModuleUnder(String string) {
        return this.getRuntime().defineModuleUnder(string, this);
    }

    private void addAccessor(ThreadContext threadContext, String string, boolean bl, boolean bl2) {
        assert (string == string.intern()) : string + " is not interned";
        final Ruby ruby = this.getRuntime();
        Visibility visibility = threadContext.getCurrentVisibility();
        if (visibility != Visibility.PRIVATE && visibility == Visibility.MODULE_FUNCTION) {
            visibility = Visibility.PRIVATE;
        }
        final String string2 = ("@" + string).intern();
        if (bl) {
            this.addMethod(string, new JavaMethod(this, Visibility.PUBLIC){

                public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
                    IRubyObject iRubyObject2;
                    if (iRubyObjectArray.length != 0) {
                        Arity.raiseArgumentError(ruby, iRubyObjectArray.length, 0, 0);
                    }
                    return (iRubyObject2 = iRubyObject.getInstanceVariables().fastGetInstanceVariable(string2)) == null ? ruby.getNil() : iRubyObject2;
                }

                public Arity getArity() {
                    return Arity.noArguments();
                }
            });
            this.callMethod(threadContext, "method_added", ruby.fastNewSymbol(string));
        }
        if (bl2) {
            string = (string + "=").intern();
            this.addMethod(string, new JavaMethod(this, Visibility.PUBLIC){

                public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
                    if (iRubyObjectArray.length != 1) {
                        Arity.raiseArgumentError(ruby, iRubyObjectArray.length, 1, 1);
                    }
                    return iRubyObject.getInstanceVariables().fastSetInstanceVariable(string2, iRubyObjectArray[0]);
                }

                public Arity getArity() {
                    return Arity.singleArgument();
                }
            });
            this.callMethod(threadContext, "method_added", ruby.fastNewSymbol(string));
        }
    }

    public void setMethodVisibility(IRubyObject[] iRubyObjectArray, Visibility visibility) {
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw this.getRuntime().newSecurityError("Insecure: can't change method visibility");
        }
        for (int i = 0; i < iRubyObjectArray.length; ++i) {
            this.exportMethod(iRubyObjectArray[i].asJavaString(), visibility);
        }
    }

    public void exportMethod(String string, Visibility visibility) {
        DynamicMethod dynamicMethod;
        if (this == this.getRuntime().getObject()) {
            this.getRuntime().secure(4);
        }
        if ((dynamicMethod = this.searchMethod(string)).isUndefined()) {
            throw this.getRuntime().newNameError("undefined method '" + string + "' for " + (this.isModule() ? "module" : "class") + " '" + this.getName() + "'", string);
        }
        if (dynamicMethod.getVisibility() != visibility) {
            if (this == dynamicMethod.getImplementationClass()) {
                dynamicMethod.setVisibility(visibility);
            } else {
                this.addMethod(string, new WrapperMethod(this, dynamicMethod, visibility));
            }
        }
    }

    public boolean isMethodBound(String string, boolean bl) {
        DynamicMethod dynamicMethod = this.searchMethod(string);
        if (!dynamicMethod.isUndefined()) {
            return !bl || dynamicMethod.getVisibility() != Visibility.PRIVATE;
        }
        return false;
    }

    public IRubyObject newMethod(IRubyObject iRubyObject, String string, boolean bl) {
        DynamicMethod dynamicMethod = this.searchMethod(string);
        if (dynamicMethod.isUndefined()) {
            throw this.getRuntime().newNameError("undefined method `" + string + "' for class `" + this.getName() + "'", string);
        }
        RubyModule rubyModule = dynamicMethod.getImplementationClass();
        RubyModule rubyModule2 = this;
        while (rubyModule2 != rubyModule && rubyModule2.isSingleton()) {
            rubyModule2 = ((MetaClass)rubyModule2).getRealClass();
        }
        RubyMethod rubyMethod = null;
        rubyMethod = bl ? RubyMethod.newMethod(rubyModule, string, rubyModule2, string, dynamicMethod, iRubyObject) : RubyUnboundMethod.newUnboundMethod(rubyModule, string, rubyModule2, string, dynamicMethod);
        rubyMethod.infectBy(this);
        return rubyMethod;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod(name={"define_method"}, required=1, optional=1, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject define_method(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        RubyProc rubyProc;
        RubyObject rubyObject;
        if (iRubyObjectArray.length < 1 || iRubyObjectArray.length > 2) {
            throw this.getRuntime().newArgumentError("wrong # of arguments(" + iRubyObjectArray.length + " for 1)");
        }
        String string = iRubyObjectArray[0].asJavaString().intern();
        DynamicMethod dynamicMethod = null;
        Visibility visibility = threadContext.getCurrentVisibility();
        if (visibility == Visibility.MODULE_FUNCTION) {
            visibility = Visibility.PRIVATE;
        }
        if (iRubyObjectArray.length == 1) {
            rubyObject = this.getRuntime().newProc(Block.Type.LAMBDA, block);
            rubyProc = rubyObject;
            ((RubyProc)rubyObject).getBlock().type = Block.Type.LAMBDA;
            dynamicMethod = this.createProcMethod(string, visibility, (RubyProc)rubyObject);
        } else {
            if (iRubyObjectArray.length != 2) throw this.getRuntime().newArgumentError("wrong # of arguments(" + iRubyObjectArray.length + " for 1)");
            if (this.getRuntime().getProc().isInstance(iRubyObjectArray[1])) {
                rubyObject = (RubyProc)iRubyObjectArray[1];
                rubyProc = rubyObject;
                dynamicMethod = this.createProcMethod(string, visibility, (RubyProc)rubyObject);
            } else {
                if (!this.getRuntime().getMethod().isInstance(iRubyObjectArray[1])) throw this.getRuntime().newTypeError("wrong argument type " + iRubyObjectArray[1].getType().getName() + " (expected Proc/Method)");
                rubyObject = (RubyMethod)iRubyObjectArray[1];
                rubyProc = rubyObject;
                dynamicMethod = new MethodMethod(this, ((RubyMethod)rubyObject).unbind(null), visibility);
            }
        }
        this.addMethod(string, dynamicMethod);
        rubyObject = this.getRuntime().fastNewSymbol(string);
        if (threadContext.getPreviousVisibility() == Visibility.MODULE_FUNCTION) {
            this.getSingletonClass().addMethod(string, new WrapperMethod((RubyModule)this.getSingletonClass(), dynamicMethod, Visibility.PUBLIC));
        }
        if (this.isSingleton()) {
            IRubyObject iRubyObject = ((MetaClass)this).getAttached();
            iRubyObject.callMethod(threadContext, "singleton_method_added", rubyObject);
            return rubyProc;
        } else {
            this.callMethod(threadContext, "method_added", rubyObject);
        }
        return rubyProc;
    }

    private DynamicMethod createProcMethod(String string, Visibility visibility, RubyProc rubyProc) {
        rubyProc.getBlock().getBinding().getFrame().setKlazz(this);
        rubyProc.getBlock().getBinding().getFrame().setName(string);
        rubyProc.getBlock().getBody().getStaticScope().setArgumentScope(true);
        rubyProc.getBlock().getBody().getStaticScope().setRequiredArgs(rubyProc.getBlock().arity().required());
        return new ProcMethod(this, rubyProc, visibility);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject executeUnder(ThreadContext threadContext, Callback callback, IRubyObject[] iRubyObjectArray, Block block) {
        threadContext.preExecuteUnder(this, block);
        try {
            IRubyObject iRubyObject = callback.execute(this, iRubyObjectArray, block);
            return iRubyObject;
        }
        finally {
            threadContext.postExecuteUnder();
        }
    }

    @JRubyMethod(name={"name"})
    public RubyString name() {
        return this.getRuntime().newString(this.getBaseName() == null ? "" : this.getName());
    }

    protected IRubyObject cloneMethods(RubyModule rubyModule) {
        RubyModule rubyModule2 = this.getNonIncludedClass();
        for (Map.Entry<String, DynamicMethod> entry : this.getMethods().entrySet()) {
            DynamicMethod dynamicMethod = entry.getValue();
            if (dynamicMethod.getImplementationClass() != rubyModule2 && !(dynamicMethod instanceof UndefinedMethod)) continue;
            DynamicMethod dynamicMethod2 = dynamicMethod.dup();
            dynamicMethod2.setImplementationClass(rubyModule);
            rubyModule.putMethod(entry.getKey(), dynamicMethod2);
        }
        return rubyModule;
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, required=1)
    public IRubyObject initialize_copy(IRubyObject iRubyObject) {
        super.initialize_copy(iRubyObject);
        RubyModule rubyModule = (RubyModule)iRubyObject;
        if (!this.getMetaClass().isSingleton()) {
            this.setMetaClass(rubyModule.getSingletonClassClone());
        }
        this.setSuperClass(rubyModule.getSuperClass());
        if (rubyModule.hasVariables()) {
            this.syncVariables(rubyModule.getVariableList());
        }
        rubyModule.cloneMethods(this);
        return this;
    }

    @JRubyMethod(name={"included_modules"})
    public RubyArray included_modules() {
        RubyArray rubyArray = this.getRuntime().newArray();
        for (RubyClass rubyClass = this.getSuperClass(); rubyClass != null; rubyClass = rubyClass.getSuperClass()) {
            if (!rubyClass.isIncluded()) continue;
            rubyArray.append(rubyClass.getNonIncludedClass());
        }
        return rubyArray;
    }

    @JRubyMethod(name={"ancestors"})
    public RubyArray ancestors() {
        RubyArray rubyArray = this.getRuntime().newArray(this.getAncestorList());
        return rubyArray;
    }

    public List<IRubyObject> getAncestorList() {
        ArrayList<IRubyObject> arrayList = new ArrayList<IRubyObject>();
        for (RubyModule rubyModule = this; rubyModule != null; rubyModule = rubyModule.getSuperClass()) {
            if (rubyModule.isSingleton()) continue;
            arrayList.add(rubyModule.getNonIncludedClass());
        }
        return arrayList;
    }

    public boolean hasModuleInHierarchy(RubyModule rubyModule) {
        for (RubyModule rubyModule2 = this; rubyModule2 != null; rubyModule2 = rubyModule2.getSuperClass()) {
            if (rubyModule2.getNonIncludedClass() != rubyModule) continue;
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.id;
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.id);
    }

    @Override
    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        if (this.isSingleton()) {
            IRubyObject iRubyObject = ((MetaClass)this).getAttached();
            StringBuffer stringBuffer = new StringBuffer("#<Class:");
            if (iRubyObject instanceof RubyClass || iRubyObject instanceof RubyModule) {
                stringBuffer.append(iRubyObject.inspect());
            } else {
                stringBuffer.append(iRubyObject.anyToString());
            }
            stringBuffer.append(">");
            return this.getRuntime().newString(stringBuffer.toString());
        }
        return this.getRuntime().newString(this.getName());
    }

    @JRubyMethod(name={"==="}, required=1)
    public RubyBoolean op_eqq(IRubyObject iRubyObject) {
        return this.getRuntime().newBoolean(this.isInstance(iRubyObject));
    }

    @Override
    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext threadContext, IRubyObject iRubyObject) {
        return super.op_equal(threadContext, iRubyObject);
    }

    @Override
    @JRubyMethod(name={"freeze"})
    public IRubyObject freeze() {
        this.to_s();
        return super.freeze();
    }

    @JRubyMethod(name={"<="}, required=1)
    public IRubyObject op_le(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof RubyModule)) {
            throw this.getRuntime().newTypeError("compared with non class/module");
        }
        if (this.isKindOfModule((RubyModule)iRubyObject)) {
            return this.getRuntime().getTrue();
        }
        if (((RubyModule)iRubyObject).isKindOfModule(this)) {
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"<"}, required=1)
    public IRubyObject op_lt(IRubyObject iRubyObject) {
        return iRubyObject == this ? this.getRuntime().getFalse() : this.op_le(iRubyObject);
    }

    @JRubyMethod(name={">="}, required=1)
    public IRubyObject op_ge(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof RubyModule)) {
            throw this.getRuntime().newTypeError("compared with non class/module");
        }
        return ((RubyModule)iRubyObject).op_le(this);
    }

    @JRubyMethod(name={">"}, required=1)
    public IRubyObject op_gt(IRubyObject iRubyObject) {
        return this == iRubyObject ? this.getRuntime().getFalse() : this.op_ge(iRubyObject);
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(IRubyObject iRubyObject) {
        if (this == iRubyObject) {
            return this.getRuntime().newFixnum(0L);
        }
        if (!(iRubyObject instanceof RubyModule)) {
            return this.getRuntime().getNil();
        }
        RubyModule rubyModule = (RubyModule)iRubyObject;
        if (rubyModule.isKindOfModule(this)) {
            return this.getRuntime().newFixnum(1L);
        }
        if (this.isKindOfModule(rubyModule)) {
            return this.getRuntime().newFixnum(-1L);
        }
        return this.getRuntime().getNil();
    }

    public boolean isKindOfModule(RubyModule rubyModule) {
        for (RubyModule rubyModule2 = this; rubyModule2 != null; rubyModule2 = rubyModule2.getSuperClass()) {
            if (!rubyModule2.isSame(rubyModule)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSame(RubyModule rubyModule) {
        return this == rubyModule;
    }

    @JRubyMethod(name={"initialize"}, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(Block block) {
        if (block.isGiven()) {
            block.getBinding().setVisibility(Visibility.PUBLIC);
            block.yield(this.getRuntime().getCurrentContext(), null, this, this, false);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"attr"}, required=1, optional=1, visibility=Visibility.PRIVATE)
    public IRubyObject attr(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        boolean bl = iRubyObjectArray.length > 1 ? iRubyObjectArray[1].isTrue() : false;
        this.addAccessor(threadContext, iRubyObjectArray[0].asJavaString().intern(), true, bl);
        return this.getRuntime().getNil();
    }

    public IRubyObject attr_reader(IRubyObject[] iRubyObjectArray) {
        return this.attr_reader(this.getRuntime().getCurrentContext(), iRubyObjectArray);
    }

    @JRubyMethod(name={"attr_reader"}, rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject attr_reader(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        for (int i = 0; i < iRubyObjectArray.length; ++i) {
            this.addAccessor(threadContext, iRubyObjectArray[i].asJavaString().intern(), true, false);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"attr_writer"}, rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject attr_writer(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        for (int i = 0; i < iRubyObjectArray.length; ++i) {
            this.addAccessor(threadContext, iRubyObjectArray[i].asJavaString().intern(), false, true);
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject attr_accessor(IRubyObject[] iRubyObjectArray) {
        return this.attr_accessor(this.getRuntime().getCurrentContext(), iRubyObjectArray);
    }

    @JRubyMethod(name={"attr_accessor"}, rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject attr_accessor(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        for (int i = 0; i < iRubyObjectArray.length; ++i) {
            this.addAccessor(threadContext, iRubyObjectArray[i].asJavaString().intern(), true, true);
        }
        return this.getRuntime().getNil();
    }

    private RubyArray instance_methods(IRubyObject[] iRubyObjectArray, Visibility visibility, boolean bl) {
        boolean bl2 = iRubyObjectArray.length > 0 ? iRubyObjectArray[0].isTrue() : true;
        RubyArray rubyArray = this.getRuntime().newArray();
        HashSet<String> hashSet = new HashSet<String>();
        for (RubyModule rubyModule = this; rubyModule != null; rubyModule = rubyModule.getSuperClass()) {
            RubyModule rubyModule2 = rubyModule.getNonIncludedClass();
            for (Map.Entry<String, DynamicMethod> entry : rubyModule.getMethods().entrySet()) {
                DynamicMethod dynamicMethod = entry.getValue();
                String string = entry.getKey();
                if (hashSet.contains(string)) continue;
                hashSet.add(string);
                if (dynamicMethod.getImplementationClass() != rubyModule2 || (bl || dynamicMethod.getVisibility() != visibility) && (!bl || dynamicMethod.getVisibility() == visibility) || dynamicMethod.isUndefined()) continue;
                rubyArray.append(this.getRuntime().newString(string));
            }
            if (!bl2) break;
        }
        return rubyArray;
    }

    @JRubyMethod(name={"instance_methods"}, optional=1)
    public RubyArray instance_methods(IRubyObject[] iRubyObjectArray) {
        return this.instance_methods(iRubyObjectArray, Visibility.PRIVATE, true);
    }

    @JRubyMethod(name={"public_instance_methods"}, optional=1)
    public RubyArray public_instance_methods(IRubyObject[] iRubyObjectArray) {
        return this.instance_methods(iRubyObjectArray, Visibility.PUBLIC, false);
    }

    @JRubyMethod(name={"instance_method"}, required=1)
    public IRubyObject instance_method(IRubyObject iRubyObject) {
        return this.newMethod(null, iRubyObject.asJavaString(), false);
    }

    @JRubyMethod(name={"protected_instance_methods"}, optional=1)
    public RubyArray protected_instance_methods(IRubyObject[] iRubyObjectArray) {
        return this.instance_methods(iRubyObjectArray, Visibility.PROTECTED, false);
    }

    @JRubyMethod(name={"private_instance_methods"}, optional=1)
    public RubyArray private_instance_methods(IRubyObject[] iRubyObjectArray) {
        return this.instance_methods(iRubyObjectArray, Visibility.PRIVATE, false);
    }

    @JRubyMethod(name={"append_features"}, required=1, visibility=Visibility.PRIVATE)
    public RubyModule append_features(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof RubyModule)) {
            throw this.getRuntime().newTypeError(iRubyObject, this.getRuntime().getClassClass());
        }
        ((RubyModule)iRubyObject).includeModule(this);
        return this;
    }

    @JRubyMethod(name={"extend_object"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject extend_object(IRubyObject iRubyObject) {
        iRubyObject.getSingletonClass().includeModule(this);
        return iRubyObject;
    }

    @JRubyMethod(name={"include"}, required=1, rest=true, visibility=Visibility.PRIVATE)
    public RubyModule include(IRubyObject[] iRubyObjectArray) {
        ThreadContext threadContext = this.getRuntime().getCurrentContext();
        int n = iRubyObjectArray.length;
        while (--n >= 0) {
            IRubyObject iRubyObject = iRubyObjectArray[n];
            if (iRubyObject.isModule()) continue;
            throw this.getRuntime().newTypeError(iRubyObject, this.getRuntime().getModule());
        }
        for (n = iRubyObjectArray.length - 1; n >= 0; --n) {
            iRubyObjectArray[n].callMethod(threadContext, "append_features", this);
            iRubyObjectArray[n].callMethod(threadContext, "included", this);
        }
        return this;
    }

    @JRubyMethod(name={"included"}, required=1)
    public IRubyObject included(IRubyObject iRubyObject) {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"extended"}, required=1, frame=true)
    public IRubyObject extended(IRubyObject iRubyObject, Block block) {
        return this.getRuntime().getNil();
    }

    private void setVisibility(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Visibility visibility) {
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw this.getRuntime().newSecurityError("Insecure: can't change method visibility");
        }
        if (iRubyObjectArray.length == 0) {
            threadContext.setCurrentVisibility(visibility);
        } else {
            this.setMethodVisibility(iRubyObjectArray, visibility);
        }
    }

    @JRubyMethod(name={"public"}, rest=true, visibility=Visibility.PRIVATE)
    public RubyModule rbPublic(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        this.setVisibility(threadContext, iRubyObjectArray, Visibility.PUBLIC);
        return this;
    }

    @JRubyMethod(name={"protected"}, rest=true, visibility=Visibility.PRIVATE)
    public RubyModule rbProtected(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        this.setVisibility(threadContext, iRubyObjectArray, Visibility.PROTECTED);
        return this;
    }

    @JRubyMethod(name={"private"}, rest=true, visibility=Visibility.PRIVATE)
    public RubyModule rbPrivate(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        this.setVisibility(threadContext, iRubyObjectArray, Visibility.PRIVATE);
        return this;
    }

    @JRubyMethod(name={"module_function"}, rest=true, visibility=Visibility.PRIVATE)
    public RubyModule module_function(IRubyObject[] iRubyObjectArray) {
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw this.getRuntime().newSecurityError("Insecure: can't change method visibility");
        }
        ThreadContext threadContext = this.getRuntime().getCurrentContext();
        if (iRubyObjectArray.length == 0) {
            threadContext.setCurrentVisibility(Visibility.MODULE_FUNCTION);
        } else {
            this.setMethodVisibility(iRubyObjectArray, Visibility.PRIVATE);
            for (int i = 0; i < iRubyObjectArray.length; ++i) {
                String string = iRubyObjectArray[i].asJavaString().intern();
                DynamicMethod dynamicMethod = this.searchMethod(string);
                assert (!dynamicMethod.isUndefined()) : "undefined method '" + string + "'";
                this.getSingletonClass().addMethod(string, new WrapperMethod((RubyModule)this.getSingletonClass(), dynamicMethod, Visibility.PUBLIC));
                this.callMethod(threadContext, "singleton_method_added", this.getRuntime().fastNewSymbol(string));
            }
        }
        return this;
    }

    @JRubyMethod(name={"method_added"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject method_added(IRubyObject iRubyObject) {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"method_removed"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject method_removed(IRubyObject iRubyObject) {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"method_undefined"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject method_undefined(IRubyObject iRubyObject) {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"method_defined?"}, required=1)
    public RubyBoolean method_defined_p(IRubyObject iRubyObject) {
        return this.isMethodBound(iRubyObject.asJavaString(), true) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"public_method_defined?"}, required=1)
    public IRubyObject public_method_defined(IRubyObject iRubyObject) {
        DynamicMethod dynamicMethod = this.searchMethod(iRubyObject.asJavaString());
        return this.getRuntime().newBoolean(!dynamicMethod.isUndefined() && dynamicMethod.getVisibility() == Visibility.PUBLIC);
    }

    @JRubyMethod(name={"protected_method_defined?"}, required=1)
    public IRubyObject protected_method_defined(IRubyObject iRubyObject) {
        DynamicMethod dynamicMethod = this.searchMethod(iRubyObject.asJavaString());
        return this.getRuntime().newBoolean(!dynamicMethod.isUndefined() && dynamicMethod.getVisibility() == Visibility.PROTECTED);
    }

    @JRubyMethod(name={"private_method_defined?"}, required=1)
    public IRubyObject private_method_defined(IRubyObject iRubyObject) {
        DynamicMethod dynamicMethod = this.searchMethod(iRubyObject.asJavaString());
        return this.getRuntime().newBoolean(!dynamicMethod.isUndefined() && dynamicMethod.getVisibility() == Visibility.PRIVATE);
    }

    @JRubyMethod(name={"public_class_method"}, rest=true)
    public RubyModule public_class_method(IRubyObject[] iRubyObjectArray) {
        this.getMetaClass().setMethodVisibility(iRubyObjectArray, Visibility.PUBLIC);
        return this;
    }

    @JRubyMethod(name={"private_class_method"}, rest=true)
    public RubyModule private_class_method(IRubyObject[] iRubyObjectArray) {
        this.getMetaClass().setMethodVisibility(iRubyObjectArray, Visibility.PRIVATE);
        return this;
    }

    @JRubyMethod(name={"alias_method"}, required=2, visibility=Visibility.PRIVATE)
    public RubyModule alias_method(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubySymbol rubySymbol;
        String string = iRubyObject.asJavaString();
        this.defineAlias(string, iRubyObject2.asJavaString());
        RubySymbol rubySymbol2 = rubySymbol = iRubyObject instanceof RubySymbol ? (RubySymbol)iRubyObject : threadContext.getRuntime().newSymbol(string);
        if (this.isSingleton()) {
            ((MetaClass)this).getAttached().callMethod(threadContext, "singleton_method_added", rubySymbol);
        } else {
            this.callMethod(threadContext, "method_added", rubySymbol);
        }
        return this;
    }

    @JRubyMethod(name={"undef_method"}, required=1, rest=true, visibility=Visibility.PRIVATE)
    public RubyModule undef_method(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        for (int i = 0; i < iRubyObjectArray.length; ++i) {
            this.undef(threadContext, iRubyObjectArray[i].asJavaString());
        }
        return this;
    }

    @JRubyMethod(name={"module_eval", "class_eval"}, optional=3, frame=true)
    public IRubyObject module_eval(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        return this.specificEval(threadContext, this, iRubyObjectArray, block);
    }

    @JRubyMethod(name={"remove_method"}, required=1, rest=true, visibility=Visibility.PRIVATE)
    public RubyModule remove_method(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        for (int i = 0; i < iRubyObjectArray.length; ++i) {
            this.removeMethod(threadContext, iRubyObjectArray[i].asJavaString());
        }
        return this;
    }

    public static void marshalTo(RubyModule rubyModule, MarshalStream marshalStream) throws IOException {
        marshalStream.registerLinkTarget(rubyModule);
        marshalStream.writeString(MarshalStream.getPathFromClass(rubyModule));
    }

    public static RubyModule unmarshalFrom(UnmarshalStream unmarshalStream) throws IOException {
        String string = RubyString.byteListToString(unmarshalStream.unmarshalString());
        RubyModule rubyModule = UnmarshalStream.getModuleFromPath(unmarshalStream.getRuntime(), string);
        unmarshalStream.registerLinkTarget(rubyModule);
        return rubyModule;
    }

    @JRubyMethod(name={"nesting"}, frame=true, meta=true)
    public static RubyArray nesting(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        Ruby ruby = iRubyObject.getRuntime();
        RubyClass rubyClass = ruby.getObject();
        StaticScope staticScope = threadContext.getCurrentScope().getStaticScope();
        RubyArray rubyArray = ruby.newArray();
        StaticScope staticScope2 = staticScope;
        while (staticScope2.getModule() != rubyClass) {
            rubyArray.append(staticScope2.getModule());
            staticScope2 = staticScope2.getPreviousCRefScope();
        }
        return rubyArray;
    }

    private void doIncludeModule(RubyModule rubyModule) {
        boolean bl = false;
        RubyModule rubyModule2 = this;
        while (rubyModule != null) {
            if (this.getNonIncludedClass() == rubyModule.getNonIncludedClass()) {
                throw this.getRuntime().newArgumentError("cyclic include detected");
            }
            boolean bl2 = false;
            for (RubyClass rubyClass = this.getSuperClass(); rubyClass != null; rubyClass = rubyClass.getSuperClass()) {
                if (rubyClass instanceof IncludedModuleWrapper) {
                    if (rubyClass.getNonIncludedClass() != rubyModule.getNonIncludedClass()) continue;
                    if (!bl2) {
                        rubyModule2 = rubyClass;
                    }
                    bl = true;
                    break;
                }
                bl2 = true;
            }
            if (!bl) {
                this.getRuntime().getCacheMap().moduleIncluded(rubyModule2, rubyModule);
                rubyModule2.setSuperClass(new IncludedModuleWrapper(this.getRuntime(), rubyModule2.getSuperClass(), rubyModule.getNonIncludedClass()));
                rubyModule2 = rubyModule2.getSuperClass();
            }
            rubyModule = rubyModule.getSuperClass();
            bl = false;
        }
    }

    @JRubyMethod(name={"class_variable_defined?"}, required=1)
    public IRubyObject class_variable_defined_p(IRubyObject iRubyObject) {
        String string = this.validateClassVariable(iRubyObject.asJavaString().intern());
        RubyModule rubyModule = this;
        do {
            if (!rubyModule.fastHasClassVariable(string)) continue;
            return this.getRuntime().getTrue();
        } while ((rubyModule = rubyModule.getSuperClass()) != null);
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"class_variable_get"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject class_variable_get(IRubyObject iRubyObject) {
        return this.fastGetClassVar(this.validateClassVariable(iRubyObject.asJavaString()).intern());
    }

    @JRubyMethod(name={"class_variable_set"}, required=2, visibility=Visibility.PRIVATE)
    public IRubyObject class_variable_set(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return this.fastSetClassVar(this.validateClassVariable(iRubyObject.asJavaString()).intern(), iRubyObject2);
    }

    @JRubyMethod(name={"remove_class_variable"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject remove_class_variable(IRubyObject iRubyObject) {
        String string = this.validateClassVariable(iRubyObject.asJavaString());
        IRubyObject iRubyObject2 = this.deleteClassVariable(string);
        if (iRubyObject2 != null) {
            return iRubyObject2;
        }
        if (this.fastIsClassVarDefined(string)) {
            throw this.cannotRemoveError(string);
        }
        throw this.getRuntime().newNameError("class variable " + string + " not defined for " + this.getName(), string);
    }

    @JRubyMethod(name={"class_variables"})
    public RubyArray class_variables() {
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        for (object = this; object != null; object = ((RubyModule)object).getSuperClass()) {
            for (String object2 : ((RubyModule)object).getClassVariableNameList()) {
                hashSet.add(object2);
            }
        }
        object = this.getRuntime();
        RubyArray rubyArray = ((Ruby)object).newArray();
        for (String string : hashSet) {
            rubyArray.add(((Ruby)object).newString(string));
        }
        return rubyArray;
    }

    @JRubyMethod(name={"const_defined?"}, required=1)
    public RubyBoolean const_defined_p(IRubyObject iRubyObject) {
        return this.getRuntime().newBoolean(this.fastIsConstantDefined(this.validateConstant(iRubyObject.asJavaString()).intern()));
    }

    @JRubyMethod(name={"const_get"}, required=1)
    public IRubyObject const_get(IRubyObject iRubyObject) {
        return this.fastGetConstant(this.validateConstant(iRubyObject.asJavaString()).intern());
    }

    @JRubyMethod(name={"const_set"}, required=2)
    public IRubyObject const_set(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return this.fastSetConstant(this.validateConstant(iRubyObject.asJavaString()).intern(), iRubyObject2);
    }

    @JRubyMethod(name={"remove_const"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject remove_const(IRubyObject iRubyObject) {
        String string = this.validateConstant(iRubyObject.asJavaString());
        IRubyObject iRubyObject2 = this.deleteConstant(string);
        if (iRubyObject2 != null) {
            if (iRubyObject2 != this.getRuntime().getUndef()) {
                return iRubyObject2;
            }
            this.getRuntime().getLoadService().removeAutoLoadFor(this.getName() + "::" + string);
            return this.getRuntime().getNil();
        }
        if (this.hasConstantInHierarchy(string)) {
            throw this.cannotRemoveError(string);
        }
        throw this.getRuntime().newNameError("constant " + string + " not defined for " + this.getName(), string);
    }

    private boolean hasConstantInHierarchy(String string) {
        for (RubyModule rubyModule = this; rubyModule != null; rubyModule = rubyModule.getSuperClass()) {
            if (!rubyModule.hasConstant(string)) continue;
            return true;
        }
        return false;
    }

    @JRubyMethod(name={"const_missing"}, required=1, frame=true)
    public IRubyObject const_missing(IRubyObject iRubyObject, Block block) {
        if (this != this.getRuntime().getObject()) {
            throw this.getRuntime().newNameError("uninitialized constant " + this.getName() + "::" + iRubyObject.asJavaString(), "" + this.getName() + "::" + iRubyObject.asJavaString());
        }
        throw this.getRuntime().newNameError("uninitialized constant " + iRubyObject.asJavaString(), iRubyObject.asJavaString());
    }

    @JRubyMethod(name={"constants"})
    public RubyArray constants() {
        Ruby ruby = this.getRuntime();
        RubyArray rubyArray = ruby.newArray();
        RubyClass rubyClass = ruby.getObject();
        if (this.getRuntime().getModule() == this) {
            for (String string : rubyClass.getStoredConstantNameList()) {
                rubyArray.add(ruby.newString(string));
            }
        } else if (rubyClass == this) {
            for (String string : this.getStoredConstantNameList()) {
                rubyArray.add(ruby.newString(string));
            }
        } else {
            HashSet<String> hashSet = new HashSet<String>();
            for (Object object = this; object != null; object = ((RubyModule)object).getSuperClass()) {
                if (rubyClass == object) continue;
                for (String string : ((RubyModule)object).getStoredConstantNameList()) {
                    hashSet.add(string);
                }
            }
            for (String string : hashSet) {
                rubyArray.add(ruby.newString(string));
            }
        }
        return rubyArray;
    }

    public IRubyObject setClassVar(String string, IRubyObject iRubyObject) {
        RubyModule rubyModule = this;
        do {
            if (!rubyModule.hasClassVariable(string)) continue;
            return rubyModule.storeClassVariable(string, iRubyObject);
        } while ((rubyModule = rubyModule.getSuperClass()) != null);
        return this.storeClassVariable(string, iRubyObject);
    }

    public IRubyObject fastSetClassVar(String string, IRubyObject iRubyObject) {
        assert (string == string.intern()) : string + " is not interned";
        RubyModule rubyModule = this;
        do {
            if (!rubyModule.fastHasClassVariable(string)) continue;
            return rubyModule.fastStoreClassVariable(string, iRubyObject);
        } while ((rubyModule = rubyModule.getSuperClass()) != null);
        return this.fastStoreClassVariable(string, iRubyObject);
    }

    public IRubyObject getClassVar(String string) {
        assert (IdUtil.isClassVariable(string));
        RubyModule rubyModule = this;
        do {
            IRubyObject iRubyObject;
            if ((iRubyObject = rubyModule.variableTableFetch(string)) == null) continue;
            return iRubyObject;
        } while ((rubyModule = rubyModule.getSuperClass()) != null);
        throw this.getRuntime().newNameError("uninitialized class variable " + string + " in " + this.getName(), string);
    }

    public IRubyObject fastGetClassVar(String string) {
        assert (string == string.intern()) : string + " is not interned";
        assert (IdUtil.isClassVariable(string));
        RubyModule rubyModule = this;
        do {
            IRubyObject iRubyObject;
            if ((iRubyObject = rubyModule.variableTableFastFetch(string)) == null) continue;
            return iRubyObject;
        } while ((rubyModule = rubyModule.getSuperClass()) != null);
        throw this.getRuntime().newNameError("uninitialized class variable " + string + " in " + this.getName(), string);
    }

    public boolean isClassVarDefined(String string) {
        RubyModule rubyModule = this;
        do {
            if (!rubyModule.hasClassVariable(string)) continue;
            return true;
        } while ((rubyModule = rubyModule.getSuperClass()) != null);
        return false;
    }

    public boolean fastIsClassVarDefined(String string) {
        assert (string == string.intern()) : string + " is not interned";
        RubyModule rubyModule = this;
        do {
            if (!rubyModule.fastHasClassVariable(string)) continue;
            return true;
        } while ((rubyModule = rubyModule.getSuperClass()) != null);
        return false;
    }

    public IRubyObject removeCvar(IRubyObject iRubyObject) {
        String string = this.validateClassVariable(iRubyObject.asJavaString());
        IRubyObject iRubyObject2 = this.deleteClassVariable(string);
        if (iRubyObject2 != null) {
            return iRubyObject2;
        }
        if (this.fastIsClassVarDefined(string)) {
            throw this.cannotRemoveError(string);
        }
        throw this.getRuntime().newNameError("class variable " + string + " not defined for " + this.getName(), string);
    }

    public IRubyObject getConstantAt(String string) {
        IRubyObject iRubyObject = this.fetchConstant(string);
        if (iRubyObject != this.getRuntime().getUndef()) {
            return iRubyObject;
        }
        this.deleteConstant(string);
        return this.getRuntime().getLoadService().autoload(this.getName() + "::" + string);
    }

    public IRubyObject fastGetConstantAt(String string) {
        assert (string == string.intern()) : string + " is not interned";
        IRubyObject iRubyObject = this.fastFetchConstant(string);
        if (iRubyObject != this.getRuntime().getUndef()) {
            return iRubyObject;
        }
        this.deleteConstant(string);
        return this.getRuntime().getLoadService().autoload(this.getName() + "::" + string);
    }

    public IRubyObject getConstant(String string) {
        assert (IdUtil.isConstant(string));
        IRubyObject iRubyObject = this.getRuntime().getUndef();
        boolean bl = false;
        RubyModule rubyModule = this;
        while (true) {
            if (rubyModule != null) {
                IRubyObject iRubyObject2 = rubyModule.constantTableFetch(string);
                if (iRubyObject2 != null) {
                    if (iRubyObject2 != iRubyObject) {
                        return iRubyObject2;
                    }
                    rubyModule.deleteConstant(string);
                    if (this.getRuntime().getLoadService().autoload(rubyModule.getName() + "::" + string) != null) continue;
                } else {
                    rubyModule = rubyModule.getSuperClass();
                    continue;
                }
            }
            if (bl || this.isClass()) break;
            bl = true;
            rubyModule = this.getRuntime().getObject();
        }
        return this.callMethod(this.getRuntime().getCurrentContext(), "const_missing", this.getRuntime().newSymbol(string));
    }

    public IRubyObject fastGetConstant(String string) {
        assert (string == string.intern()) : string + " is not interned";
        assert (IdUtil.isConstant(string));
        IRubyObject iRubyObject = this.getRuntime().getUndef();
        boolean bl = false;
        RubyModule rubyModule = this;
        while (true) {
            if (rubyModule != null) {
                IRubyObject iRubyObject2 = rubyModule.constantTableFastFetch(string);
                if (iRubyObject2 != null) {
                    if (iRubyObject2 != iRubyObject) {
                        return iRubyObject2;
                    }
                    rubyModule.deleteConstant(string);
                    if (this.getRuntime().getLoadService().autoload(rubyModule.getName() + "::" + string) != null) continue;
                } else {
                    rubyModule = rubyModule.getSuperClass();
                    continue;
                }
            }
            if (bl || this.isClass()) break;
            bl = true;
            rubyModule = this.getRuntime().getObject();
        }
        return this.callMethod(this.getRuntime().getCurrentContext(), "const_missing", this.getRuntime().fastNewSymbol(string));
    }

    public IRubyObject getConstantFrom(String string) {
        return this.fastGetConstantFrom(string.intern());
    }

    public IRubyObject fastGetConstantFrom(String string) {
        assert (string == string.intern()) : string + " is not interned";
        assert (IdUtil.isConstant(string));
        RubyClass rubyClass = this.getRuntime().getObject();
        IRubyObject iRubyObject = this.getRuntime().getUndef();
        RubyModule rubyModule = this;
        while (rubyModule != null) {
            IRubyObject iRubyObject2 = rubyModule.constantTableFastFetch(string);
            if (iRubyObject2 != null) {
                if (iRubyObject2 != iRubyObject) {
                    if (rubyModule == rubyClass && this != rubyClass) {
                        String string2 = this.getName() + "::" + string;
                        this.getRuntime().getWarnings().warn(IRubyWarnings.ID.CONSTANT_BAD_REFERENCE, "toplevel constant " + string + " referenced by " + string2, string2);
                    }
                    return iRubyObject2;
                }
                rubyModule.deleteConstant(string);
                if (this.getRuntime().getLoadService().autoload(rubyModule.getName() + "::" + string) != null) continue;
                break;
            }
            rubyModule = rubyModule.getSuperClass();
        }
        return this.callMethod(this.getRuntime().getCurrentContext(), "const_missing", this.getRuntime().fastNewSymbol(string));
    }

    public IRubyObject setConstant(String string, IRubyObject iRubyObject) {
        RubyModule rubyModule;
        IRubyObject iRubyObject2 = this.fetchConstant(string);
        if (iRubyObject2 != null) {
            if (iRubyObject2 == this.getRuntime().getUndef()) {
                this.getRuntime().getLoadService().removeAutoLoadFor(this.getName() + "::" + string);
            } else {
                this.getRuntime().getWarnings().warn(IRubyWarnings.ID.CONSTANT_ALREADY_INITIALIZED, "already initialized constant " + string, string);
            }
        }
        this.storeConstant(string, iRubyObject);
        if (iRubyObject instanceof RubyModule && (rubyModule = (RubyModule)iRubyObject).getBaseName() == null) {
            rubyModule.setBaseName(string);
            rubyModule.setParent(this);
        }
        return iRubyObject;
    }

    public IRubyObject fastSetConstant(String string, IRubyObject iRubyObject) {
        RubyModule rubyModule;
        assert (string == string.intern()) : string + " is not interned";
        IRubyObject iRubyObject2 = this.fastFetchConstant(string);
        if (iRubyObject2 != null) {
            if (iRubyObject2 == this.getRuntime().getUndef()) {
                this.getRuntime().getLoadService().removeAutoLoadFor(this.getName() + "::" + string);
            } else {
                this.getRuntime().getWarnings().warn(IRubyWarnings.ID.CONSTANT_ALREADY_INITIALIZED, "already initialized constant " + string, string);
            }
        }
        this.fastStoreConstant(string, iRubyObject);
        if (iRubyObject instanceof RubyModule && (rubyModule = (RubyModule)iRubyObject).getBaseName() == null) {
            rubyModule.setBaseName(string);
            rubyModule.setParent(this);
        }
        return iRubyObject;
    }

    public void defineConstant(String string, IRubyObject iRubyObject) {
        assert (iRubyObject != null);
        if (this == this.getRuntime().getClassClass()) {
            this.getRuntime().secure(4);
        }
        if (!IdUtil.isValidConstantName(string)) {
            throw this.getRuntime().newNameError("bad constant name " + string, string);
        }
        this.setConstant(string, iRubyObject);
    }

    public boolean isConstantDefined(String string) {
        assert (IdUtil.isConstant(string));
        boolean bl = this == this.getRuntime().getObject();
        IRubyObject iRubyObject = this.getRuntime().getUndef();
        RubyModule rubyModule = this;
        do {
            IRubyObject iRubyObject2;
            if ((iRubyObject2 = rubyModule.constantTableFetch(string)) == null) continue;
            if (iRubyObject2 != iRubyObject) {
                return true;
            }
            return this.getRuntime().getLoadService().autoloadFor(rubyModule.getName() + "::" + string) != null;
        } while (bl && (rubyModule = rubyModule.getSuperClass()) != null);
        return false;
    }

    public boolean fastIsConstantDefined(String string) {
        assert (string == string.intern()) : string + " is not interned";
        assert (IdUtil.isConstant(string));
        boolean bl = this == this.getRuntime().getObject();
        IRubyObject iRubyObject = this.getRuntime().getUndef();
        RubyModule rubyModule = this;
        do {
            IRubyObject iRubyObject2;
            if ((iRubyObject2 = rubyModule.constantTableFastFetch(string)) == null) continue;
            if (iRubyObject2 != iRubyObject) {
                return true;
            }
            return this.getRuntime().getLoadService().autoloadFor(rubyModule.getName() + "::" + string) != null;
        } while (bl && (rubyModule = rubyModule.getSuperClass()) != null);
        return false;
    }

    private RaiseException cannotRemoveError(String string) {
        return this.getRuntime().newNameError("cannot remove " + string + " for " + this.getName(), string);
    }

    public boolean hasInternalModuleVariable(String string) {
        RubyModule rubyModule = this;
        do {
            if (!rubyModule.hasInternalVariable(string)) continue;
            return true;
        } while ((rubyModule = rubyModule.getSuperClass()) != null);
        return false;
    }

    public IRubyObject searchInternalModuleVariable(String string) {
        RubyModule rubyModule = this;
        do {
            IRubyObject iRubyObject;
            if ((iRubyObject = rubyModule.getInternalVariable(string)) == null) continue;
            return iRubyObject;
        } while ((rubyModule = rubyModule.getSuperClass()) != null);
        return null;
    }

    public void setInternalModuleVariable(String string, IRubyObject iRubyObject) {
        RubyModule rubyModule = this;
        do {
            if (!rubyModule.hasInternalVariable(string)) continue;
            rubyModule.setInternalVariable(string, iRubyObject);
            return;
        } while ((rubyModule = rubyModule.getSuperClass()) != null);
        this.setInternalVariable(string, iRubyObject);
    }

    public boolean hasClassVariable(String string) {
        assert (IdUtil.isClassVariable(string));
        return this.variableTableContains(string);
    }

    public boolean fastHasClassVariable(String string) {
        assert (IdUtil.isClassVariable(string));
        return this.variableTableFastContains(string);
    }

    public IRubyObject fetchClassVariable(String string) {
        assert (IdUtil.isClassVariable(string));
        return this.variableTableFetch(string);
    }

    public IRubyObject fastFetchClassVariable(String string) {
        assert (IdUtil.isClassVariable(string));
        return this.variableTableFastFetch(string);
    }

    public IRubyObject storeClassVariable(String string, IRubyObject iRubyObject) {
        assert (IdUtil.isClassVariable(string) && iRubyObject != null);
        this.ensureClassVariablesSettable();
        return this.variableTableStore(string, iRubyObject);
    }

    public IRubyObject fastStoreClassVariable(String string, IRubyObject iRubyObject) {
        assert (IdUtil.isClassVariable(string) && iRubyObject != null);
        this.ensureClassVariablesSettable();
        return this.variableTableFastStore(string, iRubyObject);
    }

    public IRubyObject deleteClassVariable(String string) {
        assert (IdUtil.isClassVariable(string));
        this.ensureClassVariablesSettable();
        return this.variableTableRemove(string);
    }

    public List<Variable<IRubyObject>> getClassVariableList() {
        ArrayList<Variable<IRubyObject>> arrayList = new ArrayList<Variable<IRubyObject>>();
        RubyObject.VariableTableEntry[] variableTableEntryArray = this.variableTableGetTable();
        int n = variableTableEntryArray.length;
        while (--n >= 0) {
            RubyObject.VariableTableEntry variableTableEntry = variableTableEntryArray[n];
            while (variableTableEntry != null) {
                if (IdUtil.isClassVariable(variableTableEntry.name)) {
                    IRubyObject iRubyObject = variableTableEntry.value;
                    if (iRubyObject == null) {
                        iRubyObject = this.variableTableReadLocked(variableTableEntry);
                    }
                    arrayList.add(new VariableEntry<IRubyObject>(variableTableEntry.name, iRubyObject));
                }
                variableTableEntry = variableTableEntry.next;
            }
        }
        return arrayList;
    }

    public List<String> getClassVariableNameList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        RubyObject.VariableTableEntry[] variableTableEntryArray = this.variableTableGetTable();
        int n = variableTableEntryArray.length;
        while (--n >= 0) {
            RubyObject.VariableTableEntry variableTableEntry = variableTableEntryArray[n];
            while (variableTableEntry != null) {
                if (IdUtil.isClassVariable(variableTableEntry.name)) {
                    arrayList.add(variableTableEntry.name);
                }
                variableTableEntry = variableTableEntry.next;
            }
        }
        return arrayList;
    }

    protected final String validateClassVariable(String string) {
        if (IdUtil.isValidClassVariableName(string)) {
            return string;
        }
        throw this.getRuntime().newNameError("`" + string + "' is not allowed as a class variable name", string);
    }

    protected final void ensureClassVariablesSettable() {
        if (!this.isFrozen() && (this.getRuntime().getSafeLevel() < 4 || this.isTaint())) {
            return;
        }
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw this.getRuntime().newSecurityError(ERR_INSECURE_SET_CONSTANT);
        }
        if (this.isFrozen()) {
            if (this instanceof RubyModule) {
                throw this.getRuntime().newFrozenError("class/module ");
            }
            throw this.getRuntime().newFrozenError("");
        }
    }

    public boolean hasConstant(String string) {
        assert (IdUtil.isConstant(string));
        return this.constantTableContains(string);
    }

    public boolean fastHasConstant(String string) {
        assert (IdUtil.isConstant(string));
        return this.constantTableFastContains(string);
    }

    public IRubyObject fetchConstant(String string) {
        assert (IdUtil.isConstant(string));
        return this.constantTableFetch(string);
    }

    public IRubyObject fastFetchConstant(String string) {
        assert (IdUtil.isConstant(string));
        return this.constantTableFastFetch(string);
    }

    public IRubyObject storeConstant(String string, IRubyObject iRubyObject) {
        assert (IdUtil.isConstant(string) && iRubyObject != null);
        this.ensureConstantsSettable();
        return this.constantTableStore(string, iRubyObject);
    }

    public IRubyObject fastStoreConstant(String string, IRubyObject iRubyObject) {
        assert (IdUtil.isConstant(string) && iRubyObject != null);
        this.ensureConstantsSettable();
        return this.constantTableFastStore(string, iRubyObject);
    }

    public IRubyObject deleteConstant(String string) {
        assert (IdUtil.isConstant(string));
        this.ensureConstantsSettable();
        return this.constantTableRemove(string);
    }

    public List<Variable<IRubyObject>> getStoredConstantList() {
        ArrayList<Variable<IRubyObject>> arrayList = new ArrayList<Variable<IRubyObject>>();
        ConstantTableEntry[] constantTableEntryArray = this.constantTableGetTable();
        int n = constantTableEntryArray.length;
        while (--n >= 0) {
            ConstantTableEntry constantTableEntry = constantTableEntryArray[n];
            while (constantTableEntry != null) {
                arrayList.add(constantTableEntry);
                constantTableEntry = constantTableEntry.next;
            }
        }
        return arrayList;
    }

    public List<String> getStoredConstantNameList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ConstantTableEntry[] constantTableEntryArray = this.constantTableGetTable();
        int n = constantTableEntryArray.length;
        while (--n >= 0) {
            ConstantTableEntry constantTableEntry = constantTableEntryArray[n];
            while (constantTableEntry != null) {
                arrayList.add(constantTableEntry.name);
                constantTableEntry = constantTableEntry.next;
            }
        }
        return arrayList;
    }

    protected final String validateConstant(String string) {
        if (IdUtil.isValidConstantName(string)) {
            return string;
        }
        throw this.getRuntime().newNameError("wrong constant name " + string, string);
    }

    protected final void ensureConstantsSettable() {
        if (!this.isFrozen() && (this.getRuntime().getSafeLevel() < 4 || this.isTaint())) {
            return;
        }
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw this.getRuntime().newSecurityError(ERR_INSECURE_SET_CONSTANT);
        }
        if (this.isFrozen()) {
            if (this instanceof RubyModule) {
                throw this.getRuntime().newFrozenError("class/module ");
            }
            throw this.getRuntime().newFrozenError("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IRubyObject variableTableStore(String string, IRubyObject iRubyObject) {
        int n = string.hashCode();
        ReentrantLock reentrantLock = this.variableWriteLock;
        reentrantLock.lock();
        try {
            RubyObject.VariableTableEntry[] variableTableEntryArray = this.variableTable;
            if (this.variableTable == null) {
                RubyObject.VariableTableEntry variableTableEntry;
                variableTableEntryArray = new RubyObject.VariableTableEntry[8];
                variableTableEntryArray[n & 7] = variableTableEntry = new RubyObject.VariableTableEntry(n, string.intern(), iRubyObject, null);
                this.variableTableThreshold = 6;
                this.variableTableSize = 1;
                this.variableTable = variableTableEntryArray;
                IRubyObject iRubyObject2 = iRubyObject;
                return iRubyObject2;
            }
            int n2 = this.variableTableSize + 1;
            if (n2 > this.variableTableThreshold) {
                variableTableEntryArray = this.variableTableRehash();
            }
            int n3 = n & variableTableEntryArray.length - 1;
            RubyObject.VariableTableEntry variableTableEntry = variableTableEntryArray[n3];
            while (variableTableEntry != null) {
                if (n == variableTableEntry.hash && string.equals(variableTableEntry.name)) {
                    variableTableEntry.value = iRubyObject;
                    IRubyObject iRubyObject3 = iRubyObject;
                    return iRubyObject3;
                }
                variableTableEntry = variableTableEntry.next;
            }
            variableTableEntryArray[n3] = variableTableEntry = new RubyObject.VariableTableEntry(n, string.intern(), iRubyObject, variableTableEntryArray[n3]);
            this.variableTableSize = n2;
            this.variableTable = variableTableEntryArray;
        }
        finally {
            reentrantLock.unlock();
        }
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IRubyObject variableTableFastStore(String string, IRubyObject iRubyObject) {
        assert (string == string.intern()) : string + " not interned";
        int n = string.hashCode();
        ReentrantLock reentrantLock = this.variableWriteLock;
        reentrantLock.lock();
        try {
            RubyObject.VariableTableEntry[] variableTableEntryArray = this.variableTable;
            if (this.variableTable == null) {
                RubyObject.VariableTableEntry variableTableEntry;
                variableTableEntryArray = new RubyObject.VariableTableEntry[8];
                variableTableEntryArray[n & 7] = variableTableEntry = new RubyObject.VariableTableEntry(n, string, iRubyObject, null);
                this.variableTableThreshold = 6;
                this.variableTableSize = 1;
                this.variableTable = variableTableEntryArray;
                IRubyObject iRubyObject2 = iRubyObject;
                return iRubyObject2;
            }
            int n2 = this.variableTableSize + 1;
            if (n2 > this.variableTableThreshold) {
                variableTableEntryArray = this.variableTableRehash();
            }
            int n3 = n & variableTableEntryArray.length - 1;
            RubyObject.VariableTableEntry variableTableEntry = variableTableEntryArray[n3];
            while (variableTableEntry != null) {
                if (string == variableTableEntry.name) {
                    variableTableEntry.value = iRubyObject;
                    IRubyObject iRubyObject3 = iRubyObject;
                    return iRubyObject3;
                }
                variableTableEntry = variableTableEntry.next;
            }
            variableTableEntryArray[n3] = variableTableEntry = new RubyObject.VariableTableEntry(n, string, iRubyObject, variableTableEntryArray[n3]);
            this.variableTableSize = n2;
            this.variableTable = variableTableEntryArray;
        }
        finally {
            reentrantLock.unlock();
        }
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IRubyObject variableTableRemove(String string) {
        ReentrantLock reentrantLock = this.variableWriteLock;
        reentrantLock.lock();
        try {
            RubyObject.VariableTableEntry[] variableTableEntryArray = this.variableTable;
            if (this.variableTable != null) {
                RubyObject.VariableTableEntry variableTableEntry;
                int n = string.hashCode();
                int n2 = n & variableTableEntryArray.length - 1;
                RubyObject.VariableTableEntry variableTableEntry2 = variableTableEntry = variableTableEntryArray[n2];
                while (variableTableEntry2 != null) {
                    if (n == variableTableEntry2.hash && string.equals(variableTableEntry2.name)) {
                        IRubyObject iRubyObject = variableTableEntry2.value;
                        RubyObject.VariableTableEntry variableTableEntry3 = variableTableEntry2.next;
                        Object object = variableTableEntry;
                        while (object != variableTableEntry2) {
                            variableTableEntry3 = new RubyObject.VariableTableEntry(((RubyObject.VariableTableEntry)object).hash, ((RubyObject.VariableTableEntry)object).name, ((RubyObject.VariableTableEntry)object).value, variableTableEntry3);
                            object = ((RubyObject.VariableTableEntry)object).next;
                        }
                        variableTableEntryArray[n2] = variableTableEntry3;
                        --this.variableTableSize;
                        this.variableTable = variableTableEntryArray;
                        object = iRubyObject;
                        return object;
                    }
                    variableTableEntry2 = variableTableEntry2.next;
                }
            }
        }
        finally {
            reentrantLock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IRubyObject variableTableReadLocked(RubyObject.VariableTableEntry variableTableEntry) {
        ReentrantLock reentrantLock = this.variableWriteLock;
        reentrantLock.lock();
        try {
            IRubyObject iRubyObject = variableTableEntry.value;
            return iRubyObject;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void variableTableSync(List<Variable<IRubyObject>> list) {
        ReentrantLock reentrantLock = this.variableWriteLock;
        reentrantLock.lock();
        try {
            this.variableTableSize = 0;
            this.variableTableThreshold = 6;
            this.variableTable = new RubyObject.VariableTableEntry[8];
            for (Variable<IRubyObject> variable : list) {
                assert (!variable.isConstant() && variable.getValue() != null);
                this.variableTableStore(variable.getName(), variable.getValue());
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void syncVariables(List<Variable<IRubyObject>> list) {
        ArrayList<Variable<IRubyObject>> arrayList = new ArrayList<Variable<IRubyObject>>(list.size());
        Object object = list.iterator();
        while (object.hasNext()) {
            Variable<IRubyObject> variable = object.next();
            if (!variable.isConstant()) continue;
            arrayList.add(variable);
            object.remove();
        }
        object = this.variableWriteLock;
        ((ReentrantLock)object).lock();
        try {
            this.variableTableSync(list);
            this.constantTableSync(arrayList);
        }
        finally {
            ((ReentrantLock)object).unlock();
        }
    }

    @Override
    @Deprecated
    public Map getVariableMap() {
        Map map = this.variableTableGetMap();
        this.constantTableGetMap(map);
        return map;
    }

    @Override
    public boolean hasVariables() {
        return this.variableTableGetSize() > 0 || this.constantTableGetSize() > 0;
    }

    @Override
    public int getVariableCount() {
        return this.variableTableGetSize() + this.constantTableGetSize();
    }

    @Override
    public List<Variable<IRubyObject>> getVariableList() {
        Object object;
        RubyObject.VariableTableEntry[] variableTableEntryArray = this.variableTableGetTable();
        ConstantTableEntry[] constantTableEntryArray = this.constantTableGetTable();
        ArrayList<Variable<IRubyObject>> arrayList = new ArrayList<Variable<IRubyObject>>();
        int n = variableTableEntryArray.length;
        while (--n >= 0) {
            object = variableTableEntryArray[n];
            while (object != null) {
                IRubyObject iRubyObject = ((RubyObject.VariableTableEntry)object).value;
                if (iRubyObject == null) {
                    iRubyObject = this.variableTableReadLocked((RubyObject.VariableTableEntry)object);
                }
                arrayList.add(new VariableEntry<IRubyObject>(((RubyObject.VariableTableEntry)object).name, iRubyObject));
                object = ((RubyObject.VariableTableEntry)object).next;
            }
        }
        n = constantTableEntryArray.length;
        while (--n >= 0) {
            object = constantTableEntryArray[n];
            while (object != null) {
                arrayList.add((Variable<IRubyObject>)object);
                object = ((ConstantTableEntry)object).next;
            }
        }
        return arrayList;
    }

    @Override
    public List<String> getVariableNameList() {
        Object object;
        RubyObject.VariableTableEntry[] variableTableEntryArray = this.variableTableGetTable();
        ConstantTableEntry[] constantTableEntryArray = this.constantTableGetTable();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = variableTableEntryArray.length;
        while (--n >= 0) {
            object = variableTableEntryArray[n];
            while (object != null) {
                arrayList.add(((RubyObject.VariableTableEntry)object).name);
                object = ((RubyObject.VariableTableEntry)object).next;
            }
        }
        n = constantTableEntryArray.length;
        while (--n >= 0) {
            object = constantTableEntryArray[n];
            while (object != null) {
                arrayList.add(((ConstantTableEntry)object).name);
                object = ((ConstantTableEntry)object).next;
            }
        }
        return arrayList;
    }

    protected boolean constantTableContains(String string) {
        int n = string.hashCode();
        ConstantTableEntry[] constantTableEntryArray = this.constantTable;
        ConstantTableEntry constantTableEntry = this.constantTable[n & constantTableEntryArray.length - 1];
        while (constantTableEntry != null) {
            if (n == constantTableEntry.hash && string.equals(constantTableEntry.name)) {
                return true;
            }
            constantTableEntry = constantTableEntry.next;
        }
        return false;
    }

    protected boolean constantTableFastContains(String string) {
        ConstantTableEntry[] constantTableEntryArray = this.constantTable;
        ConstantTableEntry constantTableEntry = this.constantTable[string.hashCode() & constantTableEntryArray.length - 1];
        while (constantTableEntry != null) {
            if (string == constantTableEntry.name) {
                return true;
            }
            constantTableEntry = constantTableEntry.next;
        }
        return false;
    }

    protected IRubyObject constantTableFetch(String string) {
        int n = string.hashCode();
        ConstantTableEntry[] constantTableEntryArray = this.constantTable;
        ConstantTableEntry constantTableEntry = this.constantTable[n & constantTableEntryArray.length - 1];
        while (constantTableEntry != null) {
            if (n == constantTableEntry.hash && string.equals(constantTableEntry.name)) {
                return constantTableEntry.value;
            }
            constantTableEntry = constantTableEntry.next;
        }
        return null;
    }

    protected IRubyObject constantTableFastFetch(String string) {
        ConstantTableEntry[] constantTableEntryArray = this.constantTable;
        ConstantTableEntry constantTableEntry = this.constantTable[string.hashCode() & constantTableEntryArray.length - 1];
        while (constantTableEntry != null) {
            if (string == constantTableEntry.name) {
                return constantTableEntry.value;
            }
            constantTableEntry = constantTableEntry.next;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRubyObject constantTableStore(String string, IRubyObject iRubyObject) {
        int n = string.hashCode();
        ReentrantLock reentrantLock = this.variableWriteLock;
        reentrantLock.lock();
        try {
            ConstantTableEntry constantTableEntry;
            int n2 = this.constantTableSize + 1;
            ConstantTableEntry[] constantTableEntryArray = n2 > this.constantTableThreshold ? this.constantTableRehash() : this.constantTable;
            int n3 = n & constantTableEntryArray.length - 1;
            ConstantTableEntry constantTableEntry2 = constantTableEntry = constantTableEntryArray[n3];
            while (constantTableEntry2 != null) {
                if (n == constantTableEntry2.hash && string.equals(constantTableEntry2.name)) {
                    if (iRubyObject == constantTableEntry2.value) {
                        IRubyObject iRubyObject2 = iRubyObject;
                        return iRubyObject2;
                    }
                    ConstantTableEntry constantTableEntry3 = new ConstantTableEntry(constantTableEntry2.hash, constantTableEntry2.name, iRubyObject, constantTableEntry2.next);
                    Object object = constantTableEntry;
                    while (object != constantTableEntry2) {
                        constantTableEntry3 = new ConstantTableEntry(((ConstantTableEntry)object).hash, ((ConstantTableEntry)object).name, ((ConstantTableEntry)object).value, constantTableEntry3);
                        object = ((ConstantTableEntry)object).next;
                    }
                    constantTableEntryArray[n3] = constantTableEntry3;
                    this.constantTable = constantTableEntryArray;
                    object = iRubyObject;
                    return object;
                }
                constantTableEntry2 = constantTableEntry2.next;
            }
            constantTableEntryArray[n3] = new ConstantTableEntry(n, string.intern(), iRubyObject, constantTableEntryArray[n3]);
            this.constantTableSize = n2;
            this.constantTable = constantTableEntryArray;
        }
        finally {
            reentrantLock.unlock();
        }
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRubyObject constantTableFastStore(String string, IRubyObject iRubyObject) {
        assert (string == string.intern()) : string + " not interned";
        int n = string.hashCode();
        ReentrantLock reentrantLock = this.variableWriteLock;
        reentrantLock.lock();
        try {
            ConstantTableEntry constantTableEntry;
            int n2 = this.constantTableSize + 1;
            ConstantTableEntry[] constantTableEntryArray = n2 > this.constantTableThreshold ? this.constantTableRehash() : this.constantTable;
            int n3 = n & constantTableEntryArray.length - 1;
            ConstantTableEntry constantTableEntry2 = constantTableEntry = constantTableEntryArray[n3];
            while (constantTableEntry2 != null) {
                if (string == constantTableEntry2.name) {
                    if (iRubyObject == constantTableEntry2.value) {
                        IRubyObject iRubyObject2 = iRubyObject;
                        return iRubyObject2;
                    }
                    ConstantTableEntry constantTableEntry3 = new ConstantTableEntry(constantTableEntry2.hash, constantTableEntry2.name, iRubyObject, constantTableEntry2.next);
                    Object object = constantTableEntry;
                    while (object != constantTableEntry2) {
                        constantTableEntry3 = new ConstantTableEntry(((ConstantTableEntry)object).hash, ((ConstantTableEntry)object).name, ((ConstantTableEntry)object).value, constantTableEntry3);
                        object = ((ConstantTableEntry)object).next;
                    }
                    constantTableEntryArray[n3] = constantTableEntry3;
                    this.constantTable = constantTableEntryArray;
                    object = iRubyObject;
                    return object;
                }
                constantTableEntry2 = constantTableEntry2.next;
            }
            constantTableEntryArray[n3] = new ConstantTableEntry(n, string, iRubyObject, constantTableEntryArray[n3]);
            this.constantTableSize = n2;
            this.constantTable = constantTableEntryArray;
        }
        finally {
            reentrantLock.unlock();
        }
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRubyObject constantTableRemove(String string) {
        ReentrantLock reentrantLock = this.variableWriteLock;
        reentrantLock.lock();
        try {
            ConstantTableEntry[] constantTableEntryArray = this.constantTable;
            if (this.constantTable != null) {
                ConstantTableEntry constantTableEntry;
                int n = string.hashCode();
                int n2 = n & constantTableEntryArray.length - 1;
                ConstantTableEntry constantTableEntry2 = constantTableEntry = constantTableEntryArray[n2];
                while (constantTableEntry2 != null) {
                    if (n == constantTableEntry2.hash && string.equals(constantTableEntry2.name)) {
                        IRubyObject iRubyObject = constantTableEntry2.value;
                        ConstantTableEntry constantTableEntry3 = constantTableEntry2.next;
                        Object object = constantTableEntry;
                        while (object != constantTableEntry2) {
                            constantTableEntry3 = new ConstantTableEntry(((ConstantTableEntry)object).hash, ((ConstantTableEntry)object).name, ((ConstantTableEntry)object).value, constantTableEntry3);
                            object = ((ConstantTableEntry)object).next;
                        }
                        constantTableEntryArray[n2] = constantTableEntry3;
                        --this.constantTableSize;
                        this.constantTable = constantTableEntryArray;
                        object = iRubyObject;
                        return object;
                    }
                    constantTableEntry2 = constantTableEntry2.next;
                }
            }
        }
        finally {
            reentrantLock.unlock();
        }
        return null;
    }

    protected ConstantTableEntry[] constantTableGetTable() {
        return this.constantTable;
    }

    protected int constantTableGetSize() {
        if (this.constantTable != null) {
            return this.constantTableSize;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void constantTableSync(List<Variable<IRubyObject>> list) {
        ReentrantLock reentrantLock = this.variableWriteLock;
        reentrantLock.lock();
        try {
            this.constantTableSize = 0;
            this.constantTableThreshold = 6;
            this.constantTable = new ConstantTableEntry[8];
            for (Variable<IRubyObject> variable : list) {
                assert (variable.isConstant() && variable.getValue() != null);
                this.constantTableStore(variable.getName(), variable.getValue());
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    private final ConstantTableEntry[] constantTableRehash() {
        ConstantTableEntry[] constantTableEntryArray = this.constantTable;
        int n = constantTableEntryArray.length;
        if (n >= 0x40000000) {
            return constantTableEntryArray;
        }
        int n2 = n << 1;
        ConstantTableEntry[] constantTableEntryArray2 = new ConstantTableEntry[n2];
        this.constantTableThreshold = (int)((float)n2 * 0.75f);
        int n3 = n2 - 1;
        int n4 = n;
        while (--n4 >= 0) {
            int n5;
            ConstantTableEntry constantTableEntry = constantTableEntryArray[n4];
            if (constantTableEntry == null) continue;
            ConstantTableEntry constantTableEntry2 = constantTableEntry.next;
            int n6 = constantTableEntry.hash & n3;
            if (constantTableEntry2 == null) {
                constantTableEntryArray2[n6] = constantTableEntry;
                continue;
            }
            ConstantTableEntry constantTableEntry3 = constantTableEntry;
            int n7 = n6;
            ConstantTableEntry constantTableEntry4 = constantTableEntry2;
            while (constantTableEntry4 != null) {
                n5 = constantTableEntry4.hash & n3;
                if (n5 != n7) {
                    n7 = n5;
                    constantTableEntry3 = constantTableEntry4;
                }
                constantTableEntry4 = constantTableEntry4.next;
            }
            constantTableEntryArray2[n7] = constantTableEntry3;
            constantTableEntry4 = constantTableEntry;
            while (constantTableEntry4 != constantTableEntry3) {
                ConstantTableEntry constantTableEntry5;
                n5 = constantTableEntry4.hash & n3;
                constantTableEntryArray2[n5] = constantTableEntry5 = new ConstantTableEntry(constantTableEntry4.hash, constantTableEntry4.name, constantTableEntry4.value, constantTableEntryArray2[n5]);
                constantTableEntry4 = constantTableEntry4.next;
            }
        }
        this.constantTable = constantTableEntryArray2;
        return constantTableEntryArray2;
    }

    protected Map constantTableGetMap() {
        HashMap<String, IRubyObject> hashMap = new HashMap<String, IRubyObject>();
        ConstantTableEntry[] constantTableEntryArray = this.constantTable;
        if (this.constantTable != null) {
            int n = constantTableEntryArray.length;
            while (--n >= 0) {
                ConstantTableEntry constantTableEntry = constantTableEntryArray[n];
                while (constantTableEntry != null) {
                    hashMap.put(constantTableEntry.name, constantTableEntry.value);
                    constantTableEntry = constantTableEntry.next;
                }
            }
        }
        return hashMap;
    }

    protected Map constantTableGetMap(Map map) {
        ConstantTableEntry[] constantTableEntryArray = this.constantTable;
        if (this.constantTable != null) {
            int n = constantTableEntryArray.length;
            while (--n >= 0) {
                ConstantTableEntry constantTableEntry = constantTableEntryArray[n];
                while (constantTableEntry != null) {
                    map.put(constantTableEntry.name, constantTableEntry.value);
                    constantTableEntry = constantTableEntry.next;
                }
            }
        }
        return map;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class ConstantTableEntry
    implements Variable<IRubyObject> {
        final int hash;
        final String name;
        final IRubyObject value;
        final ConstantTableEntry next;

        ConstantTableEntry(int n, String string, IRubyObject iRubyObject, ConstantTableEntry constantTableEntry) {
            this.hash = n;
            this.name = string;
            this.value = iRubyObject;
            this.next = constantTableEntry;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public IRubyObject getValue() {
            return this.value;
        }

        @Override
        public final boolean isClassVariable() {
            return false;
        }

        @Override
        public final boolean isConstant() {
            return true;
        }

        @Override
        public final boolean isInstanceVariable() {
            return false;
        }

        @Override
        public final boolean isRubyVariable() {
            return true;
        }
    }

    public static class KindOf {
        public static final KindOf DEFAULT_KIND_OF = new KindOf();

        public boolean isKindOf(IRubyObject iRubyObject, RubyModule rubyModule) {
            return iRubyObject.getMetaClass().hasModuleInHierarchy(rubyModule);
        }
    }
}

