/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArgsFile;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBinding;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFile;
import org.jruby.RubyFileTest;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyIO;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyProcess;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubySystemExit;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.JumpTarget;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.IAutoloadMethod;
import org.jruby.runtime.load.LoadService;
import org.jruby.util.IdUtil;
import org.jruby.util.ShellLauncher;
import org.jruby.util.Sprintf;
import org.jruby.util.TypeConverter;

public class RubyKernel {
    public static final Class<?> IRUBY_OBJECT = IRubyObject.class;

    public static RubyModule createKernelModule(Ruby ruby) {
        RubyModule rubyModule = ruby.defineModule("Kernel");
        ruby.setKernel(rubyModule);
        CallbackFactory callbackFactory = ruby.callbackFactory(RubyObject.class);
        rubyModule.defineAnnotatedMethods(RubyKernel.class);
        rubyModule.defineAnnotatedMethods(RubyObject.class);
        ruby.setRespondToMethod(rubyModule.searchMethod("respond_to?"));
        ruby.getObject().dispatcher = callbackFactory.createDispatcher(ruby.getObject());
        rubyModule.setFlag(2048, false);
        return rubyModule;
    }

    @JRubyMethod(name={"at_exit"}, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject at_exit(IRubyObject iRubyObject, Block block) {
        return iRubyObject.getRuntime().pushExitBlock(iRubyObject.getRuntime().newProc(Block.Type.PROC, block));
    }

    @JRubyMethod(name={"autoload?"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject autoload_p(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyModule rubyModule = iRubyObject instanceof RubyModule ? (RubyModule)iRubyObject : iRubyObject.getRuntime().getObject();
        String string = rubyModule.getName() + "::" + iRubyObject2.asJavaString();
        IAutoloadMethod iAutoloadMethod = iRubyObject.getRuntime().getLoadService().autoloadFor(string);
        if (iAutoloadMethod == null) {
            return iRubyObject.getRuntime().getNil();
        }
        return iRubyObject.getRuntime().newString(iAutoloadMethod.file());
    }

    @JRubyMethod(name={"autoload"}, required=2, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject autoload(IRubyObject iRubyObject, IRubyObject iRubyObject2, final IRubyObject iRubyObject3) {
        Ruby ruby = iRubyObject.getRuntime();
        final LoadService loadService = ruby.getLoadService();
        String string = iRubyObject2.asJavaString();
        if (!IdUtil.isValidConstantName(string)) {
            throw ruby.newNameError("autoload must be constant name", string);
        }
        RubyString rubyString = iRubyObject3.convertToString();
        if (rubyString.isEmpty()) {
            throw ruby.newArgumentError("empty file name");
        }
        final String string2 = iRubyObject2.asJavaString().intern();
        final RubyModule rubyModule = iRubyObject instanceof RubyModule ? (RubyModule)iRubyObject : ruby.getObject();
        String string3 = rubyModule.getName() + "::" + string2;
        IRubyObject iRubyObject4 = ruby.getUndef();
        IRubyObject iRubyObject5 = rubyModule.fastFetchConstant(string2);
        if (iRubyObject5 != null && iRubyObject5 != iRubyObject4) {
            return ruby.getNil();
        }
        rubyModule.fastStoreConstant(string2, iRubyObject4);
        loadService.addAutoload(string3, new IAutoloadMethod(){

            public String file() {
                return iRubyObject3.toString();
            }

            public IRubyObject load(Ruby ruby, String string) {
                boolean bl = loadService.require(this.file());
                if (!bl) {
                    return null;
                }
                return rubyModule.fastGetConstant(string2);
            }
        });
        return ruby.getNil();
    }

    @JRubyMethod(name={"method_missing"}, rest=true, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject method_missing(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        RubyClass rubyClass;
        Object object;
        Ruby ruby = iRubyObject.getRuntime();
        if (iRubyObjectArray.length == 0 || !(iRubyObjectArray[0] instanceof RubySymbol)) {
            throw ruby.newArgumentError("no id given");
        }
        String string = iRubyObjectArray[0].asJavaString();
        Visibility visibility = threadContext.getLastVisibility();
        CallType callType = threadContext.getLastCallType();
        String string2 = null;
        boolean bl = true;
        if (visibility == Visibility.PRIVATE) {
            string2 = "private method `%s' called for %s";
        } else if (visibility == Visibility.PROTECTED) {
            string2 = "protected method `%s' called for %s";
        } else if (callType == CallType.VARIABLE) {
            string2 = "undefined local variable or method `%s' for %s";
            bl = false;
        } else if (callType == CallType.SUPER) {
            string2 = "super: no superclass method `%s'";
        }
        if (string2 == null) {
            string2 = "undefined method `%s' for %s";
        }
        String string3 = null;
        if (iRubyObject.isNil()) {
            string3 = "nil";
        } else if (iRubyObject instanceof RubyBoolean && iRubyObject.isTrue()) {
            string3 = "true";
        } else if (iRubyObject instanceof RubyBoolean && !iRubyObject.isTrue()) {
            string3 = "false";
        } else if (string.equals("inspect") || string.equals("to_s")) {
            string3 = iRubyObject.anyToString().toString();
        } else {
            try {
                object = iRubyObject.callMethod(threadContext, "inspect");
                if (object.getMetaClass() == iRubyObject.getMetaClass() || object instanceof RubyString && ((RubyString)object).length().getLongValue() > 65L) {
                    object = iRubyObject.anyToString();
                }
            }
            catch (JumpException jumpException) {
                object = iRubyObject.anyToString();
            }
            string3 = object.toString();
        }
        if (string3.length() == 0 || string3.length() > 0 && string3.charAt(0) != '#') {
            string3 = string3 + ":" + iRubyObject.getMetaClass().getRealClass().getName();
        }
        object = new IRubyObject[bl ? 3 : 2];
        RubyArray rubyArray = ruby.newArray(iRubyObjectArray[0], ruby.newString(string3));
        RubyString rubyString = ruby.newString(((Object)Sprintf.sprintf(ruby.newString(string2), (IRubyObject)rubyArray)).toString());
        if (iRubyObject.isTaint()) {
            rubyString.setTaint(true);
        }
        object[0] = rubyString;
        object[1] = iRubyObjectArray[0];
        if (bl) {
            IRubyObject[] iRubyObjectArray2 = new IRubyObject[iRubyObjectArray.length - 1];
            System.arraycopy(iRubyObjectArray, 1, iRubyObjectArray2, 0, iRubyObjectArray2.length);
            object[2] = ruby.newArrayNoCopy(iRubyObjectArray2);
            rubyClass = ruby.fastGetClass("NoMethodError");
        } else {
            rubyClass = ruby.fastGetClass("NameError");
        }
        throw new RaiseException((RubyException)rubyClass.newInstance(threadContext, (IRubyObject[])object, Block.NULL_BLOCK));
    }

    @JRubyMethod(name={"open"}, required=1, optional=2, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject open(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        String string = iRubyObjectArray[0].convertToString().toString();
        Ruby ruby = iRubyObject.getRuntime();
        if (string.startsWith("|")) {
            String string2 = string.substring(1);
            return RubyIO.popen(threadContext, ruby.getIO(), new IRubyObject[]{ruby.newString(string2)}, block);
        }
        return RubyFile.open(threadContext, ruby.getFile(), iRubyObjectArray, block);
    }

    @JRubyMethod(name={"getc"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject getc(ThreadContext threadContext, IRubyObject iRubyObject) {
        iRubyObject.getRuntime().getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "getc is obsolete; use STDIN.getc instead", "getc", "STDIN.getc");
        IRubyObject iRubyObject2 = iRubyObject.getRuntime().getGlobalVariables().get("$stdin");
        return iRubyObject2.callMethod(threadContext, "getc");
    }

    @JRubyMethod(name={"gets"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject gets(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        return RubyArgsFile.gets(threadContext, iRubyObject.getRuntime().getGlobalVariables().get("$<"), iRubyObjectArray);
    }

    @JRubyMethod(name={"abort"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject abort(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        if (iRubyObjectArray.length == 1) {
            iRubyObject.getRuntime().getGlobalVariables().get("$stderr").callMethod(threadContext, "puts", iRubyObjectArray[0]);
        }
        throw new MainExitException(1, true);
    }

    @JRubyMethod(name={"Array"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_array(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        IRubyObject iRubyObject3 = iRubyObject2.checkArrayType();
        if (iRubyObject3.isNil()) {
            if (iRubyObject2.getMetaClass().searchMethod("to_a").getImplementationClass() != iRubyObject.getRuntime().getKernel()) {
                iRubyObject3 = iRubyObject2.callMethod(threadContext, MethodIndex.TO_A, "to_a");
                if (!(iRubyObject3 instanceof RubyArray)) {
                    throw iRubyObject.getRuntime().newTypeError("`to_a' did not return Array");
                }
                return iRubyObject3;
            }
            return iRubyObject.getRuntime().newArray(iRubyObject2);
        }
        return iRubyObject3;
    }

    @JRubyMethod(name={"Float"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_float(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (iRubyObject2 instanceof RubyFixnum) {
            return RubyFloat.newFloat(iRubyObject2.getRuntime(), ((RubyFixnum)iRubyObject2).getDoubleValue());
        }
        if (iRubyObject2 instanceof RubyFloat) {
            return iRubyObject2;
        }
        if (iRubyObject2 instanceof RubyBignum) {
            return RubyFloat.newFloat(iRubyObject2.getRuntime(), RubyBignum.big2dbl((RubyBignum)iRubyObject2));
        }
        if (iRubyObject2 instanceof RubyString) {
            if (((RubyString)iRubyObject2).getByteList().realSize == 0) {
                throw iRubyObject.getRuntime().newArgumentError("invalid value for Float(): " + iRubyObject2.inspect());
            }
            return RubyNumeric.str2fnum(iRubyObject.getRuntime(), (RubyString)iRubyObject2, true);
        }
        if (iRubyObject2.isNil()) {
            throw iRubyObject.getRuntime().newTypeError("can't convert nil into Float");
        }
        RubyFloat rubyFloat = (RubyFloat)TypeConverter.convertToType(iRubyObject2, iRubyObject.getRuntime().getFloat(), MethodIndex.TO_F, "to_f");
        if (Double.isNaN(rubyFloat.getDoubleValue())) {
            throw iRubyObject.getRuntime().newArgumentError("invalid value for Float()");
        }
        return rubyFloat;
    }

    @JRubyMethod(name={"Integer"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_integer(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        IRubyObject iRubyObject3;
        if (iRubyObject2 instanceof RubyFloat) {
            double d = ((RubyFloat)iRubyObject2).getDoubleValue();
            if (d > 9.223372036854776E18 && d < -9.223372036854776E18) {
                return RubyNumeric.dbl2num(iRubyObject.getRuntime(), ((RubyFloat)iRubyObject2).getDoubleValue());
            }
        } else {
            if (iRubyObject2 instanceof RubyFixnum || iRubyObject2 instanceof RubyBignum) {
                return iRubyObject2;
            }
            if (iRubyObject2 instanceof RubyString) {
                return RubyNumeric.str2inum(iRubyObject.getRuntime(), (RubyString)iRubyObject2, 0, true);
            }
        }
        if ((iRubyObject3 = TypeConverter.convertToType(iRubyObject2, iRubyObject.getRuntime().getInteger(), MethodIndex.TO_INT, "to_int", false)).isNil()) {
            return iRubyObject2.convertToInteger(MethodIndex.TO_I, "to_i");
        }
        return iRubyObject3;
    }

    @JRubyMethod(name={"String"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_string(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return TypeConverter.convertToType(iRubyObject2, iRubyObject.getRuntime().getString(), MethodIndex.TO_S, "to_s");
    }

    @JRubyMethod(name={"p"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject p(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        Ruby ruby = iRubyObject.getRuntime();
        IRubyObject iRubyObject2 = ruby.getGlobalVariables().get("$>");
        for (int i = 0; i < iRubyObjectArray.length; ++i) {
            if (iRubyObjectArray[i] == null) continue;
            iRubyObject2.callMethod(threadContext, "write", iRubyObjectArray[i].callMethod(threadContext, "inspect"));
            iRubyObject2.callMethod(threadContext, "write", ruby.newString("\n"));
        }
        if (iRubyObject2 instanceof RubyFile) {
            ((RubyFile)iRubyObject2).flush();
        }
        return iRubyObject.getRuntime().getNil();
    }

    @JRubyMethod(name={"putc"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject putc(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        IRubyObject iRubyObject3 = iRubyObject.getRuntime().getGlobalVariables().get("$>");
        return iRubyObject3.callMethod(threadContext, "putc", iRubyObject2);
    }

    @JRubyMethod(name={"puts"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject puts(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject2 = iRubyObject.getRuntime().getGlobalVariables().get("$>");
        iRubyObject2.callMethod(threadContext, "puts", iRubyObjectArray);
        return iRubyObject.getRuntime().getNil();
    }

    @JRubyMethod(name={"print"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject print(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject2 = iRubyObject.getRuntime().getGlobalVariables().get("$>");
        iRubyObject2.callMethod(threadContext, "print", iRubyObjectArray);
        return iRubyObject.getRuntime().getNil();
    }

    @JRubyMethod(name={"printf"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject printf(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        if (iRubyObjectArray.length != 0) {
            IRubyObject iRubyObject2 = iRubyObject.getRuntime().getGlobalVariables().get("$>");
            if (!(iRubyObjectArray[0] instanceof RubyString)) {
                iRubyObject2 = iRubyObjectArray[0];
                iRubyObjectArray = ArgsUtil.popArray(iRubyObjectArray);
            }
            iRubyObject2.callMethod(threadContext, "write", RubyKernel.sprintf(iRubyObject, iRubyObjectArray));
        }
        return iRubyObject.getRuntime().getNil();
    }

    @JRubyMethod(name={"readline"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject readline(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject2 = RubyKernel.gets(threadContext, iRubyObject, iRubyObjectArray);
        if (iRubyObject2.isNil()) {
            throw iRubyObject.getRuntime().newEOFError();
        }
        return iRubyObject2;
    }

    @JRubyMethod(name={"readlines"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyArray readlines(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        return RubyArgsFile.readlines(threadContext, iRubyObject.getRuntime().getGlobalVariables().get("$<"), iRubyObjectArray);
    }

    private static RubyString getLastlineString(ThreadContext threadContext, Ruby ruby) {
        IRubyObject iRubyObject = threadContext.getPreviousFrame().getLastLine();
        if (iRubyObject.isNil()) {
            throw ruby.newTypeError("$_ value need to be String (nil given).");
        }
        if (!(iRubyObject instanceof RubyString)) {
            throw ruby.newTypeError("$_ value need to be String (" + iRubyObject.getMetaClass().getName() + " given).");
        }
        return (RubyString)iRubyObject;
    }

    @JRubyMethod(name={"sub!"}, required=1, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject sub_bang(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        return RubyKernel.getLastlineString(threadContext, iRubyObject.getRuntime()).sub_bang(threadContext, iRubyObjectArray, block);
    }

    @JRubyMethod(name={"sub"}, required=1, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject sub(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        RubyString rubyString = (RubyString)RubyKernel.getLastlineString(threadContext, iRubyObject.getRuntime()).dup();
        if (!rubyString.sub_bang(threadContext, iRubyObjectArray, block).isNil()) {
            threadContext.getPreviousFrame().setLastLine(rubyString);
        }
        return rubyString;
    }

    @JRubyMethod(name={"gsub!"}, required=1, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject gsub_bang(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        return RubyKernel.getLastlineString(threadContext, iRubyObject.getRuntime()).gsub_bang(threadContext, iRubyObjectArray, block);
    }

    @JRubyMethod(name={"gsub"}, required=1, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject gsub(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        RubyString rubyString = (RubyString)RubyKernel.getLastlineString(threadContext, iRubyObject.getRuntime()).dup();
        if (!rubyString.gsub_bang(threadContext, iRubyObjectArray, block).isNil()) {
            threadContext.getPreviousFrame().setLastLine(rubyString);
        }
        return rubyString;
    }

    @JRubyMethod(name={"chop!"}, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject chop_bang(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        return RubyKernel.getLastlineString(threadContext, iRubyObject.getRuntime()).chop_bang();
    }

    @JRubyMethod(name={"chop"}, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject chop(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        RubyString rubyString = RubyKernel.getLastlineString(threadContext, iRubyObject.getRuntime());
        if (rubyString.getByteList().realSize > 0) {
            rubyString = (RubyString)rubyString.dup();
            rubyString.chop_bang();
            threadContext.getPreviousFrame().setLastLine(rubyString);
        }
        return rubyString;
    }

    @JRubyMethod(name={"chomp!"}, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject chomp_bang(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        return RubyKernel.getLastlineString(threadContext, iRubyObject.getRuntime()).chomp_bang(iRubyObjectArray);
    }

    @JRubyMethod(name={"chomp"}, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject chomp(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        RubyString rubyString = RubyKernel.getLastlineString(threadContext, iRubyObject.getRuntime());
        RubyString rubyString2 = (RubyString)rubyString.dup();
        if (rubyString2.chomp_bang(iRubyObjectArray).isNil()) {
            return rubyString;
        }
        threadContext.getPreviousFrame().setLastLine(rubyString2);
        return rubyString2;
    }

    @JRubyMethod(name={"split"}, optional=2, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject split(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        return RubyKernel.getLastlineString(threadContext, iRubyObject.getRuntime()).split(threadContext, iRubyObjectArray);
    }

    @JRubyMethod(name={"scan"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject scan(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        return RubyKernel.getLastlineString(threadContext, iRubyObject.getRuntime()).scan(threadContext, iRubyObject2, block);
    }

    @JRubyMethod(name={"select"}, required=1, optional=3, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject select(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        return RubyIO.select_static(threadContext, iRubyObject.getRuntime(), iRubyObjectArray);
    }

    @JRubyMethod(name={"sleep"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject sleep(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        long l;
        long l2;
        if (iRubyObjectArray.length == 0) {
            l2 = 0L;
        } else {
            if (!(iRubyObjectArray[0] instanceof RubyNumeric)) {
                throw iRubyObject.getRuntime().newTypeError("can't convert " + iRubyObjectArray[0].getMetaClass().getName() + "into time interval");
            }
            l2 = (long)(iRubyObjectArray[0].convertToFloat().getDoubleValue() * 1000.0);
            if (l2 < 0L) {
                throw iRubyObject.getRuntime().newArgumentError("time interval must be positive");
            }
            if (l2 == 0L) {
                return iRubyObject.getRuntime().newFixnum(0L);
            }
        }
        long l3 = System.currentTimeMillis();
        RubyThread rubyThread = threadContext.getThread();
        do {
            l = System.currentTimeMillis();
            try {
                rubyThread.sleep(l2);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while ((l2 -= System.currentTimeMillis() - l) > 0L);
        return iRubyObject.getRuntime().newFixnum(Math.round((double)(System.currentTimeMillis() - l3) / 1000.0));
    }

    @JRubyMethod(name={"exit"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject exit(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        iRubyObject.getRuntime().secure(4);
        int n = 1;
        if (iRubyObjectArray.length > 0) {
            RubyObject rubyObject = (RubyObject)iRubyObjectArray[0];
            n = rubyObject instanceof RubyFixnum ? RubyNumeric.fix2int(rubyObject) : (rubyObject.isFalse() ? 1 : 0);
        }
        throw iRubyObject.getRuntime().newSystemExit(n);
    }

    @JRubyMethod(name={"exit!"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject exit_bang(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        return RubyKernel.exit(iRubyObject, iRubyObjectArray);
    }

    @JRubyMethod(name={"global_variables"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyArray global_variables(IRubyObject iRubyObject) {
        RubyArray rubyArray = iRubyObject.getRuntime().newArray();
        for (String string : iRubyObject.getRuntime().getGlobalVariables().getNames()) {
            rubyArray.append(iRubyObject.getRuntime().newString(string));
        }
        return rubyArray;
    }

    @JRubyMethod(name={"local_variables"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyArray local_variables(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby = iRubyObject.getRuntime();
        RubyArray rubyArray = ruby.newArray();
        for (String string : threadContext.getCurrentScope().getAllNamesInScope()) {
            if (!IdUtil.isLocal(string)) continue;
            rubyArray.append(ruby.newString(string));
        }
        return rubyArray;
    }

    @JRubyMethod(name={"binding"}, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static RubyBinding binding(IRubyObject iRubyObject, Block block) {
        return iRubyObject.getRuntime().newBinding();
    }

    @JRubyMethod(name={"block_given?", "iterator?"}, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static RubyBoolean block_given_p(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        return iRubyObject.getRuntime().newBoolean(threadContext.getPreviousFrame().getBlock().isGiven());
    }

    @JRubyMethod(name={"sprintf", "format"}, required=1, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject sprintf(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        if (iRubyObjectArray.length == 0) {
            throw iRubyObject.getRuntime().newArgumentError("sprintf must have at least one argument");
        }
        RubyString rubyString = RubyString.stringValue(iRubyObjectArray[0]);
        RubyArray rubyArray = iRubyObject.getRuntime().newArrayNoCopy(iRubyObjectArray);
        rubyArray.shift();
        return rubyString.op_format(rubyArray);
    }

    @JRubyMethod(name={"raise", "fail"}, optional=3, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject raise(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        IRubyObject iRubyObject2;
        Ruby ruby = iRubyObject.getRuntime();
        if (iRubyObjectArray.length == 0) {
            IRubyObject iRubyObject3 = ruby.getGlobalVariables().get("$!");
            if (iRubyObject3.isNil()) {
                throw new RaiseException(ruby, ruby.fastGetClass("RuntimeError"), "", false);
            }
            throw new RaiseException((RubyException)iRubyObject3);
        }
        if (iRubyObjectArray.length == 1) {
            if (iRubyObjectArray[0] instanceof RubyString) {
                throw new RaiseException((RubyException)ruby.fastGetClass("RuntimeError").newInstance(threadContext, iRubyObjectArray, block));
            }
            if (!iRubyObjectArray[0].respondsTo("exception")) {
                throw ruby.newTypeError("exception class/object expected");
            }
            iRubyObject2 = iRubyObjectArray[0].callMethod(threadContext, "exception");
        } else {
            if (!iRubyObjectArray[0].respondsTo("exception")) {
                throw ruby.newTypeError("exception class/object expected");
            }
            iRubyObject2 = iRubyObjectArray[0].callMethod(threadContext, "exception", iRubyObjectArray[1]);
        }
        if (!ruby.fastGetClass("Exception").isInstance(iRubyObject2)) {
            throw ruby.newTypeError("exception object expected");
        }
        if (iRubyObjectArray.length == 3) {
            ((RubyException)iRubyObject2).set_backtrace(iRubyObjectArray[2]);
        }
        throw new RaiseException((RubyException)iRubyObject2);
    }

    @JRubyMethod(name={"require"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject require(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        if (iRubyObject.getRuntime().getLoadService().require(iRubyObject2.convertToString().toString())) {
            return iRubyObject.getRuntime().getTrue();
        }
        return iRubyObject.getRuntime().getFalse();
    }

    @JRubyMethod(name={"load"}, required=1, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject load(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        RubyString rubyString = iRubyObjectArray[0].convertToString();
        boolean bl = false;
        if (iRubyObjectArray.length == 2) {
            bl = iRubyObjectArray[1].isTrue();
        }
        iRubyObject.getRuntime().getLoadService().load(rubyString.getByteList().toString(), bl);
        return iRubyObject.getRuntime().getTrue();
    }

    @JRubyMethod(name={"eval"}, required=1, optional=3, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject eval(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        IRubyObject iRubyObject2;
        Ruby ruby = iRubyObject.getRuntime();
        RubyString rubyString = iRubyObjectArray[0].convertToString();
        ruby.checkSafeString(rubyString);
        IRubyObject iRubyObject3 = iRubyObject2 = iRubyObjectArray.length > 1 && !iRubyObjectArray[1].isNil() ? iRubyObjectArray[1] : null;
        String string = iRubyObjectArray.length > 2 ? iRubyObjectArray[2].convertToString().toString() : (iRubyObject2 == null ? "(eval)" : null);
        int n = iRubyObjectArray.length > 3 ? (int)iRubyObjectArray[3].convertToInteger().getLongValue() : (iRubyObject2 == null ? 0 : -1);
        if (iRubyObject2 == null) {
            iRubyObject2 = RubyBinding.newBindingForEval(ruby);
        }
        return ASTInterpreter.evalWithBinding(threadContext, rubyString, iRubyObject2, string, n);
    }

    @JRubyMethod(name={"callcc"}, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject callcc(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        Ruby ruby = iRubyObject.getRuntime();
        ruby.getWarnings().warn(IRubyWarnings.ID.EMPTY_IMPLEMENTATION, "Kernel#callcc: Continuations are not implemented in JRuby and will not work", "Kernel#callcc");
        IRubyObject iRubyObject2 = ruby.getContinuation().callMethod(threadContext, "new");
        iRubyObject2.dataWrapStruct(block);
        return block.yield(threadContext, iRubyObject2);
    }

    @JRubyMethod(name={"caller"}, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject caller(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        int n;
        int n2 = n = iRubyObjectArray.length > 0 ? RubyNumeric.fix2int(iRubyObjectArray[0]) : 1;
        if (n < 0) {
            throw iRubyObject.getRuntime().newArgumentError("negative level(" + n + ')');
        }
        return ThreadContext.createBacktraceFromFrames(iRubyObject.getRuntime(), threadContext.createBacktrace(n, false));
    }

    @JRubyMethod(name={"catch"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject rbCatch(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        CatchTarget catchTarget = new CatchTarget(iRubyObject2.asJavaString());
        try {
            threadContext.pushCatch(catchTarget);
            IRubyObject iRubyObject3 = block.yield(threadContext, iRubyObject2);
            return iRubyObject3;
        }
        catch (JumpException.ThrowJump throwJump) {
            if (throwJump.getTarget() == catchTarget) {
                IRubyObject iRubyObject4 = (IRubyObject)throwJump.getValue();
                return iRubyObject4;
            }
            throw throwJump;
        }
        finally {
            threadContext.popCatch();
        }
    }

    @JRubyMethod(name={"throw"}, required=1, frame=true, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject rbThrow(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        Ruby ruby = iRubyObject.getRuntime();
        String string = iRubyObjectArray[0].asJavaString();
        CatchTarget[] catchTargetArray = threadContext.getActiveCatches();
        String string2 = "uncaught throw `" + string + "'";
        for (int i = catchTargetArray.length - 1; i >= 0; --i) {
            if (!string.equals(catchTargetArray[i].getTag())) continue;
            throw new JumpException.ThrowJump(catchTargetArray[i], iRubyObjectArray.length > 1 ? iRubyObjectArray[1] : ruby.getNil());
        }
        RubyThread rubyThread = threadContext.getThread();
        if (rubyThread == ruby.getThreadService().getMainThread()) {
            throw ruby.newNameError(string2, string);
        }
        throw ruby.newThreadError(string2 + " in thread 0x" + Integer.toHexString(RubyInteger.fix2int(rubyThread.id())));
    }

    @JRubyMethod(name={"trap"}, required=1, frame=true, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject trap(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        iRubyObject.getRuntime().getLoadService().require("jsignal");
        return RuntimeHelpers.invoke(threadContext, iRubyObject, "__jtrap", iRubyObjectArray, CallType.FUNCTIONAL, block);
    }

    @JRubyMethod(name={"warn"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject warn(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = iRubyObject.getRuntime();
        if (!ruby.getVerbose().isNil()) {
            IRubyObject iRubyObject3 = ruby.getGlobalVariables().get("$stderr");
            iRubyObject3.callMethod(threadContext, "puts", new IRubyObject[]{iRubyObject2});
        }
        return iRubyObject.getRuntime().getNil();
    }

    @JRubyMethod(name={"set_trace_func"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject set_trace_func(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        if (iRubyObject2.isNil()) {
            iRubyObject.getRuntime().setTraceFunction(null);
        } else {
            if (!(iRubyObject2 instanceof RubyProc)) {
                throw iRubyObject.getRuntime().newTypeError("trace_func needs to be Proc.");
            }
            iRubyObject.getRuntime().setTraceFunction((RubyProc)iRubyObject2);
        }
        return iRubyObject2;
    }

    @JRubyMethod(name={"trace_var"}, required=1, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject trace_var(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        if (iRubyObjectArray.length == 0) {
            throw iRubyObject.getRuntime().newArgumentError(0, 1);
        }
        RubyProc rubyProc = null;
        String string = null;
        if (iRubyObjectArray.length > 1) {
            string = iRubyObjectArray[0].toString();
        }
        if (string.charAt(0) != '$') {
            return iRubyObject.getRuntime().getNil();
        }
        if (iRubyObjectArray.length == 1) {
            rubyProc = RubyProc.newProc(iRubyObject.getRuntime(), block, Block.Type.PROC);
        }
        if (iRubyObjectArray.length == 2) {
            rubyProc = (RubyProc)TypeConverter.convertToType(iRubyObjectArray[1], iRubyObject.getRuntime().getProc(), 0, "to_proc", true);
        }
        iRubyObject.getRuntime().getGlobalVariables().setTraceVar(string, rubyProc);
        return iRubyObject.getRuntime().getNil();
    }

    @JRubyMethod(name={"untrace_var"}, required=1, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject untrace_var(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        if (iRubyObjectArray.length == 0) {
            throw iRubyObject.getRuntime().newArgumentError(0, 1);
        }
        String string = null;
        if (iRubyObjectArray.length >= 1) {
            string = iRubyObjectArray[0].toString();
        }
        if (string.charAt(0) != '$') {
            return iRubyObject.getRuntime().getNil();
        }
        if (iRubyObjectArray.length > 1) {
            ArrayList<IRubyObject> arrayList = new ArrayList<IRubyObject>();
            for (int i = 1; i < iRubyObjectArray.length; ++i) {
                if (!iRubyObject.getRuntime().getGlobalVariables().untraceVar(string, iRubyObjectArray[i])) continue;
                arrayList.add(iRubyObjectArray[i]);
            }
            return RubyArray.newArray(iRubyObject.getRuntime(), arrayList);
        }
        iRubyObject.getRuntime().getGlobalVariables().untraceVar(string);
        return iRubyObject.getRuntime().getNil();
    }

    @JRubyMethod(name={"singleton_method_added"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject singleton_method_added(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        return iRubyObject.getRuntime().getNil();
    }

    @JRubyMethod(name={"singleton_method_removed"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject singleton_method_removed(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        return iRubyObject.getRuntime().getNil();
    }

    @JRubyMethod(name={"singleton_method_undefined"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject singleton_method_undefined(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        return iRubyObject.getRuntime().getNil();
    }

    @JRubyMethod(name={"proc", "lambda"}, frame=true, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static RubyProc proc(IRubyObject iRubyObject, Block block) {
        return iRubyObject.getRuntime().newProc(Block.Type.LAMBDA, block);
    }

    @JRubyMethod(name={"lambda"}, frame=true, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyProc lambda(IRubyObject iRubyObject, Block block) {
        return iRubyObject.getRuntime().newProc(Block.Type.LAMBDA, block);
    }

    @JRubyMethod(name={"proc"}, frame=true, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyProc proc_1_9(IRubyObject iRubyObject, Block block) {
        return iRubyObject.getRuntime().newProc(Block.Type.PROC, block);
    }

    @JRubyMethod(name={"loop"}, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject loop(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        try {
            while (true) {
                block.yield(threadContext, iRubyObject.getRuntime().getNil());
                threadContext.pollThreadEvents();
            }
        }
        catch (JumpException.BreakJump breakJump) {
            if (breakJump.getTarget() != null && breakJump.getTarget() != block.getBody()) {
                breakJump.setBreakInKernelLoop(true);
            }
            throw breakJump;
        }
    }

    @JRubyMethod(name={"test"}, required=2, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject test(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        if (iRubyObjectArray.length == 0) {
            throw iRubyObject.getRuntime().newArgumentError("wrong number of arguments");
        }
        int n = iRubyObjectArray[0] instanceof RubyFixnum ? (int)((RubyFixnum)iRubyObjectArray[0]).getLongValue() : (iRubyObjectArray[0] instanceof RubyString && ((RubyString)iRubyObjectArray[0]).getByteList().length() > 0 ? (int)((RubyString)iRubyObjectArray[0]).getByteList().charAt(0) : (int)iRubyObjectArray[0].convertToInteger().getLongValue());
        switch (n) {
            case 45: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 67: 
            case 71: 
            case 77: 
            case 79: 
            case 82: 
            case 83: 
            case 87: 
            case 88: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 107: 
            case 108: 
            case 111: 
            case 112: 
            case 114: 
            case 115: 
            case 117: 
            case 119: 
            case 120: 
            case 122: {
                break;
            }
            default: {
                throw iRubyObject.getRuntime().newArgumentError("unknown command ?" + (char)n);
            }
        }
        switch (n) {
            case 45: 
            case 60: 
            case 61: 
            case 62: {
                if (iRubyObjectArray.length == 3) break;
                throw iRubyObject.getRuntime().newArgumentError(iRubyObjectArray.length, 3);
            }
            default: {
                if (iRubyObjectArray.length == 2) break;
                throw iRubyObject.getRuntime().newArgumentError(iRubyObjectArray.length, 2);
            }
        }
        switch (n) {
            case 65: {
                return iRubyObject.getRuntime().newFileStat(iRubyObjectArray[1].convertToString().toString(), false).atime();
            }
            case 98: {
                return RubyFileTest.blockdev_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 99: {
                return RubyFileTest.chardev_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 67: {
                return iRubyObject.getRuntime().newFileStat(iRubyObjectArray[1].convertToString().toString(), false).ctime();
            }
            case 100: {
                return RubyFileTest.directory_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 101: {
                return RubyFileTest.exist_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 102: {
                return RubyFileTest.file_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 103: {
                return RubyFileTest.setgid_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 71: {
                return RubyFileTest.grpowned_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 107: {
                return RubyFileTest.sticky_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 77: {
                return iRubyObject.getRuntime().newFileStat(iRubyObjectArray[1].convertToString().toString(), false).mtime();
            }
            case 108: {
                return RubyFileTest.symlink_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 111: {
                return RubyFileTest.owned_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 79: {
                return RubyFileTest.rowned_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 112: {
                return RubyFileTest.pipe_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 114: {
                return RubyFileTest.readable_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 82: {
                return RubyFileTest.readable_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 115: {
                return RubyFileTest.size_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 83: {
                return RubyFileTest.socket_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 117: {
                return RubyFileTest.setuid_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 119: {
                return RubyFileTest.writable_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 87: {
                return RubyFileTest.writable_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 120: {
                return RubyFileTest.executable_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 88: {
                return RubyFileTest.executable_real_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 122: {
                return RubyFileTest.zero_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 61: {
                return iRubyObject.getRuntime().newFileStat(iRubyObjectArray[1].convertToString().toString(), false).mtimeEquals(iRubyObjectArray[2]);
            }
            case 60: {
                return iRubyObject.getRuntime().newFileStat(iRubyObjectArray[1].convertToString().toString(), false).mtimeLessThan(iRubyObjectArray[2]);
            }
            case 62: {
                return iRubyObject.getRuntime().newFileStat(iRubyObjectArray[1].convertToString().toString(), false).mtimeGreaterThan(iRubyObjectArray[2]);
            }
            case 45: {
                return RubyFileTest.identical_p(iRubyObject, iRubyObjectArray[1], iRubyObjectArray[2]);
            }
        }
        throw new InternalError("unreachable code reached!");
    }

    @JRubyMethod(name={"`"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject backquote(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = iRubyObject.getRuntime();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        RubyString rubyString = iRubyObject2.convertToString();
        int n = ShellLauncher.runAndWait(ruby, new IRubyObject[]{rubyString}, byteArrayOutputStream);
        iRubyObject.getRuntime().getGlobalVariables().set("$?", RubyProcess.RubyStatus.newProcessStatus(ruby, n));
        return RubyString.newString(iRubyObject.getRuntime(), byteArrayOutputStream.toByteArray());
    }

    @JRubyMethod(name={"srand"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyInteger srand(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        Ruby ruby = iRubyObject.getRuntime();
        long l = ruby.getRandomSeed();
        if (iRubyObjectArray.length > 0) {
            RubyInteger rubyInteger = iRubyObjectArray[0].convertToInteger(MethodIndex.TO_INT, "to_int");
            ruby.setRandomSeed(rubyInteger.getLongValue());
        } else {
            ruby.setRandomSeed(System.currentTimeMillis() ^ (long)iRubyObject.hashCode() ^ ruby.incrementRandomSeedSequence() ^ (long)ruby.getRandom().nextInt(Math.max(1, Math.abs((int)ruby.getRandomSeed()))));
        }
        ruby.getRandom().setSeed(ruby.getRandomSeed());
        return ruby.newFixnum(l);
    }

    @JRubyMethod(name={"rand"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyNumeric rand(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        long l;
        Ruby ruby = iRubyObject.getRuntime();
        if (iRubyObjectArray.length == 0) {
            l = 0L;
        } else if (iRubyObjectArray.length == 1) {
            if (iRubyObjectArray[0] instanceof RubyBignum) {
                byte[] byArray = ((RubyBignum)iRubyObjectArray[0]).getValue().toByteArray();
                BigInteger bigInteger = new BigInteger(byArray).abs();
                byte[] byArray2 = new byte[byArray.length];
                ruby.getRandom().nextBytes(byArray2);
                BigInteger bigInteger2 = new BigInteger(byArray2).abs().mod(bigInteger);
                return new RubyBignum(ruby, bigInteger2);
            }
            RubyInteger rubyInteger = (RubyInteger)RubyKernel.new_integer(threadContext, iRubyObject, iRubyObjectArray[0]);
            l = Math.abs(rubyInteger.getLongValue());
        } else {
            throw ruby.newArgumentError("wrong # of arguments(" + iRubyObjectArray.length + " for 1)");
        }
        if (l == 0L) {
            return RubyFloat.newFloat(ruby, ruby.getRandom().nextDouble());
        }
        if (l > Integer.MAX_VALUE) {
            return ruby.newFixnum(Math.abs(ruby.getRandom().nextLong()) % l);
        }
        return ruby.newFixnum(ruby.getRandom().nextInt((int)l));
    }

    @JRubyMethod(name={"syscall"}, required=1, optional=9, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject syscall(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        throw iRubyObject.getRuntime().newNotImplementedError("Kernel#syscall is not implemented in JRuby");
    }

    @JRubyMethod(name={"system"}, required=1, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static RubyBoolean system(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        int n;
        Ruby ruby = iRubyObject.getRuntime();
        try {
            n = ShellLauncher.runAndWait(ruby, iRubyObjectArray);
        }
        catch (Exception exception) {
            n = 127;
        }
        iRubyObject.getRuntime().getGlobalVariables().set("$?", RubyProcess.RubyStatus.newProcessStatus(ruby, n));
        return ruby.newBoolean(n == 0);
    }

    @JRubyMethod(name={"exec"}, required=1, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject exec(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        int n;
        Ruby ruby = iRubyObject.getRuntime();
        try {
            n = ShellLauncher.execAndWait(ruby, iRubyObjectArray);
        }
        catch (Exception exception) {
            throw ruby.newErrnoENOENTError("cannot execute");
        }
        return RubyKernel.exit(iRubyObject, new IRubyObject[]{ruby.newFixnum(n)});
    }

    @JRubyMethod(name={"fork"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject fork(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        Ruby ruby = iRubyObject.getRuntime();
        if (!RubyInstanceConfig.FORK_ENABLED) {
            throw ruby.newNotImplementedError("fork is unsafe and disabled by default on JRuby");
        }
        if (block.isGiven()) {
            int n = ruby.getPosix().fork();
            if (n == 0) {
                try {
                    block.yield(threadContext, ruby.getNil());
                }
                catch (RaiseException raiseException) {
                    if (raiseException.getException() instanceof RubySystemExit) {
                        throw raiseException;
                    }
                    return RubyKernel.exit_bang(iRubyObject, new IRubyObject[]{RubyFixnum.minus_one(ruby)});
                }
                catch (Throwable throwable) {
                    return RubyKernel.exit_bang(iRubyObject, new IRubyObject[]{RubyFixnum.minus_one(ruby)});
                }
                return RubyKernel.exit_bang(iRubyObject, new IRubyObject[]{RubyFixnum.zero(ruby)});
            }
            return ruby.newFixnum(n);
        }
        int n = ruby.getPosix().fork();
        if (n == -1) {
            return ruby.getNil();
        }
        return ruby.newFixnum(n);
    }

    public static class CatchTarget
    implements JumpTarget {
        private final String tag;

        public CatchTarget(String string) {
            this.tag = string;
        }

        public String getTag() {
            return this.tag;
        }
    }
}

