/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.Closeable;
import java.io.EOFException;
import java.io.FileDescriptor;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProcess;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.posix.util.FieldAccess;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.ShellLauncher;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.BadDescriptorException;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.ChannelStream;
import org.jruby.util.io.FileExistsException;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.OpenFile;
import org.jruby.util.io.PipeException;
import org.jruby.util.io.STDIO;
import org.jruby.util.io.Stream;

public class RubyIO
extends RubyObject {
    protected OpenFile openFile;
    protected static int filenoIndex = 2;
    private static ObjectAllocator IO_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new RubyIO(ruby, rubyClass);
        }
    };
    private static final ByteList NIL_BYTELIST = ByteList.create("nil");
    private static final ByteList RECURSIVE_BYTELIST = ByteList.create("[...]");

    public void registerDescriptor(ChannelDescriptor channelDescriptor) {
        this.getRuntime().getDescriptors().put(new Integer(channelDescriptor.getFileno()), new WeakReference<ChannelDescriptor>(channelDescriptor));
    }

    public void unregisterDescriptor(int n) {
        this.getRuntime().getDescriptors().remove(new Integer(n));
    }

    public ChannelDescriptor getDescriptorByFileno(int n) {
        Reference reference = this.getRuntime().getDescriptors().get(new Integer(n));
        if (reference == null) {
            return null;
        }
        return (ChannelDescriptor)reference.get();
    }

    public static int getNewFileno() {
        return ++filenoIndex;
    }

    public RubyIO(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
        this.openFile = new OpenFile();
    }

    public RubyIO(Ruby ruby, OutputStream outputStream) {
        super(ruby, ruby.getIO());
        if (outputStream == null) {
            throw ruby.newIOError("Opening invalid stream");
        }
        this.openFile = new OpenFile();
        try {
            this.openFile.setMainStream(new ChannelStream(ruby, new ChannelDescriptor(Channels.newChannel(outputStream), RubyIO.getNewFileno(), new FileDescriptor())));
        }
        catch (InvalidValueException invalidValueException) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        this.openFile.setMode(66);
        this.registerDescriptor(this.openFile.getMainStream().getDescriptor());
    }

    public RubyIO(Ruby ruby, InputStream inputStream) {
        super(ruby, ruby.getIO());
        if (inputStream == null) {
            throw ruby.newIOError("Opening invalid stream");
        }
        this.openFile = new OpenFile();
        try {
            this.openFile.setMainStream(new ChannelStream(ruby, new ChannelDescriptor(Channels.newChannel(inputStream), RubyIO.getNewFileno(), new FileDescriptor())));
        }
        catch (InvalidValueException invalidValueException) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        this.openFile.setMode(1);
        this.registerDescriptor(this.openFile.getMainStream().getDescriptor());
    }

    public RubyIO(Ruby ruby, Channel channel) {
        super(ruby, ruby.getIO());
        if (channel == null) {
            throw ruby.newIOError("Opening invalid stream");
        }
        this.openFile = new OpenFile();
        try {
            this.openFile.setMainStream(new ChannelStream(ruby, new ChannelDescriptor(channel, RubyIO.getNewFileno(), new FileDescriptor())));
        }
        catch (InvalidValueException invalidValueException) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        this.openFile.setMode(this.openFile.getMainStream().getModes().getOpenFileFlags());
        this.registerDescriptor(this.openFile.getMainStream().getDescriptor());
    }

    public RubyIO(Ruby ruby, Process process, ModeFlags modeFlags) {
        block11: {
            super(ruby, ruby.getIO());
            this.openFile = new OpenFile();
            this.openFile.setMode(modeFlags.getOpenFileFlags() | 8);
            this.openFile.setProcess(process);
            try {
                ChannelDescriptor channelDescriptor;
                Closeable closeable;
                if (this.openFile.isReadable()) {
                    closeable = process.getInputStream();
                    if (closeable instanceof FilterInputStream) {
                        try {
                            closeable = (InputStream)FieldAccess.getProtectedFieldValue(FilterInputStream.class, "in", closeable);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    channelDescriptor = new ChannelDescriptor(Channels.newChannel(closeable), RubyIO.getNewFileno(), new FileDescriptor());
                    channelDescriptor.setCanBeSeekable(false);
                    this.openFile.setMainStream(new ChannelStream(this.getRuntime(), channelDescriptor));
                    this.registerDescriptor(channelDescriptor);
                }
                if (!this.openFile.isWritable()) break block11;
                closeable = process.getOutputStream();
                if (closeable instanceof FilterOutputStream) {
                    try {
                        closeable = (OutputStream)FieldAccess.getProtectedFieldValue(FilterOutputStream.class, "out", closeable);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                channelDescriptor = new ChannelDescriptor(Channels.newChannel((OutputStream)closeable), RubyIO.getNewFileno(), new FileDescriptor());
                channelDescriptor.setCanBeSeekable(false);
                if (this.openFile.getMainStream() != null) {
                    this.openFile.setPipeStream(new ChannelStream(this.getRuntime(), channelDescriptor));
                } else {
                    this.openFile.setMainStream(new ChannelStream(this.getRuntime(), channelDescriptor));
                }
                this.registerDescriptor(channelDescriptor);
            }
            catch (InvalidValueException invalidValueException) {
                throw this.getRuntime().newErrnoEINVALError();
            }
        }
    }

    public RubyIO(Ruby ruby, STDIO sTDIO) {
        super(ruby, ruby.getIO());
        this.openFile = new OpenFile();
        try {
            switch (sTDIO) {
                case IN: {
                    this.openFile.setMainStream(new ChannelStream(ruby, new ChannelDescriptor(ruby.getIn(), 0, new ModeFlags(0L), FileDescriptor.in), FileDescriptor.in));
                    break;
                }
                case OUT: {
                    this.openFile.setMainStream(new ChannelStream(ruby, new ChannelDescriptor(Channels.newChannel(ruby.getOut()), 1, new ModeFlags(9L), FileDescriptor.out), FileDescriptor.out));
                    this.openFile.getMainStream().setSync(true);
                    break;
                }
                case ERR: {
                    this.openFile.setMainStream(new ChannelStream(ruby, new ChannelDescriptor(Channels.newChannel(ruby.getErr()), 2, new ModeFlags(9L), FileDescriptor.err), FileDescriptor.err));
                    this.openFile.getMainStream().setSync(true);
                }
            }
        }
        catch (InvalidValueException invalidValueException) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        this.openFile.setMode(this.openFile.getMainStream().getModes().getOpenFileFlags());
        this.registerDescriptor(this.openFile.getMainStream().getDescriptor());
    }

    public OpenFile getOpenFile() {
        return this.openFile;
    }

    protected OpenFile getOpenFileChecked() {
        this.openFile.checkClosed(this.getRuntime());
        return this.openFile;
    }

    public static RubyClass createIOClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("IO", ruby.getObject(), IO_ALLOCATOR);
        CallbackFactory callbackFactory = ruby.callbackFactory(RubyIO.class);
        rubyClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject iRubyObject, RubyModule rubyModule) {
                return iRubyObject instanceof RubyIO;
            }
        };
        rubyClass.includeModule(ruby.getEnumerable());
        rubyClass.defineAnnotatedMethods(RubyIO.class);
        rubyClass.fastSetConstant("SEEK_SET", ruby.newFixnum(0L));
        rubyClass.fastSetConstant("SEEK_CUR", ruby.newFixnum(1L));
        rubyClass.fastSetConstant("SEEK_END", ruby.newFixnum(2L));
        rubyClass.dispatcher = callbackFactory.createDispatcher(rubyClass);
        return rubyClass;
    }

    public OutputStream getOutStream() {
        return this.getOpenFileChecked().getMainStream().newOutputStream();
    }

    public InputStream getInStream() {
        return this.getOpenFileChecked().getMainStream().newInputStream();
    }

    public Channel getChannel() {
        if (this.getOpenFileChecked().getMainStream() instanceof ChannelStream) {
            return ((ChannelStream)this.openFile.getMainStream()).getDescriptor().getChannel();
        }
        return null;
    }

    public Stream getHandler() {
        return this.getOpenFileChecked().getMainStream();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod(name={"reopen"}, required=1, optional=1)
    public IRubyObject reopen(IRubyObject[] iRubyObjectArray) throws InvalidValueException {
        if (iRubyObjectArray.length < 1) {
            throw this.getRuntime().newArgumentError("wrong number of arguments");
        }
        IRubyObject iRubyObject = TypeConverter.convertToTypeWithCheck(iRubyObjectArray[0], this.getRuntime().getIO(), MethodIndex.getIndex("to_io"), "to_io");
        if (!iRubyObject.isNil()) {
            try {
                RubyIO rubyIO = (RubyIO)iRubyObject;
                if (rubyIO.openFile == this.openFile) {
                    return this;
                }
                OpenFile openFile = rubyIO.getOpenFileChecked();
                OpenFile openFile2 = this.getOpenFileChecked();
                long l = 0L;
                if (openFile.isReadable()) {
                    l = openFile.getMainStream().fgetpos();
                }
                if (openFile.getPipeStream() != null) {
                    openFile.getPipeStream().fflush();
                } else if (openFile.isWritable()) {
                    openFile.getMainStream().fflush();
                }
                if (openFile2.isWritable()) {
                    openFile2.getWriteStream().fflush();
                }
                openFile2.setMode(openFile.getMode());
                openFile2.setProcess(openFile.getProcess());
                openFile2.setLineNumber(openFile.getLineNumber());
                openFile2.setPath(openFile.getPath());
                openFile2.setFinalizer(openFile.getFinalizer());
                ChannelDescriptor channelDescriptor = openFile2.getMainStream().getDescriptor();
                ChannelDescriptor channelDescriptor2 = openFile.getMainStream().getDescriptor();
                if (channelDescriptor.getChannel() != channelDescriptor2.getChannel()) {
                    if (channelDescriptor.getFileno() >= 0 && channelDescriptor.getFileno() <= 2) {
                        openFile2.getMainStream().clearerr();
                        channelDescriptor2.dup2Into(channelDescriptor);
                        this.registerDescriptor(channelDescriptor);
                    } else {
                        Stream stream = openFile2.getPipeStream();
                        int n = openFile2.getMode();
                        openFile2.getMainStream().fclose();
                        openFile2.setPipeStream(null);
                        if (stream != null) {
                            openFile2.setMainStream(ChannelStream.fdopen(this.getRuntime(), channelDescriptor2, new ModeFlags()));
                            openFile2.setPipeStream(stream);
                        } else {
                            openFile2.setMainStream(new ChannelStream(this.getRuntime(), channelDescriptor2.dup2(channelDescriptor.getFileno())));
                            this.registerDescriptor(openFile2.getMainStream().getDescriptor());
                            openFile2.getMainStream().setSync(openFile2.getMainStream().isSync());
                        }
                        openFile2.setMode(n);
                    }
                    if (openFile.isReadable() && l >= 0L) {
                        openFile2.seek(l, 0);
                        openFile.seek(l, 0);
                    }
                }
                if (openFile2.getPipeStream() == null || channelDescriptor.getFileno() == openFile2.getPipeStream().getDescriptor().getFileno()) return this;
                int n = openFile2.getPipeStream().getDescriptor().getFileno();
                if (openFile.getPipeStream() == null) {
                    openFile2.getPipeStream().fclose();
                    openFile2.setPipeStream(null);
                    return this;
                }
                if (n == openFile.getPipeStream().getDescriptor().getFileno()) return this;
                openFile2.getPipeStream().fclose();
                ChannelDescriptor channelDescriptor3 = openFile.getPipeStream().getDescriptor().dup2(n);
                openFile2.setPipeStream(ChannelStream.fdopen(this.getRuntime(), channelDescriptor3, RubyIO.getIOModes(this.getRuntime(), "w")));
                this.registerDescriptor(channelDescriptor3);
                return this;
            }
            catch (IOException iOException) {
                throw this.getRuntime().newIOError("could not reopen: " + iOException.getMessage());
            }
            catch (BadDescriptorException badDescriptorException) {
                throw this.getRuntime().newIOError("could not reopen: " + badDescriptorException.getMessage());
            }
            catch (PipeException pipeException) {
                throw this.getRuntime().newIOError("could not reopen: " + pipeException.getMessage());
            }
        }
        RubyString rubyString = iRubyObjectArray[0].convertToString();
        if (this.openFile == null) {
            this.openFile = new OpenFile();
        }
        try {
            ModeFlags modeFlags;
            Object object;
            if (iRubyObjectArray.length > 1) {
                object = iRubyObjectArray[1].convertToString();
                modeFlags = RubyIO.getIOModes(this.getRuntime(), object.toString());
                this.openFile.setMode(modeFlags.getOpenFileFlags());
            } else {
                modeFlags = RubyIO.getIOModes(this.getRuntime(), "r");
            }
            object = ((Object)rubyString).toString();
            this.openFile.setPath((String)object);
            if (this.openFile.getMainStream() == null) {
                try {
                    this.openFile.setMainStream(ChannelStream.fopen(this.getRuntime(), (String)object, modeFlags));
                }
                catch (FileExistsException fileExistsException) {
                    throw this.getRuntime().newErrnoEEXISTError((String)object);
                }
                this.registerDescriptor(this.openFile.getMainStream().getDescriptor());
                if (this.openFile.getPipeStream() == null) return this;
                this.openFile.getPipeStream().fclose();
                this.unregisterDescriptor(this.openFile.getPipeStream().getDescriptor().getFileno());
                this.openFile.setPipeStream(null);
                return this;
            }
            this.openFile.getMainStream().freopen((String)object, RubyIO.getIOModes(this.getRuntime(), this.openFile.getModeAsString(this.getRuntime())));
            this.registerDescriptor(this.openFile.getMainStream().getDescriptor());
            if (this.openFile.getPipeStream() == null) return this;
        }
        catch (PipeException pipeException) {
            throw this.getRuntime().newErrnoEPIPEError();
        }
        catch (IOException iOException) {
            throw this.getRuntime().newIOErrorFromException(iOException);
        }
        catch (BadDescriptorException badDescriptorException) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException invalidValueException) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        return this;
    }

    public static ModeFlags getIOModes(Ruby ruby, String string) throws InvalidValueException {
        return new ModeFlags(RubyIO.getIOModesIntFromString(ruby, string));
    }

    public static int getIOModesIntFromString(Ruby ruby, String string) {
        int n = 0;
        int n2 = string.length();
        if (n2 == 0) {
            throw ruby.newArgumentError("illegal access mode");
        }
        switch (string.charAt(0)) {
            case 'r': {
                n |= 0;
                break;
            }
            case 'a': {
                n |= 0x109;
                break;
            }
            case 'w': {
                n |= 0x301;
                break;
            }
            default: {
                throw ruby.newArgumentError("illegal access mode " + n);
            }
        }
        block9: for (int i = 1; i < n2; ++i) {
            switch (string.charAt(i)) {
                case 'b': {
                    n |= 0x8000;
                    continue block9;
                }
                case '+': {
                    n = n & 0xFFFEFFFF | 2;
                    continue block9;
                }
                default: {
                    throw ruby.newArgumentError("illegal access mode " + n);
                }
            }
        }
        return n;
    }

    private static ByteList getSeparatorFromArgs(Ruby ruby, IRubyObject[] iRubyObjectArray, int n) {
        ByteList byteList;
        IRubyObject iRubyObject = iRubyObjectArray.length > n ? iRubyObjectArray[n] : ruby.getRecordSeparatorVar().get();
        ByteList byteList2 = byteList = iRubyObject.isNil() ? null : iRubyObject.convertToString().getByteList();
        if (byteList != null && byteList.realSize == 0) {
            byteList = Stream.PARAGRAPH_DELIMETER;
        }
        return byteList;
    }

    private ByteList getSeparatorForGets(IRubyObject[] iRubyObjectArray) {
        return RubyIO.getSeparatorFromArgs(this.getRuntime(), iRubyObjectArray, 0);
    }

    public IRubyObject getline(ByteList byteList) {
        try {
            OpenFile openFile = this.getOpenFileChecked();
            openFile.checkReadable(this.getRuntime());
            boolean bl = byteList == Stream.PARAGRAPH_DELIMETER;
            ByteList byteList2 = byteList = byteList == Stream.PARAGRAPH_DELIMETER ? Stream.PARAGRAPH_SEPARATOR : byteList;
            if (bl) {
                this.swallow(10);
            }
            if (byteList == null) {
                IRubyObject iRubyObject = this.readAll(null);
                if (((RubyString)iRubyObject).getByteList().length() == 0) {
                    return this.getRuntime().getNil();
                }
                this.incrementLineno(openFile);
                return iRubyObject;
            }
            if (byteList.length() == 1) {
                return this.getlineFast(byteList.get(0));
            }
            Stream stream = openFile.getMainStream();
            int n = -1;
            int n2 = byteList.get(byteList.length() - 1) & 0xFF;
            ByteList byteList3 = new ByteList(1024);
            boolean bl2 = false;
            while (true) {
                block17: {
                    block18: {
                        block16: {
                            this.readCheck(stream);
                            stream.clearerr();
                            try {
                                n = stream.fgetc();
                            }
                            catch (EOFException eOFException) {
                                n = -1;
                            }
                            if (n != -1) break block16;
                            if (stream.isBlocking() || !(stream instanceof ChannelStream)) break block17;
                            if (!this.waitReadable(((ChannelStream)stream).getDescriptor())) {
                                throw this.getRuntime().newIOError("bad file descriptor: " + this.openFile.getPath());
                            }
                            break block18;
                        }
                        byteList3.append(n);
                        bl2 = true;
                    }
                    if (n != n2) continue;
                }
                if (n == -1 || n == n2 && byteList3.length() >= byteList.length() && 0 == ByteList.memcmp(byteList3.unsafeBytes(), byteList3.begin + byteList3.realSize - byteList.length(), byteList.unsafeBytes(), byteList.begin, byteList.realSize)) break;
            }
            if (bl && n != -1) {
                this.swallow(10);
            }
            if (!bl2) {
                return this.getRuntime().getNil();
            }
            this.incrementLineno(openFile);
            RubyString rubyString = RubyString.newString(this.getRuntime(), byteList3);
            rubyString.setTaint(true);
            return rubyString;
        }
        catch (PipeException pipeException) {
            throw this.getRuntime().newErrnoEPIPEError();
        }
        catch (InvalidValueException invalidValueException) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (EOFException eOFException) {
            return this.getRuntime().getNil();
        }
        catch (BadDescriptorException badDescriptorException) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (IOException iOException) {
            throw this.getRuntime().newIOError(iOException.getMessage());
        }
    }

    private void incrementLineno(OpenFile openFile) {
        Ruby ruby = this.getRuntime();
        int n = openFile.getLineNumber() + 1;
        openFile.setLineNumber(n);
        ruby.getGlobalVariables().set("$.", ruby.newFixnum(n));
        RubyNumeric.int2fix(this.getRuntime(), openFile.getLineNumber());
    }

    protected boolean swallow(int n) throws IOException, BadDescriptorException {
        int n2;
        Stream stream = this.openFile.getMainStream();
        do {
            this.readCheck(stream);
            try {
                n2 = stream.fgetc();
            }
            catch (EOFException eOFException) {
                n2 = -1;
            }
            if (n2 == n) continue;
            stream.ungetc(n2);
            return true;
        } while (n2 != -1);
        return false;
    }

    public IRubyObject getlineFast(int n) throws IOException, BadDescriptorException {
        Stream stream = this.openFile.getMainStream();
        int n2 = -1;
        ByteList byteList = new ByteList(1024);
        boolean bl = false;
        do {
            this.readCheck(stream);
            stream.clearerr();
            try {
                n2 = stream.fgetc();
            }
            catch (EOFException eOFException) {
                n2 = -1;
            }
            if (n2 == -1) {
                if (stream.isBlocking() || !(stream instanceof ChannelStream)) break;
                if (this.waitReadable(((ChannelStream)stream).getDescriptor())) continue;
                throw this.getRuntime().newIOError("bad file descriptor: " + this.openFile.getPath());
            }
            byteList.append(n2);
            bl = true;
        } while (n2 != n);
        if (!bl) {
            return this.getRuntime().getNil();
        }
        this.incrementLineno(this.openFile);
        RubyString rubyString = RubyString.newString(this.getRuntime(), byteList);
        rubyString.setTaint(true);
        return rubyString;
    }

    @JRubyMethod(name={"new", "for_fd"}, rest=true, frame=true, meta=true)
    public static IRubyObject newInstance(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        RubyClass rubyClass = (RubyClass)iRubyObject;
        if (block.isGiven()) {
            String string = rubyClass.getName();
            iRubyObject.getRuntime().getWarnings().warn(IRubyWarnings.ID.BLOCK_NOT_ACCEPTED, string + "::new() does not take block; use " + string + "::open() instead", string + "::open()");
        }
        return rubyClass.newInstance(threadContext, iRubyObjectArray, block);
    }

    @JRubyMethod(name={"initialize"}, required=1, optional=1, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] iRubyObjectArray, Block block) {
        int n = iRubyObjectArray.length;
        int n2 = RubyNumeric.fix2int(iRubyObjectArray[0]);
        try {
            ChannelDescriptor channelDescriptor = this.getDescriptorByFileno(n2);
            if (channelDescriptor == null) {
                throw this.getRuntime().newErrnoEBADFError();
            }
            channelDescriptor.checkOpen();
            ModeFlags modeFlags = n == 2 ? (iRubyObjectArray[1] instanceof RubyFixnum ? new ModeFlags(RubyFixnum.fix2long(iRubyObjectArray[1])) : RubyIO.getIOModes(this.getRuntime(), iRubyObjectArray[1].convertToString().toString())) : channelDescriptor.getOriginalModes();
            this.openFile.setMode(modeFlags.getOpenFileFlags());
            this.openFile.setMainStream(this.fdopen(channelDescriptor, modeFlags));
        }
        catch (BadDescriptorException badDescriptorException) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException invalidValueException) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        return this;
    }

    protected Stream fdopen(ChannelDescriptor channelDescriptor, ModeFlags modeFlags) throws InvalidValueException {
        if (channelDescriptor == null) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        return ChannelStream.fdopen(this.getRuntime(), channelDescriptor, modeFlags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"open"}, required=1, optional=2, frame=true, meta=true)
    public static IRubyObject open(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        Ruby ruby = iRubyObject.getRuntime();
        RubyClass rubyClass = (RubyClass)iRubyObject;
        RubyIO rubyIO = (RubyIO)rubyClass.newInstance(threadContext, iRubyObjectArray, block);
        if (block.isGiven()) {
            try {
                IRubyObject iRubyObject2 = block.yield(threadContext, rubyIO);
                return iRubyObject2;
            }
            finally {
                block8: {
                    try {
                        rubyIO.getMetaClass().invoke(threadContext, (IRubyObject)rubyIO, "close", IRubyObject.NULL_ARRAY, CallType.FUNCTIONAL, Block.NULL_BLOCK);
                    }
                    catch (RaiseException raiseException) {
                        RubyException rubyException = raiseException.getException();
                        if (rubyException.kind_of_p(ruby.getStandardError()).isTrue()) break block8;
                        throw raiseException;
                    }
                }
            }
        }
        return rubyIO;
    }

    @JRubyMethod(name={"binmode"})
    public IRubyObject binmode() {
        return this;
    }

    protected void checkInitialized() {
        if (this.openFile == null) {
            throw this.getRuntime().newIOError("uninitialized stream");
        }
    }

    protected void checkClosed() {
        if (this.openFile.getMainStream() == null && this.openFile.getPipeStream() == null) {
            throw this.getRuntime().newIOError("closed stream");
        }
    }

    @JRubyMethod(name={"syswrite"}, required=1)
    public IRubyObject syswrite(IRubyObject iRubyObject) {
        try {
            int n;
            RubyString rubyString = iRubyObject.asString();
            OpenFile openFile = this.getOpenFileChecked();
            openFile.checkWritable(this.getRuntime());
            Stream stream = openFile.getWriteStream();
            if (openFile.isWriteBuffered()) {
                this.getRuntime().getWarnings().warn(IRubyWarnings.ID.SYSWRITE_BUFFERED_IO, "syswrite for buffered IO", new Object[0]);
            }
            if (!stream.getDescriptor().isWritable()) {
                openFile.checkClosed(this.getRuntime());
            }
            if ((n = stream.getDescriptor().write(rubyString.getByteList())) == -1) {
                // empty if block
            }
            return this.getRuntime().newFixnum(n);
        }
        catch (InvalidValueException invalidValueException) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException pipeException) {
            throw this.getRuntime().newErrnoEPIPEError();
        }
        catch (BadDescriptorException badDescriptorException) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (IOException iOException) {
            throw this.getRuntime().newSystemCallError(iOException.getMessage());
        }
    }

    @JRubyMethod(name={"write_nonblock"}, required=1)
    public IRubyObject write_nonblock(IRubyObject iRubyObject) {
        OpenFile openFile = this.getOpenFileChecked();
        try {
            openFile.checkWritable(this.getRuntime());
        }
        catch (IOException iOException) {
            throw this.getRuntime().newIOErrorFromException(iOException);
        }
        catch (BadDescriptorException badDescriptorException) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException invalidValueException) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException pipeException) {
            throw this.getRuntime().newErrnoEPIPEError();
        }
        return this.write(iRubyObject);
    }

    @JRubyMethod(name={"write"}, required=1)
    public IRubyObject write(IRubyObject iRubyObject) {
        this.getRuntime().secure(4);
        RubyString rubyString = iRubyObject.asString();
        if (rubyString.getByteList().length() == 0) {
            return this.getRuntime().newFixnum(0L);
        }
        try {
            OpenFile openFile = this.getOpenFileChecked();
            openFile.checkWritable(this.getRuntime());
            int n = this.fwrite(rubyString.getByteList());
            if (n == -1) {
                // empty if block
            }
            if (!openFile.isSync()) {
                openFile.setWriteBuffered();
            }
            return this.getRuntime().newFixnum(n);
        }
        catch (IOException iOException) {
            throw this.getRuntime().newIOErrorFromException(iOException);
        }
        catch (BadDescriptorException badDescriptorException) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException invalidValueException) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException pipeException) {
            throw this.getRuntime().newErrnoEPIPEError();
        }
    }

    protected boolean waitWritable(ChannelDescriptor channelDescriptor) throws IOException {
        Channel channel = channelDescriptor.getChannel();
        if (channel == null || !(channel instanceof SelectableChannel)) {
            return false;
        }
        Selector selector = Selector.open();
        ((SelectableChannel)channel).configureBlocking(false);
        int n = ((SelectableChannel)channel).validOps() & 4;
        SelectionKey selectionKey = ((SelectableChannel)channel).keyFor(selector);
        if (selectionKey == null) {
            ((SelectableChannel)channel).register(selector, n, channelDescriptor);
        } else {
            selectionKey.interestOps(selectionKey.interestOps() | n);
        }
        while (selector.select() == 0) {
        }
        for (SelectionKey selectionKey2 : selector.selectedKeys()) {
            if ((selectionKey2.interestOps() & selectionKey2.readyOps() & 4) == 0 || selectionKey2.attachment() != channelDescriptor) continue;
            return true;
        }
        return false;
    }

    protected boolean waitReadable(ChannelDescriptor channelDescriptor) throws IOException {
        Channel channel = channelDescriptor.getChannel();
        if (channel == null || !(channel instanceof SelectableChannel)) {
            return false;
        }
        Selector selector = Selector.open();
        ((SelectableChannel)channel).configureBlocking(false);
        int n = ((SelectableChannel)channel).validOps() & 0x11;
        SelectionKey selectionKey = ((SelectableChannel)channel).keyFor(selector);
        if (selectionKey == null) {
            ((SelectableChannel)channel).register(selector, n, channelDescriptor);
        } else {
            selectionKey.interestOps(selectionKey.interestOps() | n);
        }
        while (selector.select() == 0) {
        }
        for (SelectionKey selectionKey2 : selector.selectedKeys()) {
            if ((selectionKey2.interestOps() & selectionKey2.readyOps() & 0x11) == 0 || selectionKey2.attachment() != channelDescriptor) continue;
            return true;
        }
        return false;
    }

    protected int fwrite(ByteList byteList) {
        int n = 0;
        boolean bl = false;
        Stream stream = this.openFile.getWriteStream();
        int n2 = byteList.length();
        int n3 = n2;
        if (n3 <= 0) {
            return n3;
        }
        try {
            if (this.openFile.isSync()) {
                this.openFile.fflush(stream);
                while (n < n2) {
                    int n4 = n3;
                    int n5 = stream.getDescriptor().write(byteList, n, n4);
                    if (n5 == n2) {
                        return n2;
                    }
                    if (0 <= n5) {
                        n += n5;
                        n3 -= n5;
                        bl = true;
                    }
                    if (bl && this.waitWritable(stream.getDescriptor())) {
                        this.openFile.checkClosed(this.getRuntime());
                        if (n >= byteList.length()) {
                            return -1;
                        }
                        bl = false;
                        continue;
                    }
                    return -1;
                }
            }
            return stream.fwrite(byteList);
        }
        catch (IOException iOException) {
            throw this.getRuntime().newIOErrorFromException(iOException);
        }
        catch (BadDescriptorException badDescriptorException) {
            throw this.getRuntime().newErrnoEBADFError();
        }
    }

    @JRubyMethod(name={"<<"}, required=1)
    public IRubyObject op_append(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.callMethod(threadContext, "write", iRubyObject);
        return this;
    }

    @JRubyMethod(name={"fileno"}, alias={"to_i"})
    public RubyFixnum fileno() {
        return this.getRuntime().newFixnum(this.getOpenFileChecked().getMainStream().getDescriptor().getFileno());
    }

    @JRubyMethod(name={"lineno"})
    public RubyFixnum lineno() {
        return this.getRuntime().newFixnum(this.getOpenFileChecked().getLineNumber());
    }

    @JRubyMethod(name={"lineno="}, required=1)
    public RubyFixnum lineno_set(IRubyObject iRubyObject) {
        this.getOpenFileChecked().setLineNumber(RubyNumeric.fix2int(iRubyObject));
        return this.getRuntime().newFixnum(this.getOpenFileChecked().getLineNumber());
    }

    @JRubyMethod(name={"sync"})
    public RubyBoolean sync() {
        return this.getRuntime().newBoolean(this.getOpenFileChecked().getMainStream().isSync());
    }

    @JRubyMethod(name={"pid"})
    public IRubyObject pid() {
        OpenFile openFile = this.getOpenFileChecked();
        if (openFile.getProcess() == null) {
            return this.getRuntime().getNil();
        }
        int n = openFile.getProcess().hashCode();
        return this.getRuntime().newFixnum(n);
    }

    public boolean writeDataBuffered() {
        return this.openFile.getMainStream().writeDataBuffered();
    }

    @JRubyMethod(name={"pos", "tell"})
    public RubyFixnum pos() {
        try {
            return this.getRuntime().newFixnum(this.getOpenFileChecked().getMainStream().fgetpos());
        }
        catch (InvalidValueException invalidValueException) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (BadDescriptorException badDescriptorException) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (PipeException pipeException) {
            throw this.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException iOException) {
            throw this.getRuntime().newIOError(iOException.getMessage());
        }
    }

    @JRubyMethod(name={"pos="}, required=1)
    public RubyFixnum pos_set(IRubyObject iRubyObject) {
        long l = RubyNumeric.num2long(iRubyObject);
        if (l < 0L) {
            throw this.getRuntime().newSystemCallError("Negative seek offset");
        }
        OpenFile openFile = this.getOpenFileChecked();
        try {
            openFile.getMainStream().lseek(l, 0);
        }
        catch (BadDescriptorException badDescriptorException) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException invalidValueException) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException pipeException) {
            throw this.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException iOException) {
            throw this.getRuntime().newIOError(iOException.getMessage());
        }
        openFile.getMainStream().clearerr();
        return (RubyFixnum)iRubyObject;
    }

    @JRubyMethod(name={"print"}, rest=true)
    public IRubyObject print(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        if (iRubyObjectArray.length == 0) {
            iRubyObjectArray = new IRubyObject[]{threadContext.getCurrentFrame().getLastLine()};
        }
        IRubyObject iRubyObject = this.getRuntime().getGlobalVariables().get("$,");
        IRubyObject iRubyObject2 = this.getRuntime().getGlobalVariables().get("$\\");
        for (int i = 0; i < iRubyObjectArray.length; ++i) {
            if (i > 0 && !iRubyObject.isNil()) {
                this.callMethod(threadContext, "write", iRubyObject);
            }
            if (iRubyObjectArray[i].isNil()) {
                this.callMethod(threadContext, "write", this.getRuntime().newString("nil"));
                continue;
            }
            this.callMethod(threadContext, "write", iRubyObjectArray[i]);
        }
        if (!iRubyObject2.isNil()) {
            this.callMethod(threadContext, "write", iRubyObject2);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"printf"}, required=1, rest=true)
    public IRubyObject printf(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        this.callMethod(threadContext, "write", RubyKernel.sprintf(this, iRubyObjectArray));
        return this.getRuntime().getNil();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod(name={"putc"}, required=1)
    public IRubyObject putc(ThreadContext threadContext, IRubyObject iRubyObject) {
        int n;
        if (this.getRuntime().getString().isInstance(iRubyObject)) {
            String string = ((RubyString)iRubyObject).toString();
            if (string.length() <= 0) throw this.getRuntime().newTypeError("Cannot convert String to Integer");
            n = string.charAt(0);
        } else {
            n = this.getRuntime().getFixnum().isInstance(iRubyObject) ? RubyNumeric.fix2int(iRubyObject) : RubyNumeric.fix2int(iRubyObject.callMethod(threadContext, MethodIndex.TO_I, "to_i"));
        }
        try {
            this.getOpenFileChecked().getMainStream().fputc(n);
            return iRubyObject;
        }
        catch (BadDescriptorException badDescriptorException) {
            return RubyFixnum.zero(this.getRuntime());
        }
        catch (IOException iOException) {
            return RubyFixnum.zero(this.getRuntime());
        }
    }

    @JRubyMethod(name={"seek"}, required=1, optional=1)
    public RubyFixnum seek(IRubyObject[] iRubyObjectArray) {
        long l = RubyNumeric.num2long(iRubyObjectArray[0]);
        int n = 0;
        if (iRubyObjectArray.length > 1) {
            n = RubyNumeric.fix2int(iRubyObjectArray[1].convertToInteger());
        }
        OpenFile openFile = this.getOpenFileChecked();
        try {
            openFile.seek(l, n);
        }
        catch (BadDescriptorException badDescriptorException) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException invalidValueException) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException pipeException) {
            throw this.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException iOException) {
            throw this.getRuntime().newIOError(iOException.getMessage());
        }
        openFile.getMainStream().clearerr();
        return RubyFixnum.zero(this.getRuntime());
    }

    @JRubyMethod(name={"sysseek"}, required=1, optional=1)
    public RubyFixnum sysseek(IRubyObject[] iRubyObjectArray) {
        long l;
        long l2 = RubyNumeric.num2long(iRubyObjectArray[0]);
        int n = 0;
        if (iRubyObjectArray.length > 1) {
            n = RubyNumeric.fix2int(iRubyObjectArray[1].convertToInteger());
        }
        OpenFile openFile = this.getOpenFileChecked();
        try {
            if (openFile.isReadable() && openFile.isReadBuffered()) {
                throw this.getRuntime().newIOError("sysseek for buffered IO");
            }
            if (openFile.isWritable() && openFile.isWriteBuffered()) {
                this.getRuntime().getWarnings().warn(IRubyWarnings.ID.SYSSEEK_BUFFERED_IO, "sysseek for buffered IO", new Object[0]);
            }
            l = openFile.getMainStream().getDescriptor().lseek(l2, n);
        }
        catch (BadDescriptorException badDescriptorException) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException invalidValueException) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException pipeException) {
            throw this.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException iOException) {
            throw this.getRuntime().newIOError(iOException.getMessage());
        }
        openFile.getMainStream().clearerr();
        return this.getRuntime().newFixnum(l);
    }

    @JRubyMethod(name={"rewind"})
    public RubyFixnum rewind() {
        OpenFile openFile = this.getOpenFileChecked();
        try {
            openFile.getMainStream().lseek(0L, 0);
            openFile.getMainStream().clearerr();
        }
        catch (BadDescriptorException badDescriptorException) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException invalidValueException) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException pipeException) {
            throw this.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException iOException) {
            throw this.getRuntime().newIOError(iOException.getMessage());
        }
        openFile.setLineNumber(0);
        return RubyFixnum.zero(this.getRuntime());
    }

    @JRubyMethod(name={"fsync"})
    public RubyFixnum fsync() {
        try {
            OpenFile openFile = this.getOpenFileChecked();
            openFile.checkWritable(this.getRuntime());
            openFile.getWriteStream().sync();
        }
        catch (InvalidValueException invalidValueException) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException pipeException) {
            throw this.getRuntime().newErrnoEPIPEError();
        }
        catch (IOException iOException) {
            throw this.getRuntime().newIOError(iOException.getMessage());
        }
        catch (BadDescriptorException badDescriptorException) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        return RubyFixnum.zero(this.getRuntime());
    }

    @JRubyMethod(name={"sync="}, required=1)
    public IRubyObject sync_set(IRubyObject iRubyObject) {
        this.getOpenFileChecked().setSync(iRubyObject.isTrue());
        this.getOpenFileChecked().getMainStream().setSync(iRubyObject.isTrue());
        return this;
    }

    @JRubyMethod(name={"eof?", "eof"})
    public RubyBoolean eof_p() {
        try {
            OpenFile openFile = this.getOpenFileChecked();
            openFile.checkReadable(this.getRuntime());
            if (openFile.getMainStream().feof()) {
                return this.getRuntime().getTrue();
            }
            if (openFile.getMainStream().readDataBuffered()) {
                return this.getRuntime().getFalse();
            }
            this.readCheck(openFile.getMainStream());
            openFile.getMainStream().clearerr();
            int n = openFile.getMainStream().fgetc();
            if (n != -1) {
                openFile.getMainStream().ungetc(n);
                return this.getRuntime().getFalse();
            }
            openFile.checkClosed(this.getRuntime());
            openFile.getMainStream().clearerr();
            return this.getRuntime().getTrue();
        }
        catch (PipeException pipeException) {
            throw this.getRuntime().newErrnoEPIPEError();
        }
        catch (InvalidValueException invalidValueException) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (BadDescriptorException badDescriptorException) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (IOException iOException) {
            throw this.getRuntime().newIOError(iOException.getMessage());
        }
    }

    @JRubyMethod(name={"tty?", "isatty"})
    public RubyBoolean tty_p() {
        return this.getRuntime().newBoolean(this.getRuntime().getPosix().isatty(this.getOpenFileChecked().getMainStream().getDescriptor().getFileDescriptor()));
    }

    @JRubyMethod(name={"initialize_copy"}, required=1)
    public IRubyObject initialize_copy(IRubyObject iRubyObject) {
        if (this == iRubyObject) {
            return this;
        }
        RubyIO rubyIO = (RubyIO)TypeConverter.convertToTypeWithCheck(iRubyObject, this.getRuntime().getIO(), MethodIndex.TO_IO, "to_io");
        OpenFile openFile = rubyIO.getOpenFileChecked();
        OpenFile openFile2 = this.openFile;
        try {
            openFile.checkClosed(this.getRuntime());
            if (openFile.getPipeStream() != null) {
                openFile.getPipeStream().fflush();
                openFile.getMainStream().lseek(0L, 1);
            } else if (openFile.isWritable()) {
                openFile.getMainStream().fflush();
            } else {
                openFile.getMainStream().lseek(0L, 1);
            }
            openFile2.setMode(openFile.getMode());
            openFile2.setProcess(openFile.getProcess());
            openFile2.setLineNumber(openFile.getLineNumber());
            openFile2.setPath(openFile.getPath());
            openFile2.setFinalizer(openFile.getFinalizer());
            ModeFlags modeFlags = openFile2.isReadable() ? (openFile2.isWritable() ? (openFile2.getPipeStream() != null ? new ModeFlags(0L) : new ModeFlags(2L)) : new ModeFlags(0L)) : (openFile2.isWritable() ? new ModeFlags(1L) : openFile.getMainStream().getModes());
            ChannelDescriptor channelDescriptor = openFile.getMainStream().getDescriptor().dup();
            openFile2.setMainStream(ChannelStream.fdopen(this.getRuntime(), channelDescriptor, modeFlags));
            this.registerDescriptor(openFile2.getMainStream().getDescriptor());
        }
        catch (IOException iOException) {
            throw this.getRuntime().newIOError("could not init copy: " + iOException);
        }
        catch (BadDescriptorException badDescriptorException) {
            throw this.getRuntime().newIOError("could not init copy: " + badDescriptorException);
        }
        catch (PipeException pipeException) {
            throw this.getRuntime().newIOError("could not init copy: " + pipeException);
        }
        catch (InvalidValueException invalidValueException) {
            throw this.getRuntime().newIOError("could not init copy: " + invalidValueException);
        }
        return this;
    }

    @JRubyMethod(name={"closed?"})
    public RubyBoolean closed_p() {
        if (this.openFile.getMainStream() == null && this.openFile.getPipeStream() == null) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"close"})
    public IRubyObject close() {
        if (this.getRuntime().getSafeLevel() >= 4 && this.isTaint()) {
            throw this.getRuntime().newSecurityError("Insecure: can't close");
        }
        this.openFile.checkClosed(this.getRuntime());
        return this.close2();
    }

    protected IRubyObject close2() {
        if (this.openFile == null) {
            return this.getRuntime().getNil();
        }
        if (this.openFile.getPipeStream() != null) {
            ChannelDescriptor channelDescriptor = this.openFile.getPipeStream().getDescriptor();
        } else {
            if (this.openFile.getMainStream() == null) {
                return this.getRuntime().getNil();
            }
            Object var2_2 = null;
        }
        ChannelDescriptor channelDescriptor = this.openFile.getMainStream().getDescriptor();
        this.openFile.cleanup(this.getRuntime(), true);
        if (this.openFile.getProcess() != null) {
            try {
                RubyProcess.RubyStatus rubyStatus = RubyProcess.RubyStatus.newProcessStatus(this.getRuntime(), this.openFile.getProcess().waitFor());
                this.getRuntime().getGlobalVariables().set("$?", rubyStatus);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"close_write"})
    public IRubyObject close_write() throws BadDescriptorException {
        try {
            if (this.getRuntime().getSafeLevel() >= 4 && this.isTaint()) {
                throw this.getRuntime().newSecurityError("Insecure: can't close");
            }
            OpenFile openFile = this.getOpenFileChecked();
            if (openFile.getPipeStream() == null && openFile.isReadable()) {
                throw this.getRuntime().newIOError("closing non-duplex IO for writing");
            }
            if (openFile.getPipeStream() == null) {
                this.close();
            } else {
                openFile.getPipeStream().fclose();
                openFile.setPipeStream(null);
                openFile.setMode(openFile.getMode() & 0xFFFFFFFD);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    @JRubyMethod(name={"close_read"})
    public IRubyObject close_read() throws BadDescriptorException {
        try {
            if (this.getRuntime().getSafeLevel() >= 4 && this.isTaint()) {
                throw this.getRuntime().newSecurityError("Insecure: can't close");
            }
            OpenFile openFile = this.getOpenFileChecked();
            if (openFile.getPipeStream() == null && openFile.isWritable()) {
                throw this.getRuntime().newIOError("closing non-duplex IO for reading");
            }
            if (openFile.getPipeStream() == null) {
                this.close();
            } else {
                openFile.getMainStream().fclose();
                openFile.setMode(openFile.getMode() & 0xFFFFFFFE);
                openFile.setMainStream(openFile.getPipeStream());
                openFile.setPipeStream(null);
            }
        }
        catch (IOException iOException) {
            throw this.getRuntime().newIOErrorFromException(iOException);
        }
        return this;
    }

    @JRubyMethod(name={"flush"})
    public RubyIO flush() {
        try {
            this.getOpenFileChecked().getWriteStream().fflush();
        }
        catch (BadDescriptorException badDescriptorException) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (IOException iOException) {
            throw this.getRuntime().newIOError(iOException.getMessage());
        }
        return this;
    }

    @JRubyMethod(name={"gets"}, optional=1)
    public IRubyObject gets(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        ByteList byteList = this.getSeparatorForGets(iRubyObjectArray);
        IRubyObject iRubyObject = this.getline(byteList);
        if (!iRubyObject.isNil()) {
            threadContext.getCurrentFrame().setLastLine(iRubyObject);
        }
        return iRubyObject;
    }

    public boolean getBlocking() {
        return ((ChannelStream)this.openFile.getMainStream()).isBlocking();
    }

    @JRubyMethod(name={"fcntl"}, required=2)
    public IRubyObject fcntl(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return this.ctl(iRubyObject, iRubyObject2);
    }

    @JRubyMethod(name={"ioctl"}, required=1, optional=1)
    public IRubyObject ioctl(IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject = iRubyObjectArray[0];
        IRubyObject iRubyObject2 = iRubyObjectArray.length == 2 ? iRubyObjectArray[1] : this.getRuntime().getNil();
        return this.ctl(iRubyObject, iRubyObject2);
    }

    public IRubyObject ctl(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        long l = iRubyObject.convertToInteger().getLongValue();
        long l2 = 0L;
        if (iRubyObject2.isNil() || iRubyObject2 == this.getRuntime().getFalse()) {
            l2 = 0L;
        } else if (iRubyObject2 instanceof RubyFixnum) {
            l2 = RubyFixnum.fix2long(iRubyObject2);
        } else if (iRubyObject2 == this.getRuntime().getTrue()) {
            l2 = 1L;
        } else {
            throw this.getRuntime().newNotImplementedError("JRuby does not support string for second fcntl/ioctl argument yet");
        }
        OpenFile openFile = this.getOpenFileChecked();
        if (l == 1L) {
            boolean bl = true;
            if ((l2 & 4L) == 4L) {
                bl = false;
            }
            try {
                openFile.getMainStream().setBlocking(bl);
            }
            catch (IOException iOException) {
                throw this.getRuntime().newIOError(iOException.getMessage());
            }
        } else {
            throw this.getRuntime().newNotImplementedError("JRuby only supports F_SETFL for fcntl/ioctl currently");
        }
        return this.getRuntime().newFixnum(0L);
    }

    @JRubyMethod(name={"puts"}, rest=true)
    public IRubyObject puts(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        assert (this.getRuntime().getGlobalVariables().getDefaultSeparator() instanceof RubyString);
        RubyString rubyString = (RubyString)this.getRuntime().getGlobalVariables().getDefaultSeparator();
        if (iRubyObjectArray.length == 0) {
            this.write(threadContext, rubyString.getByteList());
            return this.getRuntime().getNil();
        }
        for (int i = 0; i < iRubyObjectArray.length; ++i) {
            ByteList byteList;
            if (iRubyObjectArray[i].isNil()) {
                byteList = NIL_BYTELIST;
            } else if (this.getRuntime().isInspecting(iRubyObjectArray[i])) {
                byteList = RECURSIVE_BYTELIST;
            } else {
                if (iRubyObjectArray[i] instanceof RubyArray) {
                    this.inspectPuts(threadContext, (RubyArray)iRubyObjectArray[i]);
                    continue;
                }
                byteList = iRubyObjectArray[i].asString().getByteList();
            }
            this.write(threadContext, byteList);
            if (byteList.length() != 0 && byteList.endsWith(rubyString.getByteList())) continue;
            this.write(threadContext, rubyString.getByteList());
        }
        return this.getRuntime().getNil();
    }

    protected void write(ThreadContext threadContext, ByteList byteList) {
        this.callMethod(threadContext, "write", this.getRuntime().newStringShared(byteList));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject inspectPuts(ThreadContext threadContext, RubyArray rubyArray) {
        try {
            this.getRuntime().registerInspecting(rubyArray);
            IRubyObject iRubyObject = this.puts(threadContext, rubyArray.toJavaArray());
            return iRubyObject;
        }
        finally {
            this.getRuntime().unregisterInspecting(rubyArray);
        }
    }

    @JRubyMethod(name={"readline"}, optional=1)
    public IRubyObject readline(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject = this.gets(threadContext, iRubyObjectArray);
        if (iRubyObject.isNil()) {
            throw this.getRuntime().newEOFError();
        }
        return iRubyObject;
    }

    @JRubyMethod(name={"getc"})
    public IRubyObject getc() {
        try {
            OpenFile openFile = this.getOpenFileChecked();
            openFile.checkReadable(this.getRuntime());
            Stream stream = openFile.getMainStream();
            this.readCheck(stream);
            stream.clearerr();
            int n = openFile.getMainStream().fgetc();
            if (n == -1) {
                return this.getRuntime().getNil();
            }
            return this.getRuntime().newFixnum(n);
        }
        catch (PipeException pipeException) {
            throw this.getRuntime().newErrnoEPIPEError();
        }
        catch (InvalidValueException invalidValueException) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (BadDescriptorException badDescriptorException) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (EOFException eOFException) {
            throw this.getRuntime().newEOFError();
        }
        catch (IOException iOException) {
            throw this.getRuntime().newIOError(iOException.getMessage());
        }
    }

    private void readCheck(Stream stream) {
        if (!stream.readDataBuffered()) {
            this.openFile.checkClosed(this.getRuntime());
        }
    }

    @JRubyMethod(name={"ungetc"}, required=1)
    public IRubyObject ungetc(IRubyObject iRubyObject) {
        int n = RubyNumeric.fix2int(iRubyObject);
        OpenFile openFile = this.getOpenFileChecked();
        if (!openFile.isReadBuffered()) {
            throw this.getRuntime().newIOError("unread stream");
        }
        try {
            openFile.checkReadable(this.getRuntime());
            if (openFile.getMainStream().ungetc(n) == -1 && n != -1) {
                throw this.getRuntime().newIOError("ungetc failed");
            }
        }
        catch (PipeException pipeException) {
            throw this.getRuntime().newErrnoEPIPEError();
        }
        catch (InvalidValueException invalidValueException) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (BadDescriptorException badDescriptorException) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (EOFException eOFException) {
            throw this.getRuntime().newEOFError();
        }
        catch (IOException iOException) {
            throw this.getRuntime().newIOError(iOException.getMessage());
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"readpartial"}, required=1, optional=1)
    public IRubyObject readpartial(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        if (!(this.openFile.getMainStream() instanceof ChannelStream)) {
            throw this.getRuntime().newNotImplementedError("readpartial only works with Nio based handlers");
        }
        try {
            ByteList byteList = ((ChannelStream)this.openFile.getMainStream()).readpartial(RubyNumeric.fix2int(iRubyObjectArray[0]));
            RubyString rubyString = RubyString.newString(this.getRuntime(), byteList == null ? new ByteList(ByteList.NULL_ARRAY) : byteList);
            if (iRubyObjectArray.length > 1) {
                iRubyObjectArray[1].callMethod(threadContext, MethodIndex.OP_LSHIFT, "<<", rubyString);
                return iRubyObjectArray[1];
            }
            return rubyString;
        }
        catch (BadDescriptorException badDescriptorException) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (EOFException eOFException) {
            return this.getRuntime().getNil();
        }
        catch (IOException iOException) {
            throw this.getRuntime().newIOError(iOException.getMessage());
        }
    }

    @JRubyMethod(name={"sysread"}, required=1, optional=1)
    public IRubyObject sysread(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        int n = (int)RubyNumeric.num2long(iRubyObjectArray[0]);
        if (n < 0) {
            throw this.getRuntime().newArgumentError("Negative size");
        }
        try {
            RubyString rubyString;
            if (iRubyObjectArray.length == 1 || iRubyObjectArray[1].isNil()) {
                if (n == 0) {
                    RubyString rubyString2 = RubyString.newStringShared(this.getRuntime(), ByteList.EMPTY_BYTELIST);
                    return rubyString2;
                }
                ByteList byteList = new ByteList(n);
                rubyString = RubyString.newString(this.getRuntime(), byteList);
            } else {
                rubyString = iRubyObjectArray[1].convertToString();
                rubyString.modify(n);
                if (n == 0) {
                    RubyString rubyString3 = rubyString;
                    return rubyString3;
                }
                ByteList byteList = rubyString.getByteList();
            }
            OpenFile openFile = this.getOpenFileChecked();
            openFile.checkReadable(this.getRuntime());
            if (openFile.getMainStream().readDataBuffered()) {
                throw this.getRuntime().newIOError("sysread for buffered IO");
            }
            threadContext.getThread().beforeBlockingCall();
            openFile.checkClosed(this.getRuntime());
            int n2 = openFile.getMainStream().getDescriptor().read(n, rubyString.getByteList());
            if (n2 == -1 || n2 == 0 && n > 0) {
                throw this.getRuntime().newEOFError();
            }
            rubyString.setTaint(true);
            RubyString rubyString4 = rubyString;
            return rubyString4;
        }
        catch (BadDescriptorException badDescriptorException) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException invalidValueException) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException pipeException) {
            throw this.getRuntime().newErrnoEPIPEError();
        }
        catch (EOFException eOFException) {
            throw this.getRuntime().newEOFError();
        }
        catch (IOException iOException) {
            if ("File not open".equals(iOException.getMessage())) {
                throw this.getRuntime().newIOError(iOException.getMessage());
            }
            throw this.getRuntime().newSystemCallError(iOException.getMessage());
        }
        finally {
            threadContext.getThread().afterBlockingCall();
        }
    }

    @JRubyMethod(name={"read_nonblock"}, required=1, optional=1)
    public IRubyObject read_nonblock(IRubyObject[] iRubyObjectArray) {
        return this.read(iRubyObjectArray);
    }

    @JRubyMethod(name={"read"}, optional=2)
    public IRubyObject read(IRubyObject[] iRubyObjectArray) {
        int n = iRubyObjectArray.length;
        OpenFile openFile = this.getOpenFileChecked();
        if (n == 0 || iRubyObjectArray[0].isNil()) {
            try {
                openFile.checkReadable(this.getRuntime());
                if (iRubyObjectArray.length == 2) {
                    return this.readAll(iRubyObjectArray[1]);
                }
                return this.readAll(this.getRuntime().getNil());
            }
            catch (PipeException pipeException) {
                throw this.getRuntime().newErrnoEPIPEError();
            }
            catch (InvalidValueException invalidValueException) {
                throw this.getRuntime().newErrnoEINVALError();
            }
            catch (EOFException eOFException) {
                throw this.getRuntime().newEOFError();
            }
            catch (IOException iOException) {
                throw this.getRuntime().newIOErrorFromException(iOException);
            }
            catch (BadDescriptorException badDescriptorException) {
                throw this.getRuntime().newErrnoEBADFError();
            }
        }
        int n2 = RubyNumeric.num2int(iRubyObjectArray[0]);
        if (n2 < 0) {
            throw this.getRuntime().newArgumentError("negative length " + n2 + " given");
        }
        RubyString rubyString = null;
        if (iRubyObjectArray.length != 1 && !iRubyObjectArray[1].isNil()) {
            rubyString = iRubyObjectArray[1].convertToString();
            rubyString.modify(n2);
            if (n2 == 0) {
                return rubyString;
            }
        }
        try {
            openFile.checkReadable(this.getRuntime());
            if (openFile.getMainStream().feof()) {
                return this.getRuntime().getNil();
            }
            this.readCheck(openFile.getMainStream());
            ByteList byteList = openFile.getMainStream().fread(n2);
            if (byteList == null || byteList.length() == 0) {
                if (openFile.getMainStream() == null) {
                    return this.getRuntime().getNil();
                }
                if (openFile.getMainStream().feof()) {
                    if (rubyString != null) {
                        rubyString.setValue(ByteList.EMPTY_BYTELIST.dup());
                    }
                    return this.getRuntime().getNil();
                }
                if (n2 > 0) {
                    throw this.getRuntime().newEOFError();
                }
            }
            if (rubyString == null) {
                rubyString = byteList == null ? this.getRuntime().newString() : RubyString.newString(this.getRuntime(), byteList);
            } else if (byteList == null) {
                rubyString.setValue(ByteList.EMPTY_BYTELIST.dup());
            } else {
                rubyString.setValue(byteList);
            }
            rubyString.setTaint(true);
            return rubyString;
        }
        catch (EOFException eOFException) {
            throw this.getRuntime().newEOFError();
        }
        catch (PipeException pipeException) {
            throw this.getRuntime().newErrnoEPIPEError();
        }
        catch (InvalidValueException invalidValueException) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (IOException iOException) {
            throw this.getRuntime().newIOErrorFromException(iOException);
        }
        catch (BadDescriptorException badDescriptorException) {
            throw this.getRuntime().newErrnoEBADFError();
        }
    }

    protected IRubyObject readAll(IRubyObject iRubyObject) throws BadDescriptorException, EOFException, IOException {
        RubyString rubyString = null;
        if (iRubyObject instanceof RubyString) {
            rubyString = (RubyString)iRubyObject;
        }
        if (this.openFile.getMainStream().readDataBuffered()) {
            this.openFile.checkClosed(this.getRuntime());
        }
        ByteList byteList = this.openFile.getMainStream().readall();
        if (rubyString == null) {
            rubyString = byteList == null ? RubyString.newStringShared(this.getRuntime(), ByteList.EMPTY_BYTELIST) : RubyString.newString(this.getRuntime(), byteList);
        } else if (byteList == null) {
            rubyString.setValue(ByteList.EMPTY_BYTELIST.dup());
        } else {
            rubyString.setValue(byteList);
        }
        rubyString.taint();
        return rubyString;
    }

    @JRubyMethod(name={"readchar"})
    public IRubyObject readchar() {
        IRubyObject iRubyObject = this.getc();
        if (iRubyObject.isNil()) {
            throw this.getRuntime().newEOFError();
        }
        return iRubyObject;
    }

    @JRubyMethod
    public IRubyObject stat() {
        this.openFile.checkClosed(this.getRuntime());
        return this.getRuntime().newFileStat(this.getOpenFileChecked().getMainStream().getDescriptor().getFileDescriptor());
    }

    @JRubyMethod(name={"each_byte"}, frame=true)
    public IRubyObject each_byte(ThreadContext threadContext, Block block) {
        try {
            Ruby ruby = this.getRuntime();
            OpenFile openFile = this.getOpenFileChecked();
            while (true) {
                openFile.checkReadable(ruby);
                int n = openFile.getMainStream().fgetc();
                if (n == -1) break;
                assert (n < 256);
                block.yield(threadContext, this.getRuntime().newFixnum(n));
            }
            return this;
        }
        catch (PipeException pipeException) {
            throw this.getRuntime().newErrnoEPIPEError();
        }
        catch (InvalidValueException invalidValueException) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (BadDescriptorException badDescriptorException) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (EOFException eOFException) {
            return this.getRuntime().getNil();
        }
        catch (IOException iOException) {
            throw this.getRuntime().newIOError(iOException.getMessage());
        }
    }

    @JRubyMethod(name={"each_line", "each"}, optional=1, frame=true)
    public RubyIO each_line(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        ByteList byteList = this.getSeparatorForGets(iRubyObjectArray);
        IRubyObject iRubyObject = this.getline(byteList);
        while (!iRubyObject.isNil()) {
            block.yield(threadContext, iRubyObject);
            iRubyObject = this.getline(byteList);
        }
        return this;
    }

    @JRubyMethod(name={"readlines"}, optional=1)
    public RubyArray readlines(IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject;
        ByteList byteList;
        if (iRubyObjectArray.length > 0) {
            if (!this.getRuntime().getNilClass().isInstance(iRubyObjectArray[0]) && !this.getRuntime().getString().isInstance(iRubyObjectArray[0])) {
                throw this.getRuntime().newTypeError(iRubyObjectArray[0], this.getRuntime().getString());
            }
            byteList = this.getSeparatorForGets(new IRubyObject[]{iRubyObjectArray[0]});
        } else {
            byteList = this.getSeparatorForGets(IRubyObject.NULL_ARRAY);
        }
        RubyArray rubyArray = this.getRuntime().newArray();
        while (!(iRubyObject = this.getline(byteList)).isNil()) {
            rubyArray.append(iRubyObject);
        }
        return rubyArray;
    }

    @JRubyMethod(name={"to_io"})
    public RubyIO to_io() {
        return this;
    }

    public String toString() {
        return "RubyIO(" + this.openFile.getMode() + ", " + this.openFile.getMainStream().getDescriptor().getFileno() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"foreach"}, required=1, optional=1, frame=true, meta=true)
    public static IRubyObject foreach(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        Ruby ruby = iRubyObject.getRuntime();
        int n = iRubyObjectArray.length;
        RubyString rubyString = iRubyObjectArray[0].convertToString();
        ruby.checkSafeString(rubyString);
        ByteList byteList = RubyIO.getSeparatorFromArgs(ruby, iRubyObjectArray, 1);
        RubyIO rubyIO = (RubyIO)RubyFile.open(threadContext, ruby.getFile(), new IRubyObject[]{rubyString}, Block.NULL_BLOCK);
        if (!rubyIO.isNil()) {
            try {
                IRubyObject iRubyObject2 = rubyIO.getline(byteList);
                while (!iRubyObject2.isNil()) {
                    block.yield(threadContext, iRubyObject2);
                    iRubyObject2 = rubyIO.getline(byteList);
                }
            }
            finally {
                rubyIO.close();
            }
        }
        return ruby.getNil();
    }

    private static RubyIO registerSelect(ThreadContext threadContext, Selector selector, IRubyObject iRubyObject, int n) throws IOException {
        RubyIO rubyIO;
        if (!(iRubyObject instanceof RubyIO)) {
            if (!iRubyObject.respondsTo("to_io")) {
                return null;
            }
            rubyIO = (RubyIO)iRubyObject.callMethod(threadContext, "to_io");
        } else {
            rubyIO = (RubyIO)iRubyObject;
        }
        Channel channel = rubyIO.getChannel();
        if (channel == null || !(channel instanceof SelectableChannel)) {
            return null;
        }
        ((SelectableChannel)channel).configureBlocking(false);
        int n2 = ((SelectableChannel)channel).validOps() & n;
        SelectionKey selectionKey = ((SelectableChannel)channel).keyFor(selector);
        if (selectionKey == null) {
            ((SelectableChannel)channel).register(selector, n2, iRubyObject);
        } else {
            selectionKey.interestOps(selectionKey.interestOps() | n2);
        }
        return rubyIO;
    }

    @JRubyMethod(name={"select"}, required=1, optional=3, meta=true)
    public static IRubyObject select(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        return RubyIO.select_static(threadContext, iRubyObject.getRuntime(), iRubyObjectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject select_static(ThreadContext threadContext, Ruby ruby, IRubyObject[] iRubyObjectArray) {
        try {
            Cloneable cloneable;
            boolean bl = false;
            HashSet<IRubyObject> hashSet = new HashSet<IRubyObject>();
            Selector selector = Selector.open();
            if (!iRubyObjectArray[0].isNil()) {
                bl = true;
                for (IRubyObject iRubyObject : ((RubyArray)iRubyObjectArray[0]).getList()) {
                    cloneable = RubyIO.registerSelect(threadContext, selector, iRubyObject, 17);
                    if (cloneable == null || !((RubyIO)cloneable).writeDataBuffered()) continue;
                    hashSet.add(iRubyObject);
                }
            }
            if (iRubyObjectArray.length > 1 && !iRubyObjectArray[1].isNil()) {
                bl = true;
                for (IRubyObject iRubyObject : ((RubyArray)iRubyObjectArray[1]).getList()) {
                    RubyIO.registerSelect(threadContext, selector, iRubyObject, 4);
                }
            }
            if (iRubyObjectArray.length > 2 && !iRubyObjectArray[2].isNil()) {
                bl = true;
            }
            long l = 0L;
            if (iRubyObjectArray.length > 3 && !iRubyObjectArray[3].isNil() && (l = iRubyObjectArray[3] instanceof RubyFloat ? Math.round(((RubyFloat)iRubyObjectArray[3]).getDoubleValue() * 1000.0) : Math.round(((RubyFixnum)iRubyObjectArray[3]).getDoubleValue() * 1000.0)) < 0L) {
                throw ruby.newArgumentError("negative timeout given");
            }
            if (!bl) {
                return ruby.getNil();
            }
            if (hashSet.isEmpty()) {
                if (iRubyObjectArray.length > 3) {
                    if (l == 0L) {
                        selector.selectNow();
                    } else {
                        selector.select(l);
                    }
                } else {
                    selector.select();
                }
            } else {
                selector.selectNow();
            }
            cloneable = new ArrayList();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList arrayList2 = new ArrayList();
            for (SelectionKey selectionKey : selector.selectedKeys()) {
                if ((selectionKey.interestOps() & selectionKey.readyOps() & 0x19) != 0) {
                    cloneable.add(selectionKey.attachment());
                    hashSet.remove(selectionKey.attachment());
                }
                if ((selectionKey.interestOps() & selectionKey.readyOps() & 4) == 0) continue;
                arrayList.add(selectionKey.attachment());
            }
            cloneable.addAll(hashSet);
            for (SelectionKey selectionKey : selector.keys()) {
                SelectableChannel selectableChannel = selectionKey.channel();
                Object object = selectableChannel.blockingLock();
                synchronized (object) {
                    boolean bl2 = ((RubyIO)selectionKey.attachment()).getBlocking();
                    selectionKey.cancel();
                    selectableChannel.configureBlocking(bl2);
                }
            }
            selector.close();
            if (cloneable.size() == 0 && arrayList.size() == 0 && arrayList2.size() == 0) {
                return ruby.getNil();
            }
            ArrayList arrayList3 = new ArrayList();
            arrayList3.add(RubyArray.newArray(ruby, (Collection)((Object)cloneable)));
            arrayList3.add(RubyArray.newArray(ruby, arrayList));
            arrayList3.add(RubyArray.newArray(ruby, arrayList2));
            return RubyArray.newArray(ruby, arrayList3);
        }
        catch (IOException iOException) {
            throw ruby.newIOError(iOException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"read"}, required=1, optional=2, meta=true)
    public static IRubyObject read(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        IRubyObject[] iRubyObjectArray2 = new IRubyObject[]{iRubyObjectArray[0]};
        RubyIO rubyIO = (RubyIO)RubyKernel.open(threadContext, iRubyObject, iRubyObjectArray2, block);
        IRubyObject[] iRubyObjectArray3 = iRubyObjectArray.length >= 2 && !iRubyObjectArray[1].isNil() ? new IRubyObject[]{iRubyObjectArray[1].convertToInteger()} : new IRubyObject[]{};
        try {
            if (iRubyObjectArray.length == 3 && !iRubyObjectArray[2].isNil()) {
                rubyIO.seek(new IRubyObject[]{iRubyObjectArray[2].convertToInteger()});
            }
            IRubyObject iRubyObject2 = rubyIO.read(iRubyObjectArray3);
            return iRubyObject2;
        }
        finally {
            rubyIO.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"readlines"}, required=1, optional=1, meta=true)
    public static RubyArray readlines(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        IRubyObject[] iRubyObjectArray2;
        int n = iRubyObjectArray.length;
        IRubyObject[] iRubyObjectArray3 = new IRubyObject[]{iRubyObjectArray[0]};
        if (n >= 2) {
            IRubyObject[] iRubyObjectArray4 = new IRubyObject[1];
            iRubyObjectArray2 = iRubyObjectArray4;
            iRubyObjectArray4[0] = iRubyObjectArray[1];
        } else {
            iRubyObjectArray2 = IRubyObject.NULL_ARRAY;
        }
        IRubyObject[] iRubyObjectArray5 = iRubyObjectArray2;
        RubyIO rubyIO = (RubyIO)RubyKernel.open(threadContext, iRubyObject, iRubyObjectArray3, block);
        try {
            RubyArray rubyArray = rubyIO.readlines(iRubyObjectArray5);
            return rubyArray;
        }
        finally {
            rubyIO.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod(name={"popen"}, required=1, optional=1, meta=true)
    public static IRubyObject popen(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        IRubyObject iRubyObject2;
        Process process;
        Ruby ruby;
        block9: {
            ruby = iRubyObject.getRuntime();
            RubyString rubyString = iRubyObjectArray[0].convertToString();
            ruby.checkSafeString(rubyString);
            if ("-".equals(((Object)rubyString).toString())) {
                throw iRubyObject.getRuntime().newNotImplementedError("popen(\"-\") is unimplemented");
            }
            int n = iRubyObjectArray.length == 1 ? 0 : (iRubyObjectArray[1] instanceof RubyFixnum ? RubyFixnum.num2int(iRubyObjectArray[1]) : RubyIO.getIOModesIntFromString(ruby, iRubyObjectArray[1].convertToString().toString()));
            ModeFlags modeFlags = new ModeFlags(n);
            process = ShellLauncher.popen(ruby, rubyString, modeFlags);
            RubyIO rubyIO = new RubyIO(ruby, process, modeFlags);
            if (!block.isGiven()) return rubyIO;
            try {
                iRubyObject2 = block.yield(threadContext, rubyIO);
                if (!rubyIO.openFile.isOpen()) break block9;
                rubyIO.close();
            }
            catch (Throwable throwable) {
                try {
                    if (rubyIO.openFile.isOpen()) {
                        rubyIO.close();
                    }
                    ruby.getGlobalVariables().set("$?", RubyProcess.RubyStatus.newProcessStatus(ruby, process.waitFor() * 256));
                    throw throwable;
                }
                catch (InvalidValueException invalidValueException) {
                    throw ruby.newErrnoEINVALError();
                }
                catch (IOException iOException) {
                    throw ruby.newIOErrorFromException(iOException);
                }
                catch (InterruptedException interruptedException) {
                    throw ruby.newThreadError("unexpected interrupt");
                }
            }
        }
        ruby.getGlobalVariables().set("$?", RubyProcess.RubyStatus.newProcessStatus(ruby, process.waitFor() * 256));
        return iRubyObject2;
    }

    @JRubyMethod(name={"pipe"}, meta=true)
    public static IRubyObject pipe(IRubyObject iRubyObject) throws Exception {
        Ruby ruby = iRubyObject.getRuntime();
        Pipe pipe = Pipe.open();
        RubyIO rubyIO = new RubyIO(ruby, pipe.source());
        RubyIO rubyIO2 = new RubyIO(ruby, pipe.sink());
        rubyIO2.openFile.getMainStream().setSync(true);
        return ruby.newArrayNoCopy(new IRubyObject[]{rubyIO, rubyIO2});
    }
}

