/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyDir;
import org.jruby.RubyFileTest;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.posix.util.Platform;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Dir;
import org.jruby.util.JRubyFile;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.BadDescriptorException;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.ChannelStream;
import org.jruby.util.io.DirectoryAsFileException;
import org.jruby.util.io.FileExistsException;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.OpenFile;
import org.jruby.util.io.PipeException;
import org.jruby.util.io.Stream;

public class RubyFile
extends RubyIO {
    private static final long serialVersionUID = 1L;
    public static final int LOCK_SH = 1;
    public static final int LOCK_EX = 2;
    public static final int LOCK_NB = 4;
    public static final int LOCK_UN = 8;
    private static final int FNM_NOESCAPE = 1;
    private static final int FNM_PATHNAME = 2;
    private static final int FNM_DOTMATCH = 4;
    private static final int FNM_CASEFOLD = 8;
    protected String path;
    private FileLock currentLock;
    private static ObjectAllocator FILE_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            RubyFile rubyFile = new RubyFile(ruby, rubyClass);
            rubyFile.setMetaClass(rubyClass);
            return rubyFile;
        }
    };

    private static boolean startsWithDriveLetterOnWindows(String string) {
        return string != null && Platform.IS_WINDOWS && string.length() > 1 && RubyFile.isWindowsDriveLetter(string.charAt(0)) && string.charAt(1) == ':';
    }

    static String adjustRootPathOnWindows(Ruby ruby, String string, String string2) {
        if (string == null) {
            return string;
        }
        if (Platform.IS_WINDOWS) {
            if (string.startsWith("/") || string.startsWith("\\")) {
                if (string.length() > 1 && (string.charAt(1) == '/' || string.charAt(1) == '\\')) {
                    return string;
                }
                if (!RubyFile.startsWithDriveLetterOnWindows(string2)) {
                    string2 = ruby.getCurrentDirectory();
                }
                if (string2.length() >= 2) {
                    string = string2.substring(0, 2) + string;
                }
            } else if (RubyFile.startsWithDriveLetterOnWindows(string) && string.length() == 2) {
                string = string + "/";
            }
        }
        return string;
    }

    public RubyFile(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public RubyFile(Ruby ruby, String string, final Reader reader) {
        this(ruby, string, new InputStream(){

            public int read() throws IOException {
                return reader.read();
            }
        });
    }

    public RubyFile(Ruby ruby, String string, InputStream inputStream) {
        super(ruby, ruby.getFile());
        this.path = string;
        try {
            this.openFile.setMainStream(new ChannelStream(ruby, new ChannelDescriptor(Channels.newChannel(inputStream), RubyFile.getNewFileno(), new FileDescriptor())));
        }
        catch (InvalidValueException invalidValueException) {
            throw ruby.newErrnoEINVALError();
        }
        this.openFile.setMode(this.openFile.getMainStream().getModes().getOpenFileFlags());
        this.registerDescriptor(this.openFile.getMainStream().getDescriptor());
    }

    public static RubyClass createFileClass(Ruby ruby) {
        RubyString rubyString;
        RubyClass rubyClass = ruby.defineClass("File", ruby.getIO(), FILE_ALLOCATOR);
        ruby.setFile(rubyClass);
        CallbackFactory callbackFactory = ruby.callbackFactory(RubyFile.class);
        RubyString rubyString2 = ruby.newString("/");
        rubyClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject iRubyObject, RubyModule rubyModule) {
                return iRubyObject instanceof RubyFile;
            }
        };
        rubyString2.freeze();
        rubyClass.defineConstant("SEPARATOR", rubyString2);
        rubyClass.defineConstant("Separator", rubyString2);
        if (File.separatorChar == '\\') {
            rubyString = ruby.newString("\\");
            rubyString.freeze();
            rubyClass.defineConstant("ALT_SEPARATOR", rubyString);
        } else {
            rubyClass.defineConstant("ALT_SEPARATOR", ruby.getNil());
        }
        rubyString = ruby.newString(File.pathSeparator);
        rubyString.freeze();
        rubyClass.defineConstant("PATH_SEPARATOR", rubyString);
        rubyClass.fastSetConstant("BINARY", ruby.newFixnum(32768L));
        rubyClass.fastSetConstant("FNM_NOESCAPE", ruby.newFixnum(1L));
        rubyClass.fastSetConstant("FNM_CASEFOLD", ruby.newFixnum(8L));
        rubyClass.fastSetConstant("FNM_SYSCASE", ruby.newFixnum(8L));
        rubyClass.fastSetConstant("FNM_DOTMATCH", ruby.newFixnum(4L));
        rubyClass.fastSetConstant("FNM_PATHNAME", ruby.newFixnum(2L));
        rubyClass.fastSetConstant("RDONLY", ruby.newFixnum(0L));
        rubyClass.fastSetConstant("WRONLY", ruby.newFixnum(1L));
        rubyClass.fastSetConstant("RDWR", ruby.newFixnum(2L));
        rubyClass.fastSetConstant("CREAT", ruby.newFixnum(256L));
        rubyClass.fastSetConstant("EXCL", ruby.newFixnum(1024L));
        rubyClass.fastSetConstant("NOCTTY", ruby.newFixnum(256L));
        rubyClass.fastSetConstant("TRUNC", ruby.newFixnum(512L));
        rubyClass.fastSetConstant("APPEND", ruby.newFixnum(8L));
        rubyClass.fastSetConstant("NONBLOCK", ruby.newFixnum(4L));
        rubyClass.fastSetConstant("LOCK_SH", ruby.newFixnum(1L));
        rubyClass.fastSetConstant("LOCK_EX", ruby.newFixnum(2L));
        rubyClass.fastSetConstant("LOCK_NB", ruby.newFixnum(4L));
        rubyClass.fastSetConstant("LOCK_UN", ruby.newFixnum(8L));
        RubyModule rubyModule = rubyClass.defineModuleUnder("Constants");
        rubyModule.fastSetConstant("BINARY", ruby.newFixnum(32768L));
        rubyModule.fastSetConstant("FNM_NOESCAPE", ruby.newFixnum(1L));
        rubyModule.fastSetConstant("FNM_CASEFOLD", ruby.newFixnum(8L));
        rubyModule.fastSetConstant("FNM_DOTMATCH", ruby.newFixnum(4L));
        rubyModule.fastSetConstant("FNM_PATHNAME", ruby.newFixnum(2L));
        rubyModule.fastSetConstant("RDONLY", ruby.newFixnum(0L));
        rubyModule.fastSetConstant("WRONLY", ruby.newFixnum(1L));
        rubyModule.fastSetConstant("RDWR", ruby.newFixnum(2L));
        rubyModule.fastSetConstant("CREAT", ruby.newFixnum(256L));
        rubyModule.fastSetConstant("EXCL", ruby.newFixnum(1024L));
        rubyModule.fastSetConstant("NOCTTY", ruby.newFixnum(256L));
        rubyModule.fastSetConstant("TRUNC", ruby.newFixnum(512L));
        rubyModule.fastSetConstant("APPEND", ruby.newFixnum(8L));
        rubyModule.fastSetConstant("NONBLOCK", ruby.newFixnum(4L));
        rubyModule.fastSetConstant("LOCK_SH", ruby.newFixnum(1L));
        rubyModule.fastSetConstant("LOCK_EX", ruby.newFixnum(2L));
        rubyModule.fastSetConstant("LOCK_NB", ruby.newFixnum(4L));
        rubyModule.fastSetConstant("LOCK_UN", ruby.newFixnum(8L));
        ruby.getFileTest().extend_object(rubyClass);
        rubyClass.defineAnnotatedMethods(RubyFile.class);
        rubyClass.dispatcher = callbackFactory.createDispatcher(rubyClass);
        return rubyClass;
    }

    public void openInternal(String string, ModeFlags modeFlags) {
        this.path = string;
        this.openFile.setMode(modeFlags.getOpenFileFlags());
        try {
            if (string.startsWith("file:")) {
                JarFile jarFile;
                String string2 = this.path.substring(5, this.path.indexOf("!"));
                String string3 = this.path.substring(this.path.indexOf("!") + 2);
                try {
                    jarFile = new JarFile(string2);
                }
                catch (IOException iOException) {
                    throw this.getRuntime().newErrnoENOENTError("File not found - " + string);
                }
                ZipEntry zipEntry = jarFile.getEntry(string3);
                if (zipEntry == null) {
                    throw this.getRuntime().newErrnoENOENTError("File not found - " + string);
                }
                InputStream inputStream = jarFile.getInputStream(zipEntry);
                this.openFile.setMainStream(new ChannelStream(this.getRuntime(), new ChannelDescriptor(Channels.newChannel(inputStream), RubyFile.getNewFileno(), new FileDescriptor())));
            } else {
                try {
                    this.openFile.setMainStream(ChannelStream.fopen(this.getRuntime(), string, modeFlags));
                }
                catch (BadDescriptorException badDescriptorException) {
                    throw this.getRuntime().newErrnoEBADFError();
                }
                catch (FileExistsException fileExistsException) {
                    throw this.getRuntime().newErrnoEEXISTError(fileExistsException.getMessage());
                }
            }
            this.registerDescriptor(this.openFile.getMainStream().getDescriptor());
        }
        catch (PipeException pipeException) {
            throw this.getRuntime().newErrnoEPIPEError();
        }
        catch (InvalidValueException invalidValueException) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (DirectoryAsFileException directoryAsFileException) {
            throw this.getRuntime().newErrnoEISDirError();
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (Ruby.isSecurityRestricted() || new File(string).exists()) {
                throw this.getRuntime().newErrnoEACCESError("Permission denied - " + string);
            }
            throw this.getRuntime().newErrnoENOENTError("File not found - " + string);
        }
        catch (IOException iOException) {
            throw this.getRuntime().newIOError(iOException.getMessage());
        }
        catch (SecurityException securityException) {
            throw this.getRuntime().newIOError(securityException.getMessage());
        }
    }

    @JRubyMethod
    public IRubyObject close() {
        if (this.currentLock != null) {
            try {
                this.currentLock.release();
            }
            catch (IOException iOException) {
                throw this.getRuntime().newIOError(iOException.getMessage());
            }
        }
        return super.close();
    }

    @JRubyMethod(required=1)
    public IRubyObject flock(IRubyObject iRubyObject) {
        block17: {
            ChannelDescriptor channelDescriptor = this.openFile.getMainStream().getDescriptor();
            if (channelDescriptor.isNull()) {
                return RubyFixnum.zero(this.getRuntime());
            }
            FileChannel fileChannel = (FileChannel)channelDescriptor.getChannel();
            int n = RubyNumeric.num2int(iRubyObject);
            if (!this.openFile.isWritable() && (n & 2) > 0) {
                n = n ^ 2 | 1;
            }
            try {
                switch (n) {
                    case 8: 
                    case 12: {
                        if (this.currentLock == null) break;
                        this.currentLock.release();
                        this.currentLock = null;
                        return RubyFixnum.zero(this.getRuntime());
                    }
                    case 2: {
                        if (this.currentLock != null) {
                            this.currentLock.release();
                            this.currentLock = null;
                        }
                        this.currentLock = fileChannel.lock();
                        if (this.currentLock == null) break;
                        return RubyFixnum.zero(this.getRuntime());
                    }
                    case 6: {
                        if (this.currentLock != null) {
                            this.currentLock.release();
                            this.currentLock = null;
                        }
                        this.currentLock = fileChannel.tryLock();
                        if (this.currentLock == null) break;
                        return RubyFixnum.zero(this.getRuntime());
                    }
                    case 1: {
                        if (this.currentLock != null) {
                            this.currentLock.release();
                            this.currentLock = null;
                        }
                        this.currentLock = fileChannel.lock(0L, Long.MAX_VALUE, true);
                        if (this.currentLock == null) break;
                        return RubyFixnum.zero(this.getRuntime());
                    }
                    case 5: {
                        if (this.currentLock != null) {
                            this.currentLock.release();
                            this.currentLock = null;
                        }
                        this.currentLock = fileChannel.tryLock(0L, Long.MAX_VALUE, true);
                        if (this.currentLock == null) break;
                        return RubyFixnum.zero(this.getRuntime());
                    }
                }
            }
            catch (IOException iOException) {
                if (this.getRuntime().getDebug().isTrue()) {
                    iOException.printStackTrace(System.err);
                }
            }
            catch (OverlappingFileLockException overlappingFileLockException) {
                if (!this.getRuntime().getDebug().isTrue()) break block17;
                overlappingFileLockException.printStackTrace(System.err);
            }
        }
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(required=1, optional=2, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] iRubyObjectArray, Block block) {
        IRubyObject iRubyObject;
        if (this.openFile == null) {
            throw this.getRuntime().newRuntimeError("reinitializing File");
        }
        if (iRubyObjectArray.length > 0 && iRubyObjectArray.length < 3 && !(iRubyObject = TypeConverter.convertToTypeWithCheck(iRubyObjectArray[0], this.getRuntime().getFixnum(), MethodIndex.TO_INT, "to_int")).isNil()) {
            iRubyObjectArray[0] = iRubyObject;
            return super.initialize(iRubyObjectArray, block);
        }
        return this.openFile(iRubyObjectArray);
    }

    private IRubyObject openFile(IRubyObject[] iRubyObjectArray) {
        RubyString rubyString = iRubyObjectArray[0].convertToString();
        this.getRuntime().checkSafeString(rubyString);
        this.path = ((Object)rubyString).toString();
        try {
            block8: {
                try {
                    if (iRubyObjectArray.length > 1 && iRubyObjectArray[1] instanceof RubyFixnum || iRubyObjectArray.length > 2 && !iRubyObjectArray[2].isNil()) {
                        ModeFlags modeFlags;
                        if (iRubyObjectArray[1] instanceof RubyFixnum) {
                            modeFlags = new ModeFlags(RubyNumeric.num2int(iRubyObjectArray[1]));
                        } else {
                            String string = iRubyObjectArray[1].convertToString().toString();
                            modeFlags = RubyFile.getIOModes(this.getRuntime(), string);
                        }
                        int n = iRubyObjectArray.length > 2 && !iRubyObjectArray[2].isNil() ? RubyNumeric.num2int(iRubyObjectArray[2]) : 438;
                        this.sysopenInternal(this.path, modeFlags, n);
                        break block8;
                    }
                    String string = "r";
                    if (iRubyObjectArray.length > 1 && !iRubyObjectArray[1].isNil()) {
                        string = iRubyObjectArray[1].convertToString().toString();
                    }
                    this.openInternal(this.path, string);
                }
                catch (InvalidValueException invalidValueException) {
                    throw this.getRuntime().newErrnoEINVALError();
                }
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            throw throwable;
        }
        return this;
    }

    private void sysopenInternal(String string, ModeFlags modeFlags, int n) throws InvalidValueException {
        this.openFile = new OpenFile();
        this.openFile.setPath(string);
        this.openFile.setMode(modeFlags.getOpenFileFlags());
        ChannelDescriptor channelDescriptor = this.sysopen(string, modeFlags, n);
        this.openFile.setMainStream(this.fdopen(channelDescriptor, modeFlags));
        this.registerDescriptor(channelDescriptor);
    }

    private void openInternal(String string, String string2) throws InvalidValueException {
        this.openFile = new OpenFile();
        this.openFile.setMode(RubyFile.getIOModes(this.getRuntime(), string2).getOpenFileFlags());
        this.openFile.setPath(string);
        this.openFile.setMainStream(this.fopen(string, string2));
        this.registerDescriptor(this.openFile.getMainStream().getDescriptor());
    }

    private ChannelDescriptor sysopen(String string, ModeFlags modeFlags, int n) throws InvalidValueException {
        try {
            ChannelDescriptor channelDescriptor = ChannelDescriptor.open(this.getRuntime().getCurrentDirectory(), string, modeFlags, n, this.getRuntime().getPosix());
            return channelDescriptor;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw this.getRuntime().newErrnoENOENTError();
        }
        catch (DirectoryAsFileException directoryAsFileException) {
            throw this.getRuntime().newErrnoEISDirError();
        }
        catch (FileExistsException fileExistsException) {
            throw this.getRuntime().newErrnoEEXISTError("file exists: " + string);
        }
        catch (IOException iOException) {
            throw this.getRuntime().newIOErrorFromException(iOException);
        }
    }

    private Stream fopen(String string, String string2) {
        try {
            Stream stream = ChannelStream.fopen(this.getRuntime(), string, RubyFile.getIOModes(this.getRuntime(), string2));
            if (stream == null) {
                // empty if block
            }
            return stream;
        }
        catch (BadDescriptorException badDescriptorException) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw this.getRuntime().newErrnoENOENTError();
        }
        catch (DirectoryAsFileException directoryAsFileException) {
            throw this.getRuntime().newErrnoEISDirError();
        }
        catch (FileExistsException fileExistsException) {
            throw this.getRuntime().newErrnoEEXISTError(string);
        }
        catch (IOException iOException) {
            throw this.getRuntime().newIOErrorFromException(iOException);
        }
        catch (InvalidValueException invalidValueException) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException pipeException) {
            throw this.getRuntime().newErrnoEPIPEError();
        }
    }

    @JRubyMethod(required=1)
    public IRubyObject chmod(IRubyObject iRubyObject) {
        int n = (int)iRubyObject.convertToInteger().getLongValue();
        if (!new File(this.path).exists()) {
            throw this.getRuntime().newErrnoENOENTError("No such file or directory - " + this.path);
        }
        return this.getRuntime().newFixnum(this.getRuntime().getPosix().chmod(this.path, n));
    }

    @JRubyMethod(required=2)
    public IRubyObject chown(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        int n = (int)iRubyObject.convertToInteger().getLongValue();
        int n2 = (int)iRubyObject2.convertToInteger().getLongValue();
        if (!new File(this.path).exists()) {
            throw this.getRuntime().newErrnoENOENTError("No such file or directory - " + this.path);
        }
        return this.getRuntime().newFixnum(this.getRuntime().getPosix().chown(this.path, n, n2));
    }

    @JRubyMethod
    public IRubyObject atime() {
        return this.getRuntime().newFileStat(this.path, false).atime();
    }

    @JRubyMethod
    public IRubyObject ctime() {
        return this.getRuntime().newFileStat(this.path, false).ctime();
    }

    @JRubyMethod(required=1)
    public IRubyObject lchmod(IRubyObject iRubyObject) {
        int n = (int)iRubyObject.convertToInteger().getLongValue();
        if (!new File(this.path).exists()) {
            throw this.getRuntime().newErrnoENOENTError("No such file or directory - " + this.path);
        }
        return this.getRuntime().newFixnum(this.getRuntime().getPosix().lchmod(this.path, n));
    }

    @JRubyMethod(required=2)
    public IRubyObject lchown(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        int n = (int)iRubyObject.convertToInteger().getLongValue();
        int n2 = (int)iRubyObject2.convertToInteger().getLongValue();
        if (!new File(this.path).exists()) {
            throw this.getRuntime().newErrnoENOENTError("No such file or directory - " + this.path);
        }
        return this.getRuntime().newFixnum(this.getRuntime().getPosix().lchown(this.path, n, n2));
    }

    @JRubyMethod
    public IRubyObject lstat() {
        return this.getRuntime().newFileStat(this.path, true);
    }

    @JRubyMethod
    public IRubyObject mtime() {
        return RubyFile.getLastModified(this.getRuntime(), this.path);
    }

    @JRubyMethod
    public RubyString path() {
        return this.getRuntime().newString(this.path);
    }

    @JRubyMethod
    public IRubyObject stat() {
        this.openFile.checkClosed(this.getRuntime());
        return this.getRuntime().newFileStat(this.path, false);
    }

    @JRubyMethod(required=1)
    public IRubyObject truncate(IRubyObject iRubyObject) {
        RubyInteger rubyInteger = iRubyObject.convertToInteger();
        if (rubyInteger.getLongValue() < 0L) {
            throw this.getRuntime().newErrnoEINVALError("invalid argument: " + this.path);
        }
        try {
            this.openFile.checkWritable(this.getRuntime());
            this.openFile.getMainStream().ftruncate(rubyInteger.getLongValue());
        }
        catch (BadDescriptorException badDescriptorException) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (PipeException pipeException) {
            throw this.getRuntime().newErrnoESPIPEError();
        }
        catch (InvalidValueException invalidValueException) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return RubyFixnum.zero(this.getRuntime());
    }

    public String toString() {
        return "RubyFile(" + this.path + ", " + this.openFile.getMode() + ", " + this.openFile.getMainStream().getDescriptor().getFileno() + ")";
    }

    private static ModeFlags getModes(Ruby ruby, IRubyObject iRubyObject) throws InvalidValueException {
        if (iRubyObject instanceof RubyString) {
            return RubyFile.getIOModes(ruby, ((RubyString)iRubyObject).toString());
        }
        if (iRubyObject instanceof RubyFixnum) {
            return new ModeFlags(((RubyFixnum)iRubyObject).getLongValue());
        }
        throw ruby.newTypeError("Invalid type for modes");
    }

    @JRubyMethod
    public IRubyObject inspect() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#<File:").append(this.path);
        if (!this.openFile.isOpen()) {
            stringBuffer.append(" (closed)");
        }
        stringBuffer.append(">");
        return this.getRuntime().newString(stringBuffer.toString());
    }

    @JRubyMethod(required=1, optional=1, meta=true)
    public static IRubyObject basename(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        char c;
        int n;
        String string = RubyString.stringValue(iRubyObjectArray[0]).toString();
        if (Platform.IS_WINDOWS && string.length() > 1 && string.charAt(1) == ':' && Character.isLetter(string.charAt(0))) {
            switch (string.length()) {
                case 2: {
                    return iRubyObject.getRuntime().newString("").infectBy(iRubyObjectArray[0]);
                }
                case 3: {
                    return iRubyObject.getRuntime().newString(string.substring(2)).infectBy(iRubyObjectArray[0]);
                }
            }
            switch (string.charAt(2)) {
                case '/': 
                case '\\': {
                    break;
                }
                default: {
                    string = string.substring(2);
                }
            }
        }
        while (string.length() > 1 && string.charAt(string.length() - 1) == '/') {
            string = string.substring(0, string.length() - 1);
        }
        int n2 = 0;
        int n3 = string.length();
        for (n = n3 - 1; n >= 0 && ((c = string.charAt(n)) == '/' || c == '\\'); --n) {
            ++n2;
        }
        if (n2 > 0 && n3 > 1) {
            string = string.substring(0, string.length() - n2);
        }
        if ((n = string.lastIndexOf(47)) == -1) {
            n = string.lastIndexOf(92);
        }
        if (!string.equals("/") && n != -1) {
            string = string.substring(n + 1);
        }
        if (iRubyObjectArray.length == 2) {
            String string2 = RubyString.stringValue(iRubyObjectArray[1]).toString();
            if (".*".equals(string2)) {
                n = string.lastIndexOf(46);
                if (n > 0) {
                    string = string.substring(0, n);
                }
            } else if (string.endsWith(string2)) {
                string = string.substring(0, string.length() - string2.length());
            }
        }
        return iRubyObject.getRuntime().newString(string).infectBy(iRubyObjectArray[0]);
    }

    @JRubyMethod(required=2, rest=true, meta=true)
    public static IRubyObject chmod(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        Ruby ruby = iRubyObject.getRuntime();
        int n = 0;
        RubyInteger rubyInteger = iRubyObjectArray[0].convertToInteger();
        for (int i = 1; i < iRubyObjectArray.length; ++i) {
            boolean bl;
            IRubyObject iRubyObject2 = iRubyObjectArray[i];
            if (!RubyFileTest.exist_p(iRubyObject2, iRubyObject2.convertToString()).isTrue()) {
                throw ruby.newErrnoENOENTError("No such file or directory - " + iRubyObject2);
            }
            boolean bl2 = bl = 0 == ruby.getPosix().chmod(iRubyObject2.toString(), (int)rubyInteger.getLongValue());
            if (!bl) continue;
            ++n;
        }
        return ruby.newFixnum(n);
    }

    @JRubyMethod(required=3, rest=true, meta=true)
    public static IRubyObject chown(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        Ruby ruby = iRubyObject.getRuntime();
        int n = 0;
        RubyInteger rubyInteger = iRubyObjectArray[0].convertToInteger();
        RubyInteger rubyInteger2 = iRubyObjectArray[1].convertToInteger();
        for (int i = 2; i < iRubyObjectArray.length; ++i) {
            boolean bl;
            IRubyObject iRubyObject2 = iRubyObjectArray[i];
            if (!RubyFileTest.exist_p(iRubyObject2, iRubyObject2.convertToString()).isTrue()) {
                throw ruby.newErrnoENOENTError("No such file or directory - " + iRubyObject2);
            }
            boolean bl2 = bl = 0 == ruby.getPosix().chown(iRubyObject2.toString(), (int)rubyInteger.getLongValue(), (int)rubyInteger2.getLongValue());
            if (!bl) continue;
            ++n;
        }
        return ruby.newFixnum(n);
    }

    @JRubyMethod(required=1, meta=true)
    public static IRubyObject dirname(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        int n;
        String string;
        RubyString rubyString = RubyString.stringValue(iRubyObject2);
        String string2 = rubyString.toString();
        String string3 = string2.replace('\\', '/');
        int n2 = 1;
        boolean bl = false;
        boolean bl2 = RubyFile.startsWithDriveLetterOnWindows(string3);
        if (bl2) {
            n2 = 3;
        }
        while (string3.length() > n2 && string3.charAt(string3.length() - 1) == '/') {
            bl = true;
            string3 = string3.substring(0, string3.length() - 1);
        }
        if (bl2 && string3.length() == 2) {
            string = bl ? string2.substring(0, 3) : string2.substring(0, 2) + '.';
        } else {
            n = string3.lastIndexOf(47);
            if (n == -1) {
                if (bl2) {
                    return iRubyObject.getRuntime().newString(string2.substring(0, 2) + ".");
                }
                return iRubyObject.getRuntime().newString(".");
            }
            if (n == 0) {
                return iRubyObject.getRuntime().newString("/");
            }
            if (bl2 && n == 2) {
                ++n;
            }
            string = string2.substring(0, n);
        }
        while (string.length() > n2 && ((n = (int)string.charAt(string.length() - 1)) == 47 || n == 92)) {
            string = string.substring(0, string.length() - 1);
        }
        return iRubyObject.getRuntime().newString(string).infectBy(rubyString);
    }

    private static boolean isWindowsDriveLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    @JRubyMethod(required=1, meta=true)
    public static IRubyObject extname(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        IRubyObject iRubyObject3 = RubyFile.basename(iRubyObject, new IRubyObject[]{iRubyObject2});
        String string = RubyString.stringValue(iRubyObject3).toString();
        String string2 = "";
        int n = string.lastIndexOf(".");
        if (n > 0 && n != string.length() - 1) {
            string2 = string.substring(n);
        }
        return iRubyObject.getRuntime().newString(string2);
    }

    @JRubyMethod(required=1, optional=1, meta=true)
    public static IRubyObject expand_path(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        JRubyFile jRubyFile;
        String string;
        Ruby ruby = iRubyObject.getRuntime();
        String string2 = RubyString.stringValue(iRubyObjectArray[0]).toString();
        boolean bl = string2.startsWith("file:");
        String string3 = null;
        string2 = RubyFile.expandUserPath(threadContext, iRubyObject, string2);
        if (iRubyObjectArray.length == 2 && !iRubyObjectArray[1].isNil()) {
            boolean bl2;
            string = RubyString.stringValue(iRubyObjectArray[1]).toString();
            string3 = RubyFile.expandUserPath(threadContext, iRubyObject, string);
            boolean bl3 = bl2 = (string3 = RubyFile.adjustRootPathOnWindows(ruby, string3, null)) != null && !Platform.IS_WINDOWS && string3.length() > 0 && string3.charAt(0) == '/';
            if (!bl2 && !RubyFile.startsWithDriveLetterOnWindows(string3)) {
                string3 = new File(ruby.getCurrentDirectory(), string3).getAbsolutePath();
            }
        } else {
            string3 = ruby.getCurrentDirectory();
        }
        if (string3 == null) {
            return ruby.getNil();
        }
        string = "";
        if (!Platform.IS_WINDOWS) {
            if (string2.length() > 0 && string2.charAt(0) == '/') {
                string = RubyFile.countSlashes(string2);
            } else if (string3.length() > 0 && string3.charAt(0) == '/') {
                string = RubyFile.countSlashes(string3);
            }
        }
        if (string2.length() == 0) {
            jRubyFile = JRubyFile.create(string2, string3);
        } else {
            string2 = RubyFile.adjustRootPathOnWindows(ruby, string2, string3);
            jRubyFile = JRubyFile.create(string3, string2);
        }
        String string4 = string + RubyFile.canonicalize(jRubyFile.getAbsolutePath());
        if (bl) {
            string4 = string4.substring(string4.indexOf("file:"));
        }
        return ruby.newString(string4);
    }

    private static String expandUserPath(ThreadContext threadContext, IRubyObject iRubyObject, String string) {
        int n = string.length();
        if (n >= 1 && string.charAt(0) == '~') {
            int n2 = string.indexOf(47);
            if (n2 == -1) {
                if (n == 1) {
                    string = RubyDir.getHomeDirectoryPath(threadContext, iRubyObject).toString();
                } else {
                    n2 = n;
                }
            }
            if (n2 == 1) {
                string = RubyDir.getHomeDirectoryPath(threadContext, iRubyObject).toString() + string.substring(1);
            } else if (n2 > 1) {
                String string2 = string.substring(1, n2);
                IRubyObject iRubyObject2 = RubyDir.getHomeDirectoryPath(iRubyObject, string2);
                if (iRubyObject2.isNil()) {
                    Ruby ruby = iRubyObject.getRuntime();
                    throw ruby.newArgumentError("user " + string2 + " does not exist");
                }
                string = "" + iRubyObject2 + (n == n2 ? "" : string.substring(n2));
            }
        }
        return string;
    }

    private static String countSlashes(String string) {
        int n = 0;
        for (int i = 0; i < string.length() && string.charAt(i) == '/'; ++i) {
            ++n;
        }
        if (n > 0) {
            --n;
        }
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = 47;
        }
        return new String(byArray);
    }

    private static String canonicalize(String string) {
        return RubyFile.canonicalize(null, string);
    }

    private static String canonicalize(String string, String string2) {
        String string3;
        if (string2 == null) {
            if ("".equals(string)) {
                return "/";
            }
            if (RubyFile.startsWithDriveLetterOnWindows(string) && string.length() == 2) {
                string = string + "/";
            }
            return string;
        }
        int n = string2.indexOf(47);
        if (n == -1) {
            string3 = string2;
            string2 = null;
        } else {
            string3 = string2.substring(0, n);
            string2 = string2.substring(n + 1);
        }
        if (string3.equals(".")) {
            if (string != null && string.length() == 0) {
                string = string + "/";
            }
        } else if (string3.equals("..")) {
            if (string == null) {
                throw new IllegalArgumentException("Cannot have .. at the start of an absolute path");
            }
            int n2 = string.lastIndexOf(47);
            if (n2 == -1) {
                if (!RubyFile.startsWithDriveLetterOnWindows(string)) {
                    string = "";
                }
            } else {
                string = string.substring(0, n2);
            }
        } else {
            string = string == null ? string3 : string + "/" + string3;
        }
        return RubyFile.canonicalize(string, string2);
    }

    @JRubyMethod(name={"fnmatch", "fnmatch?"}, required=2, optional=1, meta=true)
    public static IRubyObject fnmatch(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        Ruby ruby = iRubyObject.getRuntime();
        int n = iRubyObjectArray.length == 3 ? RubyNumeric.num2int(iRubyObjectArray[2]) : 0;
        ByteList byteList = iRubyObjectArray[0].convertToString().getByteList();
        ByteList byteList2 = iRubyObjectArray[1].convertToString().getByteList();
        if (Dir.fnmatch(byteList.bytes, byteList.begin, byteList.begin + byteList.realSize, byteList2.bytes, byteList2.begin, byteList2.begin + byteList2.realSize, n) == 0) {
            return ruby.getTrue();
        }
        return ruby.getFalse();
    }

    @JRubyMethod(name={"ftype"}, required=1, meta=true)
    public static IRubyObject ftype(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return iRubyObject.getRuntime().newFileStat(iRubyObject2.convertToString().toString(), true).ftype();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String inspectJoin(IRubyObject iRubyObject, RubyArray rubyArray, RubyArray rubyArray2) {
        Ruby ruby = iRubyObject.getRuntime();
        if (ruby.isInspecting(rubyArray)) {
            return RubyFile.join(iRubyObject, rubyArray2).toString();
        }
        try {
            ruby.registerInspecting(rubyArray);
            String string = RubyFile.join(iRubyObject, rubyArray2).toString();
            Object var6_5 = null;
            ruby.unregisterInspecting(rubyArray);
            return string;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            ruby.unregisterInspecting(rubyArray);
            throw throwable;
        }
    }

    private static RubyString join(IRubyObject iRubyObject, RubyArray rubyArray) {
        IRubyObject[] iRubyObjectArray = rubyArray.toJavaArray();
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        Ruby ruby = iRubyObject.getRuntime();
        for (int i = 0; i < iRubyObjectArray.length; ++i) {
            if (iRubyObjectArray[i].isTaint()) {
                bl = true;
            }
            String string = iRubyObjectArray[i] instanceof RubyString ? iRubyObjectArray[i].toString() : (iRubyObjectArray[i] instanceof RubyArray ? (ruby.isInspecting(iRubyObjectArray[i]) ? "[...]" : RubyFile.inspectJoin(iRubyObject, rubyArray, (RubyArray)iRubyObjectArray[i])) : iRubyObjectArray[i].convertToString().toString());
            RubyFile.chomp(stringBuffer);
            if (i > 0 && !string.startsWith("/") && !string.startsWith("\\")) {
                stringBuffer.append("/");
            }
            stringBuffer.append(string);
        }
        RubyString rubyString = RubyString.newString(iRubyObject.getRuntime(), stringBuffer.toString());
        rubyString.setTaint(bl);
        return rubyString;
    }

    @JRubyMethod(rest=true, meta=true)
    public static RubyString join(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        return RubyFile.join(iRubyObject, RubyArray.newArrayNoCopyLight(iRubyObject.getRuntime(), iRubyObjectArray));
    }

    private static void chomp(StringBuffer stringBuffer) {
        for (int i = stringBuffer.length() - 1; i >= 0 && (stringBuffer.lastIndexOf("/") == i || stringBuffer.lastIndexOf("\\") == i); --i) {
            stringBuffer.setLength(i);
        }
    }

    @JRubyMethod(name={"lstat"}, required=1, meta=true)
    public static IRubyObject lstat(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        String string = iRubyObject2.convertToString().toString();
        if (string.startsWith("file:")) {
            string = string.substring(5, string.indexOf("!"));
        }
        return iRubyObject.getRuntime().newFileStat(string, true);
    }

    @JRubyMethod(name={"stat"}, required=1, meta=true)
    public static IRubyObject stat(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        String string = iRubyObject2.convertToString().toString();
        if (string.startsWith("file:")) {
            string = string.substring(5, string.indexOf("!"));
        }
        return iRubyObject.getRuntime().newFileStat(string, false);
    }

    @JRubyMethod(name={"atime"}, required=1, meta=true)
    public static IRubyObject atime(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        String string = iRubyObject2.convertToString().toString();
        if (string.startsWith("file:")) {
            string = string.substring(5, string.indexOf("!"));
        }
        return iRubyObject.getRuntime().newFileStat(string, false).atime();
    }

    @JRubyMethod(name={"ctime"}, required=1, meta=true)
    public static IRubyObject ctime(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        String string = iRubyObject2.convertToString().toString();
        if (string.startsWith("file:")) {
            string = string.substring(5, string.indexOf("!"));
        }
        return iRubyObject.getRuntime().newFileStat(string, false).ctime();
    }

    @JRubyMethod(required=2, rest=true, meta=true)
    public static IRubyObject lchmod(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        Ruby ruby = iRubyObject.getRuntime();
        int n = 0;
        RubyInteger rubyInteger = iRubyObjectArray[0].convertToInteger();
        for (int i = 1; i < iRubyObjectArray.length; ++i) {
            boolean bl;
            IRubyObject iRubyObject2 = iRubyObjectArray[i];
            if (!RubyFileTest.exist_p(iRubyObject2, iRubyObject2.convertToString()).isTrue()) {
                throw ruby.newErrnoENOENTError("No such file or directory - " + iRubyObject2);
            }
            boolean bl2 = bl = 0 == ruby.getPosix().lchmod(iRubyObject2.toString(), (int)rubyInteger.getLongValue());
            if (!bl) continue;
            ++n;
        }
        return ruby.newFixnum(n);
    }

    @JRubyMethod(required=3, rest=true, meta=true)
    public static IRubyObject lchown(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        Ruby ruby = iRubyObject.getRuntime();
        int n = 0;
        RubyInteger rubyInteger = iRubyObjectArray[0].convertToInteger();
        RubyInteger rubyInteger2 = iRubyObjectArray[1].convertToInteger();
        for (int i = 2; i < iRubyObjectArray.length; ++i) {
            boolean bl;
            IRubyObject iRubyObject2 = iRubyObjectArray[i];
            if (!RubyFileTest.exist_p(iRubyObject2, iRubyObject2.convertToString()).isTrue()) {
                throw ruby.newErrnoENOENTError("No such file or directory - " + iRubyObject2);
            }
            boolean bl2 = bl = 0 == ruby.getPosix().lchown(iRubyObject2.toString(), (int)rubyInteger.getLongValue(), (int)rubyInteger2.getLongValue());
            if (!bl) continue;
            ++n;
        }
        return ruby.newFixnum(n);
    }

    @JRubyMethod(required=2, meta=true)
    public static IRubyObject link(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        RubyString rubyString = RubyString.stringValue(iRubyObject2);
        RubyString rubyString2 = RubyString.stringValue(iRubyObject3);
        try {
            if (iRubyObject.getRuntime().getPosix().link(rubyString.toString(), rubyString2.toString()) == -1) {
                throw iRubyObject.getRuntime().newErrnoEEXISTError("File exists - " + rubyString + " or " + rubyString2);
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw iRubyObject.getRuntime().newNotImplementedError("link() function is unimplemented on this machine");
        }
        return iRubyObject.getRuntime().newFixnum(0L);
    }

    @JRubyMethod(name={"mtime"}, required=1, meta=true)
    public static IRubyObject mtime(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return RubyFile.getLastModified(iRubyObject.getRuntime(), iRubyObject2.convertToString().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject open(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, boolean bl, Block block) {
        IRubyObject iRubyObject2;
        RubyFile rubyFile;
        Ruby ruby = iRubyObject.getRuntime();
        if (iRubyObjectArray[0] instanceof RubyInteger) {
            rubyFile = new RubyFile(ruby, (RubyClass)iRubyObject);
            rubyFile.initialize(iRubyObjectArray, Block.NULL_BLOCK);
        } else {
            ModeFlags modeFlags;
            iRubyObject2 = RubyString.stringValue(iRubyObjectArray[0]);
            ruby.checkSafeString(iRubyObject2);
            String string = iRubyObject2.toString();
            try {
                modeFlags = iRubyObjectArray.length >= 2 ? RubyFile.getModes(ruby, iRubyObjectArray[1]) : new ModeFlags(0L);
            }
            catch (InvalidValueException invalidValueException) {
                throw ruby.newErrnoEINVALError();
            }
            rubyFile = new RubyFile(ruby, (RubyClass)iRubyObject);
            RubyInteger rubyInteger = iRubyObjectArray.length >= 3 ? iRubyObjectArray[2].convertToInteger() : null;
            rubyFile.openInternal(string, modeFlags);
            if (rubyInteger != null) {
                RubyFile.chmod(iRubyObject, new IRubyObject[]{rubyInteger, iRubyObject2});
            }
        }
        if (bl && block.isGiven()) {
            block9: {
                try {
                    iRubyObject2 = block.yield(threadContext, rubyFile);
                    Object var12_12 = null;
                    if (!rubyFile.openFile.isOpen()) break block9;
                    rubyFile.close();
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    if (rubyFile.openFile.isOpen()) {
                        rubyFile.close();
                    }
                    throw throwable;
                }
            }
            return iRubyObject2;
        }
        return rubyFile;
    }

    @JRubyMethod(required=2, meta=true)
    public static IRubyObject rename(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        Ruby ruby = iRubyObject.getRuntime();
        RubyString rubyString = RubyString.stringValue(iRubyObject2);
        RubyString rubyString2 = RubyString.stringValue(iRubyObject3);
        ruby.checkSafeString(rubyString);
        ruby.checkSafeString(rubyString2);
        JRubyFile jRubyFile = JRubyFile.create(ruby.getCurrentDirectory(), rubyString.toString());
        JRubyFile jRubyFile2 = JRubyFile.create(ruby.getCurrentDirectory(), rubyString2.toString());
        if (!jRubyFile.exists() || !jRubyFile2.getParentFile().exists()) {
            throw ruby.newErrnoENOENTError("No such file or directory - " + rubyString + " or " + rubyString2);
        }
        JRubyFile jRubyFile3 = JRubyFile.create(ruby.getCurrentDirectory(), rubyString2.toString());
        if (jRubyFile.renameTo(jRubyFile3)) {
            return RubyFixnum.zero(ruby);
        }
        if (jRubyFile2.exists()) {
            iRubyObject.getRuntime().getPosix().chmod(rubyString2.toString(), 438);
            jRubyFile2.delete();
        }
        if (jRubyFile.renameTo(jRubyFile3)) {
            return RubyFixnum.zero(ruby);
        }
        throw ruby.newErrnoEACCESError("Permission denied - " + rubyString + " or " + rubyString2);
    }

    @JRubyMethod(required=1, meta=true)
    public static RubyArray split(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyString rubyString = RubyString.stringValue(iRubyObject2);
        return rubyString.getRuntime().newArray(RubyFile.dirname(iRubyObject, rubyString), RubyFile.basename(iRubyObject, new IRubyObject[]{rubyString}));
    }

    @JRubyMethod(required=2, meta=true)
    public static IRubyObject symlink(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        RubyString rubyString = RubyString.stringValue(iRubyObject2);
        RubyString rubyString2 = RubyString.stringValue(iRubyObject3);
        try {
            if (iRubyObject.getRuntime().getPosix().symlink(rubyString.toString(), rubyString2.toString()) == -1) {
                throw iRubyObject.getRuntime().newErrnoEEXISTError("File exists - " + rubyString + " or " + rubyString2);
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw iRubyObject.getRuntime().newNotImplementedError("symlink() function is unimplemented on this machine");
        }
        return iRubyObject.getRuntime().newFixnum(0L);
    }

    @JRubyMethod(required=1, meta=true)
    public static IRubyObject readlink(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        try {
            String string = iRubyObject.getRuntime().getPosix().readlink(iRubyObject2.toString());
            if (!RubyFileTest.exist_p(iRubyObject, iRubyObject2).isTrue()) {
                throw iRubyObject.getRuntime().newErrnoENOENTError("No such file or directory - " + iRubyObject2);
            }
            if (!RubyFileTest.symlink_p(iRubyObject, iRubyObject2).isTrue()) {
                throw iRubyObject.getRuntime().newErrnoEINVALError("invalid argument - " + iRubyObject2);
            }
            if (string == null) {
                // empty if block
            }
            return iRubyObject.getRuntime().newString(string);
        }
        catch (IOException iOException) {
            throw iRubyObject.getRuntime().newIOError(iOException.getMessage());
        }
    }

    @JRubyMethod(required=2, meta=true)
    public static IRubyObject truncate(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        Ruby ruby = iRubyObject.getRuntime();
        RubyString rubyString = iRubyObject2.convertToString();
        RubyInteger rubyInteger = iRubyObject3.convertToInteger();
        if (!new File(rubyString.getByteList().toString()).exists()) {
            throw ruby.newErrnoENOENTError("No such file or directory - " + rubyString.getByteList().toString());
        }
        if (rubyInteger.getLongValue() < 0L) {
            throw ruby.newErrnoEINVALError("invalid argument: " + rubyString);
        }
        IRubyObject[] iRubyObjectArray = new IRubyObject[]{rubyString, ruby.newString("r+")};
        RubyFile rubyFile = (RubyFile)RubyFile.open(threadContext, iRubyObject, iRubyObjectArray, false, null);
        rubyFile.truncate(rubyInteger);
        rubyFile.close();
        return RubyFixnum.zero(ruby);
    }

    @JRubyMethod(meta=true, optional=1)
    public static IRubyObject umask(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        int n = 0;
        if (iRubyObjectArray.length == 0) {
            n = iRubyObject.getRuntime().getPosix().umask(0);
        } else if (iRubyObjectArray.length == 1) {
            n = iRubyObject.getRuntime().getPosix().umask((int)iRubyObjectArray[0].convertToInteger().getLongValue());
        } else {
            iRubyObject.getRuntime().newArgumentError("wrong number of arguments");
        }
        return iRubyObject.getRuntime().newFixnum(n);
    }

    @JRubyMethod(required=2, rest=true, meta=true)
    public static IRubyObject utime(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        long l;
        Ruby ruby = iRubyObject.getRuntime();
        if (iRubyObjectArray[1] instanceof RubyTime) {
            l = ((RubyTime)iRubyObjectArray[1]).getJavaDate().getTime();
        } else if (iRubyObjectArray[1] instanceof RubyNumeric) {
            l = RubyNumeric.num2long(iRubyObjectArray[1]);
        } else if (iRubyObjectArray[1] == ruby.getNil()) {
            l = System.currentTimeMillis();
        } else {
            RubyTime rubyTime = (RubyTime)TypeConverter.convertToType(iRubyObjectArray[1], ruby.getTime(), MethodIndex.NO_INDEX, "to_time", true);
            l = rubyTime.getJavaDate().getTime();
        }
        int n = iRubyObjectArray.length;
        for (int i = 2; i < n; ++i) {
            RubyString rubyString = RubyString.stringValue(iRubyObjectArray[i]);
            ruby.checkSafeString(rubyString);
            JRubyFile jRubyFile = JRubyFile.create(ruby.getCurrentDirectory(), rubyString.toString());
            if (!jRubyFile.exists()) {
                throw ruby.newErrnoENOENTError(" No such file or directory - \"" + rubyString + "\"");
            }
            jRubyFile.setLastModified(l);
        }
        return ruby.newFixnum(iRubyObjectArray.length - 2);
    }

    @JRubyMethod(name={"unlink", "delete"}, rest=true, meta=true)
    public static IRubyObject unlink(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        Ruby ruby = iRubyObject.getRuntime();
        for (int i = 0; i < iRubyObjectArray.length; ++i) {
            RubyString rubyString = RubyString.stringValue(iRubyObjectArray[i]);
            ruby.checkSafeString(rubyString);
            JRubyFile jRubyFile = JRubyFile.create(ruby.getCurrentDirectory(), rubyString.toString());
            boolean bl = RubyFileTest.symlink_p(iRubyObject, rubyString).isTrue();
            if (!jRubyFile.exists() && !bl) {
                throw ruby.newErrnoENOENTError(" No such file or directory - \"" + rubyString + "\"");
            }
            if (jRubyFile.delete()) continue;
            throw ruby.newErrnoEACCESError("Permission denied - \"" + rubyString + "\"");
        }
        return ruby.newFixnum(iRubyObjectArray.length);
    }

    private static IRubyObject getLastModified(Ruby ruby, String string) {
        JRubyFile jRubyFile = JRubyFile.create(ruby.getCurrentDirectory(), string);
        if (!jRubyFile.exists()) {
            throw ruby.newErrnoENOENTError("No such file or directory - " + string);
        }
        return ruby.newTime(jRubyFile.lastModified());
    }
}

