/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.RubyObject;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyBoolean
extends RubyObject {
    public RubyBoolean(Ruby ruby, boolean bl) {
        super(ruby, bl ? ruby.getTrueClass() : ruby.getFalseClass(), false);
        if (!bl) {
            this.flags = 1;
        }
    }

    @Override
    public int getNativeTypeIndex() {
        return (this.flags & 1) == 0 ? 6 : 7;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public RubyClass getSingletonClass() {
        return this.metaClass;
    }

    @Override
    public Class<?> getJavaClass() {
        return Boolean.TYPE;
    }

    public static RubyClass createFalseClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("FalseClass", ruby.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        ruby.setFalseClass(rubyClass);
        rubyClass.index = 7;
        CallbackFactory callbackFactory = ruby.callbackFactory(RubyBoolean.class);
        rubyClass.defineFastMethod("&", callbackFactory.getFastMethod("false_and", RubyKernel.IRUBY_OBJECT));
        rubyClass.defineFastMethod("|", callbackFactory.getFastMethod("false_or", RubyKernel.IRUBY_OBJECT));
        rubyClass.defineFastMethod("^", callbackFactory.getFastMethod("false_xor", RubyKernel.IRUBY_OBJECT));
        rubyClass.defineFastMethod("to_s", callbackFactory.getFastMethod("false_to_s"));
        rubyClass.getMetaClass().undefineMethod("new");
        rubyClass.dispatcher = callbackFactory.createDispatcher(rubyClass);
        return rubyClass;
    }

    public static RubyClass createTrueClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("TrueClass", ruby.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        ruby.setTrueClass(rubyClass);
        rubyClass.index = 6;
        CallbackFactory callbackFactory = ruby.callbackFactory(RubyBoolean.class);
        rubyClass.defineFastMethod("&", callbackFactory.getFastMethod("true_and", RubyKernel.IRUBY_OBJECT));
        rubyClass.defineFastMethod("|", callbackFactory.getFastMethod("true_or", RubyKernel.IRUBY_OBJECT));
        rubyClass.defineFastMethod("^", callbackFactory.getFastMethod("true_xor", RubyKernel.IRUBY_OBJECT));
        rubyClass.defineFastMethod("to_s", callbackFactory.getFastMethod("true_to_s"));
        rubyClass.getMetaClass().undefineMethod("new");
        rubyClass.dispatcher = callbackFactory.createDispatcher(rubyClass);
        return rubyClass;
    }

    public static RubyBoolean newBoolean(Ruby ruby, boolean bl) {
        return bl ? ruby.getTrue() : ruby.getFalse();
    }

    public IRubyObject false_and(IRubyObject iRubyObject) {
        return this;
    }

    public IRubyObject false_or(IRubyObject iRubyObject) {
        return iRubyObject.isTrue() ? this.getRuntime().getTrue() : this;
    }

    public IRubyObject false_xor(IRubyObject iRubyObject) {
        return iRubyObject.isTrue() ? this.getRuntime().getTrue() : this;
    }

    @Override
    public RubyFixnum id() {
        if ((this.flags & 1) == 0) {
            return RubyFixnum.newFixnum(this.getRuntime(), 2L);
        }
        return RubyFixnum.zero(this.getRuntime());
    }

    @Override
    public IRubyObject taint() {
        return this;
    }

    @Override
    public IRubyObject freeze() {
        return this;
    }

    public IRubyObject false_to_s() {
        return this.getRuntime().newString("false");
    }

    public IRubyObject true_and(IRubyObject iRubyObject) {
        return iRubyObject.isTrue() ? this : this.getRuntime().getFalse();
    }

    public IRubyObject true_or(IRubyObject iRubyObject) {
        return this;
    }

    public IRubyObject true_xor(IRubyObject iRubyObject) {
        return iRubyObject.isTrue() ? this.getRuntime().getFalse() : this;
    }

    public IRubyObject true_to_s() {
        return this.getRuntime().newString("true");
    }

    public void marshalTo(MarshalStream marshalStream) throws IOException {
        marshalStream.write(this.isTrue() ? 84 : 70);
    }
}

