/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.image.VolatileImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Arrays;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyProc;
import org.jruby.anno.JRubyMethod;
import org.jruby.demo.TextAreaReadline;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class JRubyApplet
extends Applet {
    private Ruby runtime;
    private boolean doubleBuffered = true;
    private Color backgroundColor = Color.WHITE;
    private IRubyObject rubyObject;
    private RubyProc startProc;
    private RubyProc stopProc;
    private RubyProc destroyProc;
    private RubyProc paintProc;
    private Graphics priorGraphics;
    private IRubyObject wrappedGraphics;
    private VolatileImage backBuffer;
    private Graphics backBufferGraphics;
    private Facade facade;

    private static RubyProc blockToProc(Ruby ruby, Block block) {
        if (block.isGiven()) {
            RubyProc rubyProc = block.getProcObject();
            if (rubyProc == null) {
                rubyProc = RubyProc.newProc(ruby, block, block.type);
            }
            return rubyProc;
        }
        return null;
    }

    private boolean getBooleanParameter(String string, boolean bl) {
        String string2 = this.getParameter(string);
        if (string2 != null) {
            return string2.equals("true");
        }
        return bl;
    }

    private InputStream getCodeResourceAsStream(String string) {
        if (string == null) {
            return null;
        }
        try {
            URL uRL = new URL(this.getCodeBase(), string);
            return uRL.openStream();
        }
        catch (IOException iOException) {
            return JRubyApplet.class.getClassLoader().getResourceAsStream(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Object object;
        super.init();
        this.facade = this.getBooleanParameter("console", false) ? new ConsoleFacade() : new TrivialFacade();
        Object object2 = this;
        synchronized (object2) {
            if (this.runtime != null) {
                return;
            }
            object = new RubyInstanceConfig(){
                {
                    this.setInput(JRubyApplet.this.facade.getInputStream());
                    this.setOutput(JRubyApplet.this.facade.getOutputStream());
                    this.setError(JRubyApplet.this.facade.getErrorStream());
                    this.setObjectSpaceEnabled(JRubyApplet.this.getBooleanParameter("objectspace", false));
                }
            };
            Ruby.setSecurityRestricted(true);
            this.runtime = Ruby.newInstance((RubyInstanceConfig)object);
            this.rubyObject = JavaUtil.convertJavaToUsableRubyObject(this.runtime, this);
            this.rubyObject.dataWrapStruct(this);
            this.runtime.defineGlobalConstant("JRUBY_APPLET", this.rubyObject);
            this.rubyObject.getMetaClass().defineAnnotatedMethods(RubyMethods.class);
        }
        object2 = this.getParameter("script");
        object = this.getCodeResourceAsStream((String)object2);
        String string = this.getParameter("eval");
        try {
            final JRubyApplet jRubyApplet = this;
            SwingUtilities.invokeAndWait(new Runnable((InputStream)object, (String)object2, string){
                final /* synthetic */ InputStream val$scriptStream;
                final /* synthetic */ String val$scriptName;
                final /* synthetic */ String val$evalString;
                {
                    this.val$scriptStream = inputStream;
                    this.val$scriptName = string;
                    this.val$evalString = string2;
                }

                public void run() {
                    jRubyApplet.setLayout(new BorderLayout());
                    jRubyApplet.facade.attach(jRubyApplet.runtime, jRubyApplet);
                    if (this.val$scriptStream != null) {
                        jRubyApplet.runtime.runFromMain(this.val$scriptStream, this.val$scriptName);
                    }
                    if (this.val$evalString != null) {
                        jRubyApplet.runtime.evalScriptlet(this.val$evalString);
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException("Error running script", invocationTargetException.getCause());
        }
    }

    private void invokeCallback(final RubyProc rubyProc, final IRubyObject[] iRubyObjectArray) {
        if (rubyProc == null) {
            return;
        }
        final Ruby ruby = this.runtime;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    ThreadContext threadContext = ruby.getCurrentContext();
                    rubyProc.call(threadContext, iRubyObjectArray, Block.NULL_BLOCK);
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException("Ruby callback failed", invocationTargetException.getCause());
        }
    }

    public synchronized void setBackgroundColor(Color color) {
        this.backgroundColor = color;
        this.repaint();
    }

    public synchronized Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public synchronized boolean isDoubleBuffered() {
        return this.doubleBuffered;
    }

    public synchronized void setDoubleBuffered(boolean bl) {
        this.doubleBuffered = bl;
        this.repaint();
    }

    public synchronized void start() {
        super.start();
        this.invokeCallback(this.startProc, new IRubyObject[0]);
    }

    public synchronized void stop() {
        this.invokeCallback(this.stopProc, new IRubyObject[0]);
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy() {
        try {
            this.invokeCallback(this.destroyProc, new IRubyObject[0]);
            Object var2_1 = null;
            Ruby ruby = this.runtime;
            this.runtime = null;
            this.rubyObject = null;
            this.startProc = null;
            this.stopProc = null;
            this.destroyProc = null;
            this.paintProc = null;
            this.priorGraphics = null;
            this.wrappedGraphics = null;
            ruby.tearDown();
            super.destroy();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            Ruby ruby = this.runtime;
            this.runtime = null;
            this.rubyObject = null;
            this.startProc = null;
            this.stopProc = null;
            this.destroyProc = null;
            this.paintProc = null;
            this.priorGraphics = null;
            this.wrappedGraphics = null;
            ruby.tearDown();
            super.destroy();
            throw throwable;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public synchronized void paint(Graphics graphics) {
        if (this.doubleBuffered) {
            this.paintBuffered(graphics);
        } else {
            this.paintUnbuffered(graphics);
        }
    }

    private synchronized void paintBuffered(Graphics graphics) {
        do {
            GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
            int n = this.getWidth();
            int n2 = this.getHeight();
            if (this.backBuffer == null || n != this.backBuffer.getWidth() || n2 != this.backBuffer.getHeight() || this.backBuffer.validate(graphicsConfiguration) == 2) {
                if (this.backBuffer != null) {
                    this.backBufferGraphics.dispose();
                    this.backBuffer.flush();
                }
                this.backBuffer = graphicsConfiguration.createCompatibleVolatileImage(n, n2);
                this.backBufferGraphics = this.backBuffer.createGraphics();
            }
            this.backBufferGraphics.setClip(graphics.getClip());
            this.paintUnbuffered(this.backBufferGraphics);
        } while (this.backBuffer.contentsLost());
        graphics.drawImage(this.backBuffer, 0, 0, this);
    }

    private synchronized void paintUnbuffered(Graphics graphics) {
        if (this.backgroundColor != null) {
            graphics.setColor(this.backgroundColor);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.paintProc != null) {
            if (this.priorGraphics != graphics) {
                this.wrappedGraphics = JavaUtil.convertJavaToUsableRubyObject(this.runtime, graphics);
                this.priorGraphics = graphics;
            }
            ThreadContext threadContext = this.runtime.getCurrentContext();
            this.paintProc.call(threadContext, new IRubyObject[]{this.wrappedGraphics}, Block.NULL_BLOCK);
        }
        super.paint(graphics);
    }

    private static class ConsoleFacade
    implements Facade {
        private JTextPane textPane = new JTextPane();
        private JScrollPane scrollPane;
        private TextAreaReadline adaptor;
        private InputStream inputStream;
        private PrintStream outputStream;
        private PrintStream errorStream;

        public ConsoleFacade() {
            this.textPane.setMargin(new Insets(4, 4, 0, 4));
            this.textPane.setCaretColor(new Color(164, 0, 0));
            this.textPane.setBackground(new Color(242, 242, 242));
            this.textPane.setForeground(new Color(164, 0, 0));
            Font font = this.findFont("Monospaced", 0, 14, new String[]{"Monaco", "Andale Mono"});
            this.textPane.setFont(font);
            this.scrollPane = new JScrollPane(this.textPane);
            this.scrollPane.setDoubleBuffered(true);
            this.adaptor = new TextAreaReadline(this.textPane, "  JRuby applet console  \n\n");
            this.inputStream = new PipedInputStream();
            this.outputStream = new PrintStream(this.adaptor);
            this.errorStream = new PrintStream(this.adaptor);
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public PrintStream getOutputStream() {
            return this.outputStream;
        }

        public PrintStream getErrorStream() {
            return this.errorStream;
        }

        public void attach(Ruby ruby, Applet applet) {
            this.adaptor.hookIntoRuntime(ruby);
            applet.add(this.scrollPane);
            applet.validate();
        }

        private Font findFont(String string, int n, int n2, String[] stringArray) {
            Object[] objectArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            Arrays.sort(objectArray);
            for (int i = 0; i < stringArray.length; ++i) {
                if (Arrays.binarySearch(objectArray, stringArray[i]) < 0) continue;
                return new Font(stringArray[i], n, n2);
            }
            return new Font(string, n, n2);
        }
    }

    private static class TrivialFacade
    implements Facade {
        public InputStream getInputStream() {
            return System.in;
        }

        public PrintStream getOutputStream() {
            return System.out;
        }

        public PrintStream getErrorStream() {
            return System.err;
        }

        public void attach(Ruby ruby, Applet applet) {
        }
    }

    public static class RubyMethods {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod
        public static IRubyObject on_start(IRubyObject iRubyObject, Block block) {
            JRubyApplet jRubyApplet;
            JRubyApplet jRubyApplet2 = jRubyApplet = (JRubyApplet)iRubyObject.dataGetStruct();
            synchronized (jRubyApplet2) {
                jRubyApplet.startProc = JRubyApplet.blockToProc(jRubyApplet.runtime, block);
            }
            return iRubyObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod
        public static IRubyObject on_stop(IRubyObject iRubyObject, Block block) {
            JRubyApplet jRubyApplet;
            JRubyApplet jRubyApplet2 = jRubyApplet = (JRubyApplet)iRubyObject.dataGetStruct();
            synchronized (jRubyApplet2) {
                jRubyApplet.stopProc = JRubyApplet.blockToProc(jRubyApplet.runtime, block);
            }
            return iRubyObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod
        public static IRubyObject on_destroy(IRubyObject iRubyObject, Block block) {
            JRubyApplet jRubyApplet;
            JRubyApplet jRubyApplet2 = jRubyApplet = (JRubyApplet)iRubyObject.dataGetStruct();
            synchronized (jRubyApplet2) {
                jRubyApplet.destroyProc = JRubyApplet.blockToProc(jRubyApplet.runtime, block);
            }
            return iRubyObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod
        public static IRubyObject on_paint(IRubyObject iRubyObject, Block block) {
            JRubyApplet jRubyApplet;
            JRubyApplet jRubyApplet2 = jRubyApplet = (JRubyApplet)iRubyObject.dataGetStruct();
            synchronized (jRubyApplet2) {
                jRubyApplet.paintProc = JRubyApplet.blockToProc(jRubyApplet.runtime, block);
                jRubyApplet.repaint();
            }
            return iRubyObject;
        }
    }

    private static interface Facade {
        public InputStream getInputStream();

        public PrintStream getOutputStream();

        public PrintStream getErrorStream();

        public void attach(Ruby var1, Applet var2);
    }
}

