/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import com.sun.org.apache.xml.internal.serialize.HTMLdtd;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.Properties;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.tidy.AttributeTable;
import org.w3c.tidy.Clean;
import org.w3c.tidy.Configuration;
import org.w3c.tidy.DOMDocumentImpl;
import org.w3c.tidy.EntityTable;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.Node;
import org.w3c.tidy.OutImpl;
import org.w3c.tidy.PPrint;
import org.w3c.tidy.ParserImpl;
import org.w3c.tidy.Report;
import org.w3c.tidy.StreamInImpl;
import org.w3c.tidy.TagTable;

public class Tidy
implements Serializable {
    static final long serialVersionUID = -2794371560623987718L;
    private boolean initialized = false;
    private PrintWriter errout = null;
    private PrintWriter stderr = null;
    private Configuration configuration = null;
    private String inputStreamName = "InputStream";
    private int parseErrors = 0;
    private int parseWarnings = 0;
    static final String replacement = "%leaveentitiesalone%";

    public Tidy() {
        this.init();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public PrintWriter getStderr() {
        return this.stderr;
    }

    public int getParseErrors() {
        return this.parseErrors;
    }

    public int getParseWarnings() {
        return this.parseWarnings;
    }

    public PrintWriter getErrout() {
        return this.errout;
    }

    public void setErrout(PrintWriter errout) {
        this.errout = errout;
    }

    public void setSpaces(int spaces) {
        this.configuration.spaces = spaces;
    }

    public int getSpaces() {
        return this.configuration.spaces;
    }

    public void setWraplen(int wraplen) {
        this.configuration.wraplen = wraplen;
    }

    public int getWraplen() {
        return this.configuration.wraplen;
    }

    public void setCharEncoding(int charencoding) {
        this.configuration.CharEncoding = charencoding;
    }

    public int getCharEncoding() {
        return this.configuration.CharEncoding;
    }

    public void setTabsize(int tabsize) {
        this.configuration.tabsize = tabsize;
    }

    public int getTabsize() {
        return this.configuration.tabsize;
    }

    public void setErrfile(String errfile) {
        this.configuration.errfile = errfile;
    }

    public String getErrfile() {
        return this.configuration.errfile;
    }

    public void setWriteback(boolean writeback) {
        this.configuration.writeback = writeback;
    }

    public boolean getWriteback() {
        return this.configuration.writeback;
    }

    public void setOnlyErrors(boolean OnlyErrors) {
        this.configuration.OnlyErrors = OnlyErrors;
    }

    public boolean getOnlyErrors() {
        return this.configuration.OnlyErrors;
    }

    public void setShowWarnings(boolean ShowWarnings) {
        this.configuration.ShowWarnings = ShowWarnings;
    }

    public boolean getShowWarnings() {
        return this.configuration.ShowWarnings;
    }

    public void setQuiet(boolean Quiet) {
        this.configuration.Quiet = Quiet;
    }

    public boolean getQuiet() {
        return this.configuration.Quiet;
    }

    public void setIndentContent(boolean IndentContent) {
        this.configuration.IndentContent = IndentContent;
    }

    public boolean getIndentContent() {
        return this.configuration.IndentContent;
    }

    public void setSmartIndent(boolean SmartIndent) {
        this.configuration.SmartIndent = SmartIndent;
    }

    public boolean getSmartIndent() {
        return this.configuration.SmartIndent;
    }

    public void setHideEndTags(boolean HideEndTags) {
        this.configuration.HideEndTags = HideEndTags;
    }

    public boolean getHideEndTags() {
        return this.configuration.HideEndTags;
    }

    public void setXmlTags(boolean XmlTags) {
        this.configuration.XmlTags = XmlTags;
    }

    public boolean getXmlTags() {
        return this.configuration.XmlTags;
    }

    public void setXmlOut(boolean XmlOut) {
        this.configuration.XmlOut = XmlOut;
    }

    public boolean getXmlOut() {
        return this.configuration.XmlOut;
    }

    public void setXHTML(boolean xHTML) {
        this.configuration.xHTML = xHTML;
    }

    public boolean getXHTML() {
        return this.configuration.xHTML;
    }

    public void setRawOut(boolean RawOut) {
        this.configuration.RawOut = RawOut;
    }

    public boolean getRawOut() {
        return this.configuration.RawOut;
    }

    public void setUpperCaseTags(boolean UpperCaseTags) {
        this.configuration.UpperCaseTags = UpperCaseTags;
    }

    public boolean getUpperCaseTags() {
        return this.configuration.UpperCaseTags;
    }

    public void setUpperCaseAttrs(boolean UpperCaseAttrs) {
        this.configuration.UpperCaseAttrs = UpperCaseAttrs;
    }

    public boolean getUpperCaseAttrs() {
        return this.configuration.UpperCaseAttrs;
    }

    public void setMakeClean(boolean MakeClean) {
        this.configuration.MakeClean = MakeClean;
    }

    public boolean getMakeClean() {
        return this.configuration.MakeClean;
    }

    public void setBreakBeforeBR(boolean BreakBeforeBR) {
        this.configuration.BreakBeforeBR = BreakBeforeBR;
    }

    public boolean getBreakBeforeBR() {
        return this.configuration.BreakBeforeBR;
    }

    public void setBurstSlides(boolean BurstSlides) {
        this.configuration.BurstSlides = BurstSlides;
    }

    public boolean getBurstSlides() {
        return this.configuration.BurstSlides;
    }

    public void setNumEntities(boolean NumEntities) {
        this.configuration.NumEntities = NumEntities;
    }

    public boolean getNumEntities() {
        return this.configuration.NumEntities;
    }

    public void setQuoteMarks(boolean QuoteMarks) {
        this.configuration.QuoteMarks = QuoteMarks;
    }

    public boolean getQuoteMarks() {
        return this.configuration.QuoteMarks;
    }

    public void setQuoteNbsp(boolean QuoteNbsp) {
        this.configuration.QuoteNbsp = QuoteNbsp;
    }

    public boolean getQuoteNbsp() {
        return this.configuration.QuoteNbsp;
    }

    public void setQuoteAmpersand(boolean QuoteAmpersand) {
        this.configuration.QuoteAmpersand = QuoteAmpersand;
    }

    public boolean getQuoteAmpersand() {
        return this.configuration.QuoteAmpersand;
    }

    public void setWrapAttVals(boolean WrapAttVals) {
        this.configuration.WrapAttVals = WrapAttVals;
    }

    public boolean getWrapAttVals() {
        return this.configuration.WrapAttVals;
    }

    public void setWrapScriptlets(boolean WrapScriptlets) {
        this.configuration.WrapScriptlets = WrapScriptlets;
    }

    public boolean getWrapScriptlets() {
        return this.configuration.WrapScriptlets;
    }

    public void setWrapSection(boolean WrapSection) {
        this.configuration.WrapSection = WrapSection;
    }

    public boolean getWrapSection() {
        return this.configuration.WrapSection;
    }

    public void setAltText(String altText) {
        this.configuration.altText = altText;
    }

    public String getAltText() {
        return this.configuration.altText;
    }

    public void setSlidestyle(String slidestyle) {
        this.configuration.slidestyle = slidestyle;
    }

    public String getSlidestyle() {
        return this.configuration.slidestyle;
    }

    public void setXmlPi(boolean XmlPi) {
        this.configuration.XmlPi = XmlPi;
    }

    public boolean getXmlPi() {
        return this.configuration.XmlPi;
    }

    public void setDropFontTags(boolean DropFontTags) {
        this.configuration.DropFontTags = DropFontTags;
    }

    public boolean getDropFontTags() {
        return this.configuration.DropFontTags;
    }

    public void setDropEmptyParas(boolean DropEmptyParas) {
        this.configuration.DropEmptyParas = DropEmptyParas;
    }

    public boolean getDropEmptyParas() {
        return this.configuration.DropEmptyParas;
    }

    public void setFixComments(boolean FixComments) {
        this.configuration.FixComments = FixComments;
    }

    public boolean getFixComments() {
        return this.configuration.FixComments;
    }

    public void setWrapAsp(boolean WrapAsp) {
        this.configuration.WrapAsp = WrapAsp;
    }

    public boolean getWrapAsp() {
        return this.configuration.WrapAsp;
    }

    public void setWrapJste(boolean WrapJste) {
        this.configuration.WrapJste = WrapJste;
    }

    public boolean getWrapJste() {
        return this.configuration.WrapJste;
    }

    public void setWrapPhp(boolean WrapPhp) {
        this.configuration.WrapPhp = WrapPhp;
    }

    public boolean getWrapPhp() {
        return this.configuration.WrapPhp;
    }

    public void setFixBackslash(boolean FixBackslash) {
        this.configuration.FixBackslash = FixBackslash;
    }

    public boolean getFixBackslash() {
        return this.configuration.FixBackslash;
    }

    public void setIndentAttributes(boolean IndentAttributes) {
        this.configuration.IndentAttributes = IndentAttributes;
    }

    public boolean getIndentAttributes() {
        return this.configuration.IndentAttributes;
    }

    public void setDocType(String doctype) {
        if (doctype != null) {
            this.configuration.docTypeStr = this.configuration.parseDocType(doctype, "doctype");
        }
    }

    public String getDocType() {
        String result = null;
        switch (this.configuration.docTypeMode) {
            case 0: {
                result = "omit";
                break;
            }
            case 1: {
                result = "auto";
                break;
            }
            case 2: {
                result = "strict";
                break;
            }
            case 3: {
                result = "loose";
                break;
            }
            case 4: {
                result = this.configuration.docTypeStr;
            }
        }
        return result;
    }

    public void setLogicalEmphasis(boolean LogicalEmphasis) {
        this.configuration.LogicalEmphasis = LogicalEmphasis;
    }

    public boolean getLogicalEmphasis() {
        return this.configuration.LogicalEmphasis;
    }

    public void setXmlPIs(boolean XmlPIs) {
        this.configuration.XmlPIs = XmlPIs;
    }

    public boolean getXmlPIs() {
        return this.configuration.XmlPIs;
    }

    public void setEncloseText(boolean EncloseText) {
        this.configuration.EncloseBodyText = EncloseText;
    }

    public boolean getEncloseText() {
        return this.configuration.EncloseBodyText;
    }

    public void setEncloseBlockText(boolean EncloseBlockText) {
        this.configuration.EncloseBlockText = EncloseBlockText;
    }

    public boolean getEncloseBlockText() {
        return this.configuration.EncloseBlockText;
    }

    public void setKeepFileTimes(boolean KeepFileTimes) {
        this.configuration.KeepFileTimes = KeepFileTimes;
    }

    public boolean getKeepFileTimes() {
        return this.configuration.KeepFileTimes;
    }

    public void setWord2000(boolean Word2000) {
        this.configuration.Word2000 = Word2000;
    }

    public boolean getWord2000() {
        return this.configuration.Word2000;
    }

    public void setTidyMark(boolean TidyMark) {
        this.configuration.TidyMark = TidyMark;
    }

    public boolean getTidyMark() {
        return this.configuration.TidyMark;
    }

    public void setXmlSpace(boolean XmlSpace) {
        this.configuration.XmlSpace = XmlSpace;
    }

    public boolean getXmlSpace() {
        return this.configuration.XmlSpace;
    }

    public void setEmacs(boolean Emacs) {
        this.configuration.Emacs = Emacs;
    }

    public boolean getEmacs() {
        return this.configuration.Emacs;
    }

    public void setLiteralAttribs(boolean LiteralAttribs) {
        this.configuration.LiteralAttribs = LiteralAttribs;
    }

    public boolean getLiteralAttribs() {
        return this.configuration.LiteralAttribs;
    }

    public void setInputStreamName(String name) {
        if (name != null) {
            this.inputStreamName = name;
        }
    }

    public String getInputStreamName() {
        return this.inputStreamName;
    }

    public void setConfigurationFromFile(String filename) {
        this.configuration.parseFile(filename);
    }

    public void setConfigurationFromProps(Properties props) {
        this.configuration.addProps(props);
    }

    private void init() {
        this.configuration = new Configuration();
        if (this.configuration == null) {
            return;
        }
        AttributeTable at = AttributeTable.getDefaultAttributeTable();
        if (at == null) {
            return;
        }
        TagTable tt = new TagTable();
        if (tt == null) {
            return;
        }
        tt.setConfiguration(this.configuration);
        this.configuration.tt = tt;
        EntityTable et = EntityTable.getDefaultEntityTable();
        if (et == null) {
            return;
        }
        this.configuration.errfile = null;
        this.errout = this.stderr = new PrintWriter(System.err, true);
        this.initialized = true;
    }

    public Node parse(InputStream in, OutputStream out) {
        Node document = null;
        try {
            document = this.parse(in, null, out);
        }
        catch (FileNotFoundException fnfe) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return document;
    }

    private Node parse(InputStream in, String file, OutputStream out) throws FileNotFoundException, IOException {
        Node document = null;
        OutImpl o = new OutImpl();
        if (!this.initialized) {
            return null;
        }
        if (this.errout == null) {
            return null;
        }
        this.parseErrors = 0;
        this.parseWarnings = 0;
        this.configuration.adjust();
        if (file != null) {
            in = new FileInputStream(file);
            this.inputStreamName = file;
        } else if (in == null) {
            in = System.in;
            this.inputStreamName = "stdin";
        }
        if (in != null) {
            Node doctype;
            Lexer lexer = new Lexer(new StreamInImpl(in, this.configuration.CharEncoding, this.configuration.tabsize), this.configuration);
            lexer.errout = this.errout;
            lexer.in.lexer = lexer;
            if (this.configuration.XmlTags) {
                document = ParserImpl.parseXMLDocument(lexer);
            } else {
                lexer.warnings = 0;
                if (!this.configuration.Quiet) {
                    Report.helloMessage(this.errout, "4th August 2000", this.inputStreamName);
                }
                if (!(document = ParserImpl.parseDocument(lexer)).checkNodeIntegrity()) {
                    Report.badTree(this.errout);
                    return null;
                }
                Clean cleaner = new Clean(this.configuration.tt);
                cleaner.nestedEmphasis(document);
                cleaner.list2BQ(document);
                cleaner.bQ2Div(document);
                if (this.configuration.LogicalEmphasis) {
                    cleaner.emFromI(document);
                }
                if (this.configuration.Word2000 && cleaner.isWord2000(document, this.configuration.tt)) {
                    cleaner.dropSections(lexer, document);
                    cleaner.cleanWord2000(lexer, document);
                }
                if (this.configuration.MakeClean || this.configuration.DropFontTags) {
                    cleaner.cleanTree(lexer, document);
                }
                if (!document.checkNodeIntegrity()) {
                    Report.badTree(this.errout);
                    return null;
                }
                doctype = document.findDocType();
                if (document.content != null) {
                    if (this.configuration.xHTML) {
                        lexer.setXHTMLDocType(document);
                    } else {
                        lexer.fixDocType(document);
                    }
                    if (this.configuration.TidyMark) {
                        lexer.addGenerator(document);
                    }
                }
                if (this.configuration.XmlOut && this.configuration.XmlPi) {
                    lexer.fixXMLPI(document);
                }
                if (!this.configuration.Quiet && document.content != null) {
                    Report.reportVersion(this.errout, lexer, this.inputStreamName, doctype);
                    Report.reportNumWarnings(this.errout, lexer);
                }
            }
            this.parseWarnings = lexer.warnings;
            this.parseErrors = lexer.errors;
            if (file != null && in != System.in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (lexer.errors > 0) {
                Report.needsAuthorIntervention(this.errout);
            }
            o.state = 0;
            o.encoding = this.configuration.CharEncoding;
            if (!this.configuration.OnlyErrors && lexer.errors == 0) {
                if (this.configuration.BurstSlides) {
                    Node body = null;
                    doctype = document.findDocType();
                    if (doctype != null) {
                        Node.discardElement(doctype);
                    }
                    lexer.versions = (short)(lexer.versions | 8);
                    if (this.configuration.xHTML) {
                        lexer.setXHTMLDocType(document);
                    } else {
                        lexer.fixDocType(document);
                    }
                    body = document.findBody(this.configuration.tt);
                    if (body != null) {
                        PPrint pprint = new PPrint(this.configuration);
                        Report.reportNumberOfSlides(this.errout, pprint.countSlides(body));
                        pprint.createSlides(lexer, document);
                    } else {
                        Report.missingBody(this.errout);
                    }
                } else if (this.configuration.writeback && file != null) {
                    try {
                        PPrint pprint = new PPrint(this.configuration);
                        o.out = new FileOutputStream(file);
                        if (this.configuration.XmlTags) {
                            pprint.printXMLTree(o, (short)0, 0, lexer, document);
                        } else {
                            pprint.printTree(o, (short)0, 0, lexer, document);
                        }
                        pprint.flushLine(o, 0);
                        o.out.close();
                    }
                    catch (IOException e) {
                        this.errout.println(file + e.toString());
                    }
                } else if (out != null) {
                    PPrint pprint = new PPrint(this.configuration);
                    o.out = out;
                    if (this.configuration.XmlTags) {
                        pprint.printXMLTree(o, (short)0, 0, lexer, document);
                    } else {
                        pprint.printTree(o, (short)0, 0, lexer, document);
                    }
                    pprint.flushLine(o, 0);
                }
            }
            Report.errorSummary(lexer);
        }
        return document;
    }

    public Document parseDOM(InputStream in, OutputStream out) {
        Node document = this.parse(in, out);
        if (document != null) {
            return (Document)document.getAdapter();
        }
        return null;
    }

    public static Document createEmptyDocument() {
        Node document = new Node(0, new byte[0], 0, 0);
        Node node = new Node(5, new byte[0], 0, 0, "html", new TagTable());
        if (document != null && node != null) {
            Node.insertNodeAtStart(document, node);
            return (Document)document.getAdapter();
        }
        return null;
    }

    public void pprint(Document doc, OutputStream out) {
        OutImpl o = new OutImpl();
        if (!(doc instanceof DOMDocumentImpl)) {
            return;
        }
        Node document = ((DOMDocumentImpl)doc).adaptee;
        o.state = 0;
        o.encoding = this.configuration.CharEncoding;
        if (out != null) {
            PPrint pprint = new PPrint(this.configuration);
            o.out = out;
            if (this.configuration.XmlTags) {
                pprint.printXMLTree(o, (short)0, 0, null, document);
            } else {
                pprint.printTree(o, (short)0, 0, null, document);
            }
            pprint.flushLine(o, 0);
        }
    }

    public static void main(String[] argv) {
        int totalerrors = 0;
        int totalwarnings = 0;
        String prog = "Tidy";
        OutImpl out = new OutImpl();
        int argc = argv.length + 1;
        int argIndex = 0;
        String current_errorfile = "stderr";
        Tidy tidy = new Tidy();
        Configuration configuration = tidy.getConfiguration();
        while (argc > 0) {
            if (argc > 1 && argv[argIndex].startsWith("-")) {
                String arg = argv[argIndex].substring(1);
                if (arg.length() > 0 && arg.charAt(0) == '-') {
                    arg = arg.substring(1);
                }
                if (arg.equals("xml")) {
                    configuration.XmlTags = true;
                } else if (arg.equals("asxml") || arg.equals("asxhtml")) {
                    configuration.xHTML = true;
                } else if (arg.equals("indent")) {
                    configuration.IndentContent = true;
                    configuration.SmartIndent = true;
                } else if (arg.equals("omit")) {
                    configuration.HideEndTags = true;
                } else if (arg.equals("upper")) {
                    configuration.UpperCaseTags = true;
                } else if (arg.equals("clean")) {
                    configuration.MakeClean = true;
                } else if (arg.equals("raw")) {
                    configuration.CharEncoding = 0;
                } else if (arg.equals("ascii")) {
                    configuration.CharEncoding = 1;
                } else if (arg.equals("latin1")) {
                    configuration.CharEncoding = 2;
                } else if (arg.equals("utf8")) {
                    configuration.CharEncoding = 3;
                } else if (arg.equals("iso2022")) {
                    configuration.CharEncoding = 4;
                } else if (arg.equals("mac")) {
                    configuration.CharEncoding = 5;
                } else if (arg.equals("numeric")) {
                    configuration.NumEntities = true;
                } else if (arg.equals("modify")) {
                    configuration.writeback = true;
                } else if (arg.equals("change")) {
                    configuration.writeback = true;
                } else if (arg.equals("update")) {
                    configuration.writeback = true;
                } else if (arg.equals("errors")) {
                    configuration.OnlyErrors = true;
                } else if (arg.equals("quiet")) {
                    configuration.Quiet = true;
                } else if (arg.equals("slides")) {
                    configuration.BurstSlides = true;
                } else if (arg.equals("help") || argv[argIndex].charAt(1) == '?' || argv[argIndex].charAt(1) == 'h') {
                    Report.helpText(new PrintWriter(System.out, true), prog);
                    System.exit(1);
                } else if (arg.equals("config")) {
                    if (argc >= 3) {
                        configuration.parseFile(argv[argIndex + 1]);
                        --argc;
                        ++argIndex;
                    }
                } else if (argv[argIndex].equals("-file") || argv[argIndex].equals("--file") || argv[argIndex].equals("-f")) {
                    if (argc >= 3) {
                        configuration.errfile = argv[argIndex + 1];
                        --argc;
                        ++argIndex;
                    }
                } else if (argv[argIndex].equals("-wrap") || argv[argIndex].equals("--wrap") || argv[argIndex].equals("-w")) {
                    if (argc >= 3) {
                        configuration.wraplen = Integer.parseInt(argv[argIndex + 1]);
                        --argc;
                        ++argIndex;
                    }
                } else if (argv[argIndex].equals("-version") || argv[argIndex].equals("--version") || argv[argIndex].equals("-v")) {
                    Report.showVersion(tidy.getErrout());
                    System.exit(0);
                } else {
                    String s = argv[argIndex];
                    for (int i = 1; i < s.length(); ++i) {
                        if (s.charAt(i) == 'i') {
                            configuration.IndentContent = true;
                            configuration.SmartIndent = true;
                            continue;
                        }
                        if (s.charAt(i) == 'o') {
                            configuration.HideEndTags = true;
                            continue;
                        }
                        if (s.charAt(i) == 'u') {
                            configuration.UpperCaseTags = true;
                            continue;
                        }
                        if (s.charAt(i) == 'c') {
                            configuration.MakeClean = true;
                            continue;
                        }
                        if (s.charAt(i) == 'n') {
                            configuration.NumEntities = true;
                            continue;
                        }
                        if (s.charAt(i) == 'm') {
                            configuration.writeback = true;
                            continue;
                        }
                        if (s.charAt(i) == 'e') {
                            configuration.OnlyErrors = true;
                            continue;
                        }
                        if (s.charAt(i) == 'q') {
                            configuration.Quiet = true;
                            continue;
                        }
                        Report.unknownOption(tidy.getErrout(), s.charAt(i));
                    }
                }
                --argc;
                ++argIndex;
                continue;
            }
            configuration.adjust();
            if (configuration.errfile != null && !configuration.errfile.equals(current_errorfile)) {
                if (tidy.getErrout() != tidy.getStderr()) {
                    tidy.getErrout().close();
                }
                try {
                    tidy.setErrout(new PrintWriter((Writer)new FileWriter(configuration.errfile), true));
                    current_errorfile = configuration.errfile;
                }
                catch (IOException e) {
                    current_errorfile = "stderr";
                    tidy.setErrout(tidy.getStderr());
                }
            }
            String file = argc > 1 ? argv[argIndex] : "stdin";
            try {
                Node document = tidy.parse(null, file, System.out);
                totalwarnings += tidy.parseWarnings;
                totalerrors += tidy.parseErrors;
            }
            catch (FileNotFoundException fnfe) {
                Report.unknownFile(tidy.getErrout(), prog, file);
            }
            catch (IOException ioe) {
                Report.unknownFile(tidy.getErrout(), prog, file);
            }
            ++argIndex;
            if (--argc > 1) continue;
        }
        if (totalerrors + totalwarnings > 0) {
            Report.generalInfo(tidy.getErrout());
        }
        if (tidy.getErrout() != tidy.getStderr()) {
            tidy.getErrout().close();
        }
        if (totalerrors > 0) {
            System.exit(2);
        }
        if (totalwarnings > 0) {
            System.exit(1);
        }
        System.exit(0);
    }

    public static void cleanEntities(org.w3c.dom.Node node, boolean convertHtmlToJspx) {
        NamedNodeMap nmn;
        if (node instanceof CharacterData) {
            String s;
            CharacterData text = (CharacterData)node;
            while ((s = text.getData()).indexOf(replacement) != -1) {
                s = s.replaceAll(replacement, "&");
                text.setData(s);
            }
        }
        if ((nmn = node.getAttributes()) != null) {
            int siz = nmn.getLength();
            for (int j = 0; j < siz; ++j) {
                Attr attr;
                String s;
                org.w3c.dom.Node item = nmn.item(j);
                if (!(item instanceof Attr) || (s = (attr = (Attr)item).getValue()).indexOf(replacement) == -1) continue;
                s = s.replaceAll(replacement, convertHtmlToJspx ? "&amp;" : "&");
                s = Tidy.expand(s);
                attr.setValue(s);
            }
        }
        NodeList nl = node.getChildNodes();
        int n = nl.getLength();
        for (int i = 0; i < n; ++i) {
            org.w3c.dom.Node child = nl.item(i);
            Tidy.cleanEntities(child, convertHtmlToJspx);
        }
    }

    private static String expand(String unexpanded) {
        if (unexpanded.indexOf(38) == -1) {
            return unexpanded;
        }
        int n = unexpanded.length();
        int nm1 = n - 1;
        StringBuffer sb = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = unexpanded.charAt(i);
            if (c == '&' && i < nm1) {
                int begin;
                int end;
                for (end = begin = i + 1; end < n && unexpanded.charAt(end) != ';' && end - begin <= 10; ++end) {
                }
                if (end == n || unexpanded.charAt(end) != ';') {
                    sb.append('&');
                    continue;
                }
                String entity = unexpanded.substring(begin, end);
                int e = HTMLdtd.charFromName(entity);
                if (e == -1) {
                    sb.append('&');
                    continue;
                }
                sb.append((char)e);
                i = end;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static class EntityWrapperOutputStream
    extends OutputStream {
        private boolean jspx;
        private StringBuffer sb = new StringBuffer();
        private OutputStream outputStream;

        public EntityWrapperOutputStream(OutputStream outputStream, boolean jspx) {
            this.outputStream = outputStream;
            this.jspx = jspx;
        }

        public void close() throws IOException {
            this.outputStream.close();
        }

        public void flush() throws IOException {
            this.outputStream.flush();
        }

        public void write(int b) throws IOException {
            if (this.sb.length() != 0) {
                this.sb.append((char)b);
                String s = this.sb.toString();
                if (s.equals(Tidy.replacement)) {
                    this.outputStream.write(38);
                    if (this.jspx) {
                        this.outputStream.write(97);
                        this.outputStream.write(109);
                        this.outputStream.write(112);
                        this.outputStream.write(59);
                    }
                    this.sb.setLength(0);
                } else if (!Tidy.replacement.startsWith(s)) {
                    this.outputStream.write(s.getBytes());
                    this.sb.setLength(0);
                }
            } else if (b == Tidy.replacement.charAt(0)) {
                this.sb.append((char)b);
            } else {
                this.outputStream.write(b);
            }
        }
    }

    public static class EntityWrapperInputStream
    extends InputStream {
        private String buffer;
        private InputStream inputStream;
        private int bufferPosition = -1;

        public EntityWrapperInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public int read() throws IOException {
            int result;
            if (this.buffer != null) {
                if (++this.bufferPosition >= this.buffer.length()) {
                    this.buffer = null;
                    this.bufferPosition = -1;
                } else {
                    return this.buffer.charAt(this.bufferPosition);
                }
            }
            if ((result = this.inputStream.read()) == 38) {
                this.buffer = Tidy.replacement;
                result = this.read();
            }
            return result;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int offset, int length) throws IOException {
            int i = -1;
            while (++i < length) {
                int c = this.read();
                if (c == -1) {
                    return i == 0 ? -1 : i;
                }
                b[offset + i] = (byte)c;
            }
            return i;
        }

        public void close() throws IOException {
            this.inputStream.close();
        }
    }
}

