/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.validation.variable;

import java.util.Collection;
import org.netbeans.modules.bpel.model.api.OnMessage;
import org.netbeans.modules.bpel.model.api.OperationReference;
import org.netbeans.modules.bpel.model.api.Receive;
import org.netbeans.modules.bpel.model.api.Reply;
import org.netbeans.modules.bpel.model.api.VariableReference;
import org.netbeans.modules.bpel.model.api.references.BpelReference;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;
import org.netbeans.modules.bpel.validation.core.BpelValidator;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;

public final class Validator
extends BpelValidator {
    public void visit(OnMessage onMessage) {
        this.checkVariable((VariableReference)onMessage, (OperationReference)onMessage, true);
    }

    public void visit(Receive receive) {
        this.checkVariable((VariableReference)receive, (OperationReference)receive, true);
    }

    public void visit(Reply reply) {
        this.checkVariable((VariableReference)reply, (OperationReference)reply, false);
    }

    private void checkVariable(VariableReference variableReference, OperationReference operationReference, boolean bl) {
        BpelReference bpelReference = variableReference.getVariable();
        if (bpelReference != null && bpelReference.get() != null) {
            return;
        }
        WSDLReference wSDLReference = operationReference.getOperation();
        if (wSDLReference == null) {
            return;
        }
        Operation operation = (Operation)wSDLReference.get();
        if (operation == null) {
            return;
        }
        Object object = bl ? operation.getInput() : operation.getOutput();
        if (object == null) {
            return;
        }
        NamedComponentReference namedComponentReference = object.getMessage();
        if (namedComponentReference == null) {
            return;
        }
        Message message = (Message)namedComponentReference.get();
        if (message == null) {
            return;
        }
        Collection collection = message.getParts();
        if (collection == null) {
            return;
        }
        if (collection.size() != 0) {
            this.addError("FIX_WSDL_message_variable", (Component)variableReference);
        }
    }
}

