/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.validation.reference;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.bpel.model.api.BpelContainer;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.ContentElement;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.api.Variable;
import org.netbeans.modules.bpel.model.api.VariableDeclaration;
import org.netbeans.modules.bpel.model.api.VariableDeclarationScope;
import org.netbeans.modules.bpel.model.api.references.MappedReference;
import org.netbeans.modules.bpel.model.api.references.ReferenceCollection;
import org.netbeans.modules.bpel.model.api.support.ExpressionUpdater;
import org.netbeans.modules.bpel.validation.core.BpelValidator;
import org.netbeans.modules.bpel.validation.reference.QuickFix;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Reference;
import org.netbeans.modules.xml.xam.Referenceable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Validator
extends BpelValidator {
    public void visit(Process process) {
        this.processEntity((BpelEntity)process);
    }

    private void processEntity(BpelEntity bpelEntity) {
        this.checkReferenceCollection(bpelEntity);
        this.checkExpressions(bpelEntity);
        List list = bpelEntity.getChildren();
        for (BpelEntity bpelEntity2 : list) {
            this.processEntity(bpelEntity2);
        }
    }

    private void checkExpressions(BpelEntity bpelEntity) {
        if (!(bpelEntity instanceof ContentElement)) {
            return;
        }
        String string = ((ContentElement)bpelEntity).getContent();
        Collection collection = ExpressionUpdater.getInstance().getUsedVariables(string);
        HashSet<String> hashSet = new HashSet<String>(collection);
        this.findDeclarationsAscendant(bpelEntity, hashSet);
        if (hashSet.size() == 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : hashSet) {
            stringBuilder.append(string2);
            stringBuilder.append(", ");
        }
        String string3 = hashSet.size() > 1 ? "FIX_Variables" : "FIX_Variable";
        this.addError(string3, (Component)bpelEntity, stringBuilder.substring(0, stringBuilder.length() - 2), string.trim());
    }

    private void findDeclarationsAscendant(BpelEntity bpelEntity, Set<String> set) {
        BpelContainer bpelContainer;
        if (set.size() == 0) {
            return;
        }
        if (bpelEntity instanceof VariableDeclarationScope) {
            this.findDeclarationsDescendant(bpelEntity, set);
        }
        if ((bpelContainer = bpelEntity.getParent()) != null) {
            this.findDeclarationsAscendant((BpelEntity)bpelContainer, set);
        }
    }

    private void findDeclarationsDescendant(BpelEntity bpelEntity, Set<String> set) {
        String string;
        Object object;
        Object object2;
        Object object3;
        if (bpelEntity instanceof VariableDeclaration) {
            object3 = ((VariableDeclaration)bpelEntity).getVariableName();
            set.remove(object3);
        }
        if ((object3 = bpelEntity.getChildren(Variable.class)) != null) {
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (Variable)object2.next();
                string = object.getVariableName();
                set.remove(string);
            }
        }
        if (bpelEntity instanceof VariableDeclarationScope) {
            object2 = bpelEntity.getChildren(VariableDeclarationScope.class);
            if (object2 == null) {
                return;
            }
            object = object2.iterator();
            while (object.hasNext()) {
                string = (VariableDeclarationScope)object.next();
                this.findDeclarationsDescendant((BpelEntity)string, set);
            }
        }
    }

    private void checkReferenceCollection(BpelEntity bpelEntity) {
        Reference[] referenceArray;
        if (!(bpelEntity instanceof ReferenceCollection)) {
            return;
        }
        ReferenceCollection referenceCollection = (ReferenceCollection)bpelEntity;
        for (Reference reference : referenceArray = referenceCollection.getReferences()) {
            if (reference == null || !reference.isBroken()) continue;
            String string = bpelEntity.getPeer().getLocalName();
            String string2 = ((MappedReference)reference).getAttribute().getName();
            this.addQuickFix("FIX_Reference", (Component)bpelEntity, string, string2, QuickFix.get(bpelEntity, (Reference<Referenceable>)reference));
        }
    }
}

