/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.validation.reference;

import java.util.List;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.NamedElement;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.api.Variable;
import org.netbeans.modules.bpel.model.api.VariableContainer;
import org.netbeans.modules.bpel.model.api.VariableDeclaration;
import org.netbeans.modules.bpel.model.api.VariableReference;
import org.netbeans.modules.bpel.model.api.references.BpelReferenceable;
import org.netbeans.modules.bpel.validation.core.QuickFix;
import org.netbeans.modules.bpel.validation.core.Util;
import org.netbeans.modules.soa.ui.util.UI;
import org.netbeans.modules.xml.xam.Reference;
import org.netbeans.modules.xml.xam.Referenceable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QuickFix {
    QuickFix() {
    }

    static QuickFix.Adapter get(BpelEntity bpelEntity, Reference<Referenceable> reference) {
        if (reference.getType().isAssignableFrom(VariableDeclaration.class) && bpelEntity instanceof VariableReference) {
            return new SET_VARIABLE((VariableReference)bpelEntity, reference.getRefString());
        }
        return null;
    }

    static class SET_VARIABLE
    extends QuickFix.Adapter {
        private String myName;
        private String myDescription;
        private Variable[] myVariables;
        private VariableReference myReference;

        SET_VARIABLE(VariableReference variableReference, String string) {
            this.myReference = variableReference;
            this.myName = string;
        }

        public boolean canFix() {
            this.myVariables = this.getAppropriateVariables();
            if (this.myVariables == null) {
                return false;
            }
            if (this.myVariables.length == 0) {
                return false;
            }
            return this.myVariables.length == 1;
        }

        public void doFix() {
            Variable variable = this.myVariables[0];
            this.myDescription = UI.i18n(QuickFix.class, (String)"QUICK_FIX_Change_varibale_name", (String)variable.getName());
            this.myReference.setVariable(this.myReference.createReference((BpelReferenceable)variable, VariableDeclaration.class));
        }

        public String getDescription() {
            return this.myDescription;
        }

        private Variable[] getAppropriateVariables() {
            BpelModel bpelModel = ((BpelEntity)this.myReference).getBpelModel();
            if (bpelModel == null) {
                return null;
            }
            Process process = bpelModel.getProcess();
            if (process == null) {
                return null;
            }
            VariableContainer variableContainer = process.getVariableContainer();
            if (variableContainer == null) {
                return null;
            }
            Variable[] variableArray = variableContainer.getVariables();
            if (variableArray == null) {
                return null;
            }
            List<NamedElement> list = Util.getAppropriate((NamedElement[])variableArray, this.myName);
            Variable[] variableArray2 = new Variable[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                variableArray2[i] = (Variable)list.get(i);
            }
            return variableArray2;
        }
    }
}

