/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.validation.custom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.bpel.model.api.BaseCorrelation;
import org.netbeans.modules.bpel.model.api.BpelContainer;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.Branches;
import org.netbeans.modules.bpel.model.api.CompletionCondition;
import org.netbeans.modules.bpel.model.api.Correlation;
import org.netbeans.modules.bpel.model.api.CorrelationContainer;
import org.netbeans.modules.bpel.model.api.CorrelationSet;
import org.netbeans.modules.bpel.model.api.CorrelationsHolder;
import org.netbeans.modules.bpel.model.api.CreateInstanceActivity;
import org.netbeans.modules.bpel.model.api.Else;
import org.netbeans.modules.bpel.model.api.ElseIf;
import org.netbeans.modules.bpel.model.api.EventHandlers;
import org.netbeans.modules.bpel.model.api.Exit;
import org.netbeans.modules.bpel.model.api.FaultHandlers;
import org.netbeans.modules.bpel.model.api.FinalCounterValue;
import org.netbeans.modules.bpel.model.api.Flow;
import org.netbeans.modules.bpel.model.api.ForEach;
import org.netbeans.modules.bpel.model.api.If;
import org.netbeans.modules.bpel.model.api.Import;
import org.netbeans.modules.bpel.model.api.Invoke;
import org.netbeans.modules.bpel.model.api.OnAlarmEvent;
import org.netbeans.modules.bpel.model.api.OnEvent;
import org.netbeans.modules.bpel.model.api.OnMessage;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.PatternedCorrelation;
import org.netbeans.modules.bpel.model.api.PatternedCorrelationContainer;
import org.netbeans.modules.bpel.model.api.Pick;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.api.Receive;
import org.netbeans.modules.bpel.model.api.Reply;
import org.netbeans.modules.bpel.model.api.Sequence;
import org.netbeans.modules.bpel.model.api.StartCounterValue;
import org.netbeans.modules.bpel.model.api.TerminationHandler;
import org.netbeans.modules.bpel.model.api.Throw;
import org.netbeans.modules.bpel.model.api.references.BpelReference;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;
import org.netbeans.modules.bpel.model.api.support.ExpressionUpdater;
import org.netbeans.modules.bpel.model.api.support.ImportHelper;
import org.netbeans.modules.bpel.model.api.support.Initiate;
import org.netbeans.modules.bpel.validation.core.BpelValidator;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.RequestResponseOperation;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Validator
extends BpelValidator {
    private List<Component> myErrored;

    @Override
    protected void init() {
        this.myErrored = new ArrayList<Component>();
    }

    public void visit(ForEach forEach) {
        this.checkCounters(forEach);
        this.checkNegativeCounter(forEach);
        String string = forEach.getCounterName();
        if (string == null) {
            return;
        }
        CompletionCondition completionCondition = forEach.getCompletionCondition();
        if (completionCondition == null) {
            return;
        }
        Branches branches = completionCondition.getBranches();
        if (branches == null) {
            return;
        }
        String string2 = branches.getContent();
        if (string2 == null) {
            return;
        }
        Collection collection = ExpressionUpdater.getInstance().getUsedVariables(string2);
        if (collection == null) {
            return;
        }
        for (String string3 : collection) {
            if (!string3.equals(string)) continue;
            this.addError("FIX_Branches_Cant_Use_Counter", (Component)branches, string);
        }
    }

    private void checkCounters(ForEach forEach) {
        int n;
        int n2;
        StartCounterValue startCounterValue = forEach.getStartCounterValue();
        if (startCounterValue == null) {
            return;
        }
        try {
            n2 = Integer.parseInt(startCounterValue.getContent());
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        FinalCounterValue finalCounterValue = forEach.getFinalCounterValue();
        if (finalCounterValue == null) {
            return;
        }
        try {
            n = Integer.parseInt(finalCounterValue.getContent());
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        if (n < n2) {
            this.addError("FIX_Final_Start_Counters", (Component)forEach, "" + n2, "" + n);
        }
    }

    private void checkNegativeCounter(ForEach forEach) {
        int n;
        CompletionCondition completionCondition;
        int n2;
        FinalCounterValue finalCounterValue;
        int n3;
        StartCounterValue startCounterValue = forEach.getStartCounterValue();
        if (startCounterValue == null) {
            return;
        }
        try {
            n3 = Integer.parseInt(startCounterValue.getContent());
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        if (n3 < 0) {
            this.addError("FIX_Negative_Start_Counter", (Component)startCounterValue, "" + n3);
        }
        if ((finalCounterValue = forEach.getFinalCounterValue()) == null) {
            return;
        }
        try {
            n2 = Integer.parseInt(finalCounterValue.getContent());
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        if (n2 < 0) {
            this.addError("FIX_Negative_Final_Counter", (Component)finalCounterValue, "" + n2);
        }
        if ((completionCondition = forEach.getCompletionCondition()) == null) {
            return;
        }
        Branches branches = completionCondition.getBranches();
        if (branches == null) {
            return;
        }
        try {
            n = Integer.parseInt(branches.getContent());
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        if (n < 0) {
            this.addError("FIX_Negative_Completion_Counter", (Component)branches, "" + n);
        }
    }

    public void visit(EventHandlers eventHandlers) {
        this.checkCase1(eventHandlers);
        this.checkCase3(eventHandlers);
        this.checkCase245(eventHandlers);
    }

    private void checkCase3(EventHandlers eventHandlers) {
        OnAlarmEvent[] onAlarmEventArray = eventHandlers.getOnAlarms();
        if (onAlarmEventArray == null) {
            return;
        }
        for (OnAlarmEvent onAlarmEvent : onAlarmEventArray) {
            if (onAlarmEvent.getRepeatEvery() == null) continue;
            List<Receive> list = this.getReceives((BpelEntity)onAlarmEvent);
            for (Receive receive : list) {
                this.addWarning("FIX_Receive_in_OnAlarm", (Component)receive, receive.getName());
            }
        }
    }

    private void checkCase245(EventHandlers eventHandlers) {
        ArrayList<Receive> arrayList = new ArrayList<Receive>();
        arrayList.addAll(this.getReceives(eventHandlers.getOnEvents()));
        arrayList.addAll(this.getReceives(eventHandlers.getOnAlarms()));
        this.checkDuplicate(arrayList);
    }

    private List<Receive> getReceives(OnEvent[] onEventArray) {
        ArrayList<Receive> arrayList = new ArrayList<Receive>();
        if (onEventArray == null) {
            return arrayList;
        }
        for (OnEvent onEvent : onEventArray) {
            arrayList.addAll(this.getReceives((BpelEntity)onEvent));
        }
        return arrayList;
    }

    private void checkDuplicate(List<Receive> list) {
        for (int i = 0; i < list.size(); ++i) {
            for (int j = i + 1; j < list.size(); ++j) {
                this.checkDuplicate(list.get(i), list.get(j));
            }
        }
    }

    private void checkDuplicate(Receive receive, Receive receive2) {
        if (this.samePartnerLink(receive, receive2) && this.samePortType(receive, receive2) && this.sameOperation(receive, receive2)) {
            this.addWarning("FIX_Receives_in_OnEventOnAlarm", (Component)receive, receive.getName(), receive2.getName());
            this.addWarning("FIX_Receives_in_OnEventOnAlarm", (Component)receive2, receive2.getName(), receive.getName());
        }
    }

    private boolean sameOperation(Receive receive, Receive receive2) {
        WSDLReference wSDLReference = receive.getOperation();
        if (wSDLReference == null) {
            return false;
        }
        WSDLReference wSDLReference2 = receive2.getOperation();
        if (wSDLReference2 == null) {
            return false;
        }
        return this.same(wSDLReference.get(), wSDLReference2.get());
    }

    private boolean samePortType(Receive receive, Receive receive2) {
        WSDLReference wSDLReference = receive.getPortType();
        if (wSDLReference == null) {
            return false;
        }
        WSDLReference wSDLReference2 = receive2.getPortType();
        if (wSDLReference2 == null) {
            return false;
        }
        return this.same(wSDLReference.get(), wSDLReference2.get());
    }

    private boolean samePartnerLink(Receive receive, Receive receive2) {
        BpelReference bpelReference = receive.getPartnerLink();
        if (bpelReference == null) {
            return false;
        }
        BpelReference bpelReference2 = receive2.getPartnerLink();
        if (bpelReference2 == null) {
            return false;
        }
        return this.same(bpelReference.get(), bpelReference2.get());
    }

    private boolean same(Object object, Object object2) {
        if (object == null) {
            return false;
        }
        return object.equals(object2);
    }

    private List<Receive> getReceives(OnAlarmEvent[] onAlarmEventArray) {
        ArrayList<Receive> arrayList = new ArrayList<Receive>();
        if (onAlarmEventArray == null) {
            return arrayList;
        }
        for (OnAlarmEvent onAlarmEvent : onAlarmEventArray) {
            if (onAlarmEvent.getRepeatEvery() != null) continue;
            arrayList.addAll(this.getReceives((BpelEntity)onAlarmEvent));
        }
        return arrayList;
    }

    private void checkCase1(EventHandlers eventHandlers) {
        OnEvent[] onEventArray = eventHandlers.getOnEvents();
        if (onEventArray == null) {
            return;
        }
        for (OnEvent onEvent : onEventArray) {
            List<Receive> list = this.getReceives((BpelEntity)onEvent);
            for (Receive receive : list) {
                this.addWarning("FIX_Receive_in_OnEvent", (Component)receive, receive.getName());
            }
        }
    }

    private List<Receive> getReceives(BpelEntity bpelEntity) {
        ArrayList<Receive> arrayList = new ArrayList<Receive>();
        this.collectReceives(bpelEntity, arrayList);
        return arrayList;
    }

    private void collectReceives(BpelEntity bpelEntity, List<Receive> list) {
        if (bpelEntity instanceof Receive) {
            list.add((Receive)bpelEntity);
        }
        List list2 = bpelEntity.getChildren();
        for (BpelEntity bpelEntity2 : list2) {
            this.collectReceives(bpelEntity2, list);
        }
    }

    public void visit(Branches branches) {
        String string = branches.getContent();
        if (string == null) {
            return;
        }
        if ((string = string.toLowerCase()).contains("true") || string.contains("false")) {
            this.addError("FIX_Branches_Must_Be_Integer", (Component)branches);
        }
    }

    public void visit(Process process) {
        ArrayList<Reply> arrayList = new ArrayList<Reply>();
        ArrayList<CorrelationsHolder> arrayList2 = new ArrayList<CorrelationsHolder>();
        this.visitEntities(process.getChildren(), arrayList, arrayList2);
        this.checkReplies(arrayList);
        this.checkHolders(arrayList2);
        this.checkExit((BpelEntity)process);
    }

    private void checkExit(BpelEntity bpelEntity) {
        List list = bpelEntity.getChildren();
        boolean bl = false;
        if (!(bpelEntity instanceof Flow)) {
            for (BpelEntity bpelEntity2 : list) {
                if (bl) {
                    this.addError("FIX_Activity_after_Exit", (Component)bpelEntity2);
                }
                if (!(bpelEntity2 instanceof Exit)) continue;
                bl = true;
            }
        }
        for (BpelEntity bpelEntity2 : list) {
            this.checkExit(bpelEntity2);
        }
    }

    private void visitEntities(List<BpelEntity> list, List<Reply> list2, List<CorrelationsHolder> list3) {
        for (BpelEntity bpelEntity : list) {
            if (bpelEntity instanceof Reply) {
                list2.add((Reply)bpelEntity);
            } else if (bpelEntity instanceof CorrelationsHolder) {
                list3.add((CorrelationsHolder)bpelEntity);
            }
            this.visitEntities(bpelEntity.getChildren(), list2, list3);
        }
    }

    private void checkReplies(List<Reply> list) {
        for (int i = 0; i < list.size(); ++i) {
            Reply reply = list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                this.checkReplies(reply, list.get(j));
            }
        }
    }

    private void checkHolders(List<CorrelationsHolder> list) {
        for (CorrelationsHolder correlationsHolder : list) {
            this.checkInitiateAndUse(correlationsHolder);
        }
        for (int i = 0; i < list.size(); ++i) {
            CorrelationsHolder correlationsHolder;
            correlationsHolder = list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                this.checkHolders(correlationsHolder, list.get(j));
            }
        }
    }

    private void checkInitiateAndUse(CorrelationsHolder correlationsHolder) {
        CorrelationContainer correlationContainer = correlationsHolder.getCorrelationContainer();
        if (correlationContainer == null) {
            return;
        }
        Correlation[] correlationArray = correlationContainer.getCorrelations();
        if (correlationArray == null) {
            return;
        }
        Process process = correlationsHolder.getBpelModel().getProcess();
        for (Correlation correlation : correlationArray) {
            CorrelationSet correlationSet;
            BpelReference bpelReference;
            Initiate initiate = correlation.getInitiate();
            if (initiate != Initiate.NO || (bpelReference = correlation.getSet()) == null || (correlationSet = (CorrelationSet)bpelReference.get()) == null || this.checkCorrelationSet(correlationSet, correlationsHolder, (BpelEntity)process)) continue;
            this.addError("FIX_Not_Instantiated_Correlation_Set", (Component)correlation, correlationSet.getName());
        }
    }

    private boolean checkCorrelationSet(CorrelationSet correlationSet, CorrelationsHolder correlationsHolder, BpelEntity bpelEntity) {
        BpelEntity bpelEntity22;
        List list = bpelEntity.getChildren();
        for (BpelEntity bpelEntity22 : list) {
            if (!this.checkCorrelationSet(correlationSet, correlationsHolder, bpelEntity22)) continue;
            return true;
        }
        if (correlationsHolder == bpelEntity) {
            return false;
        }
        if (this.checkCorrelationSetInInvoke(correlationSet, bpelEntity)) {
            return true;
        }
        if (!(bpelEntity instanceof CorrelationsHolder)) {
            return false;
        }
        CorrelationsHolder correlationsHolder2 = (CorrelationsHolder)bpelEntity;
        bpelEntity22 = correlationsHolder2.getCorrelationContainer();
        if (bpelEntity22 == null) {
            return false;
        }
        Correlation[] correlationArray = bpelEntity22.getCorrelations();
        if (correlationArray == null) {
            return false;
        }
        for (Correlation correlation : correlationArray) {
            if (!this.theSame(correlationSet, (BaseCorrelation)correlation)) continue;
            return true;
        }
        return false;
    }

    private boolean checkCorrelationSetInInvoke(CorrelationSet correlationSet, BpelEntity bpelEntity) {
        if (!(bpelEntity instanceof Invoke)) {
            return false;
        }
        Invoke invoke = (Invoke)bpelEntity;
        PatternedCorrelationContainer patternedCorrelationContainer = invoke.getPatternedCorrelationContainer();
        if (patternedCorrelationContainer == null) {
            return false;
        }
        PatternedCorrelation[] patternedCorrelationArray = patternedCorrelationContainer.getPatternedCorrelations();
        if (patternedCorrelationArray == null) {
            return false;
        }
        for (PatternedCorrelation patternedCorrelation : patternedCorrelationArray) {
            if (!this.theSame(correlationSet, (BaseCorrelation)patternedCorrelation)) continue;
            return true;
        }
        return false;
    }

    private boolean theSame(CorrelationSet correlationSet, BaseCorrelation baseCorrelation) {
        BpelReference bpelReference = baseCorrelation.getSet();
        if (bpelReference == null) {
            return false;
        }
        CorrelationSet correlationSet2 = (CorrelationSet)bpelReference.get();
        if (correlationSet2 == null) {
            return false;
        }
        return correlationSet2 == correlationSet && baseCorrelation.getInitiate() != Initiate.NO;
    }

    private void checkReplies(Reply reply, Reply reply2) {
        if (!(this.isInGate((BpelEntity)reply) || this.isInGate((BpelEntity)reply2) || !this.haveTheSamePartnerLinkAndOperation(reply, reply2) || this.hasNextExit((BpelEntity)reply) || this.hasNextExit((BpelEntity)reply2))) {
            this.addErrorCheck("FIX_Replies_PartnerLink_Gate", (Component)reply, reply.getName(), reply2.getName());
            this.addErrorCheck("FIX_Replies_PartnerLink_Gate", (Component)reply2, reply2.getName(), reply.getName());
            return;
        }
        if (this.getParent((BpelEntity)reply) == this.getParent((BpelEntity)reply2) && this.haveTheSamePartnerLinkAndOperation(reply, reply2)) {
            this.addErrorCheck("FIX_Replies_PartnerLink_Scope", (Component)reply, reply.getName(), reply2.getName());
            this.addErrorCheck("FIX_Replies_PartnerLink_Scope", (Component)reply2, reply2.getName(), reply.getName());
            return;
        }
    }

    private boolean hasNextExit(BpelEntity bpelEntity) {
        if (bpelEntity == null) {
            return false;
        }
        BpelContainer bpelContainer = bpelEntity.getParent();
        if (bpelContainer == null) {
            return false;
        }
        List list = bpelContainer.getChildren();
        boolean bl = false;
        for (BpelEntity bpelEntity2 : list) {
            if (bl && bpelEntity2 instanceof Exit) {
                return true;
            }
            if (bpelEntity2 != bpelEntity) continue;
            bl = true;
        }
        return false;
    }

    private void checkHolders(CorrelationsHolder correlationsHolder, CorrelationsHolder correlationsHolder2) {
        BpelEntity bpelEntity = this.getParent((BpelEntity)correlationsHolder);
        BpelEntity bpelEntity2 = this.getParent((BpelEntity)correlationsHolder2);
        if (!this.isInGate((BpelEntity)correlationsHolder) && !this.isInGate((BpelEntity)correlationsHolder2) && this.haveTheSameCorrelationWithInitiateYes(correlationsHolder, correlationsHolder2, bpelEntity, bpelEntity2)) {
            this.addErrorCheck("FIX_Holder_Correlation_Gate", (Component)correlationsHolder, this.getName(correlationsHolder), this.getName(correlationsHolder2));
            this.addErrorCheck("FIX_Holder_Correlation_Gate", (Component)correlationsHolder2, this.getName(correlationsHolder2), this.getName(correlationsHolder));
            return;
        }
        if (bpelEntity == bpelEntity2 && this.haveTheSameCorrelationWithInitiateYes(correlationsHolder, correlationsHolder2, bpelEntity, bpelEntity2)) {
            this.addErrorCheck("FIX_Holder_Correlation_Scope", (Component)correlationsHolder, this.getName(correlationsHolder), this.getName(correlationsHolder2));
            this.addErrorCheck("FIX_Holder_Correlation_Scope", (Component)correlationsHolder2, this.getName(correlationsHolder2), this.getName(correlationsHolder));
            return;
        }
    }

    private boolean haveTheSameCorrelationWithInitiateYes(CorrelationsHolder correlationsHolder, CorrelationsHolder correlationsHolder2, BpelEntity bpelEntity, BpelEntity bpelEntity2) {
        if (correlationsHolder instanceof OnMessage && bpelEntity instanceof Pick) {
            return false;
        }
        if (correlationsHolder2 instanceof OnMessage && bpelEntity2 instanceof Pick) {
            return false;
        }
        CorrelationContainer correlationContainer = correlationsHolder.getCorrelationContainer();
        if (correlationContainer == null) {
            return false;
        }
        Correlation[] correlationArray = correlationContainer.getCorrelations();
        if (correlationArray == null) {
            return false;
        }
        CorrelationContainer correlationContainer2 = correlationsHolder2.getCorrelationContainer();
        if (correlationContainer2 == null) {
            return false;
        }
        Correlation[] correlationArray2 = correlationContainer2.getCorrelations();
        if (correlationArray2 == null) {
            return false;
        }
        return this.checkCorrelations(correlationArray, correlationArray2);
    }

    private boolean checkCorrelations(Correlation[] correlationArray, Correlation[] correlationArray2) {
        for (Correlation correlation : correlationArray) {
            if (correlation.getInitiate() != Initiate.YES || !this.checkCorrelation(correlationArray2, correlation)) continue;
            return true;
        }
        return false;
    }

    private boolean checkCorrelation(Correlation[] correlationArray, Correlation correlation) {
        for (Correlation correlation2 : correlationArray) {
            if (!this.theSame(correlation2, correlation)) continue;
            return correlation2.getInitiate() == Initiate.YES;
        }
        return false;
    }

    private boolean theSame(Correlation correlation, Correlation correlation2) {
        BpelReference bpelReference = correlation.getSet();
        if (bpelReference == null) {
            return false;
        }
        BpelReference bpelReference2 = correlation2.getSet();
        if (bpelReference2 == null) {
            return false;
        }
        return bpelReference.get() == bpelReference2.get();
    }

    private boolean haveTheSamePartnerLinkAndOperation(Reply reply, Reply reply2) {
        if (reply.getPartnerLink() == null) {
            return false;
        }
        PartnerLink partnerLink = (PartnerLink)reply.getPartnerLink().get();
        if (partnerLink == null) {
            return false;
        }
        if (reply2.getPartnerLink() == null) {
            return false;
        }
        PartnerLink partnerLink2 = (PartnerLink)reply2.getPartnerLink().get();
        if (partnerLink2 == null) {
            return false;
        }
        if (partnerLink != partnerLink2) {
            return false;
        }
        if (reply.getOperation() == null) {
            return false;
        }
        Operation operation = (Operation)reply.getOperation().get();
        if (operation == null) {
            return false;
        }
        if (reply2.getOperation() == null) {
            return false;
        }
        Operation operation2 = (Operation)reply2.getOperation().get();
        if (operation2 == null) {
            return false;
        }
        return operation == operation2;
    }

    private BpelEntity getParent(BpelEntity bpelEntity) {
        BpelContainer bpelContainer = bpelEntity.getParent();
        while (bpelContainer instanceof Sequence) {
            bpelContainer = bpelContainer.getParent();
        }
        return bpelContainer;
    }

    private boolean isInGate(BpelEntity bpelEntity) {
        for (BpelContainer bpelContainer = bpelEntity.getParent(); bpelContainer != null; bpelContainer = bpelContainer.getParent()) {
            if (bpelContainer instanceof If) {
                return true;
            }
            if (bpelContainer instanceof Else) {
                return true;
            }
            if (bpelContainer instanceof ElseIf) {
                return true;
            }
            if (bpelContainer instanceof FaultHandlers) {
                return true;
            }
            if (bpelContainer instanceof Flow) {
                return true;
            }
            if (!(bpelContainer instanceof OnMessage)) continue;
            return true;
        }
        return false;
    }

    public void visit(CorrelationContainer correlationContainer) {
        BpelContainer bpelContainer = correlationContainer.getParent();
        if (!(bpelContainer instanceof CreateInstanceActivity)) {
            return;
        }
        CreateInstanceActivity createInstanceActivity = (CreateInstanceActivity)bpelContainer;
        if (!this.isCreateInstanceYes(createInstanceActivity)) {
            return;
        }
        Correlation[] correlationArray = correlationContainer.getCorrelations();
        if (correlationArray == null) {
            return;
        }
        for (Correlation correlation : correlationArray) {
            Initiate initiate = correlation.getInitiate();
            if (initiate == Initiate.NO) continue;
            return;
        }
        this.addError("FIX_Activity_with_Correlation", (Component)bpelContainer);
    }

    public void visit(Receive receive) {
        WSDLReference wSDLReference = receive.getPortType();
        if (wSDLReference == null) {
            return;
        }
        PortType portType = (PortType)wSDLReference.get();
        if (portType == null) {
            return;
        }
        Collection collection = portType.getOperations();
        if (collection.size() != 1) {
            return;
        }
        Operation operation = (Operation)collection.iterator().next();
        if (operation == null) {
            return;
        }
        if (operation.getInput() == null || operation.getOutput() == null) {
            return;
        }
        if (!this.findReply((BpelEntity)receive.getBpelModel().getProcess(), portType)) {
            this.addError("FIX_In_Out_Receive_Reply", (Component)receive, receive.getName());
        }
    }

    private boolean findReply(BpelEntity bpelEntity, PortType portType) {
        List list;
        if (bpelEntity instanceof Reply && (list = ((Reply)bpelEntity).getPortType()) != null && portType == list.get()) {
            return true;
        }
        list = bpelEntity.getChildren();
        for (BpelEntity bpelEntity2 : list) {
            if (!this.findReply(bpelEntity2, portType)) continue;
            return true;
        }
        return false;
    }

    public void visit(Reply reply) {
        super.visit(reply);
        WSDLReference wSDLReference = reply.getOperation();
        if (wSDLReference == null) {
            return;
        }
        Operation operation = (Operation)wSDLReference.get();
        if (operation == null) {
            return;
        }
        if (!(operation instanceof RequestResponseOperation)) {
            this.addError("FIX_ReplyOperation", (Component)reply, wSDLReference.getQName().toString());
        }
    }

    public void visit(Throw throw_) {
        if (this.hasParentTerminationHandler((Component)throw_.getParent())) {
            this.addError("FIX_Throw_in_TerminationHandler", (Component)throw_);
        }
    }

    private boolean hasParentTerminationHandler(Component component) {
        if (component == null) {
            return false;
        }
        if (component instanceof TerminationHandler) {
            return true;
        }
        return this.hasParentTerminationHandler(component.getParent());
    }

    public void visit(Import import_) {
        Model model = this.getModel(import_);
        if (model == null) {
            this.addError("FIX_Not_Well_Formed_Import", (Component)import_);
            return;
        }
        if (this.isValidationComplete()) {
            this.validate(model);
        }
    }

    private Model getModel(Import import_) {
        WSDLModel wSDLModel = ImportHelper.getWsdlModel((Import)import_, (boolean)false);
        if (wSDLModel != null) {
            return wSDLModel;
        }
        return ImportHelper.getSchemaModel((Import)import_, (boolean)false);
    }

    private void addErrorCheck(String string, Component component, String string2, String string3) {
        if (this.myErrored.contains(component)) {
            return;
        }
        this.myErrored.add(component);
        this.addError(string, component, string2, string3);
    }
}

