/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.validation.core;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.bpel.model.api.support.SimpleBpelModelVisitorAdaptor;
import org.netbeans.modules.bpel.validation.core.QuickFix;
import org.netbeans.modules.bpel.validation.core.QuickFixable;
import org.netbeans.modules.soa.ui.util.UI;
import org.netbeans.modules.xml.schema.model.GlobalComplexType;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.TypeContainer;
import org.netbeans.modules.xml.schema.model.visitor.DeepSchemaVisitor;
import org.netbeans.modules.xml.schema.model.visitor.SchemaVisitor;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.Named;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xam.spi.Validation;
import org.netbeans.modules.xml.xam.spi.ValidationResult;
import org.netbeans.modules.xml.xam.spi.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CoreValidator
extends SimpleBpelModelVisitorAdaptor
implements Validator {
    private Validation.ValidationType myType;
    private Validation myValidation;
    private GlobalType myGlobalType;
    private Set<Validator.ResultItem> myResultItems;

    public abstract ValidationResult validate(Model var1, Validation var2, Validation.ValidationType var3);

    protected void init() {
    }

    protected final String getDisplayName() {
        String string = this.getName();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = string.length(); i < 57; ++i) {
            stringBuffer.append(" ");
        }
        return "Validator " + string + stringBuffer;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public Set<Validator.ResultItem> getResultItems() {
        return this.myResultItems;
    }

    protected final void validate(Model model) {
        this.myValidation.validate(model, this.myType);
    }

    protected final void init(Validation validation, Validation.ValidationType validationType) {
        this.myType = validationType;
        this.myValidation = validation;
        this.myResultItems = new HashSet<Validator.ResultItem>();
        this.init();
    }

    protected final void addError(String string, Component component) {
        this.addMessage(UI.i18n(((Object)((Object)this)).getClass(), (String)string), Validator.ResultType.ERROR, component);
    }

    protected final void addError(String string, Component component, String string2) {
        this.addMessage(UI.i18n(((Object)((Object)this)).getClass(), (String)string, (String)string2), Validator.ResultType.ERROR, component);
    }

    protected final void addError(String string, Component component, String string2, String string3) {
        this.addMessage(UI.i18n(((Object)((Object)this)).getClass(), (String)string, (String)string2, (String)string3), Validator.ResultType.ERROR, component);
    }

    protected final void addWarning(String string, Component component) {
        this.addMessage(UI.i18n(((Object)((Object)this)).getClass(), (String)string), Validator.ResultType.WARNING, component);
    }

    protected final void addWarning(String string, Component component, String string2) {
        this.addMessage(UI.i18n(((Object)((Object)this)).getClass(), (String)string, (String)string2), Validator.ResultType.WARNING, component);
    }

    protected final void addWarning(String string, Component component, String string2, String string3) {
        this.addMessage(UI.i18n(((Object)((Object)this)).getClass(), (String)string, (String)string2, (String)string3), Validator.ResultType.WARNING, component);
    }

    protected final void addMessage(String string, Validator.ResultType resultType, Component component) {
        this.addQuickFixable(component, resultType, string, null);
    }

    protected final void addQuickFix(String string, Component component, String string2, String string3, QuickFix quickFix) {
        this.addQuickFixable(component, Validator.ResultType.ERROR, UI.i18n(((Object)((Object)this)).getClass(), (String)string, (String)string2, (String)string3), quickFix);
    }

    private void addQuickFixable(Component component, Validator.ResultType resultType, String string, QuickFix quickFix) {
        this.myResultItems.add(new QuickFixable(this, resultType, component, string, quickFix));
    }

    protected final boolean isValidationComplete() {
        return this.myType == Validation.ValidationType.COMPLETE;
    }

    protected final String getTypeName(Component component) {
        if (component == null) {
            return "n/a";
        }
        if (component instanceof Named) {
            return ((Named)component).getName();
        }
        return component.toString();
    }

    protected final String getName(Object object) {
        String string;
        if (object == null) {
            return null;
        }
        if (object instanceof Named && (string = ((Named)object).getName()) != null) {
            return string;
        }
        string = object.getClass().getName();
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    protected final Component getTypeOfElement(Component component) {
        NamedComponentReference namedComponentReference;
        GlobalType globalType = null;
        if (component instanceof TypeContainer && (namedComponentReference = ((TypeContainer)component).getType()) != null && (globalType = (GlobalType)namedComponentReference.get()) != null) {
            return globalType;
        }
        if (component instanceof DocumentComponent && component instanceof SchemaComponent) {
            namedComponentReference = (DocumentComponent)component;
            String string = namedComponentReference.getPeer().getAttribute("type");
            string = this.removePrefix(string);
            globalType = this.findType(string, (SchemaComponent)component);
        }
        if (globalType != null) {
            return globalType;
        }
        return component;
    }

    private GlobalType findType(String string, SchemaComponent schemaComponent) {
        if (string == null || string.equals("")) {
            return null;
        }
        SchemaModel schemaModel = schemaComponent.getModel();
        Collection collection = schemaModel.findSchemas("http://www.w3.org/2001/XMLSchema");
        GlobalType globalType = null;
        for (Schema schema : collection) {
            globalType = this.findType(string, schema);
            if (globalType == null) continue;
            return globalType;
        }
        return this.findType(string, schemaModel.getSchema());
    }

    private GlobalType findType(final String string, Schema schema) {
        this.myGlobalType = null;
        schema.accept((SchemaVisitor)new DeepSchemaVisitor(){

            public void visit(GlobalSimpleType globalSimpleType) {
                if (string.equals(globalSimpleType.getName())) {
                    CoreValidator.this.myGlobalType = (GlobalType)globalSimpleType;
                }
            }

            public void visit(GlobalComplexType globalComplexType) {
                if (string.equals(globalComplexType.getName())) {
                    CoreValidator.this.myGlobalType = (GlobalType)globalComplexType;
                }
            }
        });
        return this.myGlobalType;
    }

    private String removePrefix(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(":");
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    private void out() {
        System.out.println();
    }

    private void out(Object object) {
        System.out.println("*** " + object);
    }
}

