/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xpath.visitor.impl;

import java.util.Iterator;
import org.netbeans.modules.xml.xpath.LocationStep;
import org.netbeans.modules.xml.xpath.XPathCoreFunction;
import org.netbeans.modules.xml.xpath.XPathCoreOperation;
import org.netbeans.modules.xml.xpath.XPathExpression;
import org.netbeans.modules.xml.xpath.XPathExpressionPath;
import org.netbeans.modules.xml.xpath.XPathExtensionFunction;
import org.netbeans.modules.xml.xpath.XPathLocationPath;
import org.netbeans.modules.xml.xpath.XPathNumericLiteral;
import org.netbeans.modules.xml.xpath.XPathPredicateExpression;
import org.netbeans.modules.xml.xpath.XPathStringLiteral;
import org.netbeans.modules.xml.xpath.XPathVariableReference;
import org.netbeans.modules.xml.xpath.visitor.AbstractXPathVisitor;

public class ExpressionWriter
extends AbstractXPathVisitor {
    private StringBuffer mBuffer = new StringBuffer();

    public String getString() {
        return this.mBuffer.toString();
    }

    public void visit(LocationStep locationStep) {
        this.mBuffer.append('/');
        this.mBuffer.append(locationStep.getString());
        XPathPredicateExpression[] xPathPredicateExpressionArray = locationStep.getPredicates();
        if (xPathPredicateExpressionArray != null) {
            int n = xPathPredicateExpressionArray.length;
            for (int i = 0; i < n; ++i) {
                this.mBuffer.append('[');
                this.mBuffer.append(xPathPredicateExpressionArray[i].getExpressionString());
                this.mBuffer.append(']');
            }
        }
    }

    public void visit(XPathVariableReference xPathVariableReference) {
        this.mBuffer.append("$" + xPathVariableReference.getVariableName());
    }

    public void visit(XPathStringLiteral xPathStringLiteral) {
        String string = xPathStringLiteral.getValue();
        boolean bl = false;
        if (string.length() >= 2) {
            if (string.startsWith("'") && string.endsWith("'")) {
                bl = true;
            } else if (string.startsWith("\"") && string.endsWith("\"")) {
                bl = true;
            }
        }
        if (bl) {
            this.mBuffer.append(string);
        } else if (string.indexOf("'") >= 0) {
            this.mBuffer.append("\"");
            this.mBuffer.append(string);
            this.mBuffer.append("\"");
        } else {
            this.mBuffer.append("'");
            this.mBuffer.append(string);
            this.mBuffer.append("'");
        }
    }

    public void visit(XPathNumericLiteral xPathNumericLiteral) {
        this.mBuffer.append(xPathNumericLiteral.getValue().toString());
    }

    public void visit(XPathLocationPath xPathLocationPath) {
        LocationStep[] locationStepArray = xPathLocationPath.getSteps();
        if (xPathLocationPath.getAbsolute()) {
            this.mBuffer.append('/');
        }
        for (int i = 0; i < locationStepArray.length; ++i) {
            if (i != 0) {
                this.mBuffer.append('/');
            }
            this.mBuffer.append(locationStepArray[i].getString());
            XPathPredicateExpression[] xPathPredicateExpressionArray = locationStepArray[i].getPredicates();
            if (xPathPredicateExpressionArray == null) continue;
            int n = xPathPredicateExpressionArray.length;
            for (int j = 0; j < n; ++j) {
                this.mBuffer.append('[');
                this.mBuffer.append(xPathPredicateExpressionArray[j].getExpressionString());
                this.mBuffer.append(']');
            }
        }
    }

    public void visit(XPathExpressionPath xPathExpressionPath) {
        XPathExpression xPathExpression = xPathExpressionPath.getRootExpression();
        if (xPathExpression != null) {
            this.mBuffer.append(xPathExpression.getExpressionString());
        }
        LocationStep[] locationStepArray = xPathExpressionPath.getSteps();
        for (int i = 0; i < locationStepArray.length; ++i) {
            this.mBuffer.append('/');
            this.mBuffer.append(locationStepArray[i].getString());
            XPathPredicateExpression[] xPathPredicateExpressionArray = locationStepArray[i].getPredicates();
            if (xPathPredicateExpressionArray == null) continue;
            int n = xPathPredicateExpressionArray.length;
            for (int j = 0; j < n; ++j) {
                this.mBuffer.append('[');
                this.mBuffer.append(xPathPredicateExpressionArray[j].getExpressionString());
                this.mBuffer.append(']');
            }
        }
    }

    public void visit(XPathCoreOperation xPathCoreOperation) {
        if (6 == xPathCoreOperation.getOperator()) {
            this.mBuffer.append(xPathCoreOperation.getSign());
            if (xPathCoreOperation.getChildCount() > 0) {
                this.mBuffer.append(xPathCoreOperation.getChild(0).getExpressionString());
            }
        } else {
            this.mBuffer.append(" ( ");
            if (xPathCoreOperation.getChildCount() > 0) {
                this.mBuffer.append(xPathCoreOperation.getChild(0).getExpressionString());
            }
            this.mBuffer.append(' ');
            this.mBuffer.append(xPathCoreOperation.getSign());
            this.mBuffer.append(' ');
            if (xPathCoreOperation.getChildCount() > 1) {
                this.mBuffer.append(xPathCoreOperation.getChild(1).getExpressionString());
            }
            this.mBuffer.append(" ) ");
        }
    }

    public void visit(XPathCoreFunction xPathCoreFunction) {
        this.mBuffer.append(xPathCoreFunction.getName());
        this.mBuffer.append('(');
        Iterator iterator = xPathCoreFunction.getChildren().iterator();
        while (iterator.hasNext()) {
            XPathExpression xPathExpression = (XPathExpression)iterator.next();
            this.mBuffer.append(xPathExpression.getExpressionString());
            if (!iterator.hasNext()) continue;
            this.mBuffer.append(", ");
        }
        this.mBuffer.append(')');
    }

    public void visit(XPathExtensionFunction xPathExtensionFunction) {
        this.mBuffer.append(xPathExtensionFunction.getName());
        this.mBuffer.append('(');
        Iterator iterator = xPathExtensionFunction.getChildren().iterator();
        while (iterator.hasNext()) {
            XPathExpression xPathExpression = (XPathExpression)iterator.next();
            this.mBuffer.append(xPathExpression.getExpressionString());
            if (!iterator.hasNext()) continue;
            this.mBuffer.append(", ");
        }
        this.mBuffer.append(')');
    }
}

