/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.jaxwsmodel.project;

import java.io.IOException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntBuildExtender;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.WebServiceNotifier;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModelProvider;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.jaxwsmodel.project.TransformerUtils;
import org.netbeans.spi.project.LookupProvider;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class EjbJaxWsLookupProvider
implements LookupProvider {
    private String JAX_WS_XML_RESOURCE = "/org/netbeans/modules/websvc/jaxwsmodel/resources/jax-ws.xml";
    private String JAX_WS_STYLESHEET_RESOURCE = "/org/netbeans/modules/websvc/jaxwsmodel/resources/jaxws-ejb.xsl";
    private String JAXWS_EXTENSION = "jaxws";

    public Lookup createAdditionalLookup(Lookup lookup) {
        final Project project = (Project)lookup.lookup(Project.class);
        if (project == null) {
            return null;
        }
        final JaxWsModel jaxWsModel = this.getJaxWsModel(project);
        ProjectOpenedHook projectOpenedHook = new ProjectOpenedHook(){
            private FileChangeListener jaxWsListener;
            private ChangeListener jaxWsCreationListener;
            private JaxWsModel.ServiceListener serviceListener;

            protected void projectOpened() {
                if (jaxWsModel != null) {
                    this.serviceListener = new JaxWsModel.ServiceListener(){

                        public void serviceAdded(String string, String string2) {
                            WebServiceNotifier webServiceNotifier = (WebServiceNotifier)project.getLookup().lookup(WebServiceNotifier.class);
                            if (webServiceNotifier != null) {
                                webServiceNotifier.serviceAdded(string, string2);
                            }
                        }

                        public void serviceRemoved(String string) {
                            WebServiceNotifier webServiceNotifier = (WebServiceNotifier)project.getLookup().lookup(WebServiceNotifier.class);
                            if (webServiceNotifier != null) {
                                webServiceNotifier.serviceRemoved(string);
                            }
                        }
                    };
                    jaxWsModel.addServiceListener(this.serviceListener);
                    AntBuildExtender antBuildExtender = (AntBuildExtender)project.getLookup().lookup(AntBuildExtender.class);
                    if (antBuildExtender != null) {
                        AntBuildExtender.Extension extension;
                        FileObject fileObject = project.getProjectDirectory().getFileObject("nbproject/jaxws-build.xml");
                        int n = jaxWsModel.getClients().length;
                        int n2 = jaxWsModel.getServices().length;
                        int n3 = 0;
                        for (Service service : jaxWsModel.getServices()) {
                            if (service.getWsdlUrl() == null) continue;
                            ++n3;
                        }
                        try {
                            extension = antBuildExtender.getExtension(EjbJaxWsLookupProvider.this.JAXWS_EXTENSION);
                            if (fileObject == null || extension == null) {
                                if (n2 + n > 0) {
                                    EjbJaxWsLookupProvider.this.addJaxWsExtension(project, EjbJaxWsLookupProvider.this.JAX_WS_STYLESHEET_RESOURCE, antBuildExtender, n2, n3, n);
                                    ProjectManager.getDefault().saveProject(project);
                                }
                            } else if (n2 + n == 0) {
                                EjbJaxWsLookupProvider.this.removeJaxWsExtension(fileObject, antBuildExtender);
                                ProjectManager.getDefault().saveProject(project);
                            }
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        extension = jaxWsModel.getJaxWsFile();
                        if (extension != null) {
                            this.jaxWsListener = new FileChangeAdapter(){

                                public void fileChanged(FileEvent fileEvent) {
                                    this.handleJaxsClientBuildScript();
                                }
                            };
                            extension.addFileChangeListener(this.jaxWsListener);
                        } else {
                            this.jaxWsCreationListener = new ChangeListener(){

                                public void stateChanged(ChangeEvent changeEvent) {
                                    FileObject fileObject = jaxWsModel.getJaxWsFile();
                                    if (fileObject != null) {
                                        jaxWsListener = (FileChangeListener)new FileChangeAdapter(){

                                            public void fileChanged(FileEvent fileEvent) {
                                                this.handleJaxsClientBuildScript();
                                            }
                                        };
                                        fileObject.addFileChangeListener(jaxWsListener);
                                    }
                                }
                            };
                            jaxWsModel.addChangeListener(this.jaxWsCreationListener);
                        }
                    }
                }
            }

            protected void projectClosed() {
                if (jaxWsModel != null) {
                    jaxWsModel.removeChangeListener(this.jaxWsCreationListener);
                    FileObject fileObject = jaxWsModel.getJaxWsFile();
                    if (fileObject != null) {
                        fileObject.removeFileChangeListener(this.jaxWsListener);
                    }
                    jaxWsModel.removeServiceListener(this.serviceListener);
                }
            }

            private void handleJaxsClientBuildScript() {
                AntBuildExtender antBuildExtender = (AntBuildExtender)project.getLookup().lookup(AntBuildExtender.class);
                if (antBuildExtender != null) {
                    FileObject fileObject = project.getProjectDirectory().getFileObject("nbproject/jaxws-build.xml");
                    int n = jaxWsModel.getClients().length;
                    int n2 = jaxWsModel.getServices().length;
                    int n3 = 0;
                    for (Service service : jaxWsModel.getServices()) {
                        if (service.getWsdlUrl() == null) continue;
                        ++n3;
                    }
                    try {
                        if (n + n2 == 0) {
                            EjbJaxWsLookupProvider.this.removeJaxWsExtension(fileObject, antBuildExtender);
                            ProjectManager.getDefault().saveProject(project);
                        } else {
                            boolean bl = EjbJaxWsLookupProvider.this.changeJaxWsExtension(project, EjbJaxWsLookupProvider.this.JAX_WS_STYLESHEET_RESOURCE, antBuildExtender, n2, n3, n);
                            if (bl) {
                                ProjectManager.getDefault().saveProject(project);
                            }
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        };
        return Lookups.fixed((Object[])new Object[]{projectOpenedHook, jaxWsModel});
    }

    private JaxWsModel getJaxWsModel(Project project) {
        try {
            FileObject fileObject = this.findJaxWsFileObject(project);
            if (fileObject == null) {
                return JaxWsModelProvider.getDefault().getJaxWsModel(WSUtils.class.getResourceAsStream(this.JAX_WS_XML_RESOURCE));
            }
            JaxWsModel jaxWsModel = JaxWsModelProvider.getDefault().getJaxWsModel(fileObject);
            return jaxWsModel;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
    }

    public FileObject findJaxWsFileObject(Project project) {
        return project.getProjectDirectory().getFileObject("nbproject/jax-ws.xml");
    }

    private void addJaxWsExtension(Project project, String string, AntBuildExtender antBuildExtender, int n, int n2, int n3) throws IOException {
        TransformerUtils.transformClients(project.getProjectDirectory(), string, true);
        FileObject fileObject = project.getProjectDirectory().getFileObject("nbproject/jaxws-build.xml");
        assert (fileObject != null);
        AntBuildExtender.Extension extension = antBuildExtender.getExtension(this.JAXWS_EXTENSION);
        if (extension == null) {
            extension = antBuildExtender.addExtension(this.JAXWS_EXTENSION, fileObject);
            if (n3 > 0) {
                extension.addDependency("-pre-pre-compile", "wsimport-client-generate");
                extension.addDependency("-do-compile", "wsimport-client-compile");
                extension.addDependency("-do-compile-single", "wsimport-client-compile");
            }
            if (n2 > 0) {
                extension.addDependency("-pre-pre-compile", "wsimport-service-generate");
                extension.addDependency("-do-compile", "wsimport-service-compile");
                extension.addDependency("-do-compile-single", "wsimport-service-compile");
            }
        }
    }

    private boolean changeJaxWsExtension(Project project, String string, AntBuildExtender antBuildExtender, int n, int n2, int n3) throws IOException {
        TransformerUtils.transformClients(project.getProjectDirectory(), string, true);
        FileObject fileObject = project.getProjectDirectory().getFileObject("nbproject/jaxws-build.xml");
        assert (fileObject != null);
        AntBuildExtender.Extension extension = antBuildExtender.getExtension(this.JAXWS_EXTENSION);
        boolean bl = false;
        boolean bl2 = false;
        if (extension == null) {
            extension = antBuildExtender.addExtension(this.JAXWS_EXTENSION, fileObject);
            bl2 = true;
            bl = true;
        }
        if (n3 > 0) {
            extension.addDependency("-pre-pre-compile", "wsimport-client-generate");
            extension.addDependency("-do-compile", "wsimport-client-compile");
            extension.addDependency("-do-compile-single", "wsimport-client-compile");
            bl = true;
        } else if (!bl2 && n3 == 0) {
            extension.removeDependency("-pre-pre-compile", "wsimport-client-generate");
            extension.removeDependency("-do-compile", "wsimport-client-compile");
            extension.removeDependency("-do-compile-single", "wsimport-client-compile");
            bl = true;
        }
        if (n2 > 0) {
            extension.addDependency("-pre-pre-compile", "wsimport-service-generate");
            extension.addDependency("-do-compile", "wsimport-service-compile");
            extension.addDependency("-do-compile-single", "wsimport-service-compile");
            bl = true;
        } else if (!bl2 && n2 == 0) {
            extension.removeDependency("-pre-pre-compile", "wsimport-service-generate");
            extension.removeDependency("-do-compile", "wsimport-service-compile");
            extension.removeDependency("-do-compile-single", "wsimport-service-compile");
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeJaxWsExtension(FileObject fileObject, AntBuildExtender antBuildExtender) throws IOException {
        FileLock fileLock;
        AntBuildExtender.Extension extension = antBuildExtender.getExtension(this.JAXWS_EXTENSION);
        if (extension != null) {
            antBuildExtender.removeExtension(this.JAXWS_EXTENSION);
        }
        if (fileObject != null && (fileLock = fileObject.lock()) != null) {
            try {
                fileObject.delete(fileLock);
            }
            finally {
                fileLock.releaseLock();
            }
        }
    }
}

