/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.tidy.AttributeTable;
import org.w3c.tidy.Clean;
import org.w3c.tidy.Configuration;
import org.w3c.tidy.DOMDocumentImpl;
import org.w3c.tidy.EntityTable;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.Node;
import org.w3c.tidy.OutImpl;
import org.w3c.tidy.PPrint;
import org.w3c.tidy.ParserImpl;
import org.w3c.tidy.Report;
import org.w3c.tidy.StreamInImpl;
import org.w3c.tidy.TagTable;

public class Tidy
implements Serializable {
    static final long serialVersionUID = -2794371560623987718L;
    private boolean initialized = false;
    private PrintWriter errout;
    private PrintWriter stderr;
    private Configuration configuration;
    private String inputStreamName = "InputStream";
    private int parseErrors;
    private int parseWarnings;

    public Tidy() {
        this.init();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public PrintWriter getStderr() {
        return this.stderr;
    }

    public int getParseErrors() {
        return this.parseErrors;
    }

    public int getParseWarnings() {
        return this.parseWarnings;
    }

    public PrintWriter getErrout() {
        return this.errout;
    }

    public void setErrout(PrintWriter printWriter) {
        this.errout = printWriter;
    }

    public void setSpaces(int n) {
        this.configuration.spaces = n;
    }

    public int getSpaces() {
        return this.configuration.spaces;
    }

    public void setWraplen(int n) {
        this.configuration.wraplen = n;
    }

    public int getWraplen() {
        return this.configuration.wraplen;
    }

    public void setCharEncoding(int n) {
        this.configuration.CharEncoding = n;
    }

    public int getCharEncoding() {
        return this.configuration.CharEncoding;
    }

    public void setTabsize(int n) {
        this.configuration.tabsize = n;
    }

    public int getTabsize() {
        return this.configuration.tabsize;
    }

    public void setErrfile(String string) {
        this.configuration.errfile = string;
    }

    public String getErrfile() {
        return this.configuration.errfile;
    }

    public void setWriteback(boolean bl) {
        this.configuration.writeback = bl;
    }

    public boolean getWriteback() {
        return this.configuration.writeback;
    }

    public void setOnlyErrors(boolean bl) {
        this.configuration.OnlyErrors = bl;
    }

    public boolean getOnlyErrors() {
        return this.configuration.OnlyErrors;
    }

    public void setShowWarnings(boolean bl) {
        this.configuration.ShowWarnings = bl;
    }

    public boolean getShowWarnings() {
        return this.configuration.ShowWarnings;
    }

    public void setQuiet(boolean bl) {
        this.configuration.Quiet = bl;
    }

    public boolean getQuiet() {
        return this.configuration.Quiet;
    }

    public void setIndentContent(boolean bl) {
        this.configuration.IndentContent = bl;
    }

    public boolean getIndentContent() {
        return this.configuration.IndentContent;
    }

    public void setSmartIndent(boolean bl) {
        this.configuration.SmartIndent = bl;
    }

    public boolean getSmartIndent() {
        return this.configuration.SmartIndent;
    }

    public void setHideEndTags(boolean bl) {
        this.configuration.HideEndTags = bl;
    }

    public boolean getHideEndTags() {
        return this.configuration.HideEndTags;
    }

    public void setXmlTags(boolean bl) {
        this.configuration.XmlTags = bl;
    }

    public boolean getXmlTags() {
        return this.configuration.XmlTags;
    }

    public void setXmlOut(boolean bl) {
        this.configuration.XmlOut = bl;
    }

    public boolean getXmlOut() {
        return this.configuration.XmlOut;
    }

    public void setXHTML(boolean bl) {
        this.configuration.xHTML = bl;
    }

    public boolean getXHTML() {
        return this.configuration.xHTML;
    }

    public void setRawOut(boolean bl) {
        this.configuration.RawOut = bl;
    }

    public boolean getRawOut() {
        return this.configuration.RawOut;
    }

    public void setUpperCaseTags(boolean bl) {
        this.configuration.UpperCaseTags = bl;
    }

    public boolean getUpperCaseTags() {
        return this.configuration.UpperCaseTags;
    }

    public void setUpperCaseAttrs(boolean bl) {
        this.configuration.UpperCaseAttrs = bl;
    }

    public boolean getUpperCaseAttrs() {
        return this.configuration.UpperCaseAttrs;
    }

    public void setMakeClean(boolean bl) {
        this.configuration.MakeClean = bl;
    }

    public boolean getMakeClean() {
        return this.configuration.MakeClean;
    }

    public void setBreakBeforeBR(boolean bl) {
        this.configuration.BreakBeforeBR = bl;
    }

    public boolean getBreakBeforeBR() {
        return this.configuration.BreakBeforeBR;
    }

    public void setBurstSlides(boolean bl) {
        this.configuration.BurstSlides = bl;
    }

    public boolean getBurstSlides() {
        return this.configuration.BurstSlides;
    }

    public void setNumEntities(boolean bl) {
        this.configuration.NumEntities = bl;
    }

    public boolean getNumEntities() {
        return this.configuration.NumEntities;
    }

    public void setQuoteMarks(boolean bl) {
        this.configuration.QuoteMarks = bl;
    }

    public boolean getQuoteMarks() {
        return this.configuration.QuoteMarks;
    }

    public void setQuoteNbsp(boolean bl) {
        this.configuration.QuoteNbsp = bl;
    }

    public boolean getQuoteNbsp() {
        return this.configuration.QuoteNbsp;
    }

    public void setQuoteAmpersand(boolean bl) {
        this.configuration.QuoteAmpersand = bl;
    }

    public boolean getQuoteAmpersand() {
        return this.configuration.QuoteAmpersand;
    }

    public void setWrapAttVals(boolean bl) {
        this.configuration.WrapAttVals = bl;
    }

    public boolean getWrapAttVals() {
        return this.configuration.WrapAttVals;
    }

    public void setWrapScriptlets(boolean bl) {
        this.configuration.WrapScriptlets = bl;
    }

    public boolean getWrapScriptlets() {
        return this.configuration.WrapScriptlets;
    }

    public void setWrapSection(boolean bl) {
        this.configuration.WrapSection = bl;
    }

    public boolean getWrapSection() {
        return this.configuration.WrapSection;
    }

    public void setAltText(String string) {
        this.configuration.altText = string;
    }

    public String getAltText() {
        return this.configuration.altText;
    }

    public void setSlidestyle(String string) {
        this.configuration.slidestyle = string;
    }

    public String getSlidestyle() {
        return this.configuration.slidestyle;
    }

    public void setXmlPi(boolean bl) {
        this.configuration.XmlPi = bl;
    }

    public boolean getXmlPi() {
        return this.configuration.XmlPi;
    }

    public void setDropFontTags(boolean bl) {
        this.configuration.DropFontTags = bl;
    }

    public boolean getDropFontTags() {
        return this.configuration.DropFontTags;
    }

    public void setDropEmptyParas(boolean bl) {
        this.configuration.DropEmptyParas = bl;
    }

    public boolean getDropEmptyParas() {
        return this.configuration.DropEmptyParas;
    }

    public void setFixComments(boolean bl) {
        this.configuration.FixComments = bl;
    }

    public boolean getFixComments() {
        return this.configuration.FixComments;
    }

    public void setWrapAsp(boolean bl) {
        this.configuration.WrapAsp = bl;
    }

    public boolean getWrapAsp() {
        return this.configuration.WrapAsp;
    }

    public void setWrapJste(boolean bl) {
        this.configuration.WrapJste = bl;
    }

    public boolean getWrapJste() {
        return this.configuration.WrapJste;
    }

    public void setWrapPhp(boolean bl) {
        this.configuration.WrapPhp = bl;
    }

    public boolean getWrapPhp() {
        return this.configuration.WrapPhp;
    }

    public void setFixBackslash(boolean bl) {
        this.configuration.FixBackslash = bl;
    }

    public boolean getFixBackslash() {
        return this.configuration.FixBackslash;
    }

    public void setIndentAttributes(boolean bl) {
        this.configuration.IndentAttributes = bl;
    }

    public boolean getIndentAttributes() {
        return this.configuration.IndentAttributes;
    }

    public void setDocType(String string) {
        if (string != null) {
            this.configuration.docTypeStr = this.configuration.parseDocType(string);
        }
    }

    public String getDocType() {
        String string = null;
        switch (this.configuration.docTypeMode) {
            case 0: {
                string = "omit";
                break;
            }
            case 1: {
                string = "auto";
                break;
            }
            case 2: {
                string = "strict";
                break;
            }
            case 3: {
                string = "loose";
                break;
            }
            case 4: {
                string = this.configuration.docTypeStr;
            }
        }
        return string;
    }

    public void setLogicalEmphasis(boolean bl) {
        this.configuration.LogicalEmphasis = bl;
    }

    public boolean getLogicalEmphasis() {
        return this.configuration.LogicalEmphasis;
    }

    public void setXmlPIs(boolean bl) {
        this.configuration.XmlPIs = bl;
    }

    public boolean getXmlPIs() {
        return this.configuration.XmlPIs;
    }

    public void setEncloseText(boolean bl) {
        this.configuration.EncloseBodyText = bl;
    }

    public boolean getEncloseText() {
        return this.configuration.EncloseBodyText;
    }

    public void setEncloseBlockText(boolean bl) {
        this.configuration.EncloseBlockText = bl;
    }

    public boolean getEncloseBlockText() {
        return this.configuration.EncloseBlockText;
    }

    public void setKeepFileTimes(boolean bl) {
        this.configuration.KeepFileTimes = bl;
    }

    public boolean getKeepFileTimes() {
        return this.configuration.KeepFileTimes;
    }

    public void setWord2000(boolean bl) {
        this.configuration.Word2000 = bl;
    }

    public boolean getWord2000() {
        return this.configuration.Word2000;
    }

    public void setTidyMark(boolean bl) {
        this.configuration.TidyMark = bl;
    }

    public boolean getTidyMark() {
        return this.configuration.TidyMark;
    }

    public void setXmlSpace(boolean bl) {
        this.configuration.XmlSpace = bl;
    }

    public boolean getXmlSpace() {
        return this.configuration.XmlSpace;
    }

    public void setEmacs(boolean bl) {
        this.configuration.Emacs = bl;
    }

    public boolean getEmacs() {
        return this.configuration.Emacs;
    }

    public void setLiteralAttribs(boolean bl) {
        this.configuration.LiteralAttribs = bl;
    }

    public boolean getLiteralAttribs() {
        return this.configuration.LiteralAttribs;
    }

    public void setInputStreamName(String string) {
        if (string != null) {
            this.inputStreamName = string;
        }
    }

    public String getInputStreamName() {
        return this.inputStreamName;
    }

    public void setConfigurationFromFile(String string) {
        this.configuration.parseFile(string);
    }

    public void setConfigurationFromProps(Properties properties) {
        this.configuration.addProps(properties);
    }

    private void init() {
        this.configuration = new Configuration();
        if (this.configuration == null) {
            return;
        }
        AttributeTable attributeTable = AttributeTable.getDefaultAttributeTable();
        if (attributeTable == null) {
            return;
        }
        TagTable tagTable = TagTable.getDefaultTagTable();
        if (tagTable == null) {
            return;
        }
        tagTable.setConfiguration(this.configuration);
        EntityTable entityTable = EntityTable.getDefaultEntityTable();
        if (entityTable == null) {
            return;
        }
        this.configuration.errfile = null;
        this.errout = this.stderr = new PrintWriter(System.err, true);
        this.initialized = true;
    }

    public Node parse(InputStream inputStream, OutputStream outputStream) {
        Node node = null;
        OutImpl outImpl = new OutImpl();
        if (!this.initialized) {
            return null;
        }
        if (this.errout == null) {
            return null;
        }
        this.parseErrors = 0;
        this.parseWarnings = 0;
        this.configuration.adjust();
        if (inputStream != null) {
            Lexer lexer = new Lexer(new StreamInImpl(inputStream, this.configuration.CharEncoding, this.configuration.tabsize), this.configuration);
            lexer.errout = this.errout;
            lexer.in.lexer = lexer;
            if (this.configuration.XmlTags) {
                node = ParserImpl.parseXMLDocument(lexer);
            } else {
                lexer.warnings = 0;
                if (!this.configuration.Quiet) {
                    Report.helloMessage(this.errout, "4th August 2000", this.inputStreamName);
                }
                if (!(node = ParserImpl.parseDocument(lexer)).checkNodeIntegrity()) {
                    Report.badTree(this.errout);
                    return null;
                }
                Clean.nestedEmphasis(node);
                Clean.list2BQ(node);
                Clean.bQ2Div(node);
                if (this.configuration.LogicalEmphasis) {
                    Clean.emFromI(node);
                }
                if (this.configuration.Word2000 && Clean.isWord2000(node)) {
                    Clean.dropSections(lexer, node);
                    Clean.cleanWord2000(lexer, node);
                }
                if (this.configuration.MakeClean || this.configuration.DropFontTags) {
                    new Clean().cleanTree(lexer, node);
                }
                if (!node.checkNodeIntegrity()) {
                    Report.badTree(this.errout);
                    return null;
                }
                Node node2 = node.findDocType();
                if (node.content != null) {
                    if (this.configuration.xHTML) {
                        lexer.setXHTMLDocType(node);
                    } else {
                        lexer.fixDocType(node);
                    }
                    if (this.configuration.TidyMark) {
                        lexer.addGenerator(node);
                    }
                }
                if (this.configuration.XmlOut && this.configuration.XmlPi) {
                    lexer.fixXMLPI(node);
                }
                if (!this.configuration.Quiet && node.content != null) {
                    Report.reportVersion(this.errout, lexer, this.inputStreamName, node2);
                    Report.reportNumWarnings(this.errout, lexer);
                }
            }
            this.parseWarnings = lexer.warnings;
            this.parseErrors = lexer.errors;
            if (lexer.errors > 0) {
                Report.needsAuthorIntervention(this.errout);
            }
            outImpl.state = 0;
            outImpl.encoding = this.configuration.CharEncoding;
            if (outputStream != null && !this.configuration.OnlyErrors && lexer.errors == 0) {
                PPrint pPrint = new PPrint(this.configuration);
                outImpl.out = outputStream;
                if (this.configuration.XmlTags) {
                    pPrint.printXMLTree(outImpl, (short)0, 0, lexer, node);
                } else {
                    pPrint.printTree(outImpl, (short)0, 0, lexer, node);
                }
                pPrint.flushLine(outImpl, 0);
            }
            Report.errorSummary(lexer);
        }
        return node;
    }

    public Document parseDOM(InputStream inputStream, OutputStream outputStream) {
        Node node = this.parse(inputStream, outputStream);
        if (node != null) {
            return (Document)node.getAdapter();
        }
        return null;
    }

    public static Document createEmptyDocument() {
        Node node = new Node(0, new byte[0], 0, 0);
        Node node2 = new Node(5, new byte[0], 0, 0, "html");
        if (node != null && node2 != null) {
            Node.insertNodeAtStart(node, node2);
            return (Document)node.getAdapter();
        }
        return null;
    }

    public void pprint(Document document, OutputStream outputStream) {
        OutImpl outImpl = new OutImpl();
        if (!(document instanceof DOMDocumentImpl)) {
            return;
        }
        Node node = ((DOMDocumentImpl)document).adaptee;
        outImpl.state = 0;
        outImpl.encoding = this.configuration.CharEncoding;
        if (outputStream != null) {
            PPrint pPrint = new PPrint(this.configuration);
            outImpl.out = outputStream;
            if (this.configuration.XmlTags) {
                pPrint.printXMLTree(outImpl, (short)0, 0, null, node);
            } else {
                pPrint.printTree(outImpl, (short)0, 0, null, node);
            }
            pPrint.flushLine(outImpl, 0);
        }
    }

    public static void main(String[] stringArray) {
        int n = 0;
        int n2 = 0;
        OutImpl outImpl = new OutImpl();
        int n3 = stringArray.length + 1;
        int n4 = 0;
        String string = "stderr";
        Tidy tidy = new Tidy();
        Configuration configuration = tidy.getConfiguration();
        while (n3 > 0) {
            InputStream inputStream;
            String string2;
            Object object;
            if (n3 > 1 && stringArray[n4].startsWith("-")) {
                String string3 = stringArray[n4].substring(1);
                if (string3.length() > 0 && string3.charAt(0) == '-') {
                    string3 = string3.substring(1);
                }
                if (string3.equals("xml")) {
                    configuration.XmlTags = true;
                } else if (string3.equals("asxml") || string3.equals("asxhtml")) {
                    configuration.xHTML = true;
                } else if (string3.equals("indent")) {
                    configuration.IndentContent = true;
                    configuration.SmartIndent = true;
                } else if (string3.equals("omit")) {
                    configuration.HideEndTags = true;
                } else if (string3.equals("upper")) {
                    configuration.UpperCaseTags = true;
                } else if (string3.equals("clean")) {
                    configuration.MakeClean = true;
                } else if (string3.equals("raw")) {
                    configuration.CharEncoding = 0;
                } else if (string3.equals("ascii")) {
                    configuration.CharEncoding = 1;
                } else if (string3.equals("latin1")) {
                    configuration.CharEncoding = 2;
                } else if (string3.equals("utf8")) {
                    configuration.CharEncoding = 3;
                } else if (string3.equals("iso2022")) {
                    configuration.CharEncoding = 4;
                } else if (string3.equals("mac")) {
                    configuration.CharEncoding = 5;
                } else if (string3.equals("numeric")) {
                    configuration.NumEntities = true;
                } else if (string3.equals("modify")) {
                    configuration.writeback = true;
                } else if (string3.equals("change")) {
                    configuration.writeback = true;
                } else if (string3.equals("update")) {
                    configuration.writeback = true;
                } else if (string3.equals("errors")) {
                    configuration.OnlyErrors = true;
                } else if (string3.equals("quiet")) {
                    configuration.Quiet = true;
                } else if (string3.equals("slides")) {
                    configuration.BurstSlides = true;
                } else if (string3.equals("help") || stringArray[n4].charAt(1) == '?' || stringArray[n4].charAt(1) == 'h') {
                    Report.helpText(new PrintWriter(System.out, true), "Tidy");
                    System.exit(1);
                } else if (string3.equals("config")) {
                    if (n3 >= 3) {
                        configuration.parseFile(stringArray[n4 + 1]);
                        --n3;
                        ++n4;
                    }
                } else if (stringArray[n4].equals("-file") || stringArray[n4].equals("--file") || stringArray[n4].equals("-f")) {
                    if (n3 >= 3) {
                        configuration.errfile = new String(stringArray[n4 + 1]);
                        --n3;
                        ++n4;
                    }
                } else if (stringArray[n4].equals("-wrap") || stringArray[n4].equals("--wrap") || stringArray[n4].equals("-w")) {
                    if (n3 >= 3) {
                        configuration.wraplen = Integer.parseInt(stringArray[n4 + 1]);
                        --n3;
                        ++n4;
                    }
                } else if (stringArray[n4].equals("-version") || stringArray[n4].equals("--version") || stringArray[n4].equals("-v")) {
                    object = tidy.getErrout();
                    ((PrintWriter)object).println("Java HTML Tidy release date: 4th August 2000");
                    ((PrintWriter)object).println("See http://www.w3.org/People/Raggett for details");
                    System.exit(0);
                } else {
                    String string4 = stringArray[n4];
                    int n5 = 1;
                    while (n5 < string4.length()) {
                        if (string4.charAt(n5) == 'i') {
                            configuration.IndentContent = true;
                            configuration.SmartIndent = true;
                        } else if (string4.charAt(n5) == 'o') {
                            configuration.HideEndTags = true;
                        } else if (string4.charAt(n5) == 'u') {
                            configuration.UpperCaseTags = true;
                        } else if (string4.charAt(n5) == 'c') {
                            configuration.MakeClean = true;
                        } else if (string4.charAt(n5) == 'n') {
                            configuration.NumEntities = true;
                        } else if (string4.charAt(n5) == 'm') {
                            configuration.writeback = true;
                        } else if (string4.charAt(n5) == 'e') {
                            configuration.OnlyErrors = true;
                        } else if (string4.charAt(n5) == 'q') {
                            configuration.Quiet = true;
                        } else {
                            Report.unknownOption(tidy.getErrout(), string4.charAt(n5));
                        }
                        ++n5;
                    }
                }
                --n3;
                ++n4;
                continue;
            }
            configuration.adjust();
            if (configuration.errfile != null && !configuration.errfile.equals(string)) {
                if (tidy.getErrout() != tidy.getStderr()) {
                    tidy.getErrout().close();
                }
                try {
                    tidy.setErrout(new PrintWriter((Writer)new FileWriter(configuration.errfile), true));
                    string = configuration.errfile;
                }
                catch (IOException iOException) {
                    string = "stderr";
                    tidy.setErrout(tidy.getStderr());
                }
            }
            if (n3 > 1) {
                string2 = stringArray[n4];
                try {
                    inputStream = new FileInputStream(string2);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    inputStream = null;
                }
                catch (IOException iOException) {
                    inputStream = null;
                }
            } else {
                string2 = "stdin";
                inputStream = System.in;
            }
            if (inputStream != null) {
                Node node;
                Node node2;
                Lexer lexer = new Lexer(new StreamInImpl(inputStream, configuration.CharEncoding, configuration.tabsize), configuration);
                lexer.errout = tidy.getErrout();
                lexer.in.lexer = lexer;
                if (configuration.XmlTags) {
                    node2 = ParserImpl.parseXMLDocument(lexer);
                } else {
                    lexer.warnings = 0;
                    if (!configuration.Quiet) {
                        Report.helloMessage(tidy.getErrout(), "4th August 2000", string2);
                    }
                    if (!(node2 = ParserImpl.parseDocument(lexer)).checkNodeIntegrity()) {
                        Report.badTree(tidy.getErrout());
                        System.exit(1);
                    }
                    Clean.nestedEmphasis(node2);
                    Clean.list2BQ(node2);
                    Clean.bQ2Div(node2);
                    if (configuration.LogicalEmphasis) {
                        Clean.emFromI(node2);
                    }
                    if (configuration.Word2000 && Clean.isWord2000(node2)) {
                        Clean.dropSections(lexer, node2);
                        Clean.cleanWord2000(lexer, node2);
                    }
                    if (configuration.MakeClean || configuration.DropFontTags) {
                        new Clean().cleanTree(lexer, node2);
                    }
                    if (!node2.checkNodeIntegrity()) {
                        Report.badTree(tidy.getErrout());
                        System.exit(1);
                    }
                    node = node2.findDocType();
                    if (node2.content != null) {
                        if (configuration.xHTML) {
                            lexer.setXHTMLDocType(node2);
                        } else {
                            lexer.fixDocType(node2);
                        }
                        if (configuration.TidyMark) {
                            lexer.addGenerator(node2);
                        }
                    }
                    if (configuration.XmlOut && configuration.XmlPi) {
                        lexer.fixXMLPI(node2);
                    }
                    n2 += lexer.warnings;
                    n += lexer.errors;
                    if (!configuration.Quiet && node2.content != null) {
                        Report.reportVersion(tidy.getErrout(), lexer, string2, node);
                        Report.reportNumWarnings(tidy.getErrout(), lexer);
                    }
                }
                if (inputStream != System.in) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (lexer.errors > 0) {
                    Report.needsAuthorIntervention(tidy.getErrout());
                }
                outImpl.state = 0;
                outImpl.encoding = configuration.CharEncoding;
                if (!configuration.OnlyErrors && lexer.errors == 0) {
                    PPrint pPrint = new PPrint(configuration);
                    if (configuration.BurstSlides) {
                        object = null;
                        node = node2.findDocType();
                        if (node != null) {
                            Node.discardElement(node);
                        }
                        lexer.versions = (short)(lexer.versions | 8);
                        if (configuration.xHTML) {
                            lexer.setXHTMLDocType(node2);
                        } else {
                            lexer.fixDocType(node2);
                        }
                        object = Node.findBody(node2);
                        if (object != null) {
                            Report.reportNumberOfSlides(tidy.getErrout(), PPrint.countSlides((Node)object));
                            pPrint.createSlides(lexer, node2);
                        } else {
                            Report.missingBody(tidy.getErrout());
                        }
                    } else if (configuration.writeback) {
                        try {
                            outImpl.out = new FileOutputStream(string2);
                            if (configuration.XmlTags) {
                                pPrint.printXMLTree(outImpl, (short)0, 0, lexer, node2);
                            } else {
                                pPrint.printTree(outImpl, (short)0, 0, lexer, node2);
                            }
                            pPrint.flushLine(outImpl, 0);
                            outImpl.out.close();
                        }
                        catch (IOException iOException) {
                            tidy.getErrout().println(String.valueOf(string2) + iOException.toString());
                        }
                    } else {
                        outImpl.out = System.out;
                        if (configuration.XmlTags) {
                            pPrint.printXMLTree(outImpl, (short)0, 0, lexer, node2);
                        } else {
                            pPrint.printTree(outImpl, (short)0, 0, lexer, node2);
                        }
                        pPrint.flushLine(outImpl, 0);
                    }
                }
                Report.errorSummary(lexer);
            } else {
                Report.unknownFile(tidy.getErrout(), "Tidy", string2);
            }
            ++n4;
            if (--n3 <= 1) break;
        }
        if (n + n2 > 0) {
            Report.generalInfo(tidy.getErrout());
        }
        if (tidy.getErrout() != tidy.getStderr()) {
            tidy.getErrout().close();
        }
        if (n > 0) {
            System.exit(2);
        }
        if (n2 > 0) {
            System.exit(1);
        }
        System.exit(0);
    }
}

