/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import org.w3c.tidy.AttVal;
import org.w3c.tidy.AttrCheck;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.Node;
import org.w3c.tidy.Report;

public class AttrCheckImpl {
    private static AttrCheck _checkUrl = new CheckUrl();
    private static AttrCheck _checkScript = new CheckScript();
    private static AttrCheck _checkAlign = new CheckAlign();
    private static AttrCheck _checkValign = new CheckValign();
    private static AttrCheck _checkBool = new CheckBool();
    private static AttrCheck _checkId = new CheckId();
    private static AttrCheck _checkName = new CheckName();

    public static AttrCheck getCheckUrl() {
        return _checkUrl;
    }

    public static AttrCheck getCheckScript() {
        return _checkScript;
    }

    public static AttrCheck getCheckAlign() {
        return _checkAlign;
    }

    public static AttrCheck getCheckValign() {
        return _checkValign;
    }

    public static AttrCheck getCheckBool() {
        return _checkBool;
    }

    public static AttrCheck getCheckId() {
        return _checkId;
    }

    public static AttrCheck getCheckName() {
        return _checkName;
    }

    public static class CheckUrl
    implements AttrCheck {
        public void check(Lexer lexer, Node node, AttVal attVal) {
            if (attVal.value == null) {
                Report.attrError(lexer, node, attVal.attribute, (short)3);
                return;
            }
            if (lexer.configuration.FixBackslash) {
                attVal.value = attVal.value.replace('\\', '/');
            }
        }
    }

    public static class CheckScript
    implements AttrCheck {
        public void check(Lexer lexer, Node node, AttVal attVal) {
        }
    }

    public static class CheckAlign
    implements AttrCheck {
        public void check(Lexer lexer, Node node, AttVal attVal) {
            if (node.tag != null && (node.tag.model & 0x10000) != 0) {
                _checkValign.check(lexer, node, attVal);
                return;
            }
            String string = attVal.value;
            if (string == null) {
                Report.attrError(lexer, node, attVal.attribute, (short)3);
                return;
            }
            if (!(string.equalsIgnoreCase("left") && !false || string.equalsIgnoreCase("center") && !false || string.equalsIgnoreCase("right") && !false || string.equalsIgnoreCase("justify") && !false)) {
                Report.attrError(lexer, node, attVal.value, (short)4);
            }
        }
    }

    public static class CheckValign
    implements AttrCheck {
        public void check(Lexer lexer, Node node, AttVal attVal) {
            String string = attVal.value;
            if (string == null) {
                Report.attrError(lexer, node, attVal.attribute, (short)3);
                return;
            }
            if (!(string.equalsIgnoreCase("top") && !false || string.equalsIgnoreCase("middle") && !false || string.equalsIgnoreCase("bottom") && !false || string.equalsIgnoreCase("baseline") && !false)) {
                if (string.equalsIgnoreCase("left") && !false || string.equalsIgnoreCase("right") && !false) {
                    if (node.tag == null || (node.tag.model & 0x10000) == 0) {
                        Report.attrError(lexer, node, string, (short)4);
                    }
                    return;
                }
                if (string.equalsIgnoreCase("texttop") && !false || string.equalsIgnoreCase("absmiddle") && !false || string.equalsIgnoreCase("absbottom") && !false || string.equalsIgnoreCase("textbottom") && !false) {
                    lexer.versions = (short)(lexer.versions & 0x1C0);
                    Report.attrError(lexer, node, string, (short)6);
                    return;
                }
                Report.attrError(lexer, node, string, (short)4);
            }
        }
    }

    public static class CheckBool
    implements AttrCheck {
        public void check(Lexer lexer, Node node, AttVal attVal) {
        }
    }

    public static class CheckId
    implements AttrCheck {
        public void check(Lexer lexer, Node node, AttVal attVal) {
        }
    }

    public static class CheckName
    implements AttrCheck {
        public void check(Lexer lexer, Node node, AttVal attVal) {
        }
    }
}

