/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.complib.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.visualweb.complib.Complib;
import org.netbeans.modules.visualweb.complib.ComplibServiceProvider;
import org.netbeans.modules.visualweb.complib.IdeUtil;
import org.netbeans.modules.visualweb.complib.api.ComplibException;
import org.netbeans.modules.visualweb.complib.ui.TableSorter;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ComponentsPanel
extends JPanel {
    private Complib complib;
    private JButton btnDefaultPaletteSettings;
    private JLabel lblCompList;
    private JScrollPane scrollCompList;
    private JTable tblCompList;
    private ComplibServiceProvider mgr = ComplibServiceProvider.getInstance();

    public ComponentsPanel(Complib complib) {
        this.initComponents();
        this.complib = complib;
        try {
            this.initComponentListJtable();
        }
        catch (ComplibException complibException) {
            IdeUtil.logError(complibException);
            return;
        }
    }

    private void initComponentListJtable() throws ComplibException {
        ComplibServiceProvider.ComponentInfo[] componentInfoArray = this.mgr.getComponentInfos(this.complib);
        ComponentTableModel componentTableModel = new ComponentTableModel(componentInfoArray);
        TableSorter tableSorter = new TableSorter(componentTableModel);
        this.tblCompList.setModel(tableSorter);
        tableSorter.setTableHeader(this.tblCompList.getTableHeader());
        TableColumnModel tableColumnModel = this.tblCompList.getColumnModel();
        tableColumnModel.getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            protected void setValue(Object object) {
                IconCellInfo iconCellInfo = (IconCellInfo)object;
                if (iconCellInfo == null) {
                    return;
                }
                this.setHorizontalAlignment(2);
                this.setIcon(iconCellInfo.getIcon());
                this.setText(iconCellInfo.getDisplayName());
            }
        });
        tableColumnModel.getColumn(0).setPreferredWidth(170);
        tableColumnModel.getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            protected void setValue(Object object) {
                Set set = (Set)object;
                if (set == null) {
                    return;
                }
                StringBuffer stringBuffer = new StringBuffer();
                Iterator iterator = set.iterator();
                boolean bl = iterator.hasNext();
                while (bl) {
                    String string = (String)iterator.next();
                    stringBuffer.append(string);
                    bl = iterator.hasNext();
                    if (!bl) continue;
                    stringBuffer.append(", ");
                }
                this.setText(stringBuffer.toString());
            }
        });
        tableColumnModel.getColumn(1).setPreferredWidth(170);
        tableColumnModel.getColumn(2).setPreferredWidth(260);
        this.tblCompList.setRowHeight(18);
    }

    private void initComponents() {
        this.lblCompList = new JLabel();
        this.scrollCompList = new JScrollPane();
        this.tblCompList = new JTable();
        this.btnDefaultPaletteSettings = new JButton();
        this.setLayout(new GridBagLayout());
        this.lblCompList.setLabelFor(this.tblCompList);
        Mnemonics.setLocalizedText((JLabel)this.lblCompList, (String)NbBundle.getBundle((String)"org/netbeans/modules/visualweb/complib/ui/Bundle").getString("manager.ComponentList"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.add((Component)this.lblCompList, gridBagConstraints);
        this.lblCompList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentsPanel.class, (String)"manager.ComponentListA11yDescription"));
        this.tblCompList.setModel(new DefaultTableModel(new Object[0][], new String[]{"On Palette", "Name", "Category", "Class Name"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Boolean.class, String.class, String.class, String.class};
                this.canEdit = new boolean[]{true, false, false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.tblCompList.setAutoResizeMode(0);
        this.tblCompList.setIntercellSpacing(new Dimension(2, 2));
        this.tblCompList.setShowVerticalLines(false);
        this.scrollCompList.setViewportView(this.tblCompList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 10, 10);
        this.add((Component)this.scrollCompList, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnDefaultPaletteSettings, (String)NbBundle.getMessage(ComponentsPanel.class, (String)"manager.DefaultPaletteSettingsButton"));
        this.btnDefaultPaletteSettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ComponentsPanel.this.btnDefaultPaletteSettingsActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.add((Component)this.btnDefaultPaletteSettings, gridBagConstraints);
        this.btnDefaultPaletteSettings.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentsPanel.class, (String)"manager.DefaultPaletteSettingsButtonA11yDescription"));
    }

    private void btnDefaultPaletteSettingsActionPerformed(ActionEvent actionEvent) {
        String string = NbBundle.getMessage(ComponentsPanel.class, (String)"manager.DefaultPaletteSettingsMessage");
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, 2);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
        if (NotifyDescriptor.OK_OPTION == object) {
            try {
                this.mgr.resetToInitialPalette(this.complib);
                this.initComponentListJtable();
            }
            catch (ComplibException complibException) {
                IdeUtil.logError(complibException);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ComponentTableModel
    extends AbstractTableModel {
        private static ResourceBundle rb = NbBundle.getBundle(ComponentTableModel.class);
        private static final String[] columnNames = new String[]{rb.getString("manager.componentTable.displayName"), rb.getString("manager.componentTable.categories"), rb.getString("manager.componentTable.className")};
        private static Class[] types = new Class[]{IconCellInfo.class, Set.class, String.class};
        private ComplibServiceProvider.ComponentInfo[] compInfos;

        private ComponentTableModel(ComplibServiceProvider.ComponentInfo[] componentInfoArray) {
            this.compInfos = componentInfoArray;
        }

        @Override
        public int getColumnCount() {
            return columnNames.length;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return types[n];
        }

        @Override
        public String getColumnName(int n) {
            return columnNames[n];
        }

        @Override
        public int getRowCount() {
            return this.compInfos.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ComplibServiceProvider.ComponentInfo componentInfo = this.compInfos[n];
            switch (n2) {
                case 0: {
                    return new IconCellInfo(componentInfo.getIcon(), componentInfo.getDisplayName());
                }
                case 1: {
                    return componentInfo.getInitialCategories();
                }
                case 2: {
                    return componentInfo.getClassName();
                }
            }
            return "unknown column index";
        }
    }

    private static class IconCellInfo {
        private Icon icon;
        private String displayName;

        private IconCellInfo(Icon icon, String string) {
            this.icon = icon;
            this.displayName = string;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

