/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.servicetag;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Locale;
import javax.net.ssl.HttpsURLConnection;
import org.netbeans.modules.servicetag.BrowserSupport;
import org.netbeans.modules.servicetag.Installer;
import org.netbeans.modules.servicetag.RegistrationData;
import org.netbeans.modules.servicetag.Util;

class SunConnection {
    private static String JDK_REGISTRATION_URL = "https://inventory.sun.com/RegistrationWeb/register";
    private static String SANDBOX_TESTING_URL = "https://connection-tst.sun.com/RegistrationWeb/register";
    private static String SVCTAG_REGISTER_TESTING = "servicetag.register.testing";
    private static String SVCTAG_REGISTRATION_URL = "servicetag.registration.url";
    private static String SVCTAG_CONNECTION_TIMEOUT = "servicetag.connection.timeout";

    private SunConnection() {
    }

    static URL getRegistrationURL(String string) {
        String string2 = System.getProperty(SVCTAG_REGISTRATION_URL);
        if (string2 == null) {
            string2 = System.getProperty(SVCTAG_REGISTER_TESTING) != null ? SANDBOX_TESTING_URL : JDK_REGISTRATION_URL;
        }
        if ((string2 = string2.trim()).length() == 0) {
            throw new InternalError("Empty registration url set");
        }
        String string3 = SunConnection.rewriteURL(string2, string);
        try {
            return new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            InternalError internalError = new InternalError(malformedURLException.getMessage());
            internalError.initCause(malformedURLException);
            throw internalError;
        }
    }

    private static String rewriteURL(String string, String string2) {
        int n;
        StringBuilder stringBuilder = new StringBuilder(string.trim());
        if (stringBuilder.charAt((n = stringBuilder.length()) - 1) != '/') {
            stringBuilder.append('/');
        }
        stringBuilder.append(string2);
        stringBuilder.append("?");
        stringBuilder.append("product=jdk");
        stringBuilder.append("&");
        stringBuilder.append("locale=").append(Locale.getDefault().getLanguage());
        return stringBuilder.toString();
    }

    public static void register(RegistrationData registrationData) throws IOException {
        URL uRL = SunConnection.getRegistrationURL(registrationData.getRegistrationURN());
        boolean bl = SunConnection.postRegistrationData(uRL, registrationData);
        if (bl) {
            SunConnection.openBrowser(uRL);
        } else {
            SunConnection.openOfflineRegisterPage();
        }
    }

    private static void openBrowser(URL uRL) throws IOException {
        block7: {
            if (!BrowserSupport.isSupported()) {
                if (Util.isVerbose()) {
                    System.out.println("Browser is not supported");
                }
                return;
            }
            try {
                BrowserSupport.browse(uRL.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                InternalError internalError = new InternalError("Error in registering: " + uRISyntaxException.getMessage());
                internalError.initCause(uRISyntaxException);
                throw internalError;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (Util.isVerbose()) {
                    illegalArgumentException.printStackTrace();
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (!Util.isVerbose()) break block7;
                unsupportedOperationException.printStackTrace();
            }
        }
    }

    private static boolean postRegistrationData(URL uRL, RegistrationData registrationData) {
        try {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
            httpsURLConnection.setDoInput(true);
            httpsURLConnection.setDoOutput(true);
            httpsURLConnection.setUseCaches(false);
            httpsURLConnection.setAllowUserInteraction(false);
            String string = System.getProperty(SVCTAG_CONNECTION_TIMEOUT, "10");
            httpsURLConnection.setConnectTimeout(Util.getIntValue(string) * 1000);
            if (Util.isVerbose()) {
                System.out.println("Connecting to post registration data at " + uRL);
            }
            httpsURLConnection.setRequestMethod("POST");
            httpsURLConnection.setRequestProperty("Content-Type", "text/xml;charset=\"utf-8\"");
            httpsURLConnection.connect();
            OutputStream outputStream = httpsURLConnection.getOutputStream();
            registrationData.storeToXML(outputStream);
            outputStream.flush();
            outputStream.close();
            int n = httpsURLConnection.getResponseCode();
            if (Util.isVerbose()) {
                System.out.println("POST return status = " + n);
                SunConnection.printReturnData(httpsURLConnection, n);
            }
            return n == 200;
        }
        catch (MalformedURLException malformedURLException) {
            InternalError internalError = new InternalError("Error in registering: " + malformedURLException.getMessage());
            internalError.initCause(malformedURLException);
            throw internalError;
        }
        catch (Exception exception) {
            if (Util.isVerbose()) {
                exception.printStackTrace();
            }
            return false;
        }
    }

    private static void openOfflineRegisterPage() throws IOException {
        block7: {
            if (!BrowserSupport.isSupported()) {
                if (Util.isVerbose()) {
                    System.out.println("Browser is not supported");
                }
                return;
            }
            File file = Installer.getRegistrationHtmlPage();
            try {
                BrowserSupport.browse(file.toURI());
            }
            catch (FileNotFoundException fileNotFoundException) {
                InternalError internalError = new InternalError("Error in launching " + file + ": " + fileNotFoundException.getMessage());
                internalError.initCause(fileNotFoundException);
                throw internalError;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (Util.isVerbose()) {
                    illegalArgumentException.printStackTrace();
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (!Util.isVerbose()) break block7;
                unsupportedOperationException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printReturnData(HttpURLConnection httpURLConnection, int n) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = n < 400 ? new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream())) : new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream()));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string).append("\n");
            }
            System.out.println("Response is : ");
            System.out.println(stringBuilder.toString());
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }
}

