/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.reglib;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

class Util {
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.reglib.Util");

    Util() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String commandOutput(Process process) throws IOException {
        InputStreamReader inputStreamReader = null;
        Reader reader = null;
        try {
            inputStreamReader = new InputStreamReader(process.getInputStream());
            reader = new InputStreamReader(process.getErrorStream());
            String string = Util.commandOutput(inputStreamReader);
            String string2 = Util.commandOutput(reader);
            process.waitFor();
            String string3 = string + string2.trim();
            return string3;
        }
        catch (InterruptedException interruptedException) {
            LOG.log(Level.INFO, "Interrupted:", interruptedException);
            String string = interruptedException.getMessage();
            return string;
        }
        finally {
            if (inputStreamReader != null) {
                ((Reader)inputStreamReader).close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    static String commandOutput(Reader reader) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = reader.read()) > 0) {
            if (n == 13) continue;
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    static String formatTimestamp(Date date) {
        if (date == null) {
            return "[No timestamp]";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat.format(date);
    }

    static Date parseTimestamp(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            return simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return new Date();
        }
    }
}

