/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.reglib;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.reglib.NbBundle;
import org.netbeans.modules.reglib.NbConnectionSupport;
import org.netbeans.modules.reglib.Util;
import org.netbeans.modules.servicetag.RegistrationData;
import org.netbeans.modules.servicetag.Registry;
import org.netbeans.modules.servicetag.ServiceTag;

public class NbServiceTagSupport {
    private static String NB_CLUSTER;
    private static String NB_VERSION;
    private static String GF_VERSION;
    private static final String USER_HOME;
    private static final String USER_DIR;
    private static final String ST_DIR = "servicetag";
    private static final String ST_FILE = "servicetag";
    private static final String REG_FILE = "registration.xml";
    private static File svcTagDirHome;
    private static File svcTagDirNb;
    private static File serviceTagFileHome;
    private static File serviceTagFileNb;
    private static File nbClusterDir;
    private static File nbInstallDir;
    private static File regXmlFileHome;
    private static File regXmlFileNb;
    private static RegistrationData registration;
    private static final Logger LOG;
    private static File registerHtmlParent;
    private static final String REGISTRATION_HTML_NAME = "register";
    private static boolean inited;
    private static final String NB_HEADER_PNG_KEY = "@@NB_HEADER_PNG@@";
    private static final String PRODUCT_KEY = "@@PRODUCT@@";
    private static final String REGISTRATION_URL_KEY = "@@REGISTRATION_URL@@";
    private static final String REGISTRATION_PAYLOAD_KEY = "@@REGISTRATION_PAYLOAD@@";

    private static void init() {
        LOG.log(Level.FINE, "Initializing");
        NB_CLUSTER = NbBundle.getMessage(NbServiceTagSupport.class, "nb.cluster");
        NB_VERSION = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.nb.version");
        GF_VERSION = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.gf.version");
        File file = new File(System.getProperty("netbeans.home"));
        nbInstallDir = file.getParentFile();
        LOG.log(Level.FINE, "NetBeans install dir is:" + nbInstallDir);
        nbClusterDir = new File(nbInstallDir, NB_CLUSTER);
        LOG.log(Level.FINE, "nb cluster dir is:" + nbClusterDir);
        svcTagDirNb = new File(nbClusterDir.getPath() + File.separator + "servicetag");
        svcTagDirHome = new File(USER_HOME + File.separator + ".netbeans-registration" + File.separator + NB_VERSION);
        if (nbClusterDir.canWrite() && !svcTagDirNb.exists()) {
            svcTagDirNb.mkdirs();
        }
        if (!svcTagDirHome.exists()) {
            svcTagDirHome.mkdirs();
        }
        regXmlFileNb = new File(svcTagDirNb, REG_FILE);
        regXmlFileHome = new File(svcTagDirHome, REG_FILE);
        serviceTagFileNb = new File(svcTagDirNb, "servicetag");
        serviceTagFileHome = new File(svcTagDirHome, "servicetag");
        inited = true;
    }

    public static ServiceTag createNbServiceTag(String string, String string2) throws IOException {
        if (!inited) {
            NbServiceTagSupport.init();
        }
        LOG.log(Level.FINE, "Creating NetBeans service tag");
        ServiceTag serviceTag = NbServiceTagSupport.getNbServiceTag();
        if (serviceTag != null) {
            if (serviceTagFileNb.exists() || serviceTagFileHome.exists()) {
                LOG.log(Level.FINE, "NetBeans service tag is already created and saved in registration.xml");
                return serviceTag;
            }
            LOG.log(Level.FINE, "NetBeans service tag is already created");
        }
        if (serviceTag == null) {
            LOG.log(Level.FINE, "Creating new service tag");
            serviceTag = NbServiceTagSupport.newNbServiceTag(string, string2);
            NbServiceTagSupport.getRegistrationData().addServiceTag(serviceTag);
            NbServiceTagSupport.writeRegistrationXml();
        }
        if (Registry.isSupported()) {
            LOG.log(Level.FINE, "Add service tag to system registry");
            NbServiceTagSupport.installSystemServiceTag(serviceTag);
        } else {
            LOG.log(Level.FINE, "Cannot add service tag to system registry as ST infrastructure is not found");
        }
        return serviceTag;
    }

    public static ServiceTag createGfServiceTag(String string, String string2, String string3, String string4) throws IOException {
        if (!inited) {
            NbServiceTagSupport.init();
        }
        LOG.log(Level.FINE, "Creating GlassFish service tag");
        ServiceTag serviceTag = NbServiceTagSupport.getGfServiceTag();
        if (serviceTag != null) {
            if (serviceTagFileNb.exists() || serviceTagFileHome.exists()) {
                LOG.log(Level.FINE, "GlassFish service tag is already created and saved in registration.xml");
                return serviceTag;
            }
            LOG.log(Level.FINE, "GlassFish service tag is already created");
        }
        if (serviceTag == null) {
            LOG.log(Level.FINE, "Creating new GlassFish service tag");
            serviceTag = NbServiceTagSupport.newGfServiceTag(string, string2, string3, string4);
            NbServiceTagSupport.getRegistrationData().addServiceTag(serviceTag);
            NbServiceTagSupport.writeRegistrationXml();
        }
        return serviceTag;
    }

    public static ServiceTag createGfServiceTag(ServiceTag serviceTag) throws IOException {
        if (!inited) {
            NbServiceTagSupport.init();
        }
        LOG.log(Level.FINE, "Creating GlassFish service tag");
        ServiceTag serviceTag2 = NbServiceTagSupport.getGfServiceTag();
        if (serviceTag2 != null) {
            if (!serviceTag2.equals(serviceTag)) {
                NbServiceTagSupport.getRegistrationData().removeServiceTag(serviceTag2.getInstanceURN());
                NbServiceTagSupport.getRegistrationData().addServiceTag(serviceTag);
                NbServiceTagSupport.writeRegistrationXml();
            }
        } else {
            NbServiceTagSupport.getRegistrationData().addServiceTag(serviceTag);
            NbServiceTagSupport.writeRegistrationXml();
        }
        return serviceTag;
    }

    public static ServiceTag createJdkServiceTag(String string) throws IOException {
        if (!inited) {
            NbServiceTagSupport.init();
        }
        LOG.log(Level.FINE, "Creating JDK service tag");
        ServiceTag serviceTag = NbServiceTagSupport.getJdkServiceTag();
        if (serviceTag != null) {
            if (serviceTagFileNb.exists() || serviceTagFileHome.exists()) {
                LOG.log(Level.FINE, "JDK service tag is already created and saved in registration.xml");
                return serviceTag;
            }
            LOG.log(Level.FINE, "JDK service tag is already created");
        }
        if (serviceTag == null) {
            LOG.log(Level.FINE, "Creating new JDK service tag");
            serviceTag = ServiceTag.getJavaServiceTag(string);
            NbServiceTagSupport.getRegistrationData().addServiceTag(serviceTag);
            NbServiceTagSupport.writeRegistrationXml();
        }
        return serviceTag;
    }

    private static void writeRegistrationXml() throws IOException {
        Object object;
        File file = null;
        if (svcTagDirNb.exists() && svcTagDirNb.canWrite()) {
            object = null;
            try {
                object = File.createTempFile("regtmp", null, svcTagDirNb);
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, "Warning: Cannot create file in " + svcTagDirNb + " Will use user home dir", iOException);
            }
            if (object != null && ((File)object).exists()) {
                ((File)object).delete();
                file = regXmlFileNb;
            } else {
                file = regXmlFileHome;
            }
        } else {
            file = regXmlFileHome;
        }
        object = null;
        try {
            object = new BufferedOutputStream(new FileOutputStream(file));
            NbServiceTagSupport.getRegistrationData().storeToXML((OutputStream)object);
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, "Error: Cannot save registration data to \"" + file + "\":" + iOException.getMessage());
            throw iOException;
        }
        finally {
            if (object != null) {
                ((FilterOutputStream)object).close();
            }
        }
    }

    public static RegistrationData getRegistrationData() throws IOException {
        if (!inited) {
            NbServiceTagSupport.init();
        }
        if (registration != null) {
            return registration;
        }
        File file = null;
        if (regXmlFileNb.exists()) {
            file = regXmlFileNb;
            LOG.log(Level.FINE, "Service tag will be loaded from NB install dir: " + file);
        } else if (regXmlFileHome.exists()) {
            file = regXmlFileHome;
            LOG.log(Level.FINE, "Service tag will be loaded from user home dir: " + file);
        } else {
            registration = new RegistrationData();
            LOG.log(Level.FINE, "Service tag file not found");
            return registration;
        }
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            registration = RegistrationData.loadFromXML(bufferedInputStream);
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, "Error: Bad registration data \"" + file + "\":" + iOException.getMessage());
            throw iOException;
        }
        finally {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
        }
        return registration;
    }

    private static ServiceTag newNbServiceTag(String string, String string2) throws IOException {
        String string3 = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.nb.urn");
        String string4 = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.nb.name");
        String string5 = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.nb.parent.urn");
        String string6 = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.nb.parent.name");
        return ServiceTag.newInstance(ServiceTag.generateInstanceURN(), string4, NB_VERSION, string3, string6, string5, NbServiceTagSupport.getNbProductDefinedId(string2), "NetBeans.org", System.getProperty("os.arch"), NbServiceTagSupport.getZoneName(), string);
    }

    private static ServiceTag newGfServiceTag(String string, String string2, String string3, String string4) throws IOException {
        String string5 = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.gf.urn");
        String string6 = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.gf.name");
        String string7 = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.gf.parent.urn");
        String string8 = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.gf.parent.name");
        return ServiceTag.newInstance(ServiceTag.generateInstanceURN(), string6, GF_VERSION, string5, string8, string7, NbServiceTagSupport.getGfProductDefinedId(string2, string3, string4), "Sun Microsystems Inc.", System.getProperty("os.arch"), NbServiceTagSupport.getZoneName(), string);
    }

    private static ServiceTag getNbServiceTag() throws IOException {
        String string = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.nb.urn");
        RegistrationData registrationData = NbServiceTagSupport.getRegistrationData();
        Set<ServiceTag> set = registrationData.getServiceTags();
        for (ServiceTag serviceTag : set) {
            if (!string.equals(serviceTag.getProductURN())) continue;
            return serviceTag;
        }
        return null;
    }

    private static ServiceTag getGfServiceTag() throws IOException {
        RegistrationData registrationData = NbServiceTagSupport.getRegistrationData();
        Set<ServiceTag> set = registrationData.getServiceTags();
        for (ServiceTag serviceTag : set) {
            if (!serviceTag.getProductName().startsWith("Sun Java System Application Server")) continue;
            return serviceTag;
        }
        return null;
    }

    private static ServiceTag getJdkServiceTag() throws IOException {
        RegistrationData registrationData = NbServiceTagSupport.getRegistrationData();
        Set<ServiceTag> set = registrationData.getServiceTags();
        for (ServiceTag serviceTag : set) {
            if (!serviceTag.getProductName().startsWith("J2SE") && !serviceTag.getProductName().startsWith("Java SE")) continue;
            return serviceTag;
        }
        return null;
    }

    private static String getNbProductDefinedId(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("id=");
        stringBuilder.append(NB_VERSION);
        String string2 = ",dir=" + nbInstallDir.getPath() + ",java.version=" + string;
        if (stringBuilder.length() + string2.length() < 256) {
            stringBuilder.append(string2);
        } else {
            LOG.log(Level.INFO, "Warning: Product defined instance ID exceeds the field limit:");
        }
        return stringBuilder.toString();
    }

    private static String getGfProductDefinedId(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("os.name=");
        stringBuilder.append(System.getProperty("os.name"));
        stringBuilder.append(",os.version=");
        stringBuilder.append(System.getProperty("os.version"));
        stringBuilder.append(",java.version=");
        stringBuilder.append(string2);
        stringBuilder.append(",glassfish.home=");
        stringBuilder.append(string3);
        stringBuilder.append(",java.home=");
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    private static String getZoneName() throws IOException {
        String string = "global";
        String string2 = "/usr/bin/zonename";
        File file = new File(string2);
        if (file.exists()) {
            ProcessBuilder processBuilder = new ProcessBuilder(string2);
            Process process = processBuilder.start();
            String string3 = Util.commandOutput(process);
            if (process.exitValue() == 0) {
                string = string3.trim();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getInstalledURN() throws IOException {
        if (serviceTagFileNb.exists() || serviceTagFileHome.exists()) {
            File file = null;
            if (serviceTagFileNb.exists()) {
                file = serviceTagFileNb;
            } else if (serviceTagFileHome.exists()) {
                file = serviceTagFileHome;
            }
            BufferedReader bufferedReader = null;
            try {
                String string;
                bufferedReader = new BufferedReader(new FileReader(file));
                String string2 = string = bufferedReader.readLine().trim();
                return string2;
            }
            finally {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void installSystemServiceTag(ServiceTag serviceTag) throws IOException {
        File file;
        Object object;
        if (NbServiceTagSupport.getInstalledURN().length() > 0) {
            LOG.log(Level.INFO, "ST is already installed ie. we have file servicetag.");
            return;
        }
        if (svcTagDirNb.exists() && svcTagDirNb.canWrite()) {
            object = null;
            try {
                object = File.createTempFile("regtmp", null, svcTagDirNb);
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, "Error: Cannot create file in " + svcTagDirNb + " Will use user home dir", iOException);
            }
            if (object != null && ((File)object).exists()) {
                ((File)object).delete();
                file = serviceTagFileNb;
            } else {
                file = serviceTagFileHome;
            }
        } else {
            file = serviceTagFileHome;
        }
        if (Registry.isSupported()) {
            if (Registry.getSystemRegistry().getServiceTag(serviceTag.getInstanceURN()) != null) {
                LOG.log(Level.FINE, "Service tag: " + serviceTag.getInstanceURN() + " is already installed in system registry.");
                return;
            }
            Registry.getSystemRegistry().addServiceTag(serviceTag);
            object = null;
            try {
                LOG.log(Level.FINE, "Creating file: " + file);
                object = new BufferedWriter(new FileWriter(file));
                ((Writer)object).write(serviceTag.getInstanceURN());
                ((BufferedWriter)object).newLine();
            }
            finally {
                if (object != null) {
                    ((BufferedWriter)object).close();
                }
            }
            if ("6.0".equals(NB_VERSION)) {
                file = new File(USER_DIR + File.separator + "servicetag");
                try {
                    LOG.log(Level.FINE, "Creating file: " + file + " Specific for 6.0.");
                    object = new BufferedWriter(new FileWriter(file));
                    ((Writer)object).write(serviceTag.getInstanceURN());
                    ((BufferedWriter)object).newLine();
                }
                finally {
                    if (object != null) {
                        ((BufferedWriter)object).close();
                    }
                }
            }
        }
    }

    private static File getRegisterHtmlParent() {
        if (registerHtmlParent == null) {
            registerHtmlParent = svcTagDirHome;
        }
        return registerHtmlParent;
    }

    public static File getServiceTagDirHome() {
        if (!inited) {
            NbServiceTagSupport.init();
        }
        return svcTagDirHome;
    }

    public static File getRegistrationHtmlPage(String string, String[] stringArray) throws IOException {
        if (!inited) {
            NbServiceTagSupport.init();
        }
        File file = NbServiceTagSupport.getRegisterHtmlParent();
        File file2 = new File(file, "register.html");
        NbServiceTagSupport.generateRegisterHtml(file, string, stringArray);
        return file2;
    }

    private static void deleteRegistrationHtmlPage() {
        File file = NbServiceTagSupport.getRegisterHtmlParent();
        if (file == null) {
            return;
        }
        String string = REGISTRATION_HTML_NAME;
        File file2 = new File(file, string + ".html");
        if (file2.exists()) {
            file2.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static void generateRegisterHtml(File file, String string, String[] stringArray) throws IOException {
        void var19_25;
        Object object2;
        Object object3;
        RegistrationData registrationData = NbServiceTagSupport.getRegistrationData();
        String string2 = NbConnectionSupport.getRegistrationURL(registrationData.getRegistrationURN(), string).toString();
        String string3 = "/org/netbeans/modules/reglib/resources/nb_header.png";
        File file2 = new File(svcTagDirHome, "nb_header.png");
        String string4 = file2.toURI().toURL().toString();
        InputStream inputStream = NbServiceTagSupport.class.getResourceAsStream(string3);
        if (inputStream == null) {
            LOG.log(Level.FINE, "Missing resource file: " + string3);
        } else {
            LOG.log(Level.FINE, "Generating " + file2 + " from " + string3);
            object3 = new BufferedInputStream(inputStream);
            object2 = new FileOutputStream(file2);
            try {
                int n;
                while ((n = ((BufferedInputStream)object3).read()) != -1) {
                    ((FileOutputStream)object2).write(n);
                }
            }
            finally {
                if (object3 != null) {
                    ((BufferedInputStream)object3).close();
                }
                if (object2 != null) {
                    ((FileOutputStream)object2).close();
                }
            }
        }
        object3 = registrationData.toString();
        object2 = System.getProperty("line.separator");
        String string5 = ((String)object3).replaceAll("\"", "%22").replaceAll((String)object2, " ");
        String string6 = REGISTRATION_HTML_NAME;
        File file3 = new File(file, string6 + ".html");
        inputStream = null;
        Locale locale = Locale.getDefault();
        Locale[] localeArray = new Locale[]{new Locale(locale.getLanguage(), locale.getCountry(), locale.getVariant()), new Locale(locale.getLanguage(), locale.getCountry()), new Locale(locale.getLanguage()), new Locale("")};
        for (Locale object4 : localeArray) {
            string3 = "/org/netbeans/modules/reglib/resources/register" + (object4.toString().equals("") ? "" : "_" + object4) + ".html";
            LOG.log(Level.FINE, "Looking for html in: " + string3);
            inputStream = NbServiceTagSupport.class.getResourceAsStream(string3);
            if (inputStream != null) break;
        }
        LOG.log(Level.FINE, "Found html in: " + string3);
        LOG.log(Level.FINE, "Generating " + file3);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        PrintWriter printWriter = new PrintWriter(file3, "UTF-8");
        String string7 = null;
        String string8 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            void var19_27;
            if (i > 0) {
                String string9 = (String)var19_25 + " " + NbBundle.getMessage(NbServiceTagSupport.class, "MSG_junction") + " ";
            }
            String string10 = (String)var19_27 + "<strong>" + stringArray[i] + "</strong>";
        }
        while ((string7 = bufferedReader.readLine()) != null) {
            String string11 = string7;
            if (string7.contains(PRODUCT_KEY)) {
                string11 = string7.replace(PRODUCT_KEY, (CharSequence)var19_25);
            } else if (string7.contains(NB_HEADER_PNG_KEY)) {
                string11 = string7.replace(NB_HEADER_PNG_KEY, string4);
            } else if (string7.contains(REGISTRATION_URL_KEY)) {
                string11 = string7.replace(REGISTRATION_URL_KEY, string2);
            } else if (string7.contains(REGISTRATION_PAYLOAD_KEY)) {
                string11 = string7.replace(REGISTRATION_PAYLOAD_KEY, string5);
            }
            printWriter.println(string11);
        }
        printWriter.flush();
        printWriter.close();
        inputStream.close();
    }

    static {
        USER_HOME = System.getProperty("user.home");
        USER_DIR = System.getProperty("netbeans.user");
        LOG = Logger.getLogger("org.netbeans.modules.reglib.NbServiceTagSupport");
        inited = false;
    }
}

